/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.enrolment;

import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.OptionalEnrolment;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.OptionalCurricularCourse;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;

public class EnroledOptionalEnrolment
extends EnroledCurriculumModuleWrapper {
    private static final long serialVersionUID = 3085559707039631255L;
    private OptionalCurricularCourse optionalCurricularCourse;

    public EnroledOptionalEnrolment(CurriculumModule curriculumModule, OptionalCurricularCourse optionalCurricularCourse, ExecutionSemester executionSemester) {
        super(curriculumModule, executionSemester);
        this.setOptionalCurricularCourse(optionalCurricularCourse);
    }

    public OptionalCurricularCourse getOptionalCurricularCourse() {
        return this.optionalCurricularCourse;
    }

    public void setOptionalCurricularCourse(OptionalCurricularCourse optionalCurricularCourse) {
        this.optionalCurricularCourse = optionalCurricularCourse;
    }

    @Override
    public List<CurricularRule> getCurricularRulesFromDegreeModule(ExecutionSemester executionSemester) {
        OptionalEnrolment optionalEnrolment = (OptionalEnrolment)((Object)this.getCurriculumModule());
        return optionalEnrolment.isApproved() ? Collections.EMPTY_LIST : this.getOptionalCurricularCourse().getCurricularRules(this.getContext(), executionSemester);
    }

    @Override
    public Context getContext() {
        if (this.context == null && !this.getCurriculumModule().isRoot()) {
            CurriculumGroup parentCurriculumGroup = this.getCurriculumModule().getCurriculumGroup();
            for (Context context : parentCurriculumGroup.getDegreeModule().getValidChildContexts(this.getExecutionPeriod())) {
                if (context.getChildDegreeModule() != this.getOptionalCurricularCourse()) continue;
                this.setContext(context);
                break;
            }
        }
        return this.context;
    }

    @Override
    public boolean isFor(DegreeModule degreeModule) {
        return this.getDegreeModule() == degreeModule || this.getOptionalCurricularCourse() == degreeModule;
    }

    @Override
    public boolean isAnnualCurricularCourse(ExecutionYear executionYear) {
        return this.getOptionalCurricularCourse().isAnual(executionYear);
    }
}

