/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EquivalencePlan;
import org.fenixedu.academic.domain.EquivalencePlanEntry_Base;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.util.LogicOperator;
import org.fenixedu.bennu.core.domain.Bennu;

public class EquivalencePlanEntry
extends EquivalencePlanEntry_Base {
    public static Comparator<EquivalencePlanEntry> COMPARATOR = new Comparator<EquivalencePlanEntry>(){

        @Override
        public int compare(EquivalencePlanEntry o1, EquivalencePlanEntry o2) {
            return o1.getCompareString().compareTo(o2.getCompareString());
        }
    };
    public static Comparator<EquivalencePlanEntry> COMPARATOR_BY_SOURCE_NUMBER = new Comparator<EquivalencePlanEntry>(){

        @Override
        public int compare(EquivalencePlanEntry o1, EquivalencePlanEntry o2) {
            Integer count1 = o1.getOldDegreeModulesSet().size();
            Integer count2 = o2.getOldDegreeModulesSet().size();
            return count1.compareTo(count2);
        }
    };

    protected EquivalencePlanEntry() {
        super.setRootDomainObject(Bennu.getInstance());
    }

    public EquivalencePlanEntry(EquivalencePlan equivalencePlan, CourseGroup oldCourseGroup, CourseGroup newCourseGroup) {
        this();
        this.init(equivalencePlan, Collections.singleton(oldCourseGroup), Collections.singleton(newCourseGroup), null, null, null, true, null);
    }

    public EquivalencePlanEntry(EquivalencePlan equivalencePlan, Collection<? extends DegreeModule> oldDegreeModules, Collection<? extends DegreeModule> newDegreeModules, CourseGroup previousCourseGroupForNewDegreeModules, LogicOperator sourceDegreeModulesOperator, LogicOperator newDegreeModulesOperator, Boolean transitiveSource, Double ectsCredits) {
        this();
        this.init(equivalencePlan, oldDegreeModules, newDegreeModules, previousCourseGroupForNewDegreeModules, sourceDegreeModulesOperator, newDegreeModulesOperator, transitiveSource, ectsCredits);
    }

    protected void init(EquivalencePlan equivalencePlan, Collection<? extends DegreeModule> oldDegreeModules, Collection<? extends DegreeModule> newDegreeModules, CourseGroup previousCourseGroupForNewDegreeModules, LogicOperator sourceDegreeModulesOperator, LogicOperator newDegreeModulesOperator, Boolean transitiveSource, Double ectsCredits) {
        this.checkParameters(equivalencePlan);
        this.checkRulesToCreate(newDegreeModules, previousCourseGroupForNewDegreeModules);
        super.setEquivalencePlan(equivalencePlan);
        super.getOldDegreeModulesSet().addAll(oldDegreeModules);
        super.getNewDegreeModulesSet().addAll(newDegreeModules);
        super.setPreviousCourseGroupForNewDegreeModules(previousCourseGroupForNewDegreeModules);
        super.setSourceDegreeModulesOperator(sourceDegreeModulesOperator);
        super.setNewDegreeModulesOperator(newDegreeModulesOperator);
        super.setTransitiveSource(transitiveSource);
        super.setEctsCredits(ectsCredits);
    }

    private void checkRulesToCreate(Collection<? extends DegreeModule> newDegreeModules, CourseGroup previousCourseGroupForNewDegreeModules) {
        if (previousCourseGroupForNewDegreeModules != null) {
            for (DegreeModule degreeModule : newDegreeModules) {
                if (previousCourseGroupForNewDegreeModules.hasDegreeModule(degreeModule)) continue;
                throw new DomainException("error.EquivalencePlanEntry.new.degree.modules.must.be.children.of.choosen.course.group", new String[0]);
            }
        }
    }

    private void checkParameters(EquivalencePlan equivalencePlan) {
        if (equivalencePlan == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.EquivalencePlanEntry.equivalencePlan.cannot.be.null", new String[0]);
        }
    }

    public void addNewDegreeModules(DegreeModule newDegreeModule) {
        throw new DomainException("error.org.fenixedu.academic.domain.EquivalencePlanEntry.cannot.add.newDegreeModule", new String[0]);
    }

    public List<DegreeModule> getNewDegreeModulesSortedByType() {
        ArrayList<DegreeModule> result = new ArrayList<DegreeModule>(super.getNewDegreeModulesSet());
        Collections.sort(result, new Comparator<DegreeModule>(){

            @Override
            public int compare(DegreeModule o1, DegreeModule o2) {
                if (o1.isCourseGroup() && !o2.isCourseGroup()) {
                    return -1;
                }
                if (!o1.isCourseGroup() && o2.isCourseGroup()) {
                    return 1;
                }
                return 0;
            }
        });
        return result;
    }

    public Set<DegreeModule> getNewDegreeModulesSet() {
        return Collections.unmodifiableSet(super.getNewDegreeModulesSet());
    }

    public void removeNewDegreeModules(DegreeModule newDegreeModule) {
        throw new DomainException("error.org.fenixedu.academic.domain.EquivalencePlanEntry.cannot.remove.newDegreeModule", new String[0]);
    }

    public void addOldDegreeModules(DegreeModule oldDegreeModules) {
        throw new DomainException("error.org.fenixedu.academic.domain.EquivalencePlanEntry.cannot.add.oldDegreeModules", new String[0]);
    }

    public Set<DegreeModule> getOldDegreeModulesSet() {
        return Collections.unmodifiableSet(super.getOldDegreeModulesSet());
    }

    public void removeOldDegreeModules(DegreeModule oldDegreeModules) {
        throw new DomainException("error.org.fenixedu.academic.domain.EquivalencePlanEntry.cannot.remove.oldDegreeModules", new String[0]);
    }

    public void setPreviousCourseGroupForNewDegreeModules(CourseGroup previousCourseGroupForNewDegreeModules) {
        throw new DomainException("error.org.fenixedu.academic.domain.EquivalencePlanEntry.cannot.modify.previousCourseGroupForNewDegreeModules", new String[0]);
    }

    public void setEctsCredits(Double ectsCredits) {
        throw new DomainException("error.org.fenixedu.academic.domain.EquivalencePlanEntry.cannot.modify.ectsCredits", new String[0]);
    }

    public void setSourceDegreeModulesOperator(LogicOperator sourceDegreeModulesOperator) {
        throw new DomainException("error.org.fenixedu.academic.domain.EquivalencePlanEntry.cannot.modify.sourceDegreeModulesOperator", new String[0]);
    }

    public void setNewDegreeModulesOperator(LogicOperator newDegreeModulesOperator) {
        throw new DomainException("error.org.fenixedu.academic.domain.EquivalencePlanEntry.cannot.modify.newDegreeModulesOperator", new String[0]);
    }

    private boolean isOneCourseGroup(Set<DegreeModule> degreeModules) {
        return degreeModules.size() == 1 && !degreeModules.iterator().next().isLeaf();
    }

    public boolean isCourseGroupEntry() {
        return this.isOneCourseGroup(this.getOldDegreeModulesSet()) && this.isOneCourseGroup(this.getNewDegreeModulesSet());
    }

    public boolean isCurricularCourseEntry() {
        boolean hasAtLeastOneCourseGroup = false;
        for (DegreeModule degreeModule : this.getOldDegreeModulesSet()) {
            hasAtLeastOneCourseGroup = true;
            if (degreeModule.isLeaf()) continue;
            return false;
        }
        return hasAtLeastOneCourseGroup;
    }

    public void delete() {
        this.setRootDomainObject(null);
        this.setEquivalencePlan(null);
        super.setPreviousCourseGroupForNewDegreeModules(null);
        super.getEquivalencePlansSet().clear();
        super.getOldDegreeModulesSet().clear();
        super.getNewDegreeModulesSet().clear();
        super.deleteDomainObject();
    }

    public void removeEquivalencePlan() {
        super.setEquivalencePlan(null);
    }

    public boolean isFor(DegreeCurricularPlan degreeCurricularPlan) {
        for (DegreeModule degreeModule : this.getNewDegreeModulesSet()) {
            if (degreeModule.getParentDegreeCurricularPlan() != degreeCurricularPlan) continue;
            return true;
        }
        return false;
    }

    public boolean isFor(DegreeModule degreeModule) {
        return this.getNewDegreeModulesSet().contains((Object)degreeModule) || this.getOldDegreeModulesSet().contains((Object)degreeModule);
    }

    protected String getCompareString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendCompareString(stringBuilder, this.getOldDegreeModulesSet());
        this.appendCompareString(stringBuilder, this.getNewDegreeModulesSet());
        stringBuilder.append(this.getEctsCredits());
        if (this.getSourceDegreeModulesOperator() != null) {
            stringBuilder.append(this.getSourceDegreeModulesOperator().name());
        }
        if (this.getNewDegreeModulesOperator() != null) {
            stringBuilder.append(this.getNewDegreeModulesOperator().name());
        }
        stringBuilder.append(this.getExternalId());
        return stringBuilder.toString();
    }

    protected void appendCompareString(StringBuilder stringBuilder, Set<DegreeModule> degreeModules) {
        for (DegreeModule degreeModule : degreeModules) {
            stringBuilder.append(degreeModule.getName());
        }
    }

    public void checkPermissions(Person person) {
        for (DegreeModule degreeModule : this.getNewDegreeModulesSet()) {
            DegreeCurricularPlan degreeCurricularPlan = degreeModule.getParentDegreeCurricularPlan();
            for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
                for (Coordinator coordinator : executionDegree.getCoordinatorsListSet()) {
                    if (coordinator.getPerson() != person) continue;
                    return;
                }
            }
        }
        throw new Error("error.not.authorized");
    }

    public boolean hasOnlyCourseGroupsInDestination() {
        for (DegreeModule degreeModule : this.getNewDegreeModulesSet()) {
            if (!degreeModule.isLeaf()) continue;
            return false;
        }
        return this.getNewDegreeModulesSet().size() > 0;
    }

    public boolean hasOnlyCurricularCoursesInDestination() {
        for (DegreeModule degreeModule : this.getNewDegreeModulesSet()) {
            if (degreeModule.isLeaf()) continue;
            return false;
        }
        return this.getNewDegreeModulesSet().size() > 0;
    }

    public boolean isTransitiveSource() {
        return this.getTransitiveSource();
    }

    public boolean canApply(StudentCurricularPlan oldStudentCurricularPlan) {
        boolean isApprovedInAll = true;
        for (DegreeModule degreeModule : this.getOldDegreeModulesSet()) {
            boolean isApprovedOrEnroled = oldStudentCurricularPlan.hasEnrolmentOrAprovalInCurriculumModule(degreeModule);
            if (this.getSourceDegreeModulesOperator().isOR() && isApprovedOrEnroled) {
                return true;
            }
            isApprovedInAll &= isApprovedOrEnroled;
        }
        return isApprovedInAll;
    }
}

