/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

public enum ContentType {
    JPG,
    PNG;


    public String getMimeType() {
        ContentType type = ContentType.valueOf(this.name());
        switch (type) {
            case JPG: {
                return "image/jpeg";
            }
            case PNG: {
                return "image/png";
            }
        }
        return "*/*";
    }

    public String getFileExtention() {
        return this.name().toLowerCase();
    }

    public static ContentType getContentType(String httpContentType) {
        String contentTypeInLowerCase = httpContentType.toLowerCase();
        if (contentTypeInLowerCase.equals("image/jpeg") || contentTypeInLowerCase.equals("image/jpg") || contentTypeInLowerCase.equals("image/pjpeg")) {
            return JPG;
        }
        if (contentTypeInLowerCase.equals("image/png") || contentTypeInLowerCase.equals("image/x-png")) {
            return PNG;
        }
        return null;
    }
}

