/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.teacher;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.LessonPlanning;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.Summary;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.ShowSummariesBean;
import org.fenixedu.academic.dto.SummariesCalendarBean;
import org.fenixedu.academic.dto.SummariesManagementBean;
import org.fenixedu.academic.dto.teacher.executionCourse.NextPossibleSummaryLessonsAndDatesBean;
import org.fenixedu.academic.dto.teacher.executionCourse.SummaryTeacherBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.teacher.CreateSummary;
import org.fenixedu.academic.service.services.teacher.DeleteSummary;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.teacher.ManageExecutionCourseDA;
import org.fenixedu.academic.util.HourMinuteSecond;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.portal.servlet.PortalLayoutInjector;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Partial;
import org.joda.time.YearMonthDay;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(module="teacher", path="/summariesManagement", formBean="summariesManagementForm", functionality=ManageExecutionCourseDA.class)
@Forwards(value={@Forward(name="prepareInsertSummary", path="/teacher/executionCourse/createSummary.jsp"), @Forward(name="prepareShowSummaries", path="/teacher/executionCourse/showSummaries.jsp"), @Forward(name="showSummariesCalendar", path="/teacher/executionCourse/showSummariesCalendar.jsp"), @Forward(name="prepareInsertComplexSummary", path="/teacher/executionCourse/createComplexSummary.jsp")})
public class SummariesManagementDA
extends FenixDispatchAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Professorship loggedProfessorship;
        IViewState viewState = RenderUtils.getViewState();
        ExecutionCourse executionCourse = null;
        executionCourse = viewState != null && viewState.getMetaObject().getObject() instanceof SummariesManagementBean ? ((SummariesManagementBean)viewState.getMetaObject().getObject()).getExecutionCourse() : (viewState != null && viewState.getMetaObject().getObject() instanceof ShowSummariesBean ? ((ShowSummariesBean)viewState.getMetaObject().getObject()).getExecutionCourse() : (viewState != null && viewState.getMetaObject().getObject() instanceof NextPossibleSummaryLessonsAndDatesBean ? ((NextPossibleSummaryLessonsAndDatesBean)viewState.getMetaObject().getObject()).getLesson().getShift().getDisciplinaExecucao() : this.readAndSaveExecutionCourse(request)));
        String teacherId = request.getParameter("teacherId_");
        if (!StringUtils.isEmpty((String)teacherId)) {
            Teacher loggedTeacher = Teacher.readByIstId(teacherId);
            loggedProfessorship = loggedTeacher.getProfessorshipByExecutionCourse(executionCourse);
        } else {
            loggedProfessorship = AccessControl.getPerson().getProfessorshipByExecutionCourse(executionCourse);
        }
        if (loggedProfessorship == null) {
            throw new FenixActionException("error.summariesManagement.empty.loggedProfessorship");
        }
        request.setAttribute("loggedTeacherProfessorship", (Object)loggedProfessorship);
        request.setAttribute("loggedIsResponsible", (Object)loggedProfessorship.isResponsibleFor());
        request.setAttribute("executionCourse", (Object)executionCourse);
        request.setAttribute("executionCourseID", (Object)executionCourse.getExternalId());
        request.setAttribute("professorship", (Object)loggedProfessorship);
        HashMap<String, Object> requestContext = new HashMap<String, Object>();
        requestContext.put("professorship", (Object)loggedProfessorship);
        requestContext.put("executionCourse", (Object)executionCourse);
        PortalLayoutInjector.addContextExtension(requestContext);
        return super.execute(mapping, actionForm, request, response);
    }

    public ActionForward prepareInsertSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.buildSummariesManagementBean(form, request, SummariesManagementBean.SummaryType.NORMAL_SUMMARY);
        return mapping.findForward("prepareInsertSummary");
    }

    public ActionForward prepareInsertTaughtSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.invalidateAndReloadView(request, "summariesManagementBeanWithNotTaughtSummary");
        return mapping.findForward("prepareInsertSummary");
    }

    public ActionForward prepareInsertNotTaughtSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.invalidateAndReloadView(request, "summariesManagementBeanWithSummary");
        return mapping.findForward("prepareInsertSummary");
    }

    public ActionForward prepareInsertExtraSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.buildSummariesManagementBean(form, request, SummariesManagementBean.SummaryType.EXTRA_SUMMARY);
        request.setAttribute("notShowLessonPlanningsAndSummaries", (Object)Boolean.TRUE);
        return mapping.findForward("prepareInsertSummary");
    }

    public ActionForward goToInsertSummaryAgain(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        IViewState viewState = RenderUtils.getViewState();
        SummariesManagementBean bean = (SummariesManagementBean)viewState.getMetaObject().getObject();
        this.readAndSaveTeacher(bean, (DynaActionForm)form, request, mapping);
        return this.goToSummaryManagementPageAgain(mapping, request, dynaActionForm, bean);
    }

    public ActionForward chooseLessonPlanning(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SummariesManagementBean bean;
        LessonPlanning lessonPlanning;
        IViewState summaryViewState = RenderUtils.getViewState((String)"summariesManagementBeanWithLessonPlanning");
        if (summaryViewState == null) {
            summaryViewState = RenderUtils.getViewState((String)"summariesManagementBeanWithSummary");
        }
        if ((lessonPlanning = (bean = (SummariesManagementBean)summaryViewState.getMetaObject().getObject()).getLessonPlanning()) != null) {
            bean.setSummaryText(lessonPlanning.getPlanning());
            bean.setTitle(lessonPlanning.getTitle());
            bean.setLastSummary(null);
        }
        return this.goToSummaryManagementPageAgain(mapping, request, (DynaActionForm)form, bean);
    }

    public ActionForward chooseLastSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SummariesManagementBean bean;
        Summary lastSummary;
        IViewState summaryViewState = RenderUtils.getViewState((String)"summariesManagementBeanWithLastSummary");
        if (summaryViewState == null) {
            summaryViewState = RenderUtils.getViewState((String)"summariesManagementBeanWithSummary");
        }
        if ((lastSummary = (bean = (SummariesManagementBean)summaryViewState.getMetaObject().getObject()).getLastSummary()) != null) {
            bean.setSummaryText(lastSummary.getSummaryText());
            bean.setTitle(lastSummary.getTitle());
            bean.setLessonPlanning(null);
        }
        return this.goToSummaryManagementPageAgain(mapping, request, (DynaActionForm)form, bean);
    }

    public ActionForward chooseShift(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IViewState viewState = RenderUtils.getViewState((String)"summariesManagementBeanWithShifts");
        SummariesManagementBean bean = (SummariesManagementBean)viewState.getMetaObject().getObject();
        bean.setLesson(null);
        bean.setSummaryDate(null);
        bean.setLessonType(null);
        if (bean.getSummaryType() != null && bean.getSummaryType().equals((Object)SummariesManagementBean.SummaryType.EXTRA_SUMMARY)) {
            request.setAttribute("notShowLessonPlanningsAndSummaries", (Object)Boolean.TRUE);
        }
        return this.goToSummaryManagementPageAgain(mapping, request, (DynaActionForm)form, bean);
    }

    public ActionForward chooseLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IViewState viewState = RenderUtils.getViewState((String)"summariesManagementBeanWithLessons");
        SummariesManagementBean bean = (SummariesManagementBean)viewState.getMetaObject().getObject();
        bean.setSummaryDate(null);
        bean.setLessonType(null);
        Lesson lesson = bean.getLesson();
        if (lesson != null && lesson.getShift().getCourseLoadsSet().size() == 1) {
            bean.setLessonType(((CourseLoad)((Object)lesson.getShift().getCourseLoadsSet().iterator().next())).getType());
        }
        return this.goToSummaryManagementPageAgain(mapping, request, (DynaActionForm)form, bean);
    }

    public ActionForward chooseLessonType(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IViewState viewState = RenderUtils.getViewState((String)"summariesManagementBeanWithLessonTypes");
        SummariesManagementBean bean = (SummariesManagementBean)viewState.getMetaObject().getObject();
        return this.goToSummaryManagementPageAgain(mapping, request, (DynaActionForm)form, bean);
    }

    public ActionForward chooseDate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        IViewState viewState = RenderUtils.getViewState((String)"summariesManagementBeanWithDate");
        SummariesManagementBean bean = (SummariesManagementBean)viewState.getMetaObject().getObject();
        return this.goToSummaryManagementPageAgain(mapping, request, dynaActionForm, bean);
    }

    public ActionForward chooseSummaryType(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        IViewState viewState = RenderUtils.getViewState();
        SummariesManagementBean bean = (SummariesManagementBean)viewState.getMetaObject().getObject();
        bean.setShift(null);
        bean.setLesson(null);
        bean.setSummaryDate(null);
        bean.setSummaryRoom(null);
        bean.setSummaryTime(null);
        bean.setLessonType(null);
        if (bean.getSummaryType() != null && bean.getSummaryType().equals((Object)SummariesManagementBean.SummaryType.EXTRA_SUMMARY)) {
            request.setAttribute("notShowLessonPlanningsAndSummaries", (Object)Boolean.TRUE);
        }
        return this.goToSummaryManagementPageAgain(mapping, request, dynaActionForm, bean);
    }

    public ActionForward createSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        IViewState viewState = RenderUtils.getViewState();
        SummariesManagementBean bean = (SummariesManagementBean)viewState.getMetaObject().getObject();
        this.readAndSaveTeacher(bean, (DynaActionForm)form, request, mapping);
        if (!bean.getTaught().booleanValue()) {
            bean.setTitle(new MultiLanguageString("Not Taught."));
        }
        try {
            if (bean.getSummary() == null) {
                CreateSummary.runCreateSummary(bean);
            } else {
                CreateSummary.runEditSummary(bean);
            }
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
            return this.goToSummaryManagementPageAgain(mapping, request, (DynaActionForm)form, bean);
        }
        catch (NotAuthorizedException e) {
            this.addActionMessage(request, e.getMessage());
            return this.goToSummaryManagementPageAgain(mapping, request, (DynaActionForm)form, bean);
        }
        return this.prepareShowSummaries(mapping, form, request, response);
    }

    public ActionForward createSummaryAndNew(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        IViewState viewState = RenderUtils.getViewState();
        SummariesManagementBean bean = (SummariesManagementBean)viewState.getMetaObject().getObject();
        this.readAndSaveTeacher(bean, (DynaActionForm)form, request, mapping);
        try {
            CreateSummary.runCreateSummary(bean);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
            return this.goToSummaryManagementPageAgain(mapping, request, (DynaActionForm)form, bean);
        }
        catch (NotAuthorizedException e) {
            this.addActionMessage(request, e.getMessage());
            return this.goToSummaryManagementPageAgain(mapping, request, (DynaActionForm)form, bean);
        }
        RenderUtils.invalidateViewState();
        return this.prepareInsertSummary(mapping, form, request, response);
    }

    public ActionForward createSummaryAndSame(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        IViewState viewState = RenderUtils.getViewState();
        SummariesManagementBean bean = (SummariesManagementBean)viewState.getMetaObject().getObject();
        this.readAndSaveTeacher(bean, (DynaActionForm)form, request, mapping);
        try {
            CreateSummary.runCreateSummary(bean);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
            return this.goToSummaryManagementPageAgain(mapping, request, (DynaActionForm)form, bean);
        }
        catch (NotAuthorizedException e) {
            this.addActionMessage(request, e.getMessage());
            return this.goToSummaryManagementPageAgain(mapping, request, (DynaActionForm)form, bean);
        }
        RenderUtils.invalidateViewState();
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        Professorship loggedProfessorship = (Professorship)((Object)request.getAttribute("loggedTeacherProfessorship"));
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        dynaActionForm.set("teacher", (Object)loggedProfessorship.getExternalId().toString());
        SummariesManagementBean newBean = new SummariesManagementBean(SummariesManagementBean.SummaryType.NORMAL_SUMMARY, executionCourse, loggedProfessorship, null);
        newBean.setSummaryText(bean.getSummaryText());
        newBean.setTitle(bean.getTitle());
        request.setAttribute("summariesManagementBean", (Object)newBean);
        return mapping.findForward("prepareInsertSummary");
    }

    public ActionForward prepareEditSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        SummariesManagementBean.SummaryType summaryType;
        Professorship teacherLogged = (Professorship)((Object)request.getAttribute("loggedTeacherProfessorship"));
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        Summary summary = this.getSummaryFromParameter(request);
        if (summary.isExtraSummary()) {
            summaryType = SummariesManagementBean.SummaryType.EXTRA_SUMMARY;
            request.setAttribute("notShowLessonPlanningsAndSummaries", (Object)Boolean.TRUE);
        } else {
            summaryType = SummariesManagementBean.SummaryType.NORMAL_SUMMARY;
        }
        DateTimeFieldType[] dateTimeFieldTypes = new DateTimeFieldType[]{DateTimeFieldType.hourOfDay(), DateTimeFieldType.minuteOfHour()};
        HourMinuteSecond time = summary.getSummaryHourHourMinuteSecond();
        int[] timeArray = new int[]{time.getHour(), time.getMinuteOfHour()};
        Partial timePartial = new Partial(dateTimeFieldTypes, timeArray);
        SummariesManagementBean bean = new SummariesManagementBean(summary.getTitle(), summary.getSummaryText(), summary.getStudentsNumber(), summaryType, summary.getProfessorship(), summary.getTeacherName(), summary.getTeacher(), summary.getShift(), summary.getLesson(), summary.getSummaryDateYearMonthDay(), summary.getRoom(), timePartial, summary, teacherLogged, summary.getSummaryType(), summary.getTaught());
        return this.goToSummaryManagementPageAgain(mapping, request, dynaActionForm, bean);
    }

    public ActionForward deleteSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        Summary summary = this.getSummaryFromParameter(request);
        Professorship professorshipLogged = (Professorship)((Object)request.getAttribute("loggedTeacherProfessorship"));
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        try {
            DeleteSummary.runDeleteSummary(executionCourse, summary, professorshipLogged);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
            return this.prepareShowSummaries(mapping, form, request, response);
        }
        catch (NotAuthorizedException e) {
            this.addActionMessage(request, e.getMessage());
            return this.prepareShowSummaries(mapping, form, request, response);
        }
        return this.prepareShowSummaries(mapping, form, request, response);
    }

    public ActionForward prepareShowSummaries(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        Professorship professorshipLogged = (Professorship)((Object)request.getAttribute("loggedTeacherProfessorship"));
        TreeSet<Summary> teacherSummaries = new TreeSet<Summary>(Summary.COMPARATOR_BY_DATE_AND_HOUR);
        teacherSummaries.addAll(professorshipLogged.getAssociatedSummariesSet());
        this.readAndSaveNextPossibleSummaryLessonsAndDates(request, executionCourse);
        request.setAttribute("showSummariesBean", (Object)new ShowSummariesBean(new SummaryTeacherBean(professorshipLogged), executionCourse, ShowSummariesBean.ListSummaryType.ALL_CONTENT, professorshipLogged));
        if (professorshipLogged.getTeacher() != null) {
            request.setAttribute("teacherId", (Object)professorshipLogged.getTeacher().getPerson().getUsername());
        }
        request.setAttribute("summaries", teacherSummaries);
        return mapping.findForward("prepareShowSummaries");
    }

    public ActionForward showSummariesPostBack(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IViewState viewState = RenderUtils.getViewState();
        ShowSummariesBean bean = (ShowSummariesBean)viewState.getMetaObject().getObject();
        ExecutionCourse executionCourse = bean.getExecutionCourse();
        ShiftType shiftType = bean.getShiftType();
        Shift shift = bean.getShift();
        SummaryTeacherBean summaryTeacher = bean.getSummaryTeacher();
        Professorship teacher = summaryTeacher != null ? summaryTeacher.getProfessorship() : null;
        Boolean otherTeachers = summaryTeacher != null ? summaryTeacher.getOthers() : null;
        ShowSummariesBean.SummariesOrder summariesOrder = bean.getSummariesOrder();
        TreeSet<Summary> summariesToShow = summariesOrder == null || summariesOrder.equals((Object)ShowSummariesBean.SummariesOrder.DECREASING) ? new TreeSet<Summary>(Summary.COMPARATOR_BY_DATE_AND_HOUR) : new TreeSet<Summary>((Comparator<Summary>)new ReverseComparator(Summary.COMPARATOR_BY_DATE_AND_HOUR));
        for (Summary summary : executionCourse.getAssociatedSummariesSet()) {
            boolean insert = true;
            if (shift != null && (summary.getShift() == null || !summary.getShift().equals((Object)shift)) || teacher != null && (summary.getProfessorship() == null || !summary.getProfessorship().equals((Object)teacher)) || shiftType != null && (summary.getSummaryType() == null || !summary.getSummaryType().equals((Object)shiftType)) || otherTeachers != null && otherTeachers.booleanValue() && summary.getProfessorship() != null) {
                insert = false;
            }
            if (!insert) continue;
            summariesToShow.add(summary);
        }
        this.readAndSaveNextPossibleSummaryLessonsAndDates(request, executionCourse);
        request.setAttribute("showSummariesBean", (Object)bean);
        request.setAttribute("summaries", summariesToShow);
        return mapping.findForward("prepareShowSummaries");
    }

    public ActionForward prepareCreateComplexSummaryInSummariesCalendarMode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        Professorship loggedProfessorship = (Professorship)((Object)request.getAttribute("loggedTeacherProfessorship"));
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        NextPossibleSummaryLessonsAndDatesBean nextSummaryDateBean = this.getNextSummaryDateBeanFromParameter(request);
        if (!executionCourse.getLessons().contains((Object)nextSummaryDateBean.getLesson())) {
            throw new FenixActionException();
        }
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        ArrayList<NextPossibleSummaryLessonsAndDatesBean> nextPossibleLessonsDates = new ArrayList<NextPossibleSummaryLessonsAndDatesBean>();
        nextPossibleLessonsDates.add(nextSummaryDateBean);
        SummariesManagementBean bean = new SummariesManagementBean(SummariesManagementBean.SummaryType.NORMAL_SUMMARY, executionCourse, loggedProfessorship, nextPossibleLessonsDates);
        Shift shift = nextSummaryDateBean.getLesson().getShift();
        if (shift.getCourseLoadsSet().size() != 1) {
            request.setAttribute("notShowLessonPlanningsAndSummaries", (Object)Boolean.TRUE);
        } else {
            nextSummaryDateBean.setLessonType(((CourseLoad)((Object)shift.getCourseLoadsSet().iterator().next())).getType());
            bean.setLessonType(nextSummaryDateBean.getLessonType());
        }
        request.setAttribute("summariesManagementBean", (Object)bean);
        dynaActionForm.set("teacher", (Object)loggedProfessorship.getExternalId().toString());
        return mapping.findForward("prepareInsertComplexSummary");
    }

    public ActionForward prepareCreateTaughtComplexSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.invalidateAndReloadView(request, "summariesManagementBeanWithNotTaughtSummary");
        return mapping.findForward("prepareInsertComplexSummary");
    }

    private void invalidateAndReloadView(HttpServletRequest request, String view) {
        IViewState summaryViewState = RenderUtils.getViewState((String)view);
        SummariesManagementBean summaryBean = (SummariesManagementBean)summaryViewState.getMetaObject().getObject();
        if (summaryBean.getTitle().equals(new MultiLanguageString("Not Taught."))) {
            summaryBean.setTitle(new MultiLanguageString(""));
        }
        RenderUtils.invalidateViewState((String)view);
        request.setAttribute("summariesManagementBean", (Object)summaryBean);
    }

    public ActionForward prepareCreateNotTaughtComplexSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.invalidateAndReloadView(request, "summariesManagementBeanWithSummary");
        return mapping.findForward("prepareInsertComplexSummary");
    }

    public ActionForward prepareCreateComplexSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Professorship loggedProfessorship = (Professorship)((Object)request.getAttribute("loggedTeacherProfessorship"));
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        String[] selectedLessons = request.getParameterValues("selectedLessonAndDate");
        if (selectedLessons == null || selectedLessons.length == 0) {
            return this.goToInsertComplexSummaryAgain(request, mapping, response, form);
        }
        if (selectedLessons != null && selectedLessons.length != 0) {
            boolean uniqueType = true;
            ShiftType shiftType = null;
            ArrayList<NextPossibleSummaryLessonsAndDatesBean> nextPossibleLessonsDates = new ArrayList<NextPossibleSummaryLessonsAndDatesBean>();
            for (String lessonRepresentation : selectedLessons) {
                NextPossibleSummaryLessonsAndDatesBean nextLesson = NextPossibleSummaryLessonsAndDatesBean.getNewInstance(lessonRepresentation);
                if (nextLesson.getLesson().getShift().getCourseLoadsSet().size() == 1) {
                    nextLesson.setLessonType(((CourseLoad)((Object)nextLesson.getLesson().getShift().getCourseLoadsSet().iterator().next())).getType());
                }
                nextPossibleLessonsDates.add(nextLesson);
                ShiftType lessonType = null;
                if (nextLesson.getLesson().getShift().getCourseLoadsSet().size() == 1) {
                    lessonType = ((CourseLoad)((Object)nextLesson.getLesson().getShift().getCourseLoadsSet().iterator().next())).getType();
                    if (shiftType == null) {
                        shiftType = lessonType;
                        continue;
                    }
                    if (shiftType.equals((Object)lessonType)) continue;
                    request.setAttribute("notShowLessonPlanningsAndSummaries", (Object)Boolean.TRUE);
                    uniqueType = false;
                    continue;
                }
                request.setAttribute("notShowLessonPlanningsAndSummaries", (Object)Boolean.TRUE);
                uniqueType = false;
            }
            SummariesManagementBean bean = new SummariesManagementBean(SummariesManagementBean.SummaryType.NORMAL_SUMMARY, executionCourse, loggedProfessorship, nextPossibleLessonsDates);
            bean.setTaught(true);
            if (uniqueType) {
                bean.setLessonType(shiftType);
            }
            request.setAttribute("summariesManagementBean", (Object)bean);
            dynaActionForm.set("teacher", (Object)loggedProfessorship.getExternalId().toString());
            return mapping.findForward("prepareInsertComplexSummary");
        }
        return this.prepareShowSummaries(mapping, form, request, response);
    }

    public ActionForward createComplexSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        SummariesManagementBean summaryBean = this.getSummariesManagementBean();
        this.readAndSaveTeacher(summaryBean, (DynaActionForm)form, request, mapping);
        for (NextPossibleSummaryLessonsAndDatesBean bean : summaryBean.getNextPossibleSummaryLessonsAndDatesBean()) {
            summaryBean.setShift(bean.getLesson().getShift());
            summaryBean.setLesson(bean.getLesson());
            summaryBean.setSummaryDate(bean.getDate());
            summaryBean.setStudentsNumber(bean.getStudentsNumber());
            summaryBean.setLessonType(bean.getLessonType());
            if (!summaryBean.getTaught().booleanValue()) {
                summaryBean.setTitle(new MultiLanguageString("Not Taught."));
            }
            try {
                CreateSummary.runCreateSummary(summaryBean);
            }
            catch (DomainException e) {
                return this.returnToCreateComplexSummary(mapping, form, request, summaryBean, (Exception)((Object)e));
            }
            catch (NotAuthorizedException e) {
                return this.returnToCreateComplexSummary(mapping, form, request, summaryBean, e);
            }
        }
        return this.prepareShowSummaries(mapping, form, request, response);
    }

    private SummariesManagementBean getSummariesManagementBean() {
        IViewState summaryViewState = RenderUtils.getViewState((String)"summariesManagementBeanWithSummary");
        if (summaryViewState != null) {
            return (SummariesManagementBean)summaryViewState.getMetaObject().getObject();
        }
        IViewState notTaughtSummaryViewState = RenderUtils.getViewState((String)"summariesManagementBeanWithNotTaughtSummary");
        if (notTaughtSummaryViewState != null) {
            return (SummariesManagementBean)notTaughtSummaryViewState.getMetaObject().getObject();
        }
        return null;
    }

    public ActionForward chooseLessonPlanningToCreateComplexSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SummariesManagementBean summaryBean;
        LessonPlanning lessonPlanning;
        IViewState summaryViewState = RenderUtils.getViewState((String)"summariesManagementBeanWithLessonPlanning");
        if (summaryViewState == null) {
            summaryViewState = RenderUtils.getViewState((String)"summariesManagementBeanWithSummary");
        }
        if ((lessonPlanning = (summaryBean = (SummariesManagementBean)summaryViewState.getMetaObject().getObject()).getLessonPlanning()) != null) {
            summaryBean.setSummaryText(lessonPlanning.getPlanning());
            summaryBean.setTitle(lessonPlanning.getTitle());
            summaryBean.setLastSummary(null);
        }
        return this.returnToCreateComplexSummary(mapping, form, request, summaryBean, null);
    }

    public ActionForward chooseLastSummaryToCreateComplexSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SummariesManagementBean summaryBean;
        Summary lastSummary;
        IViewState summaryViewState = RenderUtils.getViewState((String)"summariesManagementBeanWithLastSummary");
        if (summaryViewState == null) {
            summaryViewState = RenderUtils.getViewState((String)"summariesManagementBeanWithSummary");
        }
        if ((lastSummary = (summaryBean = (SummariesManagementBean)summaryViewState.getMetaObject().getObject()).getLastSummary()) != null) {
            summaryBean.setSummaryText(lastSummary.getSummaryText());
            summaryBean.setTitle(lastSummary.getTitle());
            summaryBean.setLessonPlanning(null);
        }
        return this.returnToCreateComplexSummary(mapping, form, request, summaryBean, null);
    }

    public ActionForward showSummariesCalendar(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionCourse executionCourse = this.getExecutinCourseFromParameter(request);
        SummariesCalendarBean summariesCalendarBean = new SummariesCalendarBean(executionCourse);
        TreeSet<NextPossibleSummaryLessonsAndDatesBean> summariesCalendar = new TreeSet<NextPossibleSummaryLessonsAndDatesBean>(NextPossibleSummaryLessonsAndDatesBean.COMPARATOR_BY_DATE_AND_HOUR);
        Set<Shift> associatedShifts = executionCourse.getAssociatedShifts();
        for (Shift shift : associatedShifts) {
            for (Lesson lesson : shift.getAssociatedLessonsSet()) {
                for (YearMonthDay lessonDate : lesson.getAllLessonDates()) {
                    summariesCalendar.add(new NextPossibleSummaryLessonsAndDatesBean(lesson, lessonDate));
                }
            }
            this.addExtraSummariesToSummariesCalendar(summariesCalendar, shift, summariesCalendarBean.getCalendarViewType());
        }
        request.setAttribute("showSummariesCalendarBean", (Object)summariesCalendarBean);
        request.setAttribute("summariesCalendarResult", summariesCalendar);
        return mapping.findForward("showSummariesCalendar");
    }

    public ActionForward showSummariesCalendarPostBack(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IViewState viewState = RenderUtils.getViewState();
        SummariesCalendarBean bean = (SummariesCalendarBean)viewState.getMetaObject().getObject();
        ExecutionCourse executionCourse = bean.getExecutionCourse();
        Shift shift = bean.getShift();
        ShiftType shiftType = bean.getShiftType();
        SummariesCalendarBean.LessonCalendarViewType calendarViewType = bean.getCalendarViewType();
        TreeSet<NextPossibleSummaryLessonsAndDatesBean> summariesCalendar = new TreeSet<NextPossibleSummaryLessonsAndDatesBean>(NextPossibleSummaryLessonsAndDatesBean.COMPARATOR_BY_DATE_AND_HOUR);
        for (Lesson lesson : executionCourse.getLessons()) {
            boolean insert = true;
            if (shift != null && !shift.getAssociatedLessonsSet().contains((Object)lesson) || shiftType != null && !lesson.getShift().containsType(shiftType)) {
                insert = false;
            }
            if (!insert) continue;
            for (YearMonthDay lessonDate : lesson.getAllLessonDates()) {
                if (!calendarViewType.equals((Object)SummariesCalendarBean.LessonCalendarViewType.ALL_LESSONS) && (!calendarViewType.equals((Object)SummariesCalendarBean.LessonCalendarViewType.PAST_LESSON) || !lesson.isTimeValidToInsertSummary(new HourMinuteSecond(), lessonDate)) && (!calendarViewType.equals((Object)SummariesCalendarBean.LessonCalendarViewType.PAST_LESSON_WITHOUT_SUMMARY) || lesson.getSummaryByDate(lessonDate) != null || !lesson.isTimeValidToInsertSummary(new HourMinuteSecond(), lessonDate))) continue;
                summariesCalendar.add(new NextPossibleSummaryLessonsAndDatesBean(lesson, lessonDate));
            }
        }
        if (shift != null) {
            if (shiftType == null) {
                this.addExtraSummariesToSummariesCalendar(summariesCalendar, shift, calendarViewType);
            }
        } else {
            for (Shift executionCourseShift : executionCourse.getAssociatedShifts()) {
                if (shiftType != null) continue;
                this.addExtraSummariesToSummariesCalendar(summariesCalendar, executionCourseShift, calendarViewType);
            }
        }
        request.setAttribute("summariesCalendarResult", summariesCalendar);
        request.setAttribute("showSummariesCalendarBean", (Object)bean);
        return mapping.findForward("showSummariesCalendar");
    }

    private void addExtraSummariesToSummariesCalendar(Set<NextPossibleSummaryLessonsAndDatesBean> summariesCalendar, Shift shift, SummariesCalendarBean.LessonCalendarViewType calendarViewType) {
        if (!calendarViewType.equals((Object)SummariesCalendarBean.LessonCalendarViewType.PAST_LESSON_WITHOUT_SUMMARY)) {
            List<Summary> extraSummaries = shift.getExtraSummaries();
            for (Summary summary : extraSummaries) {
                if (!calendarViewType.equals((Object)SummariesCalendarBean.LessonCalendarViewType.ALL_LESSONS) && (!calendarViewType.equals((Object)SummariesCalendarBean.LessonCalendarViewType.PAST_LESSON) || !summary.getSummaryDateTime().isBeforeNow())) continue;
                summariesCalendar.add(new NextPossibleSummaryLessonsAndDatesBean(shift, summary.getSummaryDateYearMonthDay(), summary.getSummaryHourHourMinuteSecond(), summary.getRoom()));
            }
        }
    }

    private void buildSummariesManagementBean(ActionForm form, HttpServletRequest request, SummariesManagementBean.SummaryType summaryType) {
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        Professorship loggedProfessorship = (Professorship)((Object)request.getAttribute("loggedTeacherProfessorship"));
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        dynaActionForm.set("teacher", (Object)loggedProfessorship.getExternalId().toString());
        request.setAttribute("summariesManagementBean", (Object)new SummariesManagementBean(summaryType, executionCourse, loggedProfessorship, null));
    }

    private ActionForward goToInsertComplexSummaryAgain(HttpServletRequest request, ActionMapping mapping, HttpServletResponse response, ActionForm form) {
        IViewState summaryViewState = RenderUtils.getViewState((String)"summariesManagementBeanWithSummary");
        if (summaryViewState != null) {
            SummariesManagementBean summaryBean = (SummariesManagementBean)summaryViewState.getMetaObject().getObject();
            this.readAndSaveTeacher(summaryBean, (DynaActionForm)form, request, mapping);
            return this.returnToCreateComplexSummary(mapping, form, request, summaryBean, null);
        }
        return this.prepareShowSummaries(mapping, form, request, response);
    }

    private ActionForward returnToCreateComplexSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, SummariesManagementBean summaryBean, Exception e) {
        if (e != null) {
            this.addActionMessage(request, e.getMessage());
        }
        this.setTeacherDataToFormBean((DynaActionForm)form, summaryBean);
        request.setAttribute("summariesManagementBean", (Object)summaryBean);
        return mapping.findForward("prepareInsertComplexSummary");
    }

    private void readAndSaveTeacher(SummariesManagementBean bean, DynaActionForm dynaActionForm, HttpServletRequest request, ActionMapping mapping) {
        Professorship professorship = this.getProfessorshipFromParameter(request);
        if (professorship != null) {
            bean.setProfessorship(professorship);
            bean.setTeacher(null);
            bean.setTeacherName("");
        } else if (dynaActionForm.getString("teacher").equals("-1") && !StringUtils.isEmpty((String)dynaActionForm.getString("teacherName"))) {
            bean.setTeacherName(dynaActionForm.getString("teacherName"));
            bean.setTeacher(null);
            bean.setProfessorship(null);
        } else if (dynaActionForm.getString("teacher").equals("0") && !StringUtils.isEmpty((String)dynaActionForm.getString("teacherId"))) {
            Teacher teacher = null;
            try {
                teacher = Teacher.readByIstId(dynaActionForm.getString("teacherId"));
            }
            catch (NumberFormatException e) {
                this.addActionMessage(request, "error.summary.teacherNumber.invalid");
            }
            if (teacher == null) {
                this.addActionMessage(request, "error.summary.inexistent.teacher");
            }
            bean.setTeacher(teacher);
            bean.setTeacherName(null);
            bean.setProfessorship(null);
        }
    }

    private void readAndSaveNextPossibleSummaryLessonsAndDates(HttpServletRequest request, ExecutionCourse executionCourse) {
        TreeSet<NextPossibleSummaryLessonsAndDatesBean> possibleLessonsAndDates = new TreeSet<NextPossibleSummaryLessonsAndDatesBean>(NextPossibleSummaryLessonsAndDatesBean.COMPARATOR_BY_DATE_AND_HOUR);
        for (Shift shift : executionCourse.getAssociatedShifts()) {
            for (Lesson lesson : shift.getAssociatedLessonsSet()) {
                YearMonthDay nextPossibleSummaryDate = lesson.getNextPossibleSummaryDate();
                if (nextPossibleSummaryDate == null) continue;
                possibleLessonsAndDates.add(new NextPossibleSummaryLessonsAndDatesBean(lesson, nextPossibleSummaryDate));
            }
        }
        request.setAttribute("nextPossibleLessonsDates", possibleLessonsAndDates);
    }

    private ActionForward goToSummaryManagementPageAgain(ActionMapping mapping, HttpServletRequest request, DynaActionForm dynaActionForm, SummariesManagementBean bean) {
        this.setTeacherDataToFormBean(dynaActionForm, bean);
        request.setAttribute("summariesManagementBean", (Object)bean);
        return mapping.findForward("prepareInsertSummary");
    }

    private void setTeacherDataToFormBean(DynaActionForm dynaActionForm, SummariesManagementBean bean) {
        if (!bean.getTeacherChoose().equals("")) {
            dynaActionForm.set("teacher", (Object)bean.getTeacherChoose());
            dynaActionForm.set("teacherName", (Object)(bean.getTeacherName() != null ? bean.getTeacherName() : ""));
            dynaActionForm.set("teacherId", (Object)(bean.getTeacher() != null ? String.valueOf(bean.getTeacher().getPerson().getUsername()) : ""));
        }
    }

    private ExecutionCourse readAndSaveExecutionCourse(HttpServletRequest request) {
        ExecutionCourse executionCourse = this.getExecutinCourseFromParameter(request);
        request.setAttribute("executionCourse", (Object)executionCourse);
        return executionCourse;
    }

    private ExecutionCourse getExecutinCourseFromParameter(HttpServletRequest request) {
        String executionCourseIDString = request.getParameterMap().containsKey("executionCourseID") ? request.getParameter("executionCourseID") : (String)request.getAttribute("executionCourseID");
        return (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseIDString);
    }

    private Summary getSummaryFromParameter(HttpServletRequest request) {
        String summaryIDString = request.getParameterMap().containsKey("summaryID") ? request.getParameter("summaryID") : (String)request.getAttribute("summaryID");
        return (Summary)FenixFramework.getDomainObject((String)summaryIDString);
    }

    private NextPossibleSummaryLessonsAndDatesBean getNextSummaryDateBeanFromParameter(HttpServletRequest request) {
        String summaryDateString = request.getParameterMap().containsKey("summaryDate") ? request.getParameter("summaryDate") : (String)request.getAttribute("summaryDate");
        return StringUtils.isEmpty((String)summaryDateString) ? null : NextPossibleSummaryLessonsAndDatesBean.getNewInstance(summaryDateString);
    }

    private Professorship getProfessorshipFromParameter(HttpServletRequest request) {
        String professorshipIDString;
        String string = professorshipIDString = request.getParameterMap().containsKey("teacher") ? request.getParameter("teacher") : (String)request.getAttribute("teacher");
        if (!(StringUtils.isEmpty((String)professorshipIDString) || professorshipIDString.equals("0") || professorshipIDString.equals("-1"))) {
            return (Professorship)FenixFramework.getDomainObject((String)professorshipIDString);
        }
        return null;
    }
}

