/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager.exams;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.dto.InfoRoom;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.RAMApplication;
import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.academic.util.HourMinuteSecond;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=RAMApplication.RAMEvaluationsApp.class, path="room-search", titleKey="link.exams.searchAvailableRooms")
@Mapping(module="resourceAllocationManager", path="/roomSearch", formBean="roomSearchForm")
@Forwards(value={@Forward(name="showRooms", path="/resourceAllocationManager/exams/showRooms.jsp"), @Forward(name="roomSearch", path="/resourceAllocationManager/exams/roomSearch.jsp")})
public class RoomSearchDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("roomSearch");
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaValidatorForm roomSearchForm = (DynaValidatorForm)form;
        Calendar searchDate = Calendar.getInstance();
        Integer day = new Integer((String)roomSearchForm.get("day"));
        Integer month = new Integer((String)roomSearchForm.get("month"));
        Integer year = new Integer((String)roomSearchForm.get("year"));
        request.setAttribute("day", (Object)day.toString());
        request.setAttribute("month", (Object)month.toString());
        request.setAttribute("year", (Object)year.toString());
        searchDate.set(1, year);
        searchDate.set(2, month - 1);
        searchDate.set(5, day);
        if (searchDate.get(7) == 1) {
            ActionError actionError = new ActionError("error.sunday");
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add("error.sunday", actionError);
            this.saveErrors(request, actionErrors);
            return this.prepare(mapping, form, request, response);
        }
        Calendar searchStartTime = Calendar.getInstance();
        Integer startHour = new Integer((String)roomSearchForm.get("beginningHour"));
        Integer startMinute = new Integer((String)roomSearchForm.get("beginningMinute"));
        request.setAttribute("beginningHour", (Object)startHour.toString());
        request.setAttribute("beginningMinute", (Object)startMinute.toString());
        searchStartTime.set(11, startHour);
        searchStartTime.set(12, startMinute);
        searchStartTime.set(13, 0);
        Calendar searchEndTime = Calendar.getInstance();
        Integer endHour = new Integer((String)roomSearchForm.get("endHour"));
        Integer endMinute = new Integer((String)roomSearchForm.get("endMinute"));
        request.setAttribute("endHour", (Object)endHour.toString());
        request.setAttribute("endMinute", (Object)endMinute.toString());
        searchEndTime.set(11, endHour);
        searchEndTime.set(12, endMinute);
        searchEndTime.set(13, 0);
        if (searchStartTime.after(searchEndTime)) {
            ActionError actionError = new ActionError("error.timeSwitched");
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add("error.timeSwitched", actionError);
            this.saveErrors(request, actionErrors);
            return this.prepare(mapping, form, request, response);
        }
        int dayOfWeekInt = searchDate.get(7);
        DiaSemana dayOfWeek = new DiaSemana(dayOfWeekInt);
        List<InfoRoom> availableInfoRoom = null;
        availableInfoRoom = SpaceUtils.allocatableSpace(YearMonthDay.fromCalendarFields((Calendar)searchDate), YearMonthDay.fromCalendarFields((Calendar)searchDate), HourMinuteSecond.fromCalendarFields(searchStartTime), HourMinuteSecond.fromCalendarFields(searchEndTime), dayOfWeek, null, null, false);
        String sdate = roomSearchForm.get("day") + "/" + roomSearchForm.get("month") + "/" + roomSearchForm.get("year");
        String startTime = roomSearchForm.get("beginningHour") + ":" + roomSearchForm.get("beginningMinute");
        String endTime = roomSearchForm.get("endHour") + ":" + roomSearchForm.get("endMinute");
        request.setAttribute("date", (Object)sdate);
        request.setAttribute("start_time", (Object)startTime);
        request.setAttribute("end_time", (Object)endTime);
        Integer exam = null;
        Integer normal = null;
        List<Object> newAvailableInfoRoom = new ArrayList();
        if (availableInfoRoom != null && !availableInfoRoom.isEmpty()) {
            try {
                exam = new Integer((String)roomSearchForm.get("exam"));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            try {
                normal = new Integer((String)roomSearchForm.get("normal"));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (normal != null || exam != null) {
                for (InfoRoom elem : availableInfoRoom) {
                    if (normal != null && elem.getCapacidadeNormal() < normal || exam != null && elem.getCapacidadeExame() < exam) continue;
                    newAvailableInfoRoom.add(elem);
                }
            } else {
                newAvailableInfoRoom = availableInfoRoom;
            }
        }
        if (newAvailableInfoRoom != null && !newAvailableInfoRoom.isEmpty()) {
            Collections.sort(newAvailableInfoRoom, new BeanComparator("nome"));
            String[] availableRoomId = new String[newAvailableInfoRoom.size()];
            Iterator<Object> iter = newAvailableInfoRoom.iterator();
            int i = 0;
            while (iter.hasNext()) {
                InfoRoom elem = (InfoRoom)iter.next();
                availableRoomId[i] = elem.getExternalId().toString();
            }
            request.setAttribute("availableRoomsId", (Object)availableRoomId);
        }
        request.setAttribute("availableRooms", newAvailableInfoRoom);
        return mapping.findForward("showRooms");
    }

    public ActionForward sort(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaValidatorForm roomSearchForm = (DynaValidatorForm)form;
        String[] availableRoomsId = (String[])roomSearchForm.get("availableRoomsId");
        String sortParameter = request.getParameter("sortParameter");
        ArrayList<InfoRoom> availableRooms = new ArrayList<InfoRoom>();
        for (String element : availableRoomsId) {
            Space room = (Space)FenixFramework.getDomainObject((String)element);
            availableRooms.add(InfoRoom.newInfoFromDomain(room));
        }
        if (sortParameter != null && sortParameter.length() != 0) {
            if (sortParameter.equals("name")) {
                Collections.sort(availableRooms, new BeanComparator("nome"));
            } else if (sortParameter.equals("type")) {
                Collections.sort(availableRooms, new BeanComparator("tipo"));
            } else if (sortParameter.equals("building")) {
                Collections.sort(availableRooms, new BeanComparator("edificio"));
            } else if (sortParameter.equals("floor")) {
                Collections.sort(availableRooms, new BeanComparator("piso"));
            } else if (sortParameter.equals("normal")) {
                Collections.sort(availableRooms, new ReverseComparator((Comparator)new BeanComparator("capacidadeNormal")));
            } else if (sortParameter.equals("exam")) {
                Collections.sort(availableRooms, new ReverseComparator((Comparator)new BeanComparator("capacidadeExame")));
            }
        } else {
            Collections.sort(availableRooms, new BeanComparator("nome"));
        }
        String sdate = roomSearchForm.get("day") + "/" + roomSearchForm.get("month") + "/" + roomSearchForm.get("year");
        String startTime = roomSearchForm.get("beginningHour") + ":" + roomSearchForm.get("beginningMinute");
        String endTime = roomSearchForm.get("endHour") + ":" + roomSearchForm.get("endMinute");
        request.setAttribute("date", (Object)sdate);
        request.setAttribute("start_time", (Object)startTime);
        request.setAttribute("end_time", (Object)endTime);
        request.setAttribute("availableRooms", availableRooms);
        request.setAttribute("availableRoomsId", (Object)availableRoomsId);
        return mapping.findForward("showRooms");
    }
}

