/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager;

import com.google.common.io.CharStreams;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.dto.GenericPair;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.RAMApplication;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.ShiftDistributionFileBean;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StrutsFunctionality(app=RAMApplication.RAMFirstYearShiftsApp.class, path="shift-distribution", titleKey="link.firstTimeStudents.shiftDistribution", accessGroup="nobody")
@Mapping(path="/shiftDistributionFirstYear", module="resourceAllocationManager")
@Forwards(value={@Forward(name="shiftDistribution", path="/resourceAllocationManager/firstTimeStudents/uploadAndDistributeShifts.jsp"), @Forward(name="showStudentPerformanceGrid", path="/resourceAllocationManager/firstTimeStudents/showStudentPerformanceGrid.jsp"), @Forward(name="showStudentCurriculum", path="/resourceAllocationManager/firstTimeStudents/showStudentCurriculum.jsp"), @Forward(name="chooseRegistration", path="/resourceAllocationManager/firstTimeStudents/chooseRegistration.jsp")})
public class ShiftDistributionFirstYearDA
extends FenixDispatchAction {
    private static final Logger logger = LoggerFactory.getLogger(ShiftDistributionFirstYearDA.class);
    private final Integer FIRST_CURRICULAR_YEAR = 1;
    private final int MAX_NUMBER_OF_STUDENTS = 210;
    private final int STUDENTS_PER_LINE = 20;
    private static final String COLUMN_SEPARATOR = "\t";
    private static final String LINE_SEPARATOR = "\n";
    private static final String[] NO_VACANCY_DEGREE_CODES = new String[]{"9032", "9223", "9099"};

    @EntryPoint
    public ActionForward prepareShiftDistribution(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("fileBeanDistribution", (Object)new ShiftDistributionFileBean());
        return mapping.findForward("shiftDistribution");
    }

    public ActionForward uploadAndSimulateFileDistribution(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ShiftDistributionFileBean fileBean = (ShiftDistributionFileBean)this.getRenderedObject();
        String fileContents = CharStreams.toString((Readable)new InputStreamReader(fileBean.getInputStream(), Charset.defaultCharset()));
        String[] data = fileContents.split(LINE_SEPARATOR);
        ArrayList<ShiftDistributionDTO> shiftDistributionFromFile = new ArrayList<ShiftDistributionDTO>(data.length);
        String[] stringArray = data;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            ShiftDistributionDTO shiftDistributionDTO = new ShiftDistributionDTO();
            String dataLine = stringArray[i];
            boolean shouldAdd = shiftDistributionDTO.fillWithFileLineData(dataLine);
            if (!shouldAdd) continue;
            shiftDistributionFromFile.add(shiftDistributionDTO);
        }
        ArrayList<String> errorLog = new ArrayList<String>();
        ArrayList<String> warningLog = new ArrayList<String>();
        Map<DegreeCurricularPlan, List<SchoolClassDistributionInformation>> processedInformation = this.processInformationFrom(shiftDistributionFromFile, errorLog);
        Map<DegreeCurricularPlan, List<Integer>> abstractStudentNumbers = this.generateAbstractStudentNumbers(fileBean.getPhaseNumber(), errorLog);
        Map<Shift, List<GenericPair<DegreeCurricularPlan, Integer>>> distribution = this.distributeStudents(abstractStudentNumbers, processedInformation, warningLog);
        if (!errorLog.isEmpty()) {
            request.setAttribute("errorLog", errorLog);
            request.setAttribute("allowToWriteDistribution", (Object)"false");
            request.setAttribute("allowToGetStatistics", (Object)"false");
        } else {
            request.setAttribute("allowToWriteDistribution", (Object)"true");
            request.setAttribute("allowToGetStatistics", (Object)"true");
            fileBean.setDistribution(distribution);
            fileBean.setAbstractStudentNumbers(abstractStudentNumbers);
            request.setAttribute("fileBeanDistribution", (Object)fileBean);
        }
        Collections.sort(warningLog);
        request.setAttribute("warningLog", warningLog);
        return mapping.findForward("shiftDistribution");
    }

    public ActionForward writeDistribution(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ShiftDistributionFileBean fileBean = (ShiftDistributionFileBean)this.getRenderedObject();
        fileBean.writeDistribution();
        request.setAttribute("fileBeanDistribution", (Object)fileBean);
        request.setAttribute("allowToGetStatistics", (Object)"true");
        request.setAttribute("success", (Object)"true");
        return mapping.findForward("shiftDistribution");
    }

    public ActionForward exportStatistics(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ShiftDistributionFileBean fileBean = (ShiftDistributionFileBean)this.getRenderedObject();
        Spreadsheet spreadsheet = this.getStatisticsFromShiftDistribution(fileBean.getDistribution(), fileBean.getAbstractStudentNumbers());
        response.setHeader("Content-Disposition", "attachment; filename=estatisticas_distribuicao" + new DateTime() + ".csv");
        ServletOutputStream writer = response.getOutputStream();
        spreadsheet.exportToCSV((OutputStream)writer, COLUMN_SEPARATOR, LINE_SEPARATOR);
        writer.flush();
        response.flushBuffer();
        return null;
    }

    protected Map<Shift, List<GenericPair<DegreeCurricularPlan, Integer>>> distributeStudents(Map<DegreeCurricularPlan, List<Integer>> abstractStudentNumbers, Map<DegreeCurricularPlan, List<SchoolClassDistributionInformation>> processedInformation, List<String> warningLog) {
        HashMap<Shift, List<GenericPair<DegreeCurricularPlan, Integer>>> result = new HashMap<Shift, List<GenericPair<DegreeCurricularPlan, Integer>>>();
        for (Map.Entry<DegreeCurricularPlan, List<Integer>> entry : abstractStudentNumbers.entrySet()) {
            List<SchoolClassDistributionInformation> schoolClassDistributions = processedInformation.get((Object)entry.getKey());
            if (schoolClassDistributions == null) {
                warningLog.add("N\u00e3o foi encontrada nenhuma informa\u00e7\u00e3o para a distribui\u00e7\u00e3o de '" + entry.getKey().getName() + "'");
                continue;
            }
            this.enrolStudents(result, entry, schoolClassDistributions, warningLog);
        }
        return result;
    }

    private void enrolStudents(Map<Shift, List<GenericPair<DegreeCurricularPlan, Integer>>> result, Map.Entry<DegreeCurricularPlan, List<Integer>> entry, List<SchoolClassDistributionInformation> schoolClassDistributions, List<String> warningLog) {
        int numberOfEnroled = 0;
        SchoolClassDistributionInformation schoolClassDistribution = this.getSchoolClassDistributionWithCapacity(schoolClassDistributions);
        for (Integer studentNumber : entry.getValue()) {
            if (schoolClassDistribution.isDistributed() && (schoolClassDistribution = this.getSchoolClassDistributionWithCapacity(schoolClassDistributions)) == null) {
                warningLog.add("\tInscritos " + numberOfEnroled + " alunos de '" + entry.getKey().getName() + "' de " + entry.getValue().size() + " (teoricamente)");
                break;
            }
            this.enrolStudentInAllShiftsFromDistribution(studentNumber, schoolClassDistribution, result, entry.getKey());
            ++numberOfEnroled;
        }
    }

    private void enrolStudentInAllShiftsFromDistribution(Integer studentNumber, SchoolClassDistributionInformation schoolClassDistribution, Map<Shift, List<GenericPair<DegreeCurricularPlan, Integer>>> result, DegreeCurricularPlan degreeCurricularPlan) {
        for (Shift shift : schoolClassDistribution.getShiftsToEnrol()) {
            List<GenericPair<DegreeCurricularPlan, Integer>> studentNumbers = result.get((Object)shift);
            if (studentNumbers == null) {
                studentNumbers = new ArrayList<GenericPair<DegreeCurricularPlan, Integer>>();
                result.put(shift, studentNumbers);
            }
            studentNumbers.add(new GenericPair<DegreeCurricularPlan, Integer>(degreeCurricularPlan, studentNumber));
        }
        schoolClassDistribution.decreaseCapacity();
    }

    private SchoolClassDistributionInformation getSchoolClassDistributionWithCapacity(List<SchoolClassDistributionInformation> schoolClassDistribution) {
        for (SchoolClassDistributionInformation distributionInformation : schoolClassDistribution) {
            if (distributionInformation.isDistributed()) continue;
            return distributionInformation;
        }
        return null;
    }

    private Collection<Degree> readFirstYearFirstTimeValidDegrees() {
        ArrayList<Degree> result = new ArrayList<Degree>();
        result.addAll(Degree.readAllMatching(DegreeType::isBolonhaDegree));
        result.addAll(Degree.readAllMatching(DegreeType::isIntegratedMasterDegree));
        return this.removeDegreesWithNoVacancy(result);
    }

    private Collection<Degree> removeDegreesWithNoVacancy(Collection<Degree> result) {
        for (String degreeCode : NO_VACANCY_DEGREE_CODES) {
            result.removeAll(Degree.readAllByDegreeCode(degreeCode));
        }
        return result;
    }

    protected Map<DegreeCurricularPlan, List<Integer>> generateAbstractStudentNumbers(int phase, List<String> errorLog) {
        Collection<Degree> degrees = this.readFirstYearFirstTimeValidDegrees();
        int start = phase * degrees.size() * 210;
        int maxLimit = start + 210;
        HashMap<DegreeCurricularPlan, List<Integer>> result = new HashMap<DegreeCurricularPlan, List<Integer>>();
        for (Degree degree : degrees) {
            DegreeCurricularPlan mostRecentDegreeCurricularPlan = degree.getMostRecentDegreeCurricularPlan();
            if (mostRecentDegreeCurricularPlan == null) {
                errorLog.add("** O plano curricular do curso mais recente est\u00e1 a null para " + degree.getSigla());
                continue;
            }
            while (start <= maxLimit) {
                this.addNumberToDegreeMap(result, mostRecentDegreeCurricularPlan, start);
                ++start;
            }
            maxLimit += 210;
        }
        return result;
    }

    private void addNumberToDegreeMap(Map<DegreeCurricularPlan, List<Integer>> map, DegreeCurricularPlan key, Integer value) {
        List<Integer> entry = map.get((Object)key);
        if (entry == null) {
            entry = new ArrayList<Integer>();
            map.put(key, entry);
        }
        entry.add(value);
    }

    private Map<DegreeCurricularPlan, List<SchoolClassDistributionInformation>> processInformationFrom(Collection<ShiftDistributionDTO> shiftDistributionFromFile, List<String> errorLog) {
        HashMap<DegreeCurricularPlan, List<SchoolClassDistributionInformation>> result = new HashMap<DegreeCurricularPlan, List<SchoolClassDistributionInformation>>();
        HashMap<String, DegreeCurricularPlan> degreeCurricularPlans = new HashMap<String, DegreeCurricularPlan>();
        for (ShiftDistributionDTO shiftDistributionDTO : shiftDistributionFromFile) {
            DegreeCurricularPlan degreeCurricularPlan = this.readDegreeCurricularPlanBy(shiftDistributionDTO.getDegreeCurricularPlanName(), degreeCurricularPlans);
            if (degreeCurricularPlan == null) {
                errorLog.add("Erro ao ler o curso com o nome: '" + shiftDistributionDTO.getDegreeCurricularPlanName() + "' ignorando informa\u00e7\u00e3o.");
                continue;
            }
            SchoolClass schoolClass = this.readSchoolClassFrom(degreeCurricularPlan, shiftDistributionDTO.getSchoolClassName());
            if (schoolClass == null) {
                errorLog.add("Erro ao ler aula com o nome: '" + shiftDistributionDTO.getSchoolClassName() + "' ignorando informa\u00e7\u00e3o.");
                continue;
            }
            List<Shift> shiftsToEnrol = this.readShiftsToEnrolFrom(schoolClass, shiftDistributionDTO.getShiftNames(), errorLog);
            ArrayList<SchoolClassDistributionInformation> schoolClassInformation = (ArrayList<SchoolClassDistributionInformation>)result.get((Object)degreeCurricularPlan);
            if (schoolClassInformation == null) {
                schoolClassInformation = new ArrayList<SchoolClassDistributionInformation>();
                result.put(degreeCurricularPlan, schoolClassInformation);
            }
            schoolClassInformation.add(new SchoolClassDistributionInformation(schoolClass, shiftDistributionDTO.getTemporarySchoolClass(), shiftDistributionDTO.getMaxCapacity(), shiftsToEnrol));
        }
        return result;
    }

    private List<Shift> readShiftsToEnrolFrom(SchoolClass schoolClass, List<String> shiftNames, List<String> errorLog) {
        ArrayList<Shift> result = new ArrayList<Shift>();
        for (String shiftName : shiftNames) {
            Shift shift = this.readShiftFrom(schoolClass, shiftName);
            if (shift == null) {
                errorLog.add("N\u00e3o existe nenhum turno: '" + shiftName + "' associado \u00e0 aula: '" + schoolClass.getNome() + "'.");
                shift = this.readShiftByName(shiftName);
                if (shift == null) {
                    errorLog.add("N\u00e3o existe o turno com o nome: '" + shiftName + "' na base de dados.");
                    continue;
                }
            }
            result.add(shift);
        }
        return result;
    }

    private Shift readShiftByName(String shiftName) {
        for (Shift shift : rootDomainObject.getShiftsSet()) {
            if (!shift.getNome().equals(shiftName)) continue;
            return shift;
        }
        return null;
    }

    private Shift readShiftFrom(SchoolClass schoolClass, String shiftName) {
        for (Shift shift : schoolClass.getAssociatedShiftsSet()) {
            if (!shift.getNome().equals(shiftName)) continue;
            return shift;
        }
        return null;
    }

    private SchoolClass readSchoolClassFrom(DegreeCurricularPlan degreeCurricularPlan, String schoolClassName) {
        ExecutionDegree executionDegree = degreeCurricularPlan.getExecutionDegreeByYear(ExecutionSemester.readActualExecutionSemester().getExecutionYear());
        if (executionDegree != null) {
            for (SchoolClass schoolClass : executionDegree.getSchoolClassesSet()) {
                if (!schoolClass.getAnoCurricular().equals(this.FIRST_CURRICULAR_YEAR) || schoolClass.getExecutionPeriod() != ExecutionSemester.readActualExecutionSemester() || !schoolClass.getNome().equals(schoolClassName)) continue;
                return schoolClass;
            }
        }
        return null;
    }

    private DegreeCurricularPlan readDegreeCurricularPlanBy(String name, Map<String, DegreeCurricularPlan> degreeCurricularPlans) {
        DegreeCurricularPlan curricularPlan = degreeCurricularPlans.get(name);
        if (curricularPlan != null) {
            return curricularPlan;
        }
        for (DegreeCurricularPlan degreeCurricularPlan : DegreeCurricularPlan.readNotEmptyDegreeCurricularPlans()) {
            if (!degreeCurricularPlan.getName().equals(name)) continue;
            degreeCurricularPlans.put(name, degreeCurricularPlan);
            return degreeCurricularPlan;
        }
        return null;
    }

    protected void printAbstractStudentNumbers(Map<DegreeCurricularPlan, List<Integer>> abstractStudentNumbers) {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<DegreeCurricularPlan, List<Integer>> entry : abstractStudentNumbers.entrySet()) {
            buffer.append("[Plano curricular: ").append(entry.getKey().getName()).append(" -> (");
            Iterator<Integer> studentNumbers = entry.getValue().iterator();
            while (studentNumbers.hasNext()) {
                buffer.append(studentNumbers.next()).append(studentNumbers.hasNext() ? ", " : ")");
            }
            buffer.append(LINE_SEPARATOR);
        }
    }

    protected void printProcessedInformation(Map<DegreeCurricularPlan, List<SchoolClassDistributionInformation>> processedInformation) {
        int numberOfEntries = 0;
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<DegreeCurricularPlan, List<SchoolClassDistributionInformation>> entry : processedInformation.entrySet()) {
            buffer.append("[Plano curricular: ").append(entry.getKey().getName()).append(" (\n");
            for (SchoolClassDistributionInformation information : entry.getValue()) {
                buffer.append(information.toString()).append(LINE_SEPARATOR);
            }
            buffer.append(")]\n");
            numberOfEntries += entry.getValue().size();
        }
        buffer.append("Numero de entradas: " + numberOfEntries);
    }

    protected void printShiftDistribution(Map<Shift, List<GenericPair<DegreeCurricularPlan, Integer>>> distribution) {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<Shift, List<GenericPair<DegreeCurricularPlan, Integer>>> entry : distribution.entrySet()) {
            buffer.append("[Turno: ").append(entry.getKey().getNome()).append(" (");
            int studentsPerLine = 20;
            Iterator<GenericPair<DegreeCurricularPlan, Integer>> studentNumbers = entry.getValue().iterator();
            while (studentNumbers.hasNext()) {
                buffer.append(studentNumbers.next().getRight());
                if (!studentNumbers.hasNext()) continue;
                buffer.append(", ");
                if (--studentsPerLine != 0) continue;
                studentsPerLine = 20;
                buffer.append(LINE_SEPARATOR).append("\t\t");
            }
            buffer.append(")]\n");
        }
        buffer.append("Numero de Turnos: " + distribution.size());
    }

    private Spreadsheet getStatisticsFromShiftDistribution(Map<Shift, List<GenericPair<DegreeCurricularPlan, Integer>>> distribution, Map<DegreeCurricularPlan, List<Integer>> abstractStudentNumbers) {
        Spreadsheet spreadsheet = new Spreadsheet("Shifts");
        ArrayList<DegreeCurricularPlan> sorted = new ArrayList<DegreeCurricularPlan>(abstractStudentNumbers.keySet());
        Collections.sort(sorted, new BeanComparator("name"));
        this.addHeader(spreadsheet, sorted);
        for (Map.Entry<Shift, Map<DegreeCurricularPlan, Integer>> shiftEntry : this.calculateStatistics(distribution, abstractStudentNumbers).entrySet()) {
            this.addRow(spreadsheet, shiftEntry, sorted);
        }
        return spreadsheet;
    }

    private void addHeader(Spreadsheet spreadsheet, List<DegreeCurricularPlan> degreeCurricularPlans) {
        int i = 0;
        spreadsheet.setHeader(i, "Turno");
        for (DegreeCurricularPlan degreeCurricularPlan : degreeCurricularPlans) {
            spreadsheet.setHeader(++i, degreeCurricularPlan.getName());
        }
    }

    private void addRow(Spreadsheet spreadsheet, Map.Entry<Shift, Map<DegreeCurricularPlan, Integer>> shiftEntry, List<DegreeCurricularPlan> sorted) {
        Spreadsheet.Row row = spreadsheet.addRow();
        int i = 0;
        row.setCell(i, shiftEntry.getKey().getNome());
        for (DegreeCurricularPlan degreeCurricularPlan : sorted) {
            Integer count = shiftEntry.getValue().get((Object)degreeCurricularPlan);
            count = count != null ? count : Integer.valueOf(0);
            row.setCell(++i, count.toString());
        }
    }

    private Map<Shift, Map<DegreeCurricularPlan, Integer>> calculateStatistics(Map<Shift, List<GenericPair<DegreeCurricularPlan, Integer>>> distribution, Map<DegreeCurricularPlan, List<Integer>> abstractStudentNumbers) {
        HashMap<Shift, Map<DegreeCurricularPlan, Integer>> statistics = new HashMap<Shift, Map<DegreeCurricularPlan, Integer>>();
        for (Map.Entry<Shift, List<GenericPair<DegreeCurricularPlan, Integer>>> entry : distribution.entrySet()) {
            for (GenericPair<DegreeCurricularPlan, Integer> studentNumber : entry.getValue()) {
                Integer count;
                HashMap<DegreeCurricularPlan, Integer> degreeCurricularPlanMap = (HashMap<DegreeCurricularPlan, Integer>)statistics.get((Object)entry.getKey());
                if (degreeCurricularPlanMap == null) {
                    degreeCurricularPlanMap = new HashMap<DegreeCurricularPlan, Integer>();
                    statistics.put(entry.getKey(), degreeCurricularPlanMap);
                }
                if ((count = (Integer)degreeCurricularPlanMap.get((Object)studentNumber.getLeft())) == null) {
                    count = 0;
                }
                degreeCurricularPlanMap.put(studentNumber.getLeft(), count + 1);
            }
        }
        return statistics;
    }

    private static class ShiftDistributionDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String COLUMN_SEPARATOR = "\t";
        private int maxCapacity;
        private String degreeCurricularPlanName;
        private String temporarySchoolClassName;
        private String schoolClassName;
        private List<String> shiftNames;

        private ShiftDistributionDTO() {
        }

        public boolean fillWithFileLineData(String dataLine) {
            if (this.isToIgnoreLine(dataLine)) {
                return false;
            }
            String[] line = dataLine.split("\t");
            if (line.length < 4) {
                logger.debug("Invalid line, ignoring it.");
                return false;
            }
            this.degreeCurricularPlanName = line[0].trim();
            this.temporarySchoolClassName = line[1].trim();
            this.maxCapacity = Integer.valueOf(line[2].trim());
            this.schoolClassName = line[3].trim();
            this.shiftNames = new ArrayList<String>();
            for (int i = 4; i < line.length; ++i) {
                if (line[i].trim().length() != 0) {
                    this.shiftNames.add(line[i].trim());
                    continue;
                }
                logger.debug("found empty shift name");
            }
            return true;
        }

        public String getDegreeCurricularPlanName() {
            return this.degreeCurricularPlanName;
        }

        public int getMaxCapacity() {
            return this.maxCapacity;
        }

        public String getSchoolClassName() {
            return this.schoolClassName;
        }

        public List<String> getShiftNames() {
            return this.shiftNames;
        }

        public String getTemporarySchoolClass() {
            return this.temporarySchoolClassName;
        }

        private boolean isToIgnoreLine(String line) {
            return StringUtils.isEmpty((String)line) || line.startsWith("#") || line.equals(ShiftDistributionFirstYearDA.LINE_SEPARATOR) || line.equals("\r\n") || line.equals("\r") || line.startsWith("\t");
        }
    }

    private static class SchoolClassDistributionInformation {
        private final SchoolClass schoolClass;
        private final String temporarySchoolClassName;
        private int maxCapacity;
        private final List<Shift> shiftsToEnrol;

        SchoolClassDistributionInformation(SchoolClass schoolClass, String temporarySchoolClassName, int maxCapacity, List<Shift> shifts) {
            this.schoolClass = schoolClass;
            this.temporarySchoolClassName = temporarySchoolClassName;
            this.maxCapacity = maxCapacity;
            this.shiftsToEnrol = shifts;
        }

        public int getMaxCapacity() {
            return this.maxCapacity;
        }

        public void decreaseCapacity() {
            this.maxCapacity = --this.maxCapacity < 0 ? 0 : this.maxCapacity;
        }

        public boolean isDistributed() {
            return this.getMaxCapacity() == 0;
        }

        public SchoolClass getSchoolClass() {
            return this.schoolClass;
        }

        public List<Shift> getShiftsToEnrol() {
            return this.shiftsToEnrol;
        }

        public String getTemporarySchoolClassName() {
            return this.temporarySchoolClassName;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("[ S.C.D.I");
            buffer.append(" name: ").append(this.getSchoolClass().getNome());
            buffer.append(" tempSCName: ").append(this.getTemporarySchoolClassName());
            buffer.append(" capacity: ").append(this.getMaxCapacity()).append("\n\t(");
            Iterator<Shift> shifts = this.getShiftsToEnrol().iterator();
            while (shifts.hasNext()) {
                buffer.append(shifts.next().getNome()).append(shifts.hasNext() ? ", " : "");
            }
            return buffer.append(")]").toString();
        }
    }
}

