/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.dto.InfoCurricularCourse;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.InfoExecutionCourseOccupancy;
import org.fenixedu.academic.dto.InfoShift;
import org.fenixedu.academic.dto.InfoShiftGroupStatistics;
import org.fenixedu.academic.dto.resourceAllocationManager.ContextSelectionBean;
import org.fenixedu.academic.service.services.commons.ReadCurricularCourseScopesByExecutionCourseID;
import org.fenixedu.academic.service.services.commons.ReadExecutionCourseByOID;
import org.fenixedu.academic.service.services.resourceAllocationManager.ReadShiftsByExecutionCourseID;
import org.fenixedu.academic.service.services.resourceAllocationManager.SearchExecutionCourses;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.RAMApplication;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.base.FenixExecutionDegreeAndCurricularYearContextDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;

@StrutsFunctionality(app=RAMApplication.RAMExecutionCoursesApp.class, path="manage", titleKey="link.management")
@Mapping(path="/manageExecutionCourses", module="resourceAllocationManager")
@Forwards(value={@Forward(name="ShowSearchForm", path="/resourceAllocationManager/manageExecutionCourses_bd.jsp"), @Forward(name="showOccupancy", path="/resourceAllocationManager/showOccupancyLevels_bd.jsp"), @Forward(name="showLoads", path="/resourceAllocationManager/showLoads_bd.jsp")})
public class ManageExecutionCoursesDA
extends FenixExecutionDegreeAndCurricularYearContextDispatchAction {
    @EntryPoint
    public ActionForward prepareSearch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("ShowSearchForm");
    }

    public ActionForward choosePostBack(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("ShowSearchForm");
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContextSelectionBean contextSelectionBean = (ContextSelectionBean)request.getAttribute("context_selection_bean");
        request.setAttribute("curricular_year_oid", contextSelectionBean.getCurricularYear() != null ? contextSelectionBean.getCurricularYear().getExternalId() : null);
        request.setAttribute("execution_degree_oid", (Object)contextSelectionBean.getExecutionDegree().getExternalId());
        request.setAttribute("execution_course_name", (Object)contextSelectionBean.getCourseName().replaceAll("%", "%25"));
        List<InfoExecutionCourse> infoExecutionCourses = null;
        infoExecutionCourses = contextSelectionBean.getCurricularYear() == null ? SearchExecutionCourses.runSearchExecutionCourses(contextSelectionBean.getAcademicInterval(), contextSelectionBean.getExecutionDegree(), contextSelectionBean.getCourseName()) : SearchExecutionCourses.runSearchExecutionCourses(contextSelectionBean.getAcademicInterval(), contextSelectionBean.getExecutionDegree(), contextSelectionBean.getCurricularYear(), contextSelectionBean.getCourseName());
        if (infoExecutionCourses != null) {
            this.sortList(request, infoExecutionCourses);
            request.setAttribute("infoExecutionDegreeList", infoExecutionCourses);
        }
        return mapping.findForward("ShowSearchForm");
    }

    private void sortList(HttpServletRequest request, List<InfoExecutionCourse> infoExecutionCourses) {
        String sortParameter = request.getParameter("sortBy");
        if (sortParameter != null && sortParameter.length() != 0) {
            if (sortParameter.equals("occupancy")) {
                Collections.sort(infoExecutionCourses, new ReverseComparator((Comparator)new BeanComparator(sortParameter)));
            } else {
                Collections.sort(infoExecutionCourses, new BeanComparator(sortParameter));
            }
        } else {
            Collections.sort(infoExecutionCourses, new ReverseComparator((Comparator)new BeanComparator("occupancy")));
        }
    }

    public ActionForward showOccupancyLevels(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InfoExecutionCourseOccupancy infoExecutionCourseOccupancy = ReadShiftsByExecutionCourseID.runReadShiftsByExecutionCourseID(request.getParameter("executionCourseOID"));
        this.arranjeShifts(infoExecutionCourseOccupancy);
        request.setAttribute("infoExecutionCourseOccupancy", (Object)infoExecutionCourseOccupancy);
        return mapping.findForward("showOccupancy");
    }

    private void arranjeShifts(InfoExecutionCourseOccupancy infoExecutionCourseOccupancy) {
        ArrayList<InfoShift> theoreticalShifts = new ArrayList<InfoShift>();
        ArrayList<InfoShift> theoPraticalShifts = new ArrayList<InfoShift>();
        ArrayList<InfoShift> praticalShifts = new ArrayList<InfoShift>();
        ArrayList<InfoShift> labShifts = new ArrayList<InfoShift>();
        ArrayList<InfoShift> reserveShifts = new ArrayList<InfoShift>();
        ArrayList<InfoShift> doubtsShifts = new ArrayList<InfoShift>();
        ArrayList<InfoShift> fieldWork = new ArrayList<InfoShift>();
        ArrayList<InfoShift> problems = new ArrayList<InfoShift>();
        ArrayList<InfoShift> seminary = new ArrayList<InfoShift>();
        ArrayList<InfoShift> trainingPeriod = new ArrayList<InfoShift>();
        ArrayList<InfoShift> tutorialOrientation = new ArrayList<InfoShift>();
        infoExecutionCourseOccupancy.setShiftsInGroups(new ArrayList());
        for (InfoShift infoShift : infoExecutionCourseOccupancy.getInfoShifts()) {
            if (infoShift.containsType(ShiftType.TEORICA)) {
                theoreticalShifts.add(infoShift);
                continue;
            }
            if (infoShift.containsType(ShiftType.PRATICA)) {
                praticalShifts.add(infoShift);
                continue;
            }
            if (infoShift.containsType(ShiftType.DUVIDAS)) {
                doubtsShifts.add(infoShift);
                continue;
            }
            if (infoShift.containsType(ShiftType.LABORATORIAL)) {
                labShifts.add(infoShift);
                continue;
            }
            if (infoShift.containsType(ShiftType.RESERVA)) {
                reserveShifts.add(infoShift);
                continue;
            }
            if (infoShift.containsType(ShiftType.TEORICO_PRATICA)) {
                theoPraticalShifts.add(infoShift);
                continue;
            }
            if (infoShift.containsType(ShiftType.FIELD_WORK)) {
                fieldWork.add(infoShift);
                continue;
            }
            if (infoShift.containsType(ShiftType.PROBLEMS)) {
                problems.add(infoShift);
                continue;
            }
            if (infoShift.containsType(ShiftType.SEMINARY)) {
                seminary.add(infoShift);
                continue;
            }
            if (infoShift.containsType(ShiftType.TRAINING_PERIOD)) {
                trainingPeriod.add(infoShift);
                continue;
            }
            if (!infoShift.containsType(ShiftType.TUTORIAL_ORIENTATION)) continue;
            tutorialOrientation.add(infoShift);
        }
        infoExecutionCourseOccupancy.setInfoShifts(null);
        InfoShiftGroupStatistics infoShiftGroupStatistics = new InfoShiftGroupStatistics();
        if (!theoreticalShifts.isEmpty()) {
            infoShiftGroupStatistics.setShiftsInGroup(theoreticalShifts);
            infoExecutionCourseOccupancy.getShiftsInGroups().add(infoShiftGroupStatistics);
        }
        if (!theoPraticalShifts.isEmpty()) {
            infoShiftGroupStatistics = new InfoShiftGroupStatistics();
            infoShiftGroupStatistics.setShiftsInGroup(theoPraticalShifts);
            infoExecutionCourseOccupancy.getShiftsInGroups().add(infoShiftGroupStatistics);
        }
        if (!labShifts.isEmpty()) {
            infoShiftGroupStatistics = new InfoShiftGroupStatistics();
            infoShiftGroupStatistics.setShiftsInGroup(labShifts);
            infoExecutionCourseOccupancy.getShiftsInGroups().add(infoShiftGroupStatistics);
        }
        if (!praticalShifts.isEmpty()) {
            infoShiftGroupStatistics = new InfoShiftGroupStatistics();
            infoShiftGroupStatistics.setShiftsInGroup(praticalShifts);
            infoExecutionCourseOccupancy.getShiftsInGroups().add(infoShiftGroupStatistics);
        }
        if (!reserveShifts.isEmpty()) {
            infoShiftGroupStatistics = new InfoShiftGroupStatistics();
            infoShiftGroupStatistics.setShiftsInGroup(reserveShifts);
            infoExecutionCourseOccupancy.getShiftsInGroups().add(infoShiftGroupStatistics);
        }
        if (!doubtsShifts.isEmpty()) {
            infoShiftGroupStatistics = new InfoShiftGroupStatistics();
            infoShiftGroupStatistics.setShiftsInGroup(doubtsShifts);
            infoExecutionCourseOccupancy.getShiftsInGroups().add(infoShiftGroupStatistics);
        }
        if (!fieldWork.isEmpty()) {
            infoShiftGroupStatistics = new InfoShiftGroupStatistics();
            infoShiftGroupStatistics.setShiftsInGroup(fieldWork);
            infoExecutionCourseOccupancy.getShiftsInGroups().add(infoShiftGroupStatistics);
        }
        if (!problems.isEmpty()) {
            infoShiftGroupStatistics = new InfoShiftGroupStatistics();
            infoShiftGroupStatistics.setShiftsInGroup(problems);
            infoExecutionCourseOccupancy.getShiftsInGroups().add(infoShiftGroupStatistics);
        }
        if (!seminary.isEmpty()) {
            infoShiftGroupStatistics = new InfoShiftGroupStatistics();
            infoShiftGroupStatistics.setShiftsInGroup(seminary);
            infoExecutionCourseOccupancy.getShiftsInGroups().add(infoShiftGroupStatistics);
        }
        if (!trainingPeriod.isEmpty()) {
            infoShiftGroupStatistics = new InfoShiftGroupStatistics();
            infoShiftGroupStatistics.setShiftsInGroup(trainingPeriod);
            infoExecutionCourseOccupancy.getShiftsInGroups().add(infoShiftGroupStatistics);
        }
        if (!tutorialOrientation.isEmpty()) {
            infoShiftGroupStatistics = new InfoShiftGroupStatistics();
            infoShiftGroupStatistics.setShiftsInGroup(tutorialOrientation);
            infoExecutionCourseOccupancy.getShiftsInGroups().add(infoShiftGroupStatistics);
        }
    }

    public ActionForward showLoads(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String executionCourceOId = request.getParameter("executionCourseOID");
        InfoExecutionCourse infoExecutionCourse = ReadExecutionCourseByOID.run(executionCourceOId);
        List<InfoCurricularCourse> scopes = ReadCurricularCourseScopesByExecutionCourseID.run(executionCourceOId);
        request.setAttribute("infoExecutionCourse", (Object)infoExecutionCourse);
        request.setAttribute("curricularCourses", scopes);
        return mapping.findForward("showLoads");
    }
}

