/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.coordinator.publicProgram;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.PublicCandidacyHashCode;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramCollaborationType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessState;
import org.fenixedu.academic.domain.phd.PhdProgramFocusArea;
import org.fenixedu.academic.domain.phd.ThesisSubject;
import org.fenixedu.academic.domain.phd.candidacy.EPFLPhdCandidacyPeriod;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriod;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyReferee;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramPublicCandidacyHashCode;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.ui.renderers.providers.AbstractDomainObjectProvider;
import org.fenixedu.academic.ui.struts.action.coordinator.CoordinatorApplication;
import org.fenixedu.academic.ui.struts.action.phd.candidacy.academicAdminOffice.PhdProgramCandidacyProcessDA;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=CoordinatorApplication.CoordinatorPhdApp.class, path="ist-epfl", titleKey="label.phd.ist.epfl.collaboration.type", accessGroup="nobody")
@Mapping(path="/candidacies/phdProgramCandidacyProcess", module="coordinator")
@Forwards(value={@Forward(name="listProcesses", path="/phd/coordinator/publicProgram/listProcesses.jsp"), @Forward(name="viewProcess", path="/phd/coordinator/publicProgram/viewProcess.jsp"), @Forward(name="viewCandidacyRefereeLetter", path="/phd/coordinator/publicProgram/viewCandidacyRefereeLetter.jsp"), @Forward(name="manageFocusAreas", path="/phd/coordinator/publicProgram/manageFocusAreas.jsp"), @Forward(name="manageThesisSubjects", path="/phd/coordinator/publicProgram/manageThesisSubjects.jsp"), @Forward(name="editThesisSubject", path="/phd/coordinator/publicProgram/editThesisSubject.jsp")})
public class PublicPhdProgramCandidacyProcessDA
extends PhdProgramCandidacyProcessDA {
    @EntryPoint
    public ActionForward listProcesses(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        SelectPhdCandidacyPeriodBean selectPeriodBean = this.getSelectPhdCandidacyPeriodBean();
        if (selectPeriodBean == null) {
            selectPeriodBean = new SelectPhdCandidacyPeriodBean((PhdCandidacyPeriod)((Object)EPFLPhdCandidacyPeriod.getMostRecentCandidacyPeriod()));
        }
        Statistics statistics = new Statistics();
        ArrayList<PublicPhdCandidacyBean> candidacyHashCodes = new ArrayList<PublicPhdCandidacyBean>();
        for (PublicCandidacyHashCode hashCode : Bennu.getInstance().getCandidacyHashCodesSet()) {
            if (!hashCode.isFromPhdProgram()) continue;
            PhdProgramPublicCandidacyHashCode phdHashCode = (PhdProgramPublicCandidacyHashCode)((Object)hashCode);
            PhdCandidacyPeriod phdCandidacyPeriod = selectPeriodBean.getPhdCandidacyPeriod();
            if (phdHashCode.getPhdProgramCandidacyProcess() == null) {
                if (!phdCandidacyPeriod.contains(phdHashCode.getWhenCreated())) continue;
                statistics.plusTotalRequests();
                candidacyHashCodes.add(new PublicPhdCandidacyBean(phdHashCode));
                continue;
            }
            PhdIndividualProgramProcess individualProgramProcess = phdHashCode.getIndividualProgramProcess();
            if (individualProgramProcess.getExecutionYear() != ExecutionYear.readCurrentExecutionYear() || !PhdIndividualProgramCollaborationType.EPFL.equals((Object)individualProgramProcess.getCollaborationType()) || !PhdIndividualProgramProcessState.CANDIDACY.equals(individualProgramProcess.getActiveState())) continue;
            if (phdHashCode.hasCandidacyProcess()) {
                statistics.plusTotalCandidates();
            }
            if (phdHashCode.hasCandidacyProcess() && phdHashCode.getPhdProgramCandidacyProcess().isValidatedByCandidate()) {
                statistics.plusTotalValidated();
            }
            candidacyHashCodes.add(new PublicPhdCandidacyBean(phdHashCode));
        }
        request.setAttribute("candidacyHashCodes", candidacyHashCodes);
        request.setAttribute("statistics", (Object)statistics);
        request.setAttribute("selectPeriodBean", (Object)selectPeriodBean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("listProcesses");
    }

    private SelectPhdCandidacyPeriodBean getSelectPhdCandidacyPeriodBean() {
        return (SelectPhdCandidacyPeriodBean)this.getObjectFromViewState("select-period-bean");
    }

    public ActionForward viewProcess(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("hashCode", this.getDomainObject(request, "hashCodeId"));
        return mapping.findForward("viewProcess");
    }

    public ActionForward viewCandidacyRefereeLetter(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyRefereeLetter", (Object)((PhdCandidacyReferee)((Object)this.getDomainObject(request, "candidacyRefereeId"))).getLetter());
        return mapping.findForward("viewCandidacyRefereeLetter");
    }

    public ActionForward sendCandidacyRefereeEmail(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdCandidacyReferee referee = (PhdCandidacyReferee)((Object)this.getDomainObject(request, "candidacyRefereeId"));
        referee.sendEmail();
        this.addActionMessage("error", request, "message.resent.email.to", referee.getEmail());
        return this.viewProcess(mapping, actionForm, request, response);
    }

    public ActionForward manageFocusAreas(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("focusAreas", (Object)Bennu.getInstance().getPhdProgramFocusAreasSet());
        return mapping.findForward("manageFocusAreas");
    }

    public ActionForward manageThesisSubjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramFocusArea focusArea = (PhdProgramFocusArea)((Object)this.getDomainObject(request, "focusAreaId"));
        request.setAttribute("focusArea", (Object)focusArea);
        request.setAttribute("thesisSubjectBean", (Object)new ThesisSubjectBean());
        request.setAttribute("thesisSubjects", (Object)focusArea.getThesisSubjectsSet());
        return mapping.findForward("manageThesisSubjects");
    }

    public ActionForward addThesisSubject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ThesisSubjectBean bean = (ThesisSubjectBean)this.getRenderedObject("thesisSubjectBean");
        PhdProgramFocusArea focusArea = (PhdProgramFocusArea)((Object)this.getDomainObject(request, "focusAreaId"));
        try {
            ThesisSubject.createThesisSubject(focusArea, bean.getName(), bean.getDescription(), bean.getTeacher(), bean.getExternalAdvisorName());
        }
        catch (PhdDomainOperationException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
            return this.addThesisSubjectInvalid(mapping, form, request, response);
        }
        RenderUtils.invalidateViewState();
        return this.manageThesisSubjects(mapping, form, request, response);
    }

    public ActionForward addThesisSubjectInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramFocusArea focusArea = (PhdProgramFocusArea)((Object)this.getDomainObject(request, "focusAreaId"));
        ThesisSubjectBean bean = (ThesisSubjectBean)this.getRenderedObject("thesisSubjectBean");
        request.setAttribute("focusArea", (Object)focusArea);
        request.setAttribute("thesisSubjectBean", (Object)bean);
        request.setAttribute("thesisSubjects", (Object)focusArea.getThesisSubjectsSet());
        return mapping.findForward("manageThesisSubjects");
    }

    public ActionForward removeThesisSubject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ThesisSubject thesisSubject = (ThesisSubject)FenixFramework.getDomainObject((String)((String)this.getFromRequest(request, "thesisSubjectId")));
        try {
            thesisSubject.delete();
        }
        catch (PhdDomainOperationException e) {
            this.addActionMessage("errors", request, e.getKey(), e.getArgs());
        }
        RenderUtils.invalidateViewState();
        return this.manageThesisSubjects(mapping, form, request, response);
    }

    public ActionForward prepareEditThesisSubject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ThesisSubject subject = (ThesisSubject)((Object)this.getDomainObject(request, "thesisSubjectId"));
        PhdProgramFocusArea focusArea = (PhdProgramFocusArea)((Object)this.getDomainObject(request, "focusAreaId"));
        ThesisSubjectBean bean = new ThesisSubjectBean(subject);
        request.setAttribute("bean", (Object)bean);
        request.setAttribute("focusArea", (Object)focusArea);
        request.setAttribute("thesisSubject", (Object)subject);
        return mapping.findForward("editThesisSubject");
    }

    public ActionForward editThesisSubject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ThesisSubject subject = (ThesisSubject)((Object)this.getDomainObject(request, "thesisSubjectId"));
        ThesisSubjectBean bean = (ThesisSubjectBean)this.getRenderedObject("bean");
        try {
            subject.edit(bean.getName(), bean.getDescription(), bean.getTeacher(), bean.getExternalAdvisorName());
        }
        catch (PhdDomainOperationException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
            return this.editThesisSubjectInvalid(mapping, form, request, response);
        }
        return this.manageThesisSubjects(mapping, form, request, response);
    }

    public ActionForward editThesisSubjectInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ThesisSubjectBean bean = (ThesisSubjectBean)this.getRenderedObject("bean");
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("editThesisSubject");
    }

    public static class ThesisSubjectBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private MultiLanguageString name;
        private MultiLanguageString description;
        private Teacher teacher;
        private String externalAdvisorName;

        public ThesisSubjectBean() {
        }

        public ThesisSubjectBean(ThesisSubject thesisSubject) {
            this.setName(thesisSubject.getName());
            this.setDescription(thesisSubject.getDescription());
            this.setTeacher(thesisSubject.getTeacher());
            this.setExternalAdvisorName(thesisSubject.getExternalAdvisorName());
        }

        public MultiLanguageString getName() {
            return this.name;
        }

        public void setName(MultiLanguageString name) {
            this.name = name;
        }

        public MultiLanguageString getDescription() {
            return this.description;
        }

        public void setDescription(MultiLanguageString description) {
            this.description = description;
        }

        public Teacher getTeacher() {
            return this.teacher;
        }

        public void setTeacher(Teacher teacher) {
            this.teacher = teacher;
        }

        public String getExternalAdvisorName() {
            return this.externalAdvisorName;
        }

        public void setExternalAdvisorName(String externalAdvisorName) {
            this.externalAdvisorName = externalAdvisorName;
        }
    }

    public static class PublicPhdCandidacyBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private PhdProgramPublicCandidacyHashCode hashCode;
        private String email;
        private String name;
        private String phdFocusArea;
        private boolean candidate;
        private boolean validated;

        public PublicPhdCandidacyBean() {
        }

        public PublicPhdCandidacyBean(PhdProgramPublicCandidacyHashCode hashCode) {
            this.setHashCode(hashCode);
            this.setEmail(hashCode.getEmail());
            this.setName(hashCode.hasCandidacyProcess() ? hashCode.getPerson().getName() : null);
            this.setPhdFocusArea(hashCode.hasCandidacyProcess() && hashCode.getIndividualProgramProcess().getPhdProgramFocusArea() != null ? hashCode.getIndividualProgramProcess().getPhdProgramFocusArea().getName().getContent() : null);
            this.setCandidate(hashCode.hasCandidacyProcess());
            this.setValidated(hashCode.hasCandidacyProcess() ? hashCode.getPhdProgramCandidacyProcess().isValidatedByCandidate() : false);
        }

        public PhdProgramPublicCandidacyHashCode getHashCode() {
            return this.hashCode;
        }

        public void setHashCode(PhdProgramPublicCandidacyHashCode hashCode) {
            this.hashCode = hashCode;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPhdFocusArea() {
            return this.phdFocusArea;
        }

        public void setPhdFocusArea(String phdFocusArea) {
            this.phdFocusArea = phdFocusArea;
        }

        public boolean isCandidate() {
            return this.candidate;
        }

        public void setCandidate(boolean candidate) {
            this.candidate = candidate;
        }

        public boolean isValidated() {
            return this.validated;
        }

        public void setValidated(boolean validated) {
            this.validated = validated;
        }
    }

    public static class Statistics
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int totalRequests = 0;
        private int totalCandidates = 0;
        private int totalValidated = 0;

        Statistics() {
        }

        public int getTotalRequests() {
            return this.totalRequests;
        }

        private void plusTotalRequests() {
            ++this.totalRequests;
        }

        public int getTotalCandidates() {
            return this.totalCandidates;
        }

        private void plusTotalCandidates() {
            ++this.totalCandidates;
        }

        public int getTotalValidated() {
            return this.totalValidated;
        }

        private void plusTotalValidated() {
            ++this.totalValidated;
        }
    }

    public static final class PhdCandidacyPeriodDataProvider
    extends AbstractDomainObjectProvider {
        public Object provide(Object source, Object currentValue) {
            return this.getCandidacyPeriods();
        }

        private List<PhdCandidacyPeriod> getCandidacyPeriods() {
            ArrayList<PhdCandidacyPeriod> candidacyPeriodList = new ArrayList<PhdCandidacyPeriod>();
            CollectionUtils.select((Collection)Bennu.getInstance().getCandidacyPeriodsSet(), (Predicate)new Predicate(){

                public boolean evaluate(Object arg0) {
                    return arg0 instanceof PhdCandidacyPeriod;
                }
            }, candidacyPeriodList);
            return candidacyPeriodList;
        }
    }

    public static class SelectPhdCandidacyPeriodBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private PhdCandidacyPeriod candidacyPeriod;

        public PhdCandidacyPeriod getPhdCandidacyPeriod() {
            return this.candidacyPeriod;
        }

        public void setPhdCandidacyPeriod(PhdCandidacyPeriod candidacyPeriod) {
            this.candidacyPeriod = candidacyPeriod;
        }

        public SelectPhdCandidacyPeriodBean(PhdCandidacyPeriod candidacyPeriod) {
            this.candidacyPeriod = candidacyPeriod;
        }
    }
}

