/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.candidacy.secondCycle;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacyProcess;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.SecondCycleCandidacyPeriod;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.candidacy.CandidacyProcessDA;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.fenixedu.commons.spreadsheet.SpreadsheetXLSExporter;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminCandidaciesApp.class, path="second-cycle", titleKey="label.candidacy.secondCycle", accessGroup="(academic(MANAGE_CANDIDACY_PROCESSES) | academic(MANAGE_INDIVIDUAL_CANDIDACIES))", bundle="ApplicationResources")
@Mapping(path="/caseHandlingSecondCycleCandidacyProcess", module="academicAdministration", formBeanClass=SecondCycleCandidacyProcessForm.class)
@Forwards(value={@Forward(name="intro", path="/candidacy/secondCycle/mainCandidacyProcess.jsp"), @Forward(name="prepare-create-new-process", path="/candidacy/createCandidacyPeriod.jsp"), @Forward(name="prepare-edit-candidacy-period", path="/candidacy/editCandidacyPeriod.jsp"), @Forward(name="send-to-coordinator", path="/candidacy/sendToCoordinator.jsp"), @Forward(name="introduce-candidacy-results", path="/candidacy/secondCycle/introduceCandidacyResults.jsp"), @Forward(name="introduce-candidacy-results-for-degree", path="/candidacy/secondCycle/introduceCandidacyResultsForDegree.jsp"), @Forward(name="send-to-scientificCouncil", path="/candidacy/sendToScientificCouncil.jsp"), @Forward(name="create-registrations", path="/candidacy/createRegistrations.jsp"), @Forward(name="view-child-process-with-missing-required-documents", path="/candidacy/secondCycle/viewChildProcessWithMissingRequiredDocuments.jsp"), @Forward(name="prepare-select-available-degrees", path="/candidacy/selectAvailableDegrees.jsp")})
public class SecondCycleCandidacyProcessDA
extends CandidacyProcessDA {
    @Override
    protected Class getProcessType() {
        return SecondCycleCandidacyProcess.class;
    }

    @Override
    protected Class getChildProcessType() {
        return SecondCycleIndividualCandidacyProcess.class;
    }

    @Override
    protected Class getCandidacyPeriodType() {
        return SecondCycleCandidacyPeriod.class;
    }

    protected SecondCycleCandidacyProcess getProcess(HttpServletRequest request) {
        return (SecondCycleCandidacyProcess)((Object)super.getProcess(request));
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setChooseDegreeBean(request);
        return super.execute(mapping, actionForm, request, response);
    }

    protected void setChooseDegreeBean(HttpServletRequest request) {
        CandidacyProcessDA.ChooseDegreeBean chooseDegreeBean = (CandidacyProcessDA.ChooseDegreeBean)this.getObjectFromViewState("choose.degree.bean");
        if (chooseDegreeBean == null) {
            chooseDegreeBean = new CandidacyProcessDA.ChooseDegreeBean();
        }
        SecondCycleCandidacyProcess process2 = (SecondCycleCandidacyProcess)((Object)this.readProcess(request));
        chooseDegreeBean.setCandidacyProcess((CandidacyProcess)((Object)process2));
        request.setAttribute("chooseDegreeBean", (Object)chooseDegreeBean);
    }

    protected CandidacyProcessDA.ChooseDegreeBean getChooseDegreeBean(HttpServletRequest request) {
        return (CandidacyProcessDA.ChooseDegreeBean)request.getAttribute("chooseDegreeBean");
    }

    @Override
    protected void setStartInformation(ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        if (!this.hasExecutionInterval(request)) {
            ExecutionInterval executionInterval;
            List<SecondCycleCandidacyProcess> candidacyProcesses;
            List<ExecutionInterval> executionIntervals = this.getExecutionIntervalsWithCandidacyPeriod();
            if (executionIntervals.size() == 1 && (candidacyProcesses = this.getCandidacyProcesses(executionInterval = executionIntervals.iterator().next())).size() == 1) {
                SecondCycleCandidacyProcess process2 = candidacyProcesses.iterator().next();
                this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)process2));
                this.setCandidacyProcessInformation(actionForm, this.getProcess(request));
                request.setAttribute("candidacyProcesses", candidacyProcesses);
                CandidacyProcessDA.ChooseDegreeBean chooseDegreeBean = this.getChooseDegreeBean(request);
                chooseDegreeBean.setCandidacyProcess((CandidacyProcess)((Object)process2));
                return;
            }
            request.setAttribute("canCreateProcess", this.canCreateProcess(this.getProcessType().getName()));
            request.setAttribute("executionIntervals", executionIntervals);
        } else {
            ExecutionInterval executionInterval = this.getExecutionInterval(request);
            SecondCycleCandidacyProcess candidacyProcess = this.getCandidacyProcess(request, executionInterval);
            if (candidacyProcess != null) {
                this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)candidacyProcess));
                this.setCandidacyProcessInformation(actionForm, this.getProcess(request));
            } else {
                List<SecondCycleCandidacyProcess> candidacyProcesses = this.getCandidacyProcesses(executionInterval);
                if (candidacyProcesses.size() == 1) {
                    SecondCycleCandidacyProcess process3 = candidacyProcesses.iterator().next();
                    this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)process3));
                    this.setCandidacyProcessInformation(actionForm, this.getProcess(request));
                    request.setAttribute("candidacyProcesses", candidacyProcesses);
                    CandidacyProcessDA.ChooseDegreeBean chooseDegreeBean = this.getChooseDegreeBean(request);
                    chooseDegreeBean.setCandidacyProcess((CandidacyProcess)((Object)process3));
                    return;
                }
                request.setAttribute("canCreateProcess", this.canCreateProcess(this.getProcessType().getName()));
                request.setAttribute("executionIntervals", this.getExecutionIntervalsWithCandidacyPeriod());
            }
            request.setAttribute("candidacyProcesses", this.getCandidacyProcesses(executionInterval));
        }
    }

    private List<ExecutionInterval> getExecutionIntervalsWithCandidacyPeriod() {
        return ExecutionInterval.readExecutionIntervalsWithCandidacyPeriod(this.getCandidacyPeriodType());
    }

    protected List<SecondCycleCandidacyProcess> getCandidacyProcesses(ExecutionInterval executionInterval) {
        ArrayList<SecondCycleCandidacyProcess> result = new ArrayList<SecondCycleCandidacyProcess>();
        for (SecondCycleCandidacyPeriod period : executionInterval.getSecondCycleCandidacyPeriods()) {
            result.add(period.getSecondCycleCandidacyProcess());
        }
        return result;
    }

    @Override
    public ActionForward listProcessAllowedActivities(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)this.getProcess(request)));
        this.setCandidacyProcessInformation(form, this.getProcess(request));
        request.setAttribute("candidacyProcesses", this.getCandidacyProcesses((ExecutionInterval)((Object)this.getProcess(request).getCandidacyExecutionInterval())));
        return this.introForward(mapping);
    }

    protected void setCandidacyProcessInformation(ActionForm actionForm, SecondCycleCandidacyProcess process2) {
        SecondCycleCandidacyProcessForm form = (SecondCycleCandidacyProcessForm)actionForm;
        form.setSelectedProcessId(process2.getExternalId());
        form.setExecutionIntervalId(process2.getCandidacyExecutionInterval().getExternalId());
    }

    @Override
    protected ActionForward introForward(ActionMapping mapping) {
        return mapping.findForward("intro");
    }

    protected SecondCycleCandidacyProcess getCandidacyProcess(HttpServletRequest request, ExecutionInterval executionInterval) {
        String selectedProcessId = this.getStringFromRequest(request, "selectedProcessId");
        if (selectedProcessId != null) {
            for (SecondCycleCandidacyPeriod candidacyPeriod : executionInterval.getSecondCycleCandidacyPeriods()) {
                if (!candidacyPeriod.getSecondCycleCandidacyProcess().getExternalId().equals(selectedProcessId)) continue;
                return candidacyPeriod.getSecondCycleCandidacyProcess();
            }
        }
        return null;
    }

    public ActionForward prepareExecuteSendToCoordinator(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("send-to-coordinator");
    }

    public ActionForward executeSendToCoordinator(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "SendToCoordinator");
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            return this.prepareExecuteSendToCoordinator(mapping, actionForm, request, response);
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    public ActionForward prepareExecutePrintCandidacies(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + this.getReportFilename());
        ServletOutputStream writer = response.getOutputStream();
        this.writeReport(this.getProcess(request), writer);
        writer.flush();
        response.flushBuffer();
        return null;
    }

    public ActionForward prepareExecuteSendToScientificCouncil(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("send-to-scientificCouncil");
    }

    public ActionForward executeSendToScientificCouncil(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "SendToScientificCouncil");
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            return this.prepareExecuteSendToScientificCouncil(mapping, actionForm, request, response);
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    private void writeReport(SecondCycleCandidacyProcess process2, ServletOutputStream writer) throws IOException {
        ArrayList<Spreadsheet> spreadsheets = new ArrayList<Spreadsheet>();
        for (Map.Entry<Degree, SortedSet<SecondCycleIndividualCandidacyProcess>> entry : process2.getValidSecondCycleIndividualCandidaciesByDegree().entrySet()) {
            spreadsheets.add(this.buildReport(entry.getKey(), entry.getValue()));
        }
        new SpreadsheetXLSExporter().exportToXLSSheets((OutputStream)writer, spreadsheets);
    }

    private Spreadsheet buildReport(Degree degree, SortedSet<SecondCycleIndividualCandidacyProcess> name) {
        Spreadsheet spreadsheet = new Spreadsheet(degree.getSigla(), this.getHeader());
        for (SecondCycleIndividualCandidacyProcess process2 : name) {
            if (!process2.canExecuteActivity(Authenticate.getUser())) continue;
            Spreadsheet.Row row = spreadsheet.addRow();
            row.setCell(process2.getPersonalDetails().getName());
            row.setCell(process2.getPrecedentDegreeInformation().getConclusionGrade());
            row.setCell(process2.getCandidacyProfessionalExperience());
            row.setCell(process2.getPrecedentDegreeInformation().getDegreeAndInstitutionName());
            row.setCell(process2.getCandidacyAffinity());
            row.setCell(process2.getCandidacyDegreeNature());
            row.setCell(process2.getCandidacyGrade());
            row.setCell(process2.getCandidacyInterviewGrade() != null ? process2.getCandidacyInterviewGrade() : " ");
            row.setCell(process2.getCandidacySeriesGrade());
            if (process2.isCandidacyAccepted() || process2.isCandidacyRejected()) {
                row.setCell(BundleUtil.getString((String)"resources.EnumerationResources", (String)process2.getCandidacyState().getQualifiedName(), (String[])new String[0]));
                continue;
            }
            row.setCell(" ");
        }
        return spreadsheet;
    }

    private List<Object> getHeader() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.name", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.mfc", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.professionalExperience", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.degree.and.school", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.affinity", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.degreeNature", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.grade", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.interviewGrade", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.seriesGrade", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.result", (String[])new String[0]));
        return result;
    }

    @Override
    protected List<CandidacyProcessDA.CandidacyDegreeBean> createCandidacyDegreeBeans(HttpServletRequest request) {
        SecondCycleCandidacyProcess process2 = this.getProcess(request);
        ArrayList<CandidacyProcessDA.CandidacyDegreeBean> candidacyDegreeBeans = new ArrayList<CandidacyProcessDA.CandidacyDegreeBean>();
        for (SecondCycleIndividualCandidacyProcess child : process2.getAcceptedSecondCycleIndividualCandidacies()) {
            candidacyDegreeBeans.add(new SecondCycleCandidacyDegreeBean(child));
        }
        Collections.sort(candidacyDegreeBeans);
        return candidacyDegreeBeans;
    }

    @Override
    protected List<Object> getCandidacyHeader() {
        ArrayList<Object> result = new ArrayList<Object>(super.getCandidacyHeader());
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.notes", (String[])new String[0]));
        return result;
    }

    @Override
    protected Spreadsheet buildIndividualCandidacyReport(Spreadsheet spreadsheet, IndividualCandidacyProcess individualCandidacyProcess) {
        SecondCycleIndividualCandidacyProcess secondCycleIndividualCandidacyProcess = (SecondCycleIndividualCandidacyProcess)((Object)individualCandidacyProcess);
        Spreadsheet.Row row = spreadsheet.addRow();
        row.setCell(secondCycleIndividualCandidacyProcess.getProcessCode());
        row.setCell(secondCycleIndividualCandidacyProcess.getPersonalDetails().getName());
        row.setCell(secondCycleIndividualCandidacyProcess.getPersonalDetails().getIdDocumentType().getLocalizedName());
        row.setCell(secondCycleIndividualCandidacyProcess.getPersonalDetails().getDocumentIdNumber());
        row.setCell(secondCycleIndividualCandidacyProcess.getPersonalDetails().getCountry() != null ? secondCycleIndividualCandidacyProcess.getPersonalDetails().getCountry().getCountryNationality().getContent() : "");
        row.setCell(secondCycleIndividualCandidacyProcess.getPrecedentDegreeInformation().getDegreeAndInstitutionName());
        row.setCell(secondCycleIndividualCandidacyProcess.getPrecedentDegreeInformation().getDegreeDesignation());
        row.setCell(secondCycleIndividualCandidacyProcess.getPrecedentDegreeInformation().getConclusionDate() != null ? secondCycleIndividualCandidacyProcess.getPrecedentDegreeInformation().getConclusionDate().toString(dateFormat) : "");
        row.setCell(secondCycleIndividualCandidacyProcess.getPrecedentDegreeInformation().getConclusionGrade());
        StringBuilder degreesSb = new StringBuilder();
        for (Degree degree : secondCycleIndividualCandidacyProcess.getCandidacy().getSelectedDegreesSet()) {
            degreesSb.append(degree.getName()).append("\n");
        }
        row.setCell(degreesSb.toString());
        row.setCell(BundleUtil.getString((String)"resources.EnumerationResources", (String)individualCandidacyProcess.getCandidacyState().getQualifiedName(), (String[])new String[0]));
        row.setCell(BundleUtil.getString((String)"resources.CandidateResources", (String)(secondCycleIndividualCandidacyProcess.getProcessChecked() != null && secondCycleIndividualCandidacyProcess.getProcessChecked() != false ? this.MESSAGE_YES : this.MESSAGE_NO), (String[])new String[0]));
        row.setCell(secondCycleIndividualCandidacyProcess.getCandidacyNotes());
        return spreadsheet;
    }

    @Override
    protected Predicate<IndividualCandidacyProcess> getChildProcessSelectionPredicate(CandidacyProcess process2, HttpServletRequest request) {
        final Degree selectedDegree = this.getChooseDegreeBean(request).getDegree();
        if (selectedDegree == null) {
            return Predicates.alwaysTrue();
        }
        return new Predicate<IndividualCandidacyProcess>(){

            public boolean apply(IndividualCandidacyProcess process2) {
                return ((SecondCycleIndividualCandidacyProcess)((Object)process2)).getCandidacy().getSelectedDegreesSet().contains(selectedDegree);
            }
        };
    }

    public ActionForward prepareExecuteViewChildProcessWithMissingRequiredDocumentFiles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)this.getProcess(request)));
        this.setCandidacyProcessInformation(form, this.getProcess(request));
        request.setAttribute("candidacyProcesses", this.getCandidacyProcesses((ExecutionInterval)((Object)this.getProcess(request).getCandidacyExecutionInterval())));
        request.setAttribute("childsWithMissingRequiredDocuments", this.getChildsWithMissingRequiredDocuments(this.getProcess(request)));
        return mapping.findForward("view-child-process-with-missing-required-documents");
    }

    private Collection<IndividualCandidacyProcess> getChildsWithMissingRequiredDocuments(SecondCycleCandidacyProcess process2) {
        return Collections2.filter((Collection)process2.getChildsWithMissingRequiredDocuments(), (Predicate)CAN_EXECUTE_ACTIVITY_PREDICATE);
    }

    public static class SecondCycleCandidacyDegreeBean
    extends CandidacyProcessDA.CandidacyDegreeBean {
        private String notes;

        public SecondCycleCandidacyDegreeBean(SecondCycleIndividualCandidacyProcess process2) {
            this.setPersonalDetails(process2.getPersonalDetails());
            this.setDegree(process2.getCandidacySelectedDegree());
            this.setState(process2.getCandidacyState());
            this.setRegistrationCreated(process2.hasRegistrationForCandidacy());
            this.setNotes(process2.getCandidacyNotes());
        }

        public String getNotes() {
            return this.notes;
        }

        private void setNotes(String notes) {
            this.notes = notes;
        }
    }

    public static class SecondCycleCandidacyProcessForm
    extends CandidacyProcessDA.CandidacyProcessForm {
        private String selectedProcessId;

        public String getSelectedProcessId() {
            return this.selectedProcessId;
        }

        public void setSelectedProcessId(String selectedProcessId) {
            this.selectedProcessId = selectedProcessId;
        }
    }
}

