/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.servlet.taglib.sop.v3.renderers;

import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.FrequencyType;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.dto.InfoExam;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.InfoLesson;
import org.fenixedu.academic.dto.InfoLessonInstance;
import org.fenixedu.academic.dto.InfoLessonInstanceAggregation;
import org.fenixedu.academic.dto.InfoShowOccupation;
import org.fenixedu.academic.dto.InfoWrittenTest;
import org.fenixedu.academic.servlet.taglib.sop.v3.LessonSlot;
import org.fenixedu.academic.servlet.taglib.sop.v3.LessonSlotContentRenderer;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.LocalDate;

public class ExecutionCourseTimeTableLessonContentRenderer
extends LessonSlotContentRenderer {
    @Override
    public StringBuilder render(String context, LessonSlot lessonSlot) {
        StringBuilder strBuffer = new StringBuilder();
        InfoShowOccupation showOccupation = lessonSlot.getInfoLessonWrapper().getInfoShowOccupation();
        if (showOccupation instanceof InfoLesson) {
            InfoLesson lesson = (InfoLesson)showOccupation;
            strBuffer.append(lesson.getInfoShift().getShiftTypesCodePrettyPrint()).append("&nbsp;");
            if (lesson.getInfoSala() != null) {
                strBuffer.append("<a href='").append(context).append("/publico/");
                strBuffer.append("siteViewer.do?method=roomViewer&amp;roomName=");
                strBuffer.append(lesson.getInfoSala().getNome()).append("&amp;objectCode=");
                strBuffer.append(lesson.getInfoShift().getInfoDisciplinaExecucao().getInfoExecutionPeriod().getExternalId());
                strBuffer.append("&amp;executionPeriodOID=");
                strBuffer.append(lesson.getInfoShift().getInfoDisciplinaExecucao().getInfoExecutionPeriod().getExternalId()).append("'>");
                strBuffer.append(lesson.getInfoSala().getNome()).append("</a>");
            }
            if (lesson.getFrequency().equals((Object)FrequencyType.BIWEEKLY)) {
                strBuffer.append("&nbsp;&nbsp;[Q]");
            }
        } else if (showOccupation instanceof InfoLessonInstance) {
            InfoLessonInstance lesson = (InfoLessonInstance)showOccupation;
            strBuffer.append(lesson.getShiftTypeCodesPrettyPrint()).append("&nbsp;");
            Space allocatableSpace = lesson.getAllocatableSpace();
            if (allocatableSpace != null) {
                strBuffer.append("<a href='").append(context).append("/publico/");
                strBuffer.append("siteViewer.do?method=roomViewer&amp;roomName=");
                strBuffer.append(allocatableSpace.getName()).append("&amp;objectCode=");
                strBuffer.append(lesson.getInfoShift().getInfoDisciplinaExecucao().getInfoExecutionPeriod().getExternalId());
                strBuffer.append("&amp;executionPeriodOID=");
                strBuffer.append(lesson.getInfoShift().getInfoDisciplinaExecucao().getInfoExecutionPeriod().getExternalId()).append("'>");
                strBuffer.append(allocatableSpace.getName()).append("</a>");
            }
        } else if (showOccupation instanceof InfoLessonInstanceAggregation) {
            InfoLessonInstanceAggregation aggregation = (InfoLessonInstanceAggregation)showOccupation;
            Shift shift = aggregation.getShift();
            ExecutionCourse executionCourse = shift.getExecutionCourse();
            ExecutionSemester executionSemester = executionCourse.getExecutionPeriod();
            strBuffer.append(shift.getShiftTypesCodePrettyPrint()).append("&nbsp;");
            Space allocatableSpace = aggregation.getAllocatableSpace();
            if (allocatableSpace != null) {
                strBuffer.append("<a href='").append(context).append("/publico/");
                strBuffer.append("siteViewer.do?method=roomViewer&amp;roomName=");
                strBuffer.append(allocatableSpace.getName()).append("&amp;objectCode=");
                strBuffer.append(executionSemester.getExternalId());
                strBuffer.append("&amp;executionPeriodOID=");
                strBuffer.append(executionSemester.getExternalId()).append("'>");
                strBuffer.append(allocatableSpace.getName()).append("</a>");
            }
        } else if (showOccupation instanceof InfoExam) {
            InfoExam infoExam = (InfoExam)showOccupation;
            for (int iterEC = 0; iterEC < infoExam.getAssociatedExecutionCourse().size(); ++iterEC) {
                InfoExecutionCourse infoEC = infoExam.getAssociatedExecutionCourse().get(iterEC);
                if (iterEC != 0) {
                    strBuffer.append(", ");
                }
                strBuffer.append(infoEC.getSigla());
            }
            strBuffer.append(" - ");
            strBuffer.append(infoExam.getSeason().getSeason());
            strBuffer.append("\u00aa \u00e9poca");
        } else if (showOccupation instanceof InfoWrittenTest) {
            InfoWrittenTest infoWrittenTest = (InfoWrittenTest)showOccupation;
            for (int iterEC = 0; iterEC < infoWrittenTest.getAssociatedExecutionCourse().size(); ++iterEC) {
                InfoExecutionCourse infoEC = infoWrittenTest.getAssociatedExecutionCourse().get(iterEC);
                if (iterEC != 0) {
                    strBuffer.append(", ");
                }
                strBuffer.append(infoEC.getSigla());
            }
            strBuffer.append(" - ");
            strBuffer.append(infoWrittenTest.getDescription());
        }
        return strBuffer;
    }

    @Override
    public String renderSecondLine(String context, LessonSlot lessonSlot) {
        InfoLessonInstanceAggregation infoLessonInstanceAggregation;
        StringBuilder builder = new StringBuilder();
        InfoShowOccupation showOccupation = lessonSlot.getInfoLessonWrapper().getInfoShowOccupation();
        if (showOccupation instanceof InfoLessonInstanceAggregation && !(infoLessonInstanceAggregation = (InfoLessonInstanceAggregation)showOccupation).availableInAllWeeks()) {
            builder.append("<span>");
            builder.append(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.weeks", (String[])new String[0]));
            builder.append(": &nbsp;&nbsp;");
            builder.append(infoLessonInstanceAggregation.prettyPrintWeeks());
            builder.append("&nbsp;");
            builder.append("</span>");
        }
        builder.append(super.renderSecondLine(context, lessonSlot));
        return builder.toString();
    }

    @Override
    public String renderTitleText(LessonSlot lessonSlot) {
        StringBuilder builder = new StringBuilder(super.renderTitleText(lessonSlot));
        InfoShowOccupation occupation = lessonSlot.getInfoLessonWrapper().getInfoShowOccupation();
        if (occupation instanceof InfoLessonInstanceAggregation) {
            InfoLessonInstanceAggregation aggregation = (InfoLessonInstanceAggregation)occupation;
            for (LocalDate localDate : aggregation.getDates()) {
                builder.append('\n');
                builder.append(localDate.toString("yyyy-MM-dd"));
            }
        }
        return builder.toString();
    }
}

