/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.servlet;

import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import org.fenixedu.academic.servlet.PdfFiller;
import org.fenixedu.academic.servlet.ProcessCandidacyPrintAllDocumentsFilter;

@HandlesTypes(value={PdfFiller.class})
public class FenixContainerInitializer
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        if (classes != null) {
            for (Class<?> type : classes) {
                if (!PdfFiller.class.isAssignableFrom(type)) continue;
                this.registerFiller(type);
            }
        }
    }

    private void registerFiller(Class<?> type) {
        try {
            PdfFiller filler = (PdfFiller)type.newInstance();
            ProcessCandidacyPrintAllDocumentsFilter.registerFiller(filler);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new Error("Could not instantiate filler", e);
        }
    }
}

