/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.filter;

import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.service.filter.AuthorizationByRoleFilter;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixframework.FenixFramework;

public class ResponsibleDegreeCoordinatorAuthorizationFilter
extends AuthorizationByRoleFilter {
    public static final ResponsibleDegreeCoordinatorAuthorizationFilter instance = new ResponsibleDegreeCoordinatorAuthorizationFilter();

    @Override
    protected RoleType getRoleType() {
        return RoleType.COORDINATOR;
    }

    public void execute(String executionDegreeId) throws NotAuthorizedException {
        User id = Authenticate.getUser();
        try {
            if (id == null || !this.getRoleType().isMember(id.getPerson().getUser()) || !this.isResponsibleCoordinatorOfExecutionDegree(id, executionDegreeId)) {
                throw new NotAuthorizedException();
            }
        }
        catch (RuntimeException e) {
            throw new NotAuthorizedException();
        }
    }

    private boolean isResponsibleCoordinatorOfExecutionDegree(User id, String executionDegreeId) {
        boolean result = false;
        if (executionDegreeId == null) {
            return result;
        }
        try {
            Person person = id.getPerson();
            ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)executionDegreeId);
            Coordinator coordinator = executionDegree.getCoordinatorByTeacher(person);
            result = coordinator != null && coordinator.getResponsible() != false;
        }
        catch (Exception e) {
            return false;
        }
        return result;
    }
}

