/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.thesis;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisFile;
import org.fenixedu.academic.report.thesis.ThesisDocument;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class StudentThesisIdentificationDocument
extends ThesisDocument {
    private static final long serialVersionUID = 1L;

    public StudentThesisIdentificationDocument(Thesis thesis) {
        super(thesis);
    }

    @Override
    protected void fillThesisInfo() {
        Thesis thesis = this.getThesis();
        ThesisFile file = thesis.getDissertation();
        if (file != null) {
            this.addParameter("thesisTitle", file.getTitle());
            this.addParameter("thesisSubtitle", this.neverNull(file.getSubTitle()));
            this.addParameter("thesisLanguage", this.getLanguage(file));
        } else {
            this.addParameter("thesisTitle", thesis.getTitle().getContent());
            this.addParameter("thesisSubtitle", "");
            this.addParameter("thesisLanguage", "");
        }
        String date = null;
        DateTime discussion = thesis.getDiscussed();
        if (discussion != null) {
            date = String.format(new Locale("pt"), "%1$td/%1$tm/%1$tY", discussion.toDate());
        }
        this.addParameter("discussion", this.neverNull(date));
        int index = 0;
        for (String keyword : this.splitKeywords(thesis.getKeywordsPt())) {
            this.addParameter("keywordPt" + index++, keyword);
        }
        while (index < 6) {
            this.addParameter("keywordPt" + index++, "");
        }
        index = 0;
        for (String keyword : this.splitKeywords(thesis.getKeywordsEn())) {
            this.addParameter("keywordEn" + index++, keyword);
        }
        while (index < 6) {
            this.addParameter("keywordEn" + index++, "");
        }
        this.addParameter("keywordsPt", thesis.getKeywordsPt());
        this.addParameter("keywordsEn", thesis.getKeywordsEn());
        this.addParameter("abstractPt", this.neverNull(thesis.getThesisAbstractPt()));
        this.addParameter("abstractEn", this.neverNull(thesis.getThesisAbstractEn()));
    }

    private String getLanguage(ThesisFile file) {
        Locale language = file.getLanguage();
        if (language == null) {
            return "";
        }
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)language.getLanguage(), (String[])new String[0]);
    }

    private List<String> splitKeywords(String keywords) {
        ArrayList<String> result = new ArrayList<String>();
        if (keywords == null) {
            return result;
        }
        for (String part : keywords.split(",")) {
            String trimmed = part.trim();
            if (trimmed.length() <= 0) continue;
            result.add(trimmed);
        }
        return result;
    }

    @Override
    public String getReportFileName() {
        Thesis thesis = this.getThesis();
        return "identificacao-aluno-" + thesis.getStudent().getNumber();
    }
}

