/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.util.icalendar;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.util.icalendar.EventBean;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;

public class EvaluationEventBean
extends EventBean {
    Set<ExecutionCourse> course;
    Space assignedRoom;

    public EvaluationEventBean(String title, DateTime begin, DateTime end, boolean allDay, Set<Space> rooms, String url, String note, Set<ExecutionCourse> course) {
        this(title, begin, end, allDay, null, rooms, url, note, course);
    }

    public EvaluationEventBean(String title, DateTime begin, DateTime end, boolean allDay, Space assignedRoom, Set<Space> rooms, String url, String note, Set<ExecutionCourse> course) {
        super(title, begin, end, allDay, rooms, url, note);
        this.setCourses(course);
        this.assignedRoom = assignedRoom;
    }

    @Override
    public String getTitle() {
        ImmutableSet acronyms = FluentIterable.from(this.getCourses()).transform((Function)new Function<ExecutionCourse, String>(){

            public String apply(ExecutionCourse input) {
                return input.getSigla();
            }
        }).toSet();
        return super.getTitle() + " : " + Joiner.on((String)"; ").join((Iterable)acronyms);
    }

    @Override
    public String getOriginalTitle() {
        return super.getTitle();
    }

    public Set<ExecutionCourse> getCourses() {
        return this.course;
    }

    public void setCourses(Set<ExecutionCourse> course) {
        this.course = course;
    }

    public Space getAssignedRoom() {
        return this.assignedRoom;
    }
}

