/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.transactions;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.GuideEntry;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PersonAccount;
import org.fenixedu.academic.domain.gratuity.ReimbursementGuideState;
import org.fenixedu.academic.domain.reimbursementGuide.ReimbursementGuideEntry;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.transactions.InsuranceTransaction_Base;
import org.fenixedu.academic.domain.transactions.PaymentType;
import org.fenixedu.academic.domain.transactions.TransactionType;
import org.joda.time.DateTime;

public class InsuranceTransaction
extends InsuranceTransaction_Base {
    public InsuranceTransaction() {
    }

    public InsuranceTransaction(Double value, Timestamp transactionDate, String remarks, PaymentType paymentType, TransactionType transactionType, Boolean wasInternalBalance, Person responsiblePerson, PersonAccount personAccount, GuideEntry guideEntry, ExecutionYear executionYear, Registration registration) {
        this();
        this.setValue(value);
        this.setTransactionDate(transactionDate);
        this.setRemarks(remarks);
        this.setPaymentType(paymentType);
        this.setTransactionType(transactionType);
        this.setWasInternalBalance(wasInternalBalance);
        this.setResponsiblePerson(responsiblePerson);
        this.setPersonAccount(personAccount);
        this.setExecutionYear(executionYear);
        this.setGuideEntry(guideEntry);
        this.setStudent(registration);
    }

    public InsuranceTransaction(BigDecimal value, DateTime whenRegistered, PaymentType paymentType, Person responsiblePerson, PersonAccount personAccount, ExecutionYear executionYear, Registration registration) {
        this();
        this.setValueBigDecimal(value);
        this.setTransactionDateDateTime(whenRegistered);
        this.setPaymentType(paymentType);
        this.setTransactionType(TransactionType.INSURANCE_PAYMENT);
        this.setWasInternalBalance(false);
        this.setResponsiblePerson(responsiblePerson);
        this.setPersonAccount(personAccount);
        this.setExecutionYear(executionYear);
        this.setStudent(registration);
    }

    public boolean isReimbursed() {
        if (this.getGuideEntry() == null || this.getGuideEntry().getReimbursementGuideEntriesSet().size() == 0) {
            return false;
        }
        for (ReimbursementGuideEntry reimbursementGuideEntry : this.getGuideEntry().getReimbursementGuideEntriesSet()) {
            if (!reimbursementGuideEntry.getReimbursementGuide().getActiveReimbursementGuideSituation().getReimbursementGuideState().equals((Object)ReimbursementGuideState.PAYED)) continue;
            return true;
        }
        return false;
    }

    public void delete() {
        this.setExecutionYear(null);
        this.setStudent(null);
        super.delete();
    }
}

