/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.candidacy;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.CandidacyPeriod;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriod$callable$edit;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriodType;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriod_Base;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyReferee;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class PhdCandidacyPeriod
extends PhdCandidacyPeriod_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected PhdCandidacyPeriod() {
    }

    protected void init(ExecutionInterval executionInterval, DateTime start, DateTime end) {
        throw new DomainException("call init(ExecutionYear, DateTime, DateTime)", new String[0]);
    }

    protected void init(ExecutionYear executionInterval, DateTime start, DateTime end, PhdCandidacyPeriodType type) {
        if (type == null) {
            throw new DomainException("error.PhdCandidacyPeriod.type.is.required", new String[0]);
        }
        this.setType(type);
        super.init((ExecutionInterval)((Object)executionInterval), start, end);
    }

    public ExecutionYear getExecutionInterval() {
        return (ExecutionYear)((Object)super.getExecutionInterval());
    }

    public boolean isPhdCandidacyPeriod() {
        return true;
    }

    public static List<PhdCandidacyPeriod> readPhdCandidacyPeriods() {
        ArrayList<PhdCandidacyPeriod> phdCandidacyPeriods = new ArrayList<PhdCandidacyPeriod>();
        for (CandidacyPeriod candidacyPeriod : Bennu.getInstance().getCandidacyPeriodsSet()) {
            if (!candidacyPeriod.isPhdCandidacyPeriod()) continue;
            phdCandidacyPeriods.add((PhdCandidacyPeriod)((Object)candidacyPeriod));
        }
        return phdCandidacyPeriods;
    }

    public static List<PhdCandidacyPeriod> readOrderedPhdCandidacyPeriods() {
        List<PhdCandidacyPeriod> phdCandidacyPeriods = PhdCandidacyPeriod.readPhdCandidacyPeriods();
        Collections.sort(phdCandidacyPeriods, Collections.reverseOrder(CandidacyPeriod.LAST_CANDIDACY_PERIOD));
        return phdCandidacyPeriods;
    }

    protected void checkOverlapingDates(DateTime start, DateTime end, PhdCandidacyPeriodType type) {
        for (CandidacyPeriod period : Bennu.getInstance().getCandidacyPeriodsSet()) {
            if (!period.isPhdCandidacyPeriod()) continue;
            PhdCandidacyPeriod phdCandidacyPeriod = (PhdCandidacyPeriod)((Object)period);
            if (period.equals((Object)this) || !type.equals((Object)phdCandidacyPeriod.getType()) || !period.intercept(start, end)) continue;
            throw new DomainException("error.InstitutionPhdCandidacyPeriod.already.contains.candidacyPeriod.in.given.dates", new String[0]);
        }
    }

    public void edit(DateTime dateTime, DateTime dateTime2) {
        Object object = advice$edit.perform((Callable)new PhdCandidacyPeriod$callable$edit(this, dateTime, dateTime2));
    }

    static /* synthetic */ void advised$edit(PhdCandidacyPeriod this_, DateTime start, DateTime end) {
        this_.checkOverlapingDates(start, end, this_.getType());
        super.edit(start, end);
    }

    public abstract String getEmailMessageBodyForRefereeForm(PhdCandidacyReferee var1);

    public abstract MultiLanguageString getEmailMessageSubjectForMissingCandidacyValidation(PhdIndividualProgramProcess var1);

    public abstract MultiLanguageString getEmailMessageBodyForMissingCandidacyValidation(PhdIndividualProgramProcess var1);

    public String getPresentationName() {
        return this.getType().getLocalizedName() + " - " + this.getExecutionInterval().getName() + " - " + super.getPresentationName();
    }

    public String getStartDateDescription() {
        return this.getStart().toString("dd/MM/yyyy");
    }

    public String getEndDateDescription() {
        if (this.getEnd() == null) {
            return "";
        }
        return this.getEnd().toString("dd/MM/yyyy");
    }
}

