/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExternalCurricularCourse;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Accountability;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.CountryUnit$callable$associateCountry;
import org.fenixedu.academic.domain.organizationalStructure.CountryUnit_Base;
import org.fenixedu.academic.domain.organizationalStructure.PartyType;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitClassification;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.YearMonthDay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CountryUnit
extends CountryUnit_Base {
    private static final Logger logger;
    private static transient CountryUnit defaultCountry;
    public static final Advice advice$associateCountry;

    private CountryUnit() {
        super.setType(PartyTypeEnum.COUNTRY);
    }

    public static CountryUnit createNewCountryUnit(MultiLanguageString countryName, String countryNameCard, Integer costCenterCode, String countryAcronym, YearMonthDay beginDate, YearMonthDay endDate, Unit parentUnit, String webAddress, UnitClassification classification, Boolean canBeResponsibleOfSpaces, Space campus) {
        CountryUnit countryUnit = new CountryUnit();
        countryUnit.init(countryName, countryNameCard, costCenterCode, countryAcronym, beginDate, endDate, webAddress, classification, null, canBeResponsibleOfSpaces, campus);
        countryUnit.addParentUnit(parentUnit, AccountabilityType.readByType(AccountabilityTypeEnum.GEOGRAPHIC));
        CountryUnit.checkIfAlreadyExistsOneCountryWithSameAcronym(countryUnit);
        return countryUnit;
    }

    public void edit(MultiLanguageString name, String acronym) {
        super.edit(name, acronym);
        CountryUnit.checkIfAlreadyExistsOneCountryWithSameAcronym(this);
    }

    public void edit(MultiLanguageString unitName, String unitNameCard, Integer unitCostCenter, String acronym, YearMonthDay beginDate, YearMonthDay endDate, String webAddress, UnitClassification classification, Department department, Degree degree, AdministrativeOffice administrativeOffice, Boolean canBeResponsibleOfSpaces, Space campus) {
        super.edit(unitName, unitNameCard, unitCostCenter, acronym, beginDate, endDate, webAddress, classification, department, degree, administrativeOffice, canBeResponsibleOfSpaces, campus);
        CountryUnit.checkIfAlreadyExistsOneCountryWithSameAcronym(this);
    }

    public Accountability addParentUnit(Unit parentUnit, AccountabilityType accountabilityType) {
        if (!(parentUnit == null || parentUnit.isOfficialExternal() && parentUnit.isPlanetUnit())) {
            throw new DomainException("error.exception.commons.institution.invalidParentUnit", new String[0]);
        }
        return super.addParentUnit(parentUnit, accountabilityType);
    }

    public void setAcronym(String acronym) {
        if (StringUtils.isEmpty((String)acronym)) {
            throw new DomainException("error.unit.empty.acronym", new String[0]);
        }
        super.setAcronym(acronym);
    }

    public void setType(PartyTypeEnum partyTypeEnum) {
        throw new DomainException("unit.impossible.set.type", new String[0]);
    }

    public List<ExternalCurricularCourse> getAllExternalCurricularCourses() {
        ArrayList<ExternalCurricularCourse> result = new ArrayList<ExternalCurricularCourse>(this.getExternalCurricularCoursesSet());
        for (Unit subUnit : this.getSubUnits()) {
            if (!subUnit.isUniversityUnit() && !subUnit.isSchoolUnit()) continue;
            result.addAll(subUnit.getExternalCurricularCoursesSet());
        }
        return result;
    }

    public boolean isCountryUnit() {
        return true;
    }

    private static void checkIfAlreadyExistsOneCountryWithSameAcronym(CountryUnit countryUnit) {
        for (Unit parentUnit : countryUnit.getParentUnits()) {
            for (Unit unit : parentUnit.getAllSubUnits()) {
                if (unit.equals((Object)countryUnit) || !unit.isCountryUnit() || !countryUnit.getAcronym().equalsIgnoreCase(unit.getAcronym())) continue;
                throw new DomainException("error.unit.already.exists.unit.with.same.name.or.acronym: " + countryUnit.getAcronym(), new String[0]);
            }
        }
    }

    public static CountryUnit getDefault() {
        if (defaultCountry != null && defaultCountry.getRootDomainObject() == Bennu.getInstance()) {
            return defaultCountry;
        }
        defaultCountry = (CountryUnit)((Object)Unit.readUnitByAcronymAndType(BundleUtil.getString((String)"resources.GlobalResources", (String)"default.country.code", (String[])new String[0]), PartyTypeEnum.COUNTRY));
        return defaultCountry;
    }

    public static Set<CountryUnit> readAllCountryUnits() {
        PartyType partyType = PartyType.readPartyTypeByType(PartyTypeEnum.COUNTRY);
        return partyType.getPartiesSet();
    }

    public void associateCountry(Country country) {
        Object object = advice$associateCountry.perform((Callable)new CountryUnit$callable$associateCountry(this, country));
    }

    static /* synthetic */ void advised$associateCountry(CountryUnit this_, Country country) {
        if (country == null) {
            throw new DomainException("error.country.unit.country.is.empty", new String[0]);
        }
        this_.setCountry(country);
    }

    public static CountryUnit getCountryUnitByCountry(Country country) {
        if (country == null) {
            return null;
        }
        PartyType partyType = PartyType.readPartyTypeByType(PartyTypeEnum.COUNTRY);
        Set units = partyType.getPartiesSet();
        for (Unit unit : units) {
            if (!(unit instanceof CountryUnit)) {
                logger.info(String.format("Unit is not country %s", unit.getName()));
                continue;
            }
            if (((CountryUnit)((Object)unit)).getCountry() != country) continue;
            return (CountryUnit)((Object)unit);
        }
        return null;
    }

    static {
        advice$associateCountry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(CountryUnit.class);
    }
}

