/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.RestrictionBetweenDegreeModules_Base;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.util.LogicOperator;
import org.fenixedu.academic.dto.GenericPair;

public class RestrictionBetweenDegreeModules
extends RestrictionBetweenDegreeModules_Base {
    private RestrictionBetweenDegreeModules(DegreeModule precedenceDegreeModule, Double minimumCredits) {
        this.checkParameters(precedenceDegreeModule, minimumCredits);
        this.setPrecedenceDegreeModule(precedenceDegreeModule);
        this.setMinimumCredits(minimumCredits);
        this.setCurricularRuleType(CurricularRuleType.PRECEDENCY_BETWEEN_DEGREE_MODULES);
    }

    private void checkParameters(DegreeModule precedenceDegreeModule, Double minimumCredits) throws DomainException {
        if (precedenceDegreeModule == null || minimumCredits == null) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
    }

    protected RestrictionBetweenDegreeModules(DegreeModule degreeModuleToApplyRule, DegreeModule precedenceDegreeModule, Double minimumCredits, CourseGroup contextCourseGroup, ExecutionSemester begin, ExecutionSemester end) {
        this(precedenceDegreeModule, minimumCredits);
        this.init(degreeModuleToApplyRule, contextCourseGroup, begin, end);
    }

    protected void edit(DegreeModule precedenceDegreeModule, Double minimumCredits, CourseGroup contextCourseGroup) {
        this.checkParameters(precedenceDegreeModule, minimumCredits);
        this.setPrecedenceDegreeModule(precedenceDegreeModule);
        this.setMinimumCredits(minimumCredits);
        this.setContextCourseGroup(contextCourseGroup);
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        ArrayList<GenericPair<Object, Boolean>> labelList = new ArrayList<GenericPair<Object, Boolean>>();
        if (this.belongsToCompositeRule() && this.getParentCompositeRule().getCompositeRuleType().equals((Object)LogicOperator.NOT)) {
            labelList.add(new GenericPair<String, Boolean>("label.precedence", true));
        } else {
            labelList.add(new GenericPair<String, Boolean>("label.precedence", true));
        }
        labelList.add(new GenericPair<String, Boolean>(" ", false));
        labelList.add(new GenericPair<String, Boolean>("label.of", true));
        labelList.add(new GenericPair<String, Boolean>(" ", false));
        labelList.add(new GenericPair<String, Boolean>("label.module", true));
        labelList.add(new GenericPair<String, Boolean>(": ", false));
        String precedenceDegreeModule = this.getPrecedenceDegreeModule().isLeaf() ? this.getPrecedenceDegreeModule().getName() : this.getPrecedenceDegreeModule().getOneFullName();
        labelList.add(new GenericPair<String, Boolean>(precedenceDegreeModule, false));
        if (this.getMinimumCredits() != 0.0) {
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>("label.with", true));
            labelList.add(new GenericPair<String, Boolean>(", ", false));
            labelList.add(new GenericPair<String, Boolean>("label.in", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>("label.minimum", true));
            labelList.add(new GenericPair<String, Boolean>(", ", false));
            labelList.add(new GenericPair<Double, Boolean>(this.getMinimumCredits(), false));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>("label.credits", true));
        }
        if (this.getContextCourseGroup() != null) {
            labelList.add(new GenericPair<String, Boolean>(", ", false));
            labelList.add(new GenericPair<String, Boolean>("label.inContext", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>(this.getContextCourseGroup().getOneFullName(), false));
        }
        return labelList;
    }

    protected boolean appliesToPeriod(Context context) {
        return this.getDegreeModuleToApplyRule().isCourseGroup() || super.appliesToPeriod(context);
    }

    public boolean hasMinimumCredits() {
        return this.getMinimumCredits() != null && this.getMinimumCredits() != 0.0;
    }

    public boolean allowCredits(Double credits) {
        return credits >= this.getMinimumCredits();
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return VerifyRuleExecutor.NULL_VERIFY_EXECUTOR;
    }
}

