/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.secondCycle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessSelectDegreesBean;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessState;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleCandidacyProcess_Base;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacyProcess;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.CandidacyPeriod;
import org.fenixedu.academic.domain.period.SecondCycleCandidacyPeriod;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class SecondCycleCandidacyProcess
extends SecondCycleCandidacyProcess_Base {
    private static List<Activity> activities = new ArrayList<Activity>();
    private static final Predicate<DegreeType> ALLOWED_DEGREE_TYPES;

    private SecondCycleCandidacyProcess() {
    }

    private SecondCycleCandidacyProcess(ExecutionYear executionYear, DateTime start, DateTime end, String name) {
        this();
        this.checkParameters((ExecutionInterval)((Object)executionYear), start, end);
        this.setState(CandidacyProcessState.STAND_BY);
        this.setName(name);
        new SecondCycleCandidacyPeriod(this, executionYear, start, end);
    }

    private void checkParameters(ExecutionInterval executionInterval, DateTime start, DateTime end) {
        if (executionInterval == null) {
            throw new DomainException("error.SecondCycleCandidacyProcess.invalid.executionInterval", new String[0]);
        }
        if (start == null || end == null || start.isAfter((ReadableInstant)end)) {
            throw new DomainException("error.SecondCycleCandidacyProcess.invalid.interval", new String[0]);
        }
    }

    private void edit(DateTime start, DateTime end) {
        this.checkParameters(this.getCandidacyPeriod().getExecutionInterval(), start, end);
        this.getCandidacyPeriod().edit(start, end);
    }

    public boolean canExecuteActivity(User userView) {
        return SecondCycleCandidacyProcess.isAllowedToManageProcess(userView) || RoleType.SCIENTIFIC_COUNCIL.isMember(userView.getPerson().getUser()) || RoleType.COORDINATOR.isMember(userView.getPerson().getUser());
    }

    public List<Activity> getActivities() {
        return activities;
    }

    public ExecutionYear getCandidacyExecutionInterval() {
        return (ExecutionYear)((Object)super.getCandidacyExecutionInterval());
    }

    public List<SecondCycleIndividualCandidacyProcess> getValidSecondCycleIndividualCandidacies() {
        ArrayList<SecondCycleIndividualCandidacyProcess> result = new ArrayList<SecondCycleIndividualCandidacyProcess>();
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            SecondCycleIndividualCandidacyProcess process2 = (SecondCycleIndividualCandidacyProcess)((Object)child);
            if (!process2.isCandidacyValid()) continue;
            result.add(process2);
        }
        return result;
    }

    public List<SecondCycleIndividualCandidacyProcess> getValidSecondCycleIndividualCandidacies(Degree degree) {
        if (degree == null) {
            return Collections.emptyList();
        }
        ArrayList<SecondCycleIndividualCandidacyProcess> result = new ArrayList<SecondCycleIndividualCandidacyProcess>();
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            SecondCycleIndividualCandidacyProcess process2 = (SecondCycleIndividualCandidacyProcess)((Object)child);
            if (!process2.isCandidacyValid() || !process2.hasCandidacyForSelectedDegree(degree)) continue;
            result.add(process2);
        }
        return result;
    }

    public Map<Degree, SortedSet<SecondCycleIndividualCandidacyProcess>> getValidSecondCycleIndividualCandidaciesByDegree() {
        TreeMap<Degree, SortedSet<SecondCycleIndividualCandidacyProcess>> result = new TreeMap<Degree, SortedSet<SecondCycleIndividualCandidacyProcess>>(Degree.COMPARATOR_BY_NAME_AND_ID);
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            SecondCycleIndividualCandidacyProcess process2 = (SecondCycleIndividualCandidacyProcess)((Object)child);
            if (!process2.isCandidacyValid()) continue;
            this.addCandidacy(result, process2);
        }
        return result;
    }

    private void addCandidacy(Map<Degree, SortedSet<SecondCycleIndividualCandidacyProcess>> result, SecondCycleIndividualCandidacyProcess process2) {
        SortedSet<SecondCycleIndividualCandidacyProcess> values = result.get(process2.getCandidacySelectedDegree());
        if (values == null) {
            values = new TreeSet<SecondCycleIndividualCandidacyProcess>(SecondCycleIndividualCandidacyProcess.COMPARATOR_BY_CANDIDACY_PERSON);
            result.put(process2.getCandidacySelectedDegree(), values);
        }
        values.add(process2);
    }

    public List<SecondCycleIndividualCandidacyProcess> getAcceptedSecondCycleIndividualCandidacies() {
        ArrayList<SecondCycleIndividualCandidacyProcess> result = new ArrayList<SecondCycleIndividualCandidacyProcess>();
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            if (!child.isCandidacyValid() || !child.isCandidacyAccepted()) continue;
            result.add((SecondCycleIndividualCandidacyProcess)((Object)child));
        }
        return result;
    }

    private static boolean isAllowedToManageProcess(User userView) {
        for (AcademicProgram program : AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_CANDIDACY_PROCESSES, userView.getPerson().getUser()).collect(Collectors.toSet())) {
            if (!ALLOWED_DEGREE_TYPES.test(program.getDegreeType())) continue;
            return true;
        }
        return false;
    }

    public List<Degree> getAvailableDegrees() {
        Set degrees = this.getDegreeSet();
        return degrees.isEmpty() ? Degree.readAllMatching(DegreeType.oneOf(DegreeType::isBolonhaMasterDegree, DegreeType::isIntegratedMasterDegree)) : new ArrayList<Degree>(degrees);
    }

    public List<SecondCycleCandidacyProcess> getNextSecondCyleCandidacyProcesses() {
        ArrayList<SecondCycleCandidacyProcess> result = new ArrayList<SecondCycleCandidacyProcess>();
        List<CandidacyPeriod> readAllByType = CandidacyPeriod.readAllByType(SecondCycleCandidacyPeriod.class);
        for (CandidacyPeriod candidacyPeriod : readAllByType) {
            SecondCycleCandidacyPeriod secondCycleCandidacyPeriod = (SecondCycleCandidacyPeriod)((Object)candidacyPeriod);
            if (!this.getCandidacyPeriod().getStart().isBefore((ReadableInstant)candidacyPeriod.getStart())) continue;
            result.add(secondCycleCandidacyPeriod.getSecondCycleCandidacyProcess());
        }
        return result;
    }

    static {
        activities.add(new EditCandidacyPeriod());
        activities.add(new SendToCoordinator());
        activities.add(new PrintCandidacies());
        activities.add(new ExportCandidacies());
        activities.add(new SendToScientificCouncil());
        activities.add(new ViewChildProcessWithMissingRequiredDocumentFiles());
        activities.add(new SelectAvailableDegrees());
        ALLOWED_DEGREE_TYPES = DegreeType.oneOf(DegreeType::isBolonhaMasterDegree, DegreeType::isIntegratedMasterDegree);
    }

    private static class SelectAvailableDegrees
    extends Activity<SecondCycleCandidacyProcess> {
        private SelectAvailableDegrees() {
        }

        @Override
        public void checkPreConditions(SecondCycleCandidacyProcess process2, User userView) {
            if (!SecondCycleCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleCandidacyProcess executeActivity(SecondCycleCandidacyProcess process2, User userView, Object object) {
            CandidacyProcessSelectDegreesBean bean = (CandidacyProcessSelectDegreesBean)object;
            List<Degree> degrees = bean.getDegrees();
            process2.getDegreeSet().addAll(degrees);
            process2.getDegreeSet().retainAll(degrees);
            return process2;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return Boolean.FALSE;
        }
    }

    private static class ViewChildProcessWithMissingRequiredDocumentFiles
    extends Activity<SecondCycleCandidacyProcess> {
        private ViewChildProcessWithMissingRequiredDocumentFiles() {
        }

        @Override
        public void checkPreConditions(SecondCycleCandidacyProcess process2, User userView) {
            if (!SecondCycleCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleCandidacyProcess executeActivity(SecondCycleCandidacyProcess process2, User userView, Object object) {
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return true;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }
    }

    private static class SendToScientificCouncil
    extends Activity<SecondCycleCandidacyProcess> {
        private SendToScientificCouncil() {
        }

        @Override
        public void checkPreConditions(SecondCycleCandidacyProcess process2, User userView) {
            if (!SecondCycleCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isInStandBy() && !process2.isSentToCoordinator()) {
                throw new PreConditionNotValidException();
            }
            if (process2.getCandidacyPeriod() == null || !process2.hasStarted() || process2.hasOpenCandidacyPeriod()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleCandidacyProcess executeActivity(SecondCycleCandidacyProcess process2, User userView, Object object) {
            process2.setState(CandidacyProcessState.SENT_TO_SCIENTIFIC_COUNCIL);
            return process2;
        }
    }

    private static class ExportCandidacies
    extends Activity<SecondCycleCandidacyProcess> {
        private ExportCandidacies() {
        }

        @Override
        public void checkPreConditions(SecondCycleCandidacyProcess process2, User userView) {
            if (!SecondCycleCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleCandidacyProcess executeActivity(SecondCycleCandidacyProcess process2, User userView, Object object) {
            return process2;
        }
    }

    private static class PrintCandidacies
    extends Activity<SecondCycleCandidacyProcess> {
        private PrintCandidacies() {
        }

        @Override
        public void checkPreConditions(SecondCycleCandidacyProcess process2, User userView) {
            if (!SecondCycleCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleCandidacyProcess executeActivity(SecondCycleCandidacyProcess process2, User userView, Object object) {
            return process2;
        }
    }

    private static class SendToCoordinator
    extends Activity<SecondCycleCandidacyProcess> {
        private SendToCoordinator() {
        }

        @Override
        public void checkPreConditions(SecondCycleCandidacyProcess process2, User userView) {
            if (!SecondCycleCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isInStandBy() && !process2.isSentToScientificCouncil()) {
                throw new PreConditionNotValidException();
            }
            if (process2.getCandidacyPeriod() == null || !process2.hasStarted() || process2.hasOpenCandidacyPeriod()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleCandidacyProcess executeActivity(SecondCycleCandidacyProcess process2, User userView, Object object) {
            process2.setState(CandidacyProcessState.SENT_TO_COORDINATOR);
            return process2;
        }
    }

    private static class EditCandidacyPeriod
    extends Activity<SecondCycleCandidacyProcess> {
        private EditCandidacyPeriod() {
        }

        @Override
        public void checkPreConditions(SecondCycleCandidacyProcess process2, User userView) {
            if (!SecondCycleCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleCandidacyProcess executeActivity(SecondCycleCandidacyProcess process2, User userView, Object object) {
            CandidacyProcessBean bean = (CandidacyProcessBean)object;
            process2.edit(bean.getStart(), bean.getEnd());
            return process2;
        }
    }

    @StartActivity
    public static class CreateCandidacyPeriod
    extends Activity<SecondCycleCandidacyProcess> {
        @Override
        public void checkPreConditions(SecondCycleCandidacyProcess process2, User userView) {
            if (!SecondCycleCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleCandidacyProcess executeActivity(SecondCycleCandidacyProcess process2, User userView, Object object) {
            CandidacyProcessBean bean = (CandidacyProcessBean)object;
            return new SecondCycleCandidacyProcess((ExecutionYear)((Object)bean.getExecutionInterval()), bean.getStart(), bean.getEnd(), bean.getName());
        }
    }
}

