/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.serviceAgreements.DegreeCurricularPlanServiceAgreement;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.CandidacyDocument;
import org.fenixedu.academic.domain.candidacy.CandidacyOperationType;
import org.fenixedu.academic.domain.candidacy.CandidacySituation;
import org.fenixedu.academic.domain.candidacy.CandidacySituationType;
import org.fenixedu.academic.domain.candidacy.DFACandidacy_Base;
import org.fenixedu.academic.domain.candidacy.PreCandidacySituation;
import org.fenixedu.academic.domain.util.workflow.Operation;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.YearMonthDay;

public class DFACandidacy
extends DFACandidacy_Base {
    private static Map<String, Set<String>> stateMap = new HashMap<String, Set<String>>();

    public DFACandidacy(Person person, ExecutionDegree executionDegree) {
        this.init(person, executionDegree);
        new PreCandidacySituation((Candidacy)((Object)this));
        this.addCandidacyDocuments(new CandidacyDocument("curriculum.vitae"));
        this.addCandidacyDocuments(new CandidacyDocument("habilitation.certificate"));
        this.addCandidacyDocuments(new CandidacyDocument("second.habilitation.certificate"));
        this.addCandidacyDocuments(new CandidacyDocument("interest.letter"));
        AdministrativeOffice administrativeOffice = executionDegree.getDegree().getAdministrativeOffice();
        new DegreeCurricularPlanServiceAgreement(person, executionDegree.getDegreeCurricularPlan().getServiceAgreementTemplate());
    }

    public DFACandidacy(Person person, ExecutionDegree executionDegree, YearMonthDay startDate) {
        this(person, executionDegree);
        if (startDate != null) {
            this.setStartDate(startDate);
        }
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.CandidateResources", (String)"label.dfaCandidacy", (String[])new String[0]) + " - " + this.getExecutionDegree().getDegreeCurricularPlan().getName() + " - " + this.getExecutionDegree().getExecutionYear().getYear();
    }

    public Set<Operation> getOperations(CandidacySituation candidacySituation) {
        return new HashSet<Operation>();
    }

    protected void moveToNextState(CandidacyOperationType candidacyOperationType, Person person) {
    }

    public void cancelEvents() {
    }

    public Map<String, Set<String>> getStateMapping() {
        return stateMap;
    }

    public String getDefaultState() {
        switch (this.getActiveCandidacySituation().getCandidacySituationType()) {
            case ADMITTED: {
                return CandidacySituationType.REGISTERED.toString();
            }
            case PRE_CANDIDACY: {
                return CandidacySituationType.STAND_BY.toString();
            }
            case STAND_BY: {
                return CandidacySituationType.STAND_BY_FILLED_DATA.toString();
            }
            case STAND_BY_FILLED_DATA: {
                return CandidacySituationType.ADMITTED.toString();
            }
        }
        return null;
    }

    protected boolean checkIfDataIsFilled() {
        Person person = this.getPerson();
        return person.getGender() != null && person.getExpirationDateOfDocumentIdYearMonthDay() != null && person.getProfession() != null && person.getMaritalStatus() != null && person.getDateOfBirthYearMonthDay() != null && person.getCountry() != null && person.getNameOfFather() != null && person.getNameOfMother() != null && person.hasDefaultPhysicalAddress() && person.getInstitutionalOrDefaultEmailAddressValue() != null;
    }

    static {
        HashSet<String> admittedSet = new HashSet<String>();
        admittedSet.add(CandidacySituationType.ADMITTED.toString());
        admittedSet.add(CandidacySituationType.REGISTERED.toString());
        admittedSet.add(CandidacySituationType.NOT_ADMITTED.toString());
        admittedSet.add(CandidacySituationType.SUBSTITUTE.toString());
        admittedSet.add(CandidacySituationType.CANCELLED.toString());
        stateMap.put(CandidacySituationType.ADMITTED.toString(), admittedSet);
        stateMap.put(CandidacySituationType.CANCELLED.toString(), new HashSet());
        HashSet<String> notAdmitted = new HashSet<String>();
        notAdmitted.add(CandidacySituationType.ADMITTED.toString());
        notAdmitted.add(CandidacySituationType.NOT_ADMITTED.toString());
        notAdmitted.add(CandidacySituationType.SUBSTITUTE.toString());
        notAdmitted.add(CandidacySituationType.CANCELLED.toString());
        stateMap.put(CandidacySituationType.NOT_ADMITTED.toString(), notAdmitted);
        HashSet<String> preCandidacy = new HashSet<String>();
        preCandidacy.add(CandidacySituationType.STAND_BY.toString());
        preCandidacy.add(CandidacySituationType.CANCELLED.toString());
        stateMap.put(CandidacySituationType.PRE_CANDIDACY.toString(), preCandidacy);
        stateMap.put(CandidacySituationType.REGISTERED.toString(), new HashSet());
        HashSet<String> standBy = new HashSet<String>();
        standBy.add(CandidacySituationType.STAND_BY_FILLED_DATA.toString());
        standBy.add(CandidacySituationType.STAND_BY_CONFIRMED_DATA.toString());
        standBy.add(CandidacySituationType.CANCELLED.toString());
        stateMap.put(CandidacySituationType.STAND_BY.toString(), standBy);
        HashSet<String> standByConfirmedData = new HashSet<String>();
        standByConfirmedData.add(CandidacySituationType.ADMITTED.toString());
        standByConfirmedData.add(CandidacySituationType.NOT_ADMITTED.toString());
        standByConfirmedData.add(CandidacySituationType.SUBSTITUTE.toString());
        standByConfirmedData.add(CandidacySituationType.CANCELLED.toString());
        stateMap.put(CandidacySituationType.STAND_BY_CONFIRMED_DATA.toString(), standByConfirmedData);
        HashSet<String> standByFilledData = new HashSet<String>();
        standByFilledData.add(CandidacySituationType.STAND_BY_CONFIRMED_DATA.toString());
        standByFilledData.add(CandidacySituationType.ADMITTED.toString());
        standByFilledData.add(CandidacySituationType.STAND_BY.toString());
        stateMap.put(CandidacySituationType.STAND_BY_FILLED_DATA.toString(), standByFilledData);
        HashSet<String> substitute = new HashSet<String>();
        substitute.add(CandidacySituationType.ADMITTED.toString());
        substitute.add(CandidacySituationType.NOT_ADMITTED.toString());
        substitute.add(CandidacySituationType.SUBSTITUTE.toString());
        stateMap.put(CandidacySituationType.SUBSTITUTE.toString(), substitute);
    }
}

