/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.report.events;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.QueueJobResult;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.ResidenceEvent;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceEvent;
import org.fenixedu.academic.domain.accounting.events.candidacy.IndividualCandidacyEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.AcademicServiceRequestEvent;
import org.fenixedu.academic.domain.accounting.report.events.AcademicServiceRequestEventWrapper;
import org.fenixedu.academic.domain.accounting.report.events.AdminFeeAndInsuranceEventWrapper;
import org.fenixedu.academic.domain.accounting.report.events.EventReportQueueJob$1$callable$run;
import org.fenixedu.academic.domain.accounting.report.events.EventReportQueueJob$3$callable$run;
import org.fenixedu.academic.domain.accounting.report.events.EventReportQueueJob$5$callable$run;
import org.fenixedu.academic.domain.accounting.report.events.EventReportQueueJob$callable$createRequest;
import org.fenixedu.academic.domain.accounting.report.events.EventReportQueueJobBean;
import org.fenixedu.academic.domain.accounting.report.events.EventReportQueueJobFile;
import org.fenixedu.academic.domain.accounting.report.events.EventReportQueueJob_Base;
import org.fenixedu.academic.domain.accounting.report.events.EventWrapper;
import org.fenixedu.academic.domain.accounting.report.events.ExemptionWrapper;
import org.fenixedu.academic.domain.accounting.report.events.ExternalScholarshipPhdGratuityContribuitionEventWrapper;
import org.fenixedu.academic.domain.accounting.report.events.GratuityEventWrapper;
import org.fenixedu.academic.domain.accounting.report.events.IndividualCandidacyEventWrapper;
import org.fenixedu.academic.domain.accounting.report.events.InstallmentWrapper;
import org.fenixedu.academic.domain.accounting.report.events.PhdEventWrapper;
import org.fenixedu.academic.domain.accounting.report.events.ResidenceEventWrapper;
import org.fenixedu.academic.domain.accounting.report.events.Wrapper;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.phd.debts.PhdEvent;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilder;
import org.fenixedu.commons.spreadsheet.WorkbookExportFormat;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EventReportQueueJob
extends EventReportQueueJob_Base {
    private static final Logger logger;
    private static final String FIELD_SEPARATOR = "\t";
    private static final String LINE_BREAK = "\n";
    private static final Integer BLOCK;
    public static final Advice advice$createRequest;

    private EventReportQueueJob() {
    }

    private EventReportQueueJob(EventReportQueueJobBean bean) {
        this();
        this.checkPermissions(bean);
        this.setExportGratuityEvents(bean.getExportGratuityEvents());
        this.setExportAcademicServiceRequestEvents(bean.getExportAcademicServiceRequestEvents());
        this.setExportAdministrativeOfficeFeeAndInsuranceEvents(bean.getExportAdminOfficeFeeAndInsuranceEvents());
        this.setExportIndividualCandidacyEvents(bean.getExportIndividualCandidacyEvents());
        this.setExportPhdEvents(bean.getExportPhdEvents());
        this.setExportResidenceEvents(bean.getExportResidenceEvents());
        this.setExportOthers(bean.getExportOthers());
        this.setBeginDate(bean.getBeginDate());
        this.setEndDate(bean.getEndDate());
        this.setForExecutionYear(bean.getExecutionYear());
        this.setForAdministrativeOffice(bean.getAdministrativeOffice());
    }

    private void checkPermissions(EventReportQueueJobBean bean) {
        Person loggedPerson = AccessControl.getPerson();
        if (loggedPerson == null) {
            throw new DomainException("error.EventReportQueueJob.permission.denied", new String[0]);
        }
        if (RoleType.MANAGER.isMember(loggedPerson.getUser())) {
            return;
        }
        if (bean.getAdministrativeOffice() == null) {
            throw new DomainException("error.EventReportQueueJob.permission.denied", new String[0]);
        }
        Set offices = AcademicAccessRule.getOfficesAccessibleToFunction(AcademicOperationType.MANAGE_EVENT_REPORTS, loggedPerson.getUser()).collect(Collectors.toSet());
        if (!offices.contains((Object)bean.getAdministrativeOffice())) {
            throw new DomainException("error.EventReportQueueJob.permission.denied", new String[0]);
        }
    }

    public String getFilename() {
        return "dividas" + this.getRequestDate().toString("ddMMyyyyhms") + ".tsv";
    }

    public QueueJobResult execute() throws Exception {
        ByteArrayOutputStream byteArrayOSForDebts = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOSForExemptions = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOSForTransactions = new ByteArrayOutputStream();
        StringBuilder errors = new StringBuilder();
        SheetData[] reports = this.buildReport(errors);
        SpreadsheetBuilder spreadsheetBuilderForDebts = new SpreadsheetBuilder();
        SpreadsheetBuilder spreadsheetBuilderForExemptions = new SpreadsheetBuilder();
        SpreadsheetBuilder spreadsheetBuilderForTransactions = new SpreadsheetBuilder();
        spreadsheetBuilderForDebts.addSheet("dividas", reports[0]);
        spreadsheetBuilderForExemptions.addSheet("isencoes", reports[1]);
        spreadsheetBuilderForTransactions.addSheet("transaccoes", reports[2]);
        spreadsheetBuilderForDebts.build(WorkbookExportFormat.TSV, (OutputStream)byteArrayOSForDebts);
        spreadsheetBuilderForExemptions.build(WorkbookExportFormat.TSV, (OutputStream)byteArrayOSForExemptions);
        spreadsheetBuilderForTransactions.build(WorkbookExportFormat.TSV, (OutputStream)byteArrayOSForTransactions);
        byteArrayOSForDebts.close();
        byteArrayOSForExemptions.close();
        byteArrayOSForTransactions.close();
        QueueJobResult queueJobResult = new QueueJobResult();
        queueJobResult.setContentType("text/tsv");
        queueJobResult.setContent(byteArrayOSForDebts.toByteArray());
        EventReportQueueJobFile fileForDebts = new EventReportQueueJobFile(byteArrayOSForDebts.toByteArray(), "dividas.tsv");
        EventReportQueueJobFile fileForExemptions = new EventReportQueueJobFile(byteArrayOSForExemptions.toByteArray(), "isencoes.tsv");
        EventReportQueueJobFile fileForTransactions = new EventReportQueueJobFile(byteArrayOSForTransactions.toByteArray(), "transaccoes.tsv");
        if (!errors.toString().isEmpty()) {
            StringBuilder headers = this.buildHeaders();
            headers.append((CharSequence)errors);
            EventReportQueueJobFile fileForErrors = new EventReportQueueJobFile(headers.toString().getBytes(StandardCharsets.UTF_8), "erros.tsv");
            this.setErrorsFile(fileForErrors);
        }
        this.setDebts(fileForDebts);
        this.setExemptions(fileForExemptions);
        this.setTransactions(fileForTransactions);
        logger.info("Job " + this.getFilename() + " completed");
        return queueJobResult;
    }

    private SheetData[] buildReport(StringBuilder errors) {
        SheetData<EventBean> eventsSheet = this.allEvents(errors);
        SheetData<ExemptionBean> exemptionsSheet = this.allExemptions(errors);
        SheetData<AccountingTransactionBean> transactionsSheet = this.allTransactions(errors);
        return new SheetData[]{eventsSheet, exemptionsSheet, transactionsSheet};
    }

    /*
     * Exception decompiling
     */
    private List<String> getAllEventsExternalIds() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SheetData<EventBean> allEvents(final StringBuilder errors) {
        List<String> allEventsExternalIds = this.getAllEventsExternalIds();
        logger.info(String.format("%s events to process", allEventsExternalIds.size()));
        Integer blockRead = 0;
        final List result = Collections.synchronizedList(new ArrayList());
        while (blockRead < allEventsExternalIds.size()) {
            Integer inc = BLOCK;
            if (blockRead + inc >= allEventsExternalIds.size()) {
                inc = allEventsExternalIds.size() - blockRead;
            }
            final List<String> block = allEventsExternalIds.subList(blockRead, blockRead + inc);
            blockRead = blockRead + inc;
            Thread thread = new Thread(){
                public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));

                @Override
                public void run() {
                    Object object = advice$run.perform((Callable)new EventReportQueueJob$1$callable$run(this));
                }

                static /* synthetic */ void advised$run(1 this_) {
                    for (String oid : this_.block) {
                        Event event = null;
                        try {
                            event = (Event)FenixFramework.getDomainObject((String)oid);
                            if (!this_.EventReportQueueJob.this.isAccountingEventForReport(event)) continue;
                            this_.result.add(this_.EventReportQueueJob.this.writeEvent(event));
                        }
                        catch (Throwable e) {
                            this_.errors.append((CharSequence)this_.EventReportQueueJob.this.getErrorLine(event, e));
                        }
                    }
                }
            };
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            logger.info(String.format("Read %s events", blockRead));
        }
        logger.info(String.format("Catch %s events ", result.size()));
        return new SheetData<EventBean>(result){

            protected void makeLine(EventBean bean) {
                this.addCell("Identificador", bean.externalId);
                this.addCell("Aluno", bean.studentNumber);
                this.addCell("Nome", bean.studentName);
                this.addCell("Email", bean.email);
                this.addCell("Data inscri\u00e7\u00e3o", bean.registrationStartDate);
                this.addCell("Ano lectivo", bean.executionYear);
                this.addCell("Tipo de matricula", bean.studiesType);
                this.addCell("Nome do Curso", bean.degreeName);
                this.addCell("Tipo de curso", bean.degreeType);
                this.addCell("Programa doutoral", bean.phdProgramName);
                this.addCell("ECTS inscritos", bean.enrolledECTS);
                this.addCell("Regime", bean.regime);
                this.addCell("Modelo de inscri\u00e7\u00e3o", bean.enrolmentModel);
                this.addCell("Resid\u00eancia - Ano", bean.residenceYear);
                this.addCell("Resid\u00eancia - M\u00eas", bean.residenceMonth);
                this.addCell("Tipo de divida", bean.description);
                this.addCell("Data de cria\u00e7\u00e3o", bean.whenOccured);
                this.addCell("Valor Total", bean.totalAmount);
                this.addCell("Valor Pago", bean.payedAmount);
                this.addCell("Valor em divida", bean.amountToPay);
                this.addCell("Valor Reembols\u00e1vel", bean.reimbursableAmount);
                this.addCell("Desconto", bean.totalDiscount);
                this.addCell("D\u00edvida Associada", bean.relatedEvent);
                this.addCell("Id. Fiscal Entidade", bean.debtorFiscalId);
                this.addCell("Nome Entidade", bean.debtorName);
                List<InstallmentWrapper> list = bean.installments;
                if (list != null) {
                    for (InstallmentWrapper installment : list) {
                        this.addCell(installment.getExpirationDateLabel(), installment.getExpirationDate());
                        this.addCell(installment.getAmountToPayLabel(), installment.getAmountToPay());
                        this.addCell(installment.getRemainingAmountLabel(), installment.getRemainingAmount());
                    }
                }
            }
        };
    }

    private boolean isAccountingEventForReport(Event event) {
        if (event.isCancelled()) {
            return false;
        }
        Wrapper wrapper = this.buildWrapper(event);
        if (wrapper == null) {
            return false;
        }
        if (this.getForExecutionYear() != null && this.getForExecutionYear() != wrapper.getForExecutionYear()) {
            return false;
        }
        if (!this.officesMatch(wrapper)) {
            return false;
        }
        if (event.getWhenOccured().isAfter((ReadableInstant)this.getBeginDate().toDateTimeAtStartOfDay()) && event.getWhenOccured().isBefore((ReadableInstant)this.getEndDate().toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1))) {
            return true;
        }
        for (AccountingTransaction transaction : event.getNonAdjustingTransactions()) {
            if (transaction.getWhenRegistered() != null && transaction.getWhenRegistered().isBefore((ReadableInstant)this.getEndDate().toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1)) && transaction.getWhenRegistered().isAfter((ReadableInstant)this.getBeginDate().toDateTimeAtStartOfDay())) {
                return true;
            }
            if (transaction.getWhenProcessed() != null && transaction.getWhenProcessed().isBefore((ReadableInstant)this.getEndDate().toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1)) && transaction.getWhenProcessed().isAfter((ReadableInstant)this.getBeginDate().toDateTimeAtStartOfDay())) {
                return true;
            }
            for (AccountingTransaction adjustment : transaction.getAdjustmentTransactionsSet()) {
                if (adjustment.getWhenRegistered() != null && adjustment.getWhenRegistered().isBefore((ReadableInstant)this.getEndDate().toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1)) && adjustment.getWhenRegistered().isAfter((ReadableInstant)this.getBeginDate().toDateTimeAtStartOfDay())) {
                    return true;
                }
                if (adjustment.getWhenProcessed() == null || !adjustment.getWhenProcessed().isBefore((ReadableInstant)this.getEndDate().toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1)) || !adjustment.getWhenProcessed().isAfter((ReadableInstant)this.getBeginDate().toDateTimeAtStartOfDay())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean officesMatch(Wrapper wrapper) {
        if (wrapper.getRelatedAcademicOffice() == null) {
            return true;
        }
        return wrapper.getRelatedAcademicOffice().equals((Object)this.getForAdministrativeOffice());
    }

    private EventBean writeEvent(Event event) {
        Wrapper wrapper = this.buildWrapper(event);
        EventBean bean = new EventBean();
        bean.externalId = event.getExternalId();
        bean.studentNumber = wrapper.getStudentNumber();
        bean.studentName = wrapper.getStudentName();
        bean.email = wrapper.getStudentEmail();
        bean.registrationStartDate = wrapper.getRegistrationStartDate();
        bean.executionYear = wrapper.getExecutionYear();
        bean.studiesType = wrapper.getStudiesType();
        bean.degreeName = wrapper.getDegreeName();
        bean.degreeType = wrapper.getDegreeType();
        bean.phdProgramName = wrapper.getPhdProgramName();
        bean.enrolledECTS = wrapper.getEnrolledECTS();
        bean.regime = wrapper.getRegime();
        bean.enrolmentModel = wrapper.getEnrolmentModel();
        bean.residenceYear = wrapper.getResidenceYear();
        bean.residenceMonth = wrapper.getResidenceMonth();
        bean.description = event.getDescription().toString();
        bean.whenOccured = event.getWhenOccured().toString("dd/MM/yyyy");
        bean.totalAmount = event.getTotalAmountToPay() != null ? event.getTotalAmountToPay().toPlainString() : "-";
        bean.payedAmount = event.getPayedAmount().toPlainString();
        bean.amountToPay = event.getAmountToPay().toPlainString();
        bean.reimbursableAmount = event.getReimbursableAmount().toPlainString();
        bean.totalDiscount = event.getTotalDiscount().toPlainString();
        bean.relatedEvent = wrapper.getRelatedEventExternalId();
        bean.debtorFiscalId = wrapper.getDebtorFiscalId();
        bean.debtorName = wrapper.getDebtorName();
        if (wrapper instanceof GratuityEventWrapper) {
            bean.installments = ((GratuityEventWrapper)wrapper).getInstallments();
        }
        return bean;
    }

    private SheetData<ExemptionBean> allExemptions(final StringBuilder errors) {
        List<String> allEventsExternalIds = this.getAllEventsExternalIds();
        logger.info(String.format("%s events (exemptions) to process", allEventsExternalIds.size()));
        Integer blockRead = 0;
        final List result = Collections.synchronizedList(new ArrayList());
        while (blockRead < allEventsExternalIds.size()) {
            Integer inc = BLOCK;
            if (blockRead + inc >= allEventsExternalIds.size()) {
                inc = allEventsExternalIds.size() - blockRead;
            }
            final List<String> block = allEventsExternalIds.subList(blockRead, blockRead + inc);
            blockRead = blockRead + inc;
            Thread thread = new Thread(){
                public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));

                @Override
                public void run() {
                    Object object = advice$run.perform((Callable)new EventReportQueueJob$3$callable$run(this));
                }

                static /* synthetic */ void advised$run(3 this_) {
                    for (String oid : this_.block) {
                        Event event = (Event)FenixFramework.getDomainObject((String)oid);
                        try {
                            if (!this_.EventReportQueueJob.this.isAccountingEventForReport(event)) continue;
                            this_.result.addAll(this_.EventReportQueueJob.this.writeExemptionInformation(event));
                        }
                        catch (Throwable e) {
                            this_.errors.append((CharSequence)this_.EventReportQueueJob.this.getErrorLine(event, e));
                        }
                    }
                }
            };
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            logger.info(String.format("Read %s events", blockRead));
        }
        return new SheetData<ExemptionBean>(result){

            protected void makeLine(ExemptionBean bean) {
                this.addCell("Identificador", bean.eventExternalId);
                this.addCell("Tipo da Isen\u00e7\u00e3o", bean.exemptionTypeDescription);
                this.addCell("Valor da Isen\u00e7\u00e3o", bean.exemptionValue);
                this.addCell("Percentagem da Isen\u00e7\u00e3o", bean.percentage);
                this.addCell("Motivo da Isen\u00e7\u00e3o", bean.justification);
            }
        };
    }

    private StringBuilder buildHeaders() {
        StringBuilder header = new StringBuilder();
        header.append("ID Evento").append(FIELD_SEPARATOR).append("Username").append(FIELD_SEPARATOR).append("Nome").append(FIELD_SEPARATOR);
        header.append("Data evento").append(FIELD_SEPARATOR).append("Descri\u00e7\u00e3o").append(FIELD_SEPARATOR);
        header.append("Valor Total").append(FIELD_SEPARATOR).append("Excep\u00e7\u00e3o").append(LINE_BREAK);
        return header;
    }

    private StringBuilder getErrorLine(Event event, Throwable e) {
        StringBuilder errorLine = new StringBuilder();
        try {
            if (event != null) {
                errorLine.append(event.getExternalId()).append(FIELD_SEPARATOR).append(event.getPerson().getUsername()).append(FIELD_SEPARATOR);
                errorLine.append(event.getPerson().getName()).append(FIELD_SEPARATOR).append(event.getWhenOccured()).append(FIELD_SEPARATOR);
                errorLine.append(event.getDescription().toString()).append(FIELD_SEPARATOR).append(event.getOriginalAmountToPay()).append(FIELD_SEPARATOR);
            } else {
                errorLine.append(FIELD_SEPARATOR).append(FIELD_SEPARATOR).append(FIELD_SEPARATOR).append(FIELD_SEPARATOR).append(FIELD_SEPARATOR);
                errorLine.append(FIELD_SEPARATOR).append(FIELD_SEPARATOR).append(FIELD_SEPARATOR);
            }
        }
        catch (Exception e2) {
            errorLine.append((CharSequence)this.getExceptionLine(e2)).append(FIELD_SEPARATOR);
        }
        errorLine.append((CharSequence)this.getExceptionLine(e)).append(LINE_BREAK);
        return errorLine;
    }

    private StringBuilder getExceptionLine(Throwable e) {
        StringBuilder exceptionLine = new StringBuilder();
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        e.printStackTrace(printWriter);
        String[] exceptionLines = ((Object)result).toString().split(LINE_BREAK);
        exceptionLine.append(exceptionLines[0]).append(" - ").append(exceptionLines[1].replace(FIELD_SEPARATOR, ""));
        return exceptionLine;
    }

    private List<ExemptionBean> writeExemptionInformation(Event event) {
        Set<Exemption> exemptionsSet = event.getExemptionsSet();
        ArrayList<ExemptionBean> result = new ArrayList<ExemptionBean>();
        for (Exemption exemption : exemptionsSet) {
            ExemptionWrapper wrapper = new ExemptionWrapper(exemption);
            ExemptionBean bean = new ExemptionBean();
            bean.eventExternalId = event.getExternalId();
            bean.exemptionTypeDescription = wrapper.getExemptionTypeDescription();
            bean.exemptionValue = wrapper.getExemptionValue();
            bean.percentage = wrapper.getPercentage();
            bean.justification = wrapper.getJustification();
            result.add(bean);
        }
        return result;
    }

    private SheetData<AccountingTransactionBean> allTransactions(final StringBuilder errors) {
        List<String> allEventsExternalIds = this.getAllEventsExternalIds();
        logger.info(String.format("%s events (transactions) to process", allEventsExternalIds.size()));
        Integer blockRead = 0;
        final List result = Collections.synchronizedList(new ArrayList());
        while (blockRead < allEventsExternalIds.size()) {
            Integer inc = BLOCK;
            if (blockRead + inc >= allEventsExternalIds.size()) {
                inc = allEventsExternalIds.size() - blockRead;
            }
            final List<String> block = allEventsExternalIds.subList(blockRead, blockRead + inc);
            blockRead = blockRead + inc;
            Thread thread = new Thread(){
                public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));

                @Override
                public void run() {
                    Object object = advice$run.perform((Callable)new EventReportQueueJob$5$callable$run(this));
                }

                static /* synthetic */ void advised$run(5 this_) {
                    for (String oid : this_.block) {
                        Event event = (Event)FenixFramework.getDomainObject((String)oid);
                        try {
                            if (!this_.EventReportQueueJob.this.isAccountingEventForReport(event)) continue;
                            this_.result.addAll(this_.EventReportQueueJob.this.writeTransactionInformation(event));
                        }
                        catch (Throwable e) {
                            this_.errors.append((CharSequence)this_.EventReportQueueJob.this.getErrorLine(event, e));
                        }
                    }
                }
            };
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            logger.info(String.format("Read %s events", blockRead));
        }
        return new SheetData<AccountingTransactionBean>(result){

            protected void makeLine(AccountingTransactionBean bean) {
                this.addCell("Identificador", bean.eventExternalId);
                this.addCell("Data do pagamento", bean.whenRegistered);
                this.addCell("Data de entrada do pagamento", bean.whenProcessed);
                this.addCell("Nome da entidade devedora", bean.debtPartyName);
                this.addCell("Contribuinte da entidade devedora", bean.debtSocialSecurityNumber);
                this.addCell("Nome da entidade credora", bean.credPartyName);
                this.addCell("Contribuinte da entidade credora", bean.credSocialSecurityNumber);
                this.addCell("Montante inicial", bean.originalAmount);
                this.addCell("Montante ajustado", bean.amountWithAdjustment);
                this.addCell("Modo de pagamento", bean.paymentMode);
                this.addCell("Data do ajuste", bean.whenAdjustmentRegistered);
                this.addCell("Data de entrada do ajuste", bean.whenAdjustmentProcessed);
                this.addCell("Montante do ajuste", bean.adjustmentAmount);
                this.addCell("Justifica\u00e7\u00e3o", bean.comments);
            }
        };
    }

    private List<AccountingTransactionBean> writeTransactionInformation(Event event) {
        ArrayList<AccountingTransactionBean> result = new ArrayList<AccountingTransactionBean>();
        for (AccountingTransaction transaction : event.getNonAdjustingTransactions()) {
            for (AccountingTransaction adjustment : transaction.getAdjustmentTransactionsSet()) {
                Entry internalEntry = this.obtainInternalAccountEntry(adjustment);
                Entry externalEntry = this.obtainExternalAccountEntry(adjustment);
                AccountingTransactionBean bean = new AccountingTransactionBean();
                bean.eventExternalId = EventReportQueueJob.valueOrNull(event.getExternalId());
                bean.whenRegistered = EventReportQueueJob.valueOrNull(transaction.getWhenRegistered());
                bean.whenProcessed = EventReportQueueJob.valueOrNull(transaction.getWhenProcessed());
                bean.debtPartyName = internalEntry != null ? EventReportQueueJob.valueOrNull(internalEntry.getAccount().getParty().getPartyName().getContent()) : "-";
                bean.debtSocialSecurityNumber = internalEntry != null ? EventReportQueueJob.valueOrNull(internalEntry.getAccount().getParty().getSocialSecurityNumber()) : "-";
                bean.credPartyName = externalEntry != null ? EventReportQueueJob.valueOrNull(externalEntry.getAccount().getParty().getPartyName().getContent()) : "-";
                bean.credSocialSecurityNumber = externalEntry != null ? EventReportQueueJob.valueOrNull(externalEntry.getAccount().getParty().getSocialSecurityNumber()) : "-";
                bean.originalAmount = EventReportQueueJob.valueOrNull(transaction.getOriginalAmount().toPlainString());
                bean.amountWithAdjustment = EventReportQueueJob.valueOrNull(transaction.getAmountWithAdjustment().toPlainString());
                bean.paymentMode = EventReportQueueJob.valueOrNull(transaction.getPaymentMode().getLocalizedName());
                bean.whenAdjustmentRegistered = EventReportQueueJob.valueOrNull(adjustment.getWhenRegistered());
                bean.whenAdjustmentProcessed = EventReportQueueJob.valueOrNull(adjustment.getWhenProcessed());
                bean.amountWithAdjustment = EventReportQueueJob.valueOrNull(adjustment.getAmountWithAdjustment().toPlainString());
                bean.comments = EventReportQueueJob.valueOrNull(adjustment.getComments());
                result.add(bean);
            }
            if (!transaction.getAdjustmentTransactionsSet().isEmpty()) continue;
            Entry internalEntry = this.obtainInternalAccountEntry(transaction);
            Entry externalEntry = this.obtainExternalAccountEntry(transaction);
            AccountingTransactionBean bean = new AccountingTransactionBean();
            bean.eventExternalId = event.getExternalId();
            bean.whenRegistered = EventReportQueueJob.valueOrNull(transaction.getWhenRegistered());
            bean.whenProcessed = EventReportQueueJob.valueOrNull(transaction.getWhenProcessed());
            bean.debtPartyName = internalEntry != null ? EventReportQueueJob.valueOrNull(internalEntry.getAccount().getParty().getPartyName().getContent()) : "-";
            bean.debtSocialSecurityNumber = internalEntry != null ? EventReportQueueJob.valueOrNull(internalEntry.getAccount().getParty().getSocialSecurityNumber()) : "-";
            bean.credPartyName = externalEntry != null ? EventReportQueueJob.valueOrNull(externalEntry.getAccount().getParty().getPartyName().getContent()) : "-";
            bean.credSocialSecurityNumber = externalEntry != null ? EventReportQueueJob.valueOrNull(externalEntry.getAccount().getParty().getSocialSecurityNumber()) : "-";
            bean.originalAmount = EventReportQueueJob.valueOrNull(transaction.getOriginalAmount().toPlainString());
            bean.amountWithAdjustment = EventReportQueueJob.valueOrNull(transaction.getAmountWithAdjustment().toPlainString());
            bean.paymentMode = EventReportQueueJob.valueOrNull(transaction.getPaymentMode().getLocalizedName());
            bean.whenAdjustmentRegistered = "-";
            bean.amountWithAdjustment = "-";
            bean.whenAdjustmentProcessed = "-";
            bean.comments = "-";
            result.add(bean);
        }
        return result;
    }

    private Entry obtainInternalAccountEntry(AccountingTransaction transaction) {
        return transaction.getFromAccountEntry();
    }

    private Entry obtainExternalAccountEntry(AccountingTransaction transaction) {
        return transaction.getToAccountEntry();
    }

    private Wrapper buildWrapper(Event event) {
        if (event.isGratuity()) {
            return this.getExportGratuityEvents() != false ? new GratuityEventWrapper((GratuityEvent)((Object)event)) : null;
        }
        if (event.isAcademicServiceRequestEvent()) {
            return this.getExportAcademicServiceRequestEvents() != false ? new AcademicServiceRequestEventWrapper((AcademicServiceRequestEvent)((Object)event)) : null;
        }
        if (event instanceof AdministrativeOfficeFeeAndInsuranceEvent) {
            return this.getExportAdministrativeOfficeFeeAndInsuranceEvents() != false ? new AdminFeeAndInsuranceEventWrapper((AdministrativeOfficeFeeAndInsuranceEvent)((Object)event)) : null;
        }
        if (event.isIndividualCandidacyEvent()) {
            return this.getExportIndividualCandidacyEvents() != false ? new IndividualCandidacyEventWrapper((IndividualCandidacyEvent)((Object)event)) : null;
        }
        if (event.isPhdEvent()) {
            return this.getExportPhdEvents() != false ? new PhdEventWrapper((PhdEvent)((Object)event)) : null;
        }
        if (event.isResidenceEvent()) {
            return this.getExportResidenceEvents() != false ? new ResidenceEventWrapper((ResidenceEvent)((Object)event)) : null;
        }
        if (event.isFctScholarshipPhdGratuityContribuitionEvent()) {
            return this.getExportPhdEvents() != false ? new ExternalScholarshipPhdGratuityContribuitionEventWrapper(event) : null;
        }
        if (this.getExportOthers().booleanValue()) {
            return new EventWrapper(event);
        }
        return null;
    }

    public static List<EventReportQueueJob> retrieveAllGeneratedReports() {
        ArrayList<EventReportQueueJob> reports = new ArrayList<EventReportQueueJob>();
        CollectionUtils.select((Collection)Bennu.getInstance().getQueueJobSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return arg0 instanceof EventReportQueueJob;
            }
        }, reports);
        return reports;
    }

    public static List<EventReportQueueJob> retrieveDoneGeneratedReports() {
        ArrayList<EventReportQueueJob> reports = new ArrayList<EventReportQueueJob>();
        CollectionUtils.select((Collection)Bennu.getInstance().getQueueJobSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                if (!(arg0 instanceof EventReportQueueJob)) {
                    return false;
                }
                EventReportQueueJob eventReportQueueJob = (EventReportQueueJob)((Object)arg0);
                return eventReportQueueJob.getDone();
            }
        }, reports);
        return reports;
    }

    public static List<EventReportQueueJob> retrievePendingOrCancelledGeneratedReports() {
        List<EventReportQueueJob> all = EventReportQueueJob.retrieveAllGeneratedReports();
        List<EventReportQueueJob> done = EventReportQueueJob.retrieveDoneGeneratedReports();
        all.removeAll(done);
        return all;
    }

    public static EventReportQueueJob createRequest(EventReportQueueJobBean eventReportQueueJobBean) {
        return (EventReportQueueJob)((Object)advice$createRequest.perform((Callable)new EventReportQueueJob$callable$createRequest(eventReportQueueJobBean)));
    }

    static /* synthetic */ EventReportQueueJob advised$createRequest(EventReportQueueJobBean bean) {
        return new EventReportQueueJob(bean);
    }

    public static List<EventReportQueueJob> readPendingOrCancelledJobs(Set<AdministrativeOffice> offices) {
        List<EventReportQueueJob> list = EventReportQueueJob.retrievePendingOrCancelledGeneratedReports();
        return EventReportQueueJob.filterByAdministrativeOfficeType(list, offices);
    }

    public static List<EventReportQueueJob> readDoneReports(Set<AdministrativeOffice> offices) {
        List<EventReportQueueJob> list = EventReportQueueJob.retrieveDoneGeneratedReports();
        return EventReportQueueJob.filterByAdministrativeOfficeType(list, offices);
    }

    private static List<EventReportQueueJob> filterByAdministrativeOfficeType(List<EventReportQueueJob> list, Set<AdministrativeOffice> offices) {
        if (offices == null) {
            return list;
        }
        ArrayList<EventReportQueueJob> result = new ArrayList<EventReportQueueJob>();
        for (EventReportQueueJob eventReportQueueJob : list) {
            if (!offices.contains((Object)eventReportQueueJob.getForAdministrativeOffice())) continue;
            result.add(eventReportQueueJob);
        }
        return result;
    }

    private static String valueOrNull(Object obj) {
        if (obj == null) {
            return "-";
        }
        if (obj instanceof DateTime) {
            return ((DateTime)obj).toString("dd-MM-yyyy HH:mm");
        }
        if (obj instanceof LocalDate) {
            return ((LocalDate)obj).toString("dd-MM-yyyy");
        }
        return obj.toString();
    }

    public boolean isDebtsReportPresent() {
        return this.getDebts() != null;
    }

    public boolean isTransactionsReportPresent() {
        return this.getTransactions() != null;
    }

    public boolean isExemptionsReportPresent() {
        return this.getExemptions() != null;
    }

    public boolean isBrokenInThree() {
        return this.getDebts() != null;
    }

    public boolean isErrorReportPresent() {
        return this.getErrorsFile() != null;
    }

    static {
        advice$createRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(EventReportQueueJob.class);
        BLOCK = 5000;
    }

    private static class AccountingTransactionBean {
        public String eventExternalId;
        public String whenRegistered;
        public String whenProcessed;
        public String debtPartyName;
        public String debtSocialSecurityNumber;
        public String credPartyName;
        public String credSocialSecurityNumber;
        public String originalAmount;
        public String amountWithAdjustment;
        public String paymentMode;
        public String whenAdjustmentRegistered;
        public String whenAdjustmentProcessed;
        public String adjustmentAmount;
        public String comments;

        private AccountingTransactionBean() {
        }
    }

    private static class ExemptionBean {
        public String eventExternalId;
        public String exemptionTypeDescription;
        public String exemptionValue;
        public String percentage;
        public String justification;

        private ExemptionBean() {
        }
    }

    private static class EventBean {
        public String externalId;
        public String studentNumber;
        public String studentName;
        public String email;
        public String registrationStartDate;
        public String executionYear;
        public String studiesType;
        public String degreeName;
        public String degreeType;
        public String phdProgramName;
        public String enrolledECTS;
        public String regime;
        public String enrolmentModel;
        public String residenceYear;
        public String residenceMonth;
        public String description;
        public String whenOccured;
        public String totalAmount;
        public String payedAmount;
        public String amountToPay;
        public String reimbursableAmount;
        public String totalDiscount;
        public String relatedEvent;
        public String debtorFiscalId;
        public String debtorName;
        public List<InstallmentWrapper> installments;

        private EventBean() {
        }
    }
}

