/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.gratuity;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.DFAGratuityByAmountPerEctsPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class DFAGratuityByAmountPerEctsPR
extends DFAGratuityByAmountPerEctsPR_Base {
    protected DFAGratuityByAmountPerEctsPR() {
    }

    public DFAGratuityByAmountPerEctsPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money dfaTotalAmount, BigDecimal partialAcceptedPercentage, Money dfaAmountPerEctsCredit) {
        this.init(EntryType.GRATUITY_FEE, EventType.GRATUITY, startDate, endDate, serviceAgreementTemplate, dfaTotalAmount, partialAcceptedPercentage, dfaAmountPerEctsCredit);
    }

    protected void init(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money dfaTotalAmount, BigDecimal dfaPartialAcceptedPercentage, Money dfaAmountPerEctsCredit) {
        super.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate, dfaTotalAmount, dfaPartialAcceptedPercentage);
        this.checkParameters(dfaAmountPerEctsCredit);
        super.setDfaAmountPerEctsCredit(dfaAmountPerEctsCredit);
    }

    private void checkParameters(Money dfaAmountPerEctsCredit) {
        if (dfaAmountPerEctsCredit == null) {
            throw new DomainException("error.accounting.postingRules.gratuity.DFAGratuityByAmountPerEctsPR.dfaAmountPerEctsCredit.cannot.be.null", new String[0]);
        }
    }

    public void setDfaAmountPerEctsCredit(Money dfaAmountPerEctsCredit) {
        throw new DomainException("error.accounting.postingRules.gratuity.DFAGratuityByAmountPerEctsPR.cannot.modify.dfaAmountPerEctsCredit", new String[0]);
    }

    protected Money calculateDFAGratuityTotalAmountToPay(Event event) {
        double enrolmentsEctsForRegistration = ((GratuityEvent)((Object)event)).getEnrolmentsEctsForRegistration();
        Money result = this.getDfaAmountPerEctsCredit().multiply(new BigDecimal(enrolmentsEctsForRegistration));
        return result;
    }

    public DFAGratuityByAmountPerEctsPR edit(Money dfaTotalAmount, Money dfaAmountPerEctsCredit, BigDecimal partialAcceptedPercentage) {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        return this.edit(new DateTime(), dfaTotalAmount, dfaAmountPerEctsCredit, partialAcceptedPercentage);
    }

    public DFAGratuityByAmountPerEctsPR edit(DateTime startDate, Money dfaTotalAmount, Money dfaAmountPerEctsCredit, BigDecimal partialAcceptedPercentage) {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        this.deactivate(startDate);
        return new DFAGratuityByAmountPerEctsPR(startDate, null, this.getServiceAgreementTemplate(), dfaTotalAmount, partialAcceptedPercentage, dfaAmountPerEctsCredit);
    }
}

