/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.paymentCodes;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PersonAccount;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.paymentCodes.MasterDegreeInsurancePaymentCode_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.transactions.InsuranceTransaction;
import org.fenixedu.academic.domain.transactions.PaymentType;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public class MasterDegreeInsurancePaymentCode
extends MasterDegreeInsurancePaymentCode_Base {
    protected MasterDegreeInsurancePaymentCode() {
    }

    private MasterDegreeInsurancePaymentCode(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Money minAmount, Money maxAmount, Student student, ExecutionYear executionYear) {
        this();
        this.init(paymentCodeType, startDate, endDate, minAmount, maxAmount, student, executionYear);
    }

    private void init(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Money minAmount, Money maxAmount, Student student, ExecutionYear executionYear) {
        super.init(paymentCodeType, startDate, endDate, minAmount, maxAmount, student.getPerson());
        this.checkParameters(executionYear, student);
        super.setExecutionYear(executionYear);
    }

    private void checkParameters(ExecutionYear executionYear, Student student) {
        if (executionYear == null) {
            throw new DomainException("error.accounting.paymentCodes.MasterDegreeInsurancePaymentCode.executionYear.cannot.be.null", new String[0]);
        }
        if (student == null) {
            throw new DomainException("error.accounting.paymentCodes.MasterDegreeInsurancePaymentCode.student.cannot.be.null", new String[0]);
        }
    }

    public static MasterDegreeInsurancePaymentCode create(YearMonthDay startDate, YearMonthDay endDate, Money minAmount, Money maxAmount, Student student, ExecutionYear executionYear) {
        if (PaymentCode.canGenerateNewCode(MasterDegreeInsurancePaymentCode.class, PaymentCodeType.PRE_BOLONHA_MASTER_DEGREE_INSURANCE, student.getPerson())) {
            return new MasterDegreeInsurancePaymentCode(PaymentCodeType.PRE_BOLONHA_MASTER_DEGREE_INSURANCE, startDate, endDate, minAmount, maxAmount, student, executionYear);
        }
        throw new DomainException("error.accounting.paymentCodes.MasterDegreeInsurancePaymentCode.could.not.generate.new.code", new String[0]);
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        throw new DomainException("error.accounting.paymentCodes.MasterDegreeInsurancePaymentCode.cannot.modify.executionYear", new String[0]);
    }

    protected void internalProcess(Person responsiblePerson, Money amount, DateTime whenRegistered, String sibsTransactionId, String comments) {
        new InsuranceTransaction(amount.getAmount(), whenRegistered, PaymentType.SIBS, responsiblePerson, this.getPersonAccount(), this.getExecutionYear(), this.getRegistration());
    }

    private PersonAccount getPersonAccount() {
        return this.getPerson().getAssociatedPersonAccount();
    }

    private Registration getRegistration() {
        return MasterDegreeInsurancePaymentCode.getActiveRegistrationByDegreeType(this.getPerson().getStudent());
    }

    private static Registration getActiveRegistrationByDegreeType(Student student) {
        for (Registration registration : student.getRegistrationsSet()) {
            if (!registration.getDegreeType().isPreBolonhaMasterDegree() || !registration.isActive()) continue;
            return registration;
        }
        return null;
    }

    public void delete() {
        super.setExecutionYear(null);
        super.delete();
    }

    public void setPerson(Person student) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.PaymentCode.cannot.modify.person", new String[0]);
    }
}

