/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.serviceRequests;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.StudentReingressionRequestEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.StudentReingressionRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.util.LabelFormatter;

public class StudentReingressionRequestEvent
extends StudentReingressionRequestEvent_Base {
    protected StudentReingressionRequestEvent() {
    }

    public StudentReingressionRequestEvent(AdministrativeOffice administrativeOffice, Person person, StudentReingressionRequest academicServiceRequest) {
        this();
        super.init(administrativeOffice, EventType.STUDENT_REINGRESSION_REQUEST, person, (RegistrationAcademicServiceRequest)((Object)academicServiceRequest));
    }

    public StudentReingressionRequest getAcademicServiceRequest() {
        return (StudentReingressionRequest)((Object)super.getAcademicServiceRequest());
    }

    private Registration getRegistration() {
        return this.getAcademicServiceRequest().getRegistration();
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources");
        labelFormatter.appendLabel(" (");
        labelFormatter.appendLabel("label.in", "resources.ApplicationResources");
        labelFormatter.appendLabel(" ");
        labelFormatter.appendLabel(this.getRegistration().getLastDegreeCurricularPlan().getName());
        labelFormatter.appendLabel(")");
        if (this.getAcademicServiceRequest().getExecutionYear() != null) {
            labelFormatter.appendLabel(" - " + this.getExecutionYear().getYear());
        }
        return labelFormatter;
    }
}

