/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.dfa;

import org.fenixedu.academic.domain.CandidacyPeriodInDegreeCurricularPlan;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountType;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.events.dfa.DFACandidacyEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.DFACandidacy;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.util.workflow.StateMachine;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.util.LabelFormatter;
import org.joda.time.DateTime;

public class DFACandidacyEvent
extends DFACandidacyEvent_Base {
    private DFACandidacyEvent() {
    }

    public DFACandidacyEvent(AdministrativeOffice administrativeOffice, Person person, DFACandidacy candidacy) {
        this();
        this.init(administrativeOffice, person, candidacy);
    }

    private void init(AdministrativeOffice administrativeOffice, Person person, DFACandidacy candidacy) {
        this.init(administrativeOffice, EventType.CANDIDACY_ENROLMENT, person);
        this.checkParameters((Candidacy)((Object)candidacy));
        super.setCandidacy(candidacy);
    }

    private void checkParameters(Candidacy candidacy) {
        if (candidacy == null) {
            throw new DomainException("error.candidacy.dfaCandidacyEvent.invalid.candidacy", new String[0]);
        }
    }

    public Account getToAccount() {
        return this.getUnit().getAccountBy(AccountType.INTERNAL);
    }

    protected Account getFromAccount() {
        return this.getPerson().getAccountBy(AccountType.EXTERNAL);
    }

    private Unit getUnit() {
        return this.getCandidacy().getExecutionDegree().getDegreeCurricularPlan().getDegree().getUnit();
    }

    public void setCandidacy(DFACandidacy candidacy) {
        throw new DomainException("error.candidacy.dfaCandidacyEvent.cannot.modify.candidacy", new String[0]);
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources").appendLabel(" (").appendLabel(this.getDegree().getDegreeType().getName().getContent()).appendLabel(" - ").appendLabel(this.getDegree().getNameFor(this.getExecutionYear()).getContent()).appendLabel(" - ").appendLabel(this.getExecutionYear().getYear()).appendLabel(")");
        return labelFormatter;
    }

    private ExecutionDegree getExecutionDegree() {
        return this.getCandidacy().getExecutionDegree();
    }

    private Degree getDegree() {
        return this.getExecutionDegree().getDegreeCurricularPlan().getDegree();
    }

    public void closeEvent() {
        StateMachine.execute(this.getCandidacy().getActiveCandidacySituation());
        super.closeEvent();
    }

    public PostingRule getPostingRule() {
        return this.getExecutionDegree().getDegreeCurricularPlan().getServiceAgreementTemplate().findPostingRuleByEventTypeAndDate(this.getEventType(), this.getWhenOccured());
    }

    public CandidacyPeriodInDegreeCurricularPlan getCandidacyPeriodInDegreeCurricularPlan() {
        return this.getExecutionDegree().getDegreeCurricularPlan().getCandidacyPeriod(this.getExecutionYear());
    }

    public boolean hasCandidacyPeriodInDegreeCurricularPlan() {
        return this.getExecutionDegree().getDegreeCurricularPlan().hasCandidacyPeriodFor(this.getExecutionYear());
    }

    private ExecutionYear getExecutionYear() {
        return this.getExecutionDegree().getExecutionYear();
    }

    public DateTime getCandidacyDate() {
        return this.getCandidacy().getCandidacyDate();
    }

    public LabelFormatter getDescription() {
        LabelFormatter labelFormatter = super.getDescription();
        labelFormatter.appendLabel(" ");
        labelFormatter.appendLabel(this.getDegree().getDegreeType().getName().getContent()).appendLabel(" - ");
        labelFormatter.appendLabel(this.getDegree().getNameFor(this.getExecutionYear()).getContent()).appendLabel(" - ");
        labelFormatter.appendLabel(this.getExecutionYear().getYear());
        return labelFormatter;
    }

    protected void disconnect() {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        super.setCandidacy(null);
        super.disconnect();
    }

    public boolean isExemptionAppliable() {
        return true;
    }
}

