/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Branch;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularCourseEquivalence;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.GratuitySituation;
import org.fenixedu.academic.domain.GratuityValues;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.OptionalEnrolment;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan$callable$editEndStageDate;
import org.fenixedu.academic.domain.StudentCurricularPlan$callable$enrol;
import org.fenixedu.academic.domain.StudentCurricularPlan$callable$removeCurriculumModulesFromNoCourseGroupCurriculumGroup;
import org.fenixedu.academic.domain.StudentCurricularPlan$callable$setEvaluationsForCurriculumValidation;
import org.fenixedu.academic.domain.StudentCurricularPlanEquivalencePlan;
import org.fenixedu.academic.domain.StudentCurricularPlan_Base;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.accounting.events.EnrolmentOutOfPeriodEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.candidacy.CandidacySituationType;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.MaximumNumberOfCreditsForEnrolmentPeriod;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.curriculum.EnrollmentCondition;
import org.fenixedu.academic.domain.curriculum.EnrollmentState;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degree.enrollment.CurricularCourse2Enroll;
import org.fenixedu.academic.domain.degree.enrollment.NotNeedToEnrollInCurricularCourse;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.OptionalCurricularCourse;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.gratuity.GratuitySituationType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.studentCurricularPlan.Specialization;
import org.fenixedu.academic.domain.studentCurricularPlan.StudentCurricularPlanState;
import org.fenixedu.academic.domain.studentCurriculum.BranchCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Credits;
import org.fenixedu.academic.domain.studentCurriculum.CreditsManager;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroupFactory;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.Equivalence;
import org.fenixedu.academic.domain.studentCurriculum.ExternalCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.ExtraCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.InternalSubstitution;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroupType;
import org.fenixedu.academic.domain.studentCurriculum.PropaedeuticsCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.RootCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.StandaloneCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolment;
import org.fenixedu.academic.domain.studentCurriculum.Substitution;
import org.fenixedu.academic.domain.studentCurriculum.curriculumLine.CurriculumLineLocationBean;
import org.fenixedu.academic.domain.studentCurriculum.curriculumLine.MoveCurriculumLinesBean;
import org.fenixedu.academic.dto.administrativeOffice.dismissal.DismissalBean;
import org.fenixedu.academic.dto.administrativeOffice.studentEnrolment.NoCourseGroupEnrolmentBean;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetEnrolmentEvaluationBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.StudentCurricularPlanPredicates;
import org.fenixedu.academic.service.services.exceptions.BothAreasAreTheSameServiceException;
import org.fenixedu.academic.service.services.exceptions.InvalidArgumentsServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedBranchChangeException;
import org.fenixedu.academic.util.EnrolmentEvaluationState;
import org.fenixedu.academic.util.predicates.AndPredicate;
import org.fenixedu.academic.util.predicates.ResultCollection;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class StudentCurricularPlan
extends StudentCurricularPlan_Base {
    public static final Comparator<StudentCurricularPlan> COMPARATOR_BY_STUDENT_NUMBER;
    public static final Comparator<StudentCurricularPlan> STUDENT_CURRICULAR_PLAN_COMPARATOR_BY_DEGREE_TYPE_AND_DEGREE_NAME;
    public static final Comparator<StudentCurricularPlan> STUDENT_CURRICULAR_PLAN_COMPARATOR_BY_DEGREE_DEGREE_NAME_AND_STUDENT_NUMBER_AND_NAME;
    public static final Comparator<StudentCurricularPlan> COMPARATOR_BY_DEGREE_TYPE;
    public static final Comparator<StudentCurricularPlan> STUDENT_CURRICULAR_PLAN_COMPARATOR_BY_START_DATE;
    public static final Comparator<StudentCurricularPlan> DATE_COMPARATOR;
    public static final Comparator<StudentCurricularPlan> COMPARATOR_BY_STUDENT_IST_ID;
    public static final Advice advice$enrol;
    public static final Advice advice$removeCurriculumModulesFromNoCourseGroupCurriculumGroup;
    public static final Advice advice$setEvaluationsForCurriculumValidation;
    public static final Advice advice$editEndStageDate;

    private StudentCurricularPlan() {
        this.setCurrentState(StudentCurricularPlanState.ACTIVE);
        this.setRootDomainObject(Bennu.getInstance());
        this.setWhenDateTime(new DateTime());
        this.setGivenCredits(0.0);
    }

    public static StudentCurricularPlan createPreBolonhaMasterDegree(Registration registration, DegreeCurricularPlan degreeCurricularPlan, YearMonthDay startDate, Branch branch, Double givenCredits, Specialization specialization) {
        return new StudentCurricularPlan(registration, degreeCurricularPlan, startDate, branch, givenCredits, specialization);
    }

    private StudentCurricularPlan(Registration registration, DegreeCurricularPlan degreeCurricularPlan, YearMonthDay startDate, Branch branch, Double givenCredits, Specialization specialization) {
        this(registration, degreeCurricularPlan, startDate);
        this.setBranch(branch);
        this.setGivenCredits(givenCredits);
        this.setSpecialization(specialization);
    }

    private StudentCurricularPlan(Registration registration, DegreeCurricularPlan degreeCurricularPlan, YearMonthDay startDate) {
        this();
        this.init(registration, degreeCurricularPlan, startDate);
    }

    public static StudentCurricularPlan createWithEmptyStructure(Registration registration, DegreeCurricularPlan degreeCurricularPlan, YearMonthDay startDate) {
        StudentCurricularPlan result = new StudentCurricularPlan(registration, degreeCurricularPlan, startDate);
        CurriculumGroupFactory.createRoot(result, degreeCurricularPlan.getRoot(), null);
        return result;
    }

    public static StudentCurricularPlan createWithEmptyStructure(Registration registration, DegreeCurricularPlan degreeCurricularPlan, CycleType cycleType, YearMonthDay startDate) {
        StudentCurricularPlan result = new StudentCurricularPlan(registration, degreeCurricularPlan, startDate);
        CurriculumGroupFactory.createRoot(result, degreeCurricularPlan.getRoot(), cycleType);
        return result;
    }

    public static StudentCurricularPlan createBolonhaStudentCurricularPlan(Registration registration, DegreeCurricularPlan degreeCurricularPlan, YearMonthDay startDate, ExecutionSemester executionSemester) {
        return StudentCurricularPlan.createBolonhaStudentCurricularPlan(registration, degreeCurricularPlan, startDate, executionSemester, null);
    }

    public static StudentCurricularPlan createBolonhaStudentCurricularPlan(Registration registration, DegreeCurricularPlan degreeCurricularPlan, YearMonthDay startDate, ExecutionSemester executionSemester, CycleType cycleType) {
        return new StudentCurricularPlan(registration, degreeCurricularPlan, startDate, executionSemester, cycleType);
    }

    private StudentCurricularPlan(Registration registration, DegreeCurricularPlan degreeCurricularPlan, YearMonthDay startDate, ExecutionSemester executionSemester, CycleType cycleType) {
        this(registration, degreeCurricularPlan, startDate);
        this.createStructure(executionSemester, cycleType);
    }

    private void createStructure(ExecutionSemester executionSemester, CycleType cycleType) {
        CurriculumGroupFactory.createRoot(this, this.getDegreeCurricularPlan().getRoot(), executionSemester, cycleType);
    }

    private void init(Registration registration, DegreeCurricularPlan degreeCurricularPlan, YearMonthDay startDate) {
        this.checkParameters(registration, degreeCurricularPlan, startDate);
        this.setDegreeCurricularPlan(degreeCurricularPlan);
        this.setRegistration(registration);
        this.setStartDateYearMonthDay(startDate);
    }

    private void checkParameters(Registration registration, DegreeCurricularPlan degreeCurricularPlan, YearMonthDay startDate) {
        if (registration == null) {
            throw new DomainException("error.studentCurricularPlan.registration.cannot.be.null", new String[0]);
        }
        if (degreeCurricularPlan == null) {
            throw new DomainException("error.studentCurricularPlan.degreeCurricularPlan.cannot.be.null", new String[0]);
        }
        if (startDate == null) {
            throw new DomainException("error.studentCurricularPlan.startDate.cannot.be.null", new String[0]);
        }
    }

    public void delete() throws DomainException {
        this.checkRulesToDelete();
        while (!this.getEnrolmentsSet().isEmpty()) {
            this.getEnrolmentsSet().iterator().next().delete();
        }
        this.getRoot().delete();
        Iterator iter = this.getNotNeedToEnrollCurricularCoursesSet().iterator();
        while (iter.hasNext()) {
            NotNeedToEnrollInCurricularCourse notNeedToEnrollInCurricularCourse = (NotNeedToEnrollInCurricularCourse)((Object)iter.next());
            iter.remove();
            notNeedToEnrollInCurricularCourse.setStudentCurricularPlan(null);
            notNeedToEnrollInCurricularCourse.delete();
        }
        while (!this.getCreditsSet().isEmpty()) {
            ((Credits)((Object)this.getCreditsSet().iterator().next())).delete();
        }
        this.setDegreeCurricularPlan(null);
        this.setBranch(null);
        this.setStudent(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    private void checkRulesToDelete() {
        if (!this.getGratuityEventsSet().isEmpty()) {
            throw new DomainException("error.StudentCurricularPlan.cannot.delete.because.already.has.gratuity.events", new String[0]);
        }
        if (!this.getGratuitySituationsSet().isEmpty()) {
            throw new DomainException("error.StudentCurricularPlan.cannot.delete.because.already.has.gratuity.situations", new String[0]);
        }
    }

    public final String print() {
        StringBuilder result = new StringBuilder();
        result.append("[SCP ").append(this.getExternalId()).append("] ").append(this.getName()).append("\n");
        result.append((CharSequence)this.getRoot().print(""));
        return result.toString();
    }

    public final boolean isFirstCycle() {
        return this.getDegreeType().isFirstCycle();
    }

    public final boolean isSecondCycle() {
        return this.getDegreeType().isSecondCycle();
    }

    public final boolean hasConcludedCycle(CycleType cycleType) {
        return this.getRoot().hasConcludedCycle(cycleType);
    }

    public final boolean hasConcludedCycle(CycleType cycleType, ExecutionYear executionYear) {
        return this.getRoot().hasConcludedCycle(cycleType, executionYear);
    }

    public boolean hasConcludedAnyInternalCycle() {
        for (CycleCurriculumGroup cycleCurriculumGroup : this.getInternalCycleCurriculumGrops()) {
            if (!cycleCurriculumGroup.isConcluded()) continue;
            return true;
        }
        return false;
    }

    public final YearMonthDay getConclusionDate(CycleType cycleType) {
        if (this.getDegreeType().getCycleTypes().isEmpty()) {
            throw new DomainException("StudentCurricularPlan.has.no.cycle.type", new String[0]);
        }
        if (!this.getDegreeType().hasCycleTypes(cycleType)) {
            throw new DomainException("StudentCurricularPlan.doesnt.have.such.cycle.type", new String[0]);
        }
        return this.getCycle(cycleType).getConclusionDate();
    }

    public YearMonthDay calculateConclusionDate(CycleType cycleType) {
        if (cycleType == null) {
            return this.getLastApprovementDate();
        }
        if (this.getDegreeType().getCycleTypes().isEmpty()) {
            throw new DomainException("StudentCurricularPlan.has.no.cycle.type", new String[0]);
        }
        if (!this.getDegreeType().hasCycleTypes(cycleType)) {
            throw new DomainException("StudentCurricularPlan.doesnt.have.such.cycle.type", new String[0]);
        }
        return this.getCycle(cycleType).calculateConclusionDate();
    }

    public final boolean isConcluded() {
        if (this.isEmptyDegree()) {
            return this.getRegistration().getLastActiveState().getStateType().equals((Object)RegistrationStateType.CONCLUDED);
        }
        return ProgramConclusion.isConcluded(this);
    }

    public final boolean isConclusionProcessed() {
        if (this.isEmptyDegree()) {
            return this.getRegistration().getLastActiveState().getStateType().equals((Object)RegistrationStateType.CONCLUDED);
        }
        return ProgramConclusion.isConclusionProcessed(this);
    }

    public final Curriculum getCurriculum(DateTime when, ExecutionYear executionYear) {
        return this.getRoot().getCurriculum(when, executionYear);
    }

    public final boolean isActive() {
        return this.isLastStudentCurricularPlanFromRegistration() && this.getRegistration().isActive();
    }

    public final boolean isPast() {
        return this.getDegreeCurricularPlan().isPast();
    }

    public boolean hasIncompleteState() {
        return this.getCurrentState().equals((Object)StudentCurricularPlanState.INCOMPLETE);
    }

    public boolean isTransition() {
        return this.getRegistration().isTransition();
    }

    public final boolean isBolonhaDegree() {
        return this.getDegreeCurricularPlan().isBolonhaDegree();
    }

    public final Person getPerson() {
        return this.getRegistration().getPerson();
    }

    public final Department getDepartment() {
        return this.getDegree().getUnit().getDepartment();
    }

    public final Degree getDegree() {
        return this.getDegreeCurricularPlan().getDegree();
    }

    public final DegreeType getDegreeType() {
        return this.getDegree().getDegreeType();
    }

    public final Integer getDegreeDuration() {
        return this.getDegreeCurricularPlan().getDegreeDuration();
    }

    public final boolean hasClassification() {
        return this.getClassification() != null && this.getClassification() != 0.0;
    }

    @Deprecated
    public final Registration getStudent() {
        return this.getRegistration();
    }

    public void setStartDate(YearMonthDay startDate) {
        super.setStartDateYearMonthDay(startDate);
    }

    @Deprecated
    public void setStudent(Registration registration) {
        this.setRegistration(registration);
    }

    public Registration getRegistration() {
        return super.getStudent();
    }

    public void setRegistration(Registration registration) {
        if (registration != null) {
            if (registration.getDegree() != null) {
                if (!registration.getDegree().getDegreeCurricularPlansSet().contains((Object)this.getDegreeCurricularPlan())) {
                    throw new DomainException("error.StudentCurricularPlan.setting.registration.with.different.degree", new String[0]);
                }
            } else {
                registration.setDegree(this.getDegree());
            }
        }
        super.setStudent(registration);
    }

    public boolean hasRegistration() {
        return super.getStudent() != null;
    }

    public Set<CurriculumLine> getAllCurriculumLines() {
        return this.getRoot().getAllCurriculumLines();
    }

    public Set<CurriculumGroup> getAllCurriculumGroups() {
        return this.getRoot().getAllCurriculumGroups();
    }

    public Set<CurriculumGroup> getAllCurriculumGroupsWithoutNoCourseGroupCurriculumGroups() {
        return this.getRoot().getAllCurriculumGroupsWithoutNoCourseGroupCurriculumGroups();
    }

    public final Set<Enrolment> getEnrolmentsSet() {
        return this.getRoot().getEnrolmentsSet();
    }

    public final boolean hasAnyEnrolments() {
        return this.getRoot().hasAnyEnrolments();
    }

    public final boolean hasAnyCurriculumLines() {
        return this.hasAnyCurriculumModules(new CurriculumModule.CurriculumModulePredicateByType(CurriculumLine.class));
    }

    public final boolean hasAnyCurriculumLines(ExecutionYear executionYear) {
        AndPredicate<CurriculumModule> andPredicate = new AndPredicate<CurriculumModule>();
        andPredicate.add((Predicate)new CurriculumModule.CurriculumModulePredicateByType(CurriculumLine.class));
        andPredicate.add((Predicate)new CurriculumModule.CurriculumModulePredicateByExecutionYear(executionYear));
        return this.hasAnyCurriculumModules(andPredicate);
    }

    public final boolean hasAnyCurriculumLines(ExecutionSemester executionSemester) {
        AndPredicate<CurriculumModule> andPredicate = new AndPredicate<CurriculumModule>();
        andPredicate.add((Predicate)new CurriculumModule.CurriculumModulePredicateByType(CurriculumLine.class));
        andPredicate.add((Predicate)new CurriculumModule.CurriculumModulePredicateByExecutionSemester(executionSemester));
        return this.hasAnyCurriculumModules(andPredicate);
    }

    public final boolean hasEnrolments(Enrolment enrolment) {
        return this.getRoot().hasCurriculumModule((CurriculumModule)((Object)enrolment));
    }

    public final boolean hasEnrolments(ExecutionYear executionYear) {
        return this.getRoot().hasEnrolment(executionYear);
    }

    public final boolean hasEnrolments(ExecutionSemester executionSemester) {
        return this.getRoot().hasEnrolment(executionSemester);
    }

    public final long countCurrentEnrolments() {
        return this.getEnrolmentsSet().stream().filter(enrolment -> enrolment.getExecutionPeriod().getExecutionYear().isCurrent() && enrolment.isEnroled()).count();
    }

    public final long getCountCurrentEnrolments() {
        return this.countCurrentEnrolments();
    }

    public final List<Enrolment> getEnrolments(CurricularCourse curricularCourse) {
        ArrayList<Enrolment> results = new ArrayList<Enrolment>();
        for (Enrolment enrollment : this.getEnrolmentsSet()) {
            if (enrollment.getCurricularCourse() != curricularCourse) continue;
            results.add(enrollment);
        }
        return results;
    }

    public final int countEnrolmentsByCurricularCourse(CurricularCourse curricularCourse) {
        int count = 0;
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (enrolment.getCurricularCourse() != curricularCourse) continue;
            ++count;
        }
        return count;
    }

    public final int countEnrolmentsByCurricularCourse(CurricularCourse curricularCourse, ExecutionSemester untilExecutionPeriod) {
        int count = 0;
        for (Enrolment enrolment : this.getEnrolments(curricularCourse)) {
            if (!enrolment.getExecutionPeriod().isBeforeOrEquals(untilExecutionPeriod)) continue;
            ++count;
        }
        return count;
    }

    public final List<Enrolment> getEnrolmentsByState(EnrollmentState state) {
        ArrayList<Enrolment> results = new ArrayList<Enrolment>();
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (!enrolment.getEnrollmentState().equals((Object)state)) continue;
            results.add(enrolment);
        }
        return results;
    }

    public final List<Enrolment> getEnrolmentsByExecutionPeriod(ExecutionSemester executionSemester) {
        ArrayList<Enrolment> results = new ArrayList<Enrolment>();
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (enrolment.getExecutionPeriod() != executionSemester) continue;
            results.add(enrolment);
        }
        return results;
    }

    public final Collection<Enrolment> getStudentEnrollmentsWithEnrolledState() {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (!enrolment.isEnroled() || enrolment.isInvisible()) continue;
            result.add(enrolment);
        }
        return result;
    }

    public final int getNumberOfEnrolledCurricularCourses() {
        return this.getStudentEnrollmentsWithEnrolledState().size();
    }

    private Collection<Enrolment> getVisibleEnroledEnrolments(ExecutionSemester executionSemester) {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (enrolment.isAnnulled() || enrolment.isInvisible() || executionSemester != null && !enrolment.isValid(executionSemester)) continue;
            result.add(enrolment);
        }
        return result;
    }

    public final int countEnrolments(ExecutionSemester executionSemester) {
        int numberEnrolments = 0;
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (enrolment.getExecutionPeriod() != executionSemester) continue;
            ++numberEnrolments;
        }
        return numberEnrolments;
    }

    public final boolean hasAnyEnrolmentForExecutionPeriod(ExecutionSemester executionSemester) {
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (enrolment.getExecutionPeriod() != executionSemester) continue;
            return true;
        }
        return false;
    }

    public final List<Enrolment> getEnrolmentsByExecutionYear(ExecutionYear executionYear) {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (enrolment.getExecutionPeriod().getExecutionYear() != executionYear) continue;
            result.add(enrolment);
        }
        return result;
    }

    public final int countEnrolments(ExecutionYear executionYear) {
        int numberEnrolments = 0;
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (enrolment.getExecutionPeriod().getExecutionYear() != executionYear) continue;
            ++numberEnrolments;
        }
        return numberEnrolments;
    }

    public final boolean hasAnyEnrolmentForExecutionYear(ExecutionYear executionYear) {
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (!enrolment.getExecutionPeriod().getExecutionYear().equals(executionYear)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasAnyEnrolmentForCurrentExecutionYear() {
        return this.hasAnyEnrolmentForExecutionYear(ExecutionYear.readCurrentExecutionYear());
    }

    public final Collection<Enrolment> getLatestCurricularCoursesEnrolments(ExecutionYear executionYear) {
        HashMap<CurricularCourse, Enrolment> result = new HashMap<CurricularCourse, Enrolment>();
        for (Enrolment enrolment : this.getEnrolmentsByExecutionYear(executionYear)) {
            if (result.containsKey((Object)enrolment.getCurricularCourse()) && !((Enrolment)result.get((Object)enrolment.getCurricularCourse())).isBefore(enrolment)) continue;
            result.put(enrolment.getCurricularCourse(), enrolment);
        }
        return result.values();
    }

    public void addApprovedEnrolments(Collection<Enrolment> enrolments) {
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (enrolment.isInvisible() || !enrolment.isApproved()) continue;
            enrolments.add(enrolment);
        }
    }

    public Set<Enrolment> getDismissalApprovedEnrolments() {
        HashSet<Enrolment> aprovedEnrolments = new HashSet<Enrolment>();
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (!enrolment.canBeUsedAsCreditsSource()) continue;
            aprovedEnrolments.add(enrolment);
        }
        return aprovedEnrolments;
    }

    public Collection<? extends CurriculumModule> getCurriculumModules(ResultCollection<CurriculumModule> collection) {
        this.getRoot().getCurriculumModules(collection);
        return collection.getResult();
    }

    public boolean hasAnyCurriculumModules(Predicate<CurriculumModule> predicate) {
        return this.getRoot().hasAnyCurriculumModules(predicate);
    }

    public final Collection<CurriculumLine> getApprovedCurriculumLines() {
        HashSet<CurriculumLine> result = new HashSet<CurriculumLine>();
        this.getRoot().addApprovedCurriculumLines(result);
        return result;
    }

    public Collection<CurriculumLine> getApprovedCurriculumLines(ExecutionSemester executionSemester) {
        AndPredicate andPredicate = new AndPredicate();
        andPredicate.add((Predicate)new CurriculumModule.CurriculumModulePredicateByType(CurriculumLine.class));
        andPredicate.add((Predicate)new CurriculumModule.CurriculumModulePredicateByExecutionSemester(executionSemester));
        andPredicate.add((Predicate)new CurriculumModule.CurriculumModulePredicateByApproval());
        return this.getCurriculumModules(new ResultCollection<CurriculumModule>(andPredicate));
    }

    public Collection<CurriculumLine> getApprovedCurriculumLines(ExecutionYear executionYear) {
        AndPredicate andPredicate = new AndPredicate();
        andPredicate.add((Predicate)new CurriculumModule.CurriculumModulePredicateByType(CurriculumLine.class));
        andPredicate.add((Predicate)new CurriculumModule.CurriculumModulePredicateByExecutionYear(executionYear));
        andPredicate.add((Predicate)new CurriculumModule.CurriculumModulePredicateByApproval());
        return this.getCurriculumModules(new ResultCollection<CurriculumModule>(andPredicate));
    }

    public final ExecutionYear getApprovedCurriculumLinesLastExecutionYear() {
        return this.getRoot().getApprovedCurriculumLinesLastExecutionYear();
    }

    public final CurriculumLine getLastApprovement() {
        return this.getAprovedEnrolments().stream().sorted(CurriculumLine.COMPARATOR_BY_APPROVEMENT_DATE_AND_ID.reversed()).findFirst().orElse(null);
    }

    public final YearMonthDay getLastApprovementDate() {
        CurriculumLine lastApprovement = this.getLastApprovement();
        return lastApprovement == null ? null : lastApprovement.getApprovementDate();
    }

    public final ExecutionYear getLastApprovementExecutionYear() {
        return this.hasAnyApprovedCurriculumLines() ? this.getApprovedCurriculumLinesLastExecutionYear() : null;
    }

    public final boolean hasAnyApprovedCurriculumLines() {
        return this.getRoot().hasAnyApprovedCurriculumLines();
    }

    public final List<Enrolment> getAprovedEnrolments() {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        this.addApprovedEnrolments(result);
        return result;
    }

    public boolean hasAnyApprovedEnrolment() {
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (!enrolment.isApproved()) continue;
            return true;
        }
        return false;
    }

    public final List<Enrolment> getAprovedEnrolmentsInExecutionPeriod(ExecutionSemester executionSemester) {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        for (Enrolment enrolment : this.getEnrolmentsByExecutionPeriod(executionSemester)) {
            if (!enrolment.isApproved()) continue;
            result.add(enrolment);
        }
        return result;
    }

    public final Collection<Enrolment> getDissertationEnrolments() {
        HashSet<Enrolment> result = new HashSet<Enrolment>();
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (!enrolment.getCurricularCourse().isDissertation()) continue;
            result.add(enrolment);
        }
        for (Dismissal dismissal : this.getDismissals()) {
            for (IEnrolment enrolment : dismissal.getSourceIEnrolments()) {
                Enrolment realEnrolment;
                if (!enrolment.isEnrolment() || !(realEnrolment = (Enrolment)enrolment).getCurricularCourse().isDissertation()) continue;
                result.add(realEnrolment);
            }
        }
        return result;
    }

    public final Enrolment getLatestDissertationEnrolment() {
        TreeSet<Enrolment> result = new TreeSet<Enrolment>(Enrolment.COMPARATOR_BY_EXECUTION_PERIOD_AND_ID);
        result.addAll(this.getDissertationEnrolments());
        return result.isEmpty() ? null : (Enrolment)result.last();
    }

    public final Enrolment getEnrolment(String executionYear, Integer semester, String code) {
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (!enrolment.getCurricularCourse().getCode().equals(code) || !enrolment.getExecutionPeriod().getSemester().equals(semester) || !enrolment.getExecutionPeriod().getExecutionYear().getYear().equals(executionYear)) continue;
            return enrolment;
        }
        return null;
    }

    public final Enrolment getEnrolment(ExecutionSemester executionSemester, String code) {
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (!enrolment.getCurricularCourse().getCode().equals(code) || enrolment.getExecutionPeriod() != executionSemester) continue;
            return enrolment;
        }
        return null;
    }

    public final Enrolment findEnrolmentByEnrolmentID(String enrolmentID) {
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (!enrolment.getExternalId().equals(enrolmentID)) continue;
            return enrolment;
        }
        return null;
    }

    public final Enrolment findEnrolmentFor(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return this.getRoot().findEnrolmentFor(curricularCourse, executionSemester);
    }

    public final Enrolment getEnrolmentByCurricularCourseAndExecutionPeriod(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (!enrolment.getCurricularCourse().equals((Object)curricularCourse) || !enrolment.isValid(executionSemester)) continue;
            return enrolment;
        }
        return null;
    }

    public final Set<ExecutionSemester> getEnrolmentsExecutionPeriods() {
        HashSet<ExecutionSemester> result = new HashSet<ExecutionSemester>();
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            result.add(enrolment.getExecutionPeriod());
        }
        return result;
    }

    public final Set<ExecutionYear> getEnrolmentsExecutionYears() {
        TreeSet<ExecutionYear> result = new TreeSet<ExecutionYear>(ExecutionYear.REVERSE_COMPARATOR_BY_YEAR);
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            result.add(enrolment.getExecutionPeriod().getExecutionYear());
        }
        return result;
    }

    public final ExecutionYear getStartExecutionYear() {
        return ExecutionYear.getExecutionYearByDate(this.getStartDateYearMonthDay());
    }

    public ExecutionSemester getStartExecutionPeriod() {
        ExecutionSemester result = null;
        YearMonthDay startDate = this.getStartDateYearMonthDay();
        if (startDate != null && (result = ExecutionSemester.readByDateTime(startDate.toDateTimeAtMidnight())) == null) {
            result = ExecutionYear.readByDateTime(startDate.toDateTimeAtMidnight()).getFirstExecutionPeriod();
        }
        return result != null ? result : this.getFirstExecutionPeriod();
    }

    public final ExecutionSemester getFirstExecutionPeriod() {
        ExecutionSemester result = null;
        for (CurriculumLine curriculumLine : this.getAllCurriculumLines()) {
            ExecutionSemester executionSemester = curriculumLine.getExecutionPeriod();
            if (result != null && (executionSemester == null || !result.isAfter(executionSemester))) continue;
            result = executionSemester;
        }
        return result;
    }

    public YearMonthDay getEndDate() {
        StudentCurricularPlan nextStudentCurricularPlan = this.getNextStudentCurricularPlan();
        if (nextStudentCurricularPlan != null) {
            return nextStudentCurricularPlan.getStartDateYearMonthDay().minusDays(1);
        }
        if (this.getRegistration() != null && !this.getRegistration().isActive()) {
            return this.getRegistration().getActiveState().getStateDate().toYearMonthDay();
        }
        return null;
    }

    private StudentCurricularPlan getNextStudentCurricularPlan() {
        if (this.getRegistration() != null) {
            Iterator<StudentCurricularPlan> iter = this.getRegistration().getSortedStudentCurricularPlans().iterator();
            while (iter.hasNext()) {
                if (iter.next() != this) continue;
                return iter.hasNext() ? iter.next() : null;
            }
        }
        return null;
    }

    public boolean isActive(ExecutionYear executionYear) {
        return !this.getStartDateYearMonthDay().isAfter((ReadablePartial)executionYear.getEndDateYearMonthDay()) && (this.getEndDate() == null || !this.getEndDate().isBefore((ReadablePartial)executionYear.getBeginDateYearMonthDay()));
    }

    public final ExecutionYear getLastExecutionYear() {
        ExecutionYear result = null;
        for (CurriculumLine curriculumLine : this.getAllCurriculumLines()) {
            ExecutionSemester executionSemester = curriculumLine.getExecutionPeriod();
            if (result != null && (executionSemester == null || !result.isBefore(executionSemester.getExecutionYear()))) continue;
            result = executionSemester.getExecutionYear();
        }
        return result;
    }

    public boolean hasGivenCredits() {
        return this.getGivenCredits() != null && this.getGivenCredits().doubleValue() != Double.valueOf(0.0).doubleValue();
    }

    public Integer getCreditsInSecundaryArea() {
        return 0;
    }

    public void setCreditsInSecundaryArea(Integer creditsInSecundaryArea) {
    }

    public Integer getCreditsInSpecializationArea() {
        return 0;
    }

    public void setCreditsInSpecializationArea(Integer creditsInSpecializationArea) {
    }

    public Branch getSecundaryBranch() {
        return null;
    }

    public boolean hasSecundaryBranch() {
        return this.getSecundaryBranch() != null;
    }

    public void setSecundaryBranch(Branch secundaryBranch) {
    }

    public final Integer getSecundaryBranchKey() {
        return null;
    }

    public void setSecundaryBranchKey(Integer secundaryBranchKey) {
    }

    public List<Enrolment> getAllEnrollments() {
        ArrayList<Enrolment> allEnrollments = new ArrayList<Enrolment>();
        this.addNonInvisibleEnrolments(allEnrollments, this.getEnrolmentsSet());
        for (StudentCurricularPlan studentCurricularPlan : this.getRegistration().getStudentCurricularPlansSet()) {
            this.addNonInvisibleEnrolments(allEnrollments, studentCurricularPlan.getEnrolmentsSet());
        }
        return allEnrollments;
    }

    private void addNonInvisibleEnrolments(Collection<Enrolment> allEnrollments, Collection<Enrolment> enrollmentsToAdd) {
        for (Enrolment enrolment : enrollmentsToAdd) {
            if (enrolment.isInvisible()) continue;
            allEnrollments.add(enrolment);
        }
    }

    public final int getNumberOfStudentEnrollments() {
        return this.getAllEnrollments().size();
    }

    public List<Enrolment> getStudentEnrollmentsWithApprovedState() {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        for (Enrolment enrolment : this.getAllEnrollments()) {
            if (!enrolment.isApproved()) continue;
            result.add(enrolment);
        }
        return result;
    }

    public final int getNumberOfStudentEnrollmentsWithApprovedState() {
        int result = 0;
        for (Enrolment enrolment : this.getAllEnrollments()) {
            if (!enrolment.isApproved()) continue;
            ++result;
        }
        return result;
    }

    protected final boolean isApproved(CurricularCourse curricularCourse, List<CurricularCourse> approvedCourses) {
        return this.hasEquivalenceIn(curricularCourse, approvedCourses) || this.hasEquivalenceInNotNeedToEnroll(curricularCourse);
    }

    public final boolean isApproved(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return this.getRoot().isApproved(curricularCourse, executionSemester);
    }

    public final boolean isCurricularCourseApproved(CurricularCourse curricularCourse) {
        List<Enrolment> studentApprovedEnrollments = this.getStudentEnrollmentsWithApprovedState();
        List result = (List)CollectionUtils.collect(studentApprovedEnrollments, (Transformer)new Transformer(){

            public final Object transform(Object obj) {
                Enrolment enrollment = (Enrolment)obj;
                return enrollment.getCurricularCourse();
            }
        });
        return this.isApproved(curricularCourse, result);
    }

    public final boolean isApproved(CurricularCourse curricularCourse) {
        return this.getRoot().isApproved(curricularCourse);
    }

    public int getNumberOfApprovedCurricularCourses() {
        int counter = 0;
        int size = this.getDegreeCurricularPlan().getCurricularCoursesSet().size();
        for (CurricularCourse curricularCourse : this.getDegreeCurricularPlan().getCurricularCoursesSet()) {
            if (!this.isCurricularCourseApproved(curricularCourse)) continue;
            ++counter;
        }
        return counter;
    }

    public final boolean isCurricularCourseNotExtraApprovedInCurrentOrPreviousPeriod(CurricularCourse course, ExecutionSemester executionSemester) {
        List<Enrolment> studentApprovedEnrollments = this.getStudentEnrollmentsWithApprovedState();
        ArrayList<CurricularCourse> approvedCurricularCourses = new ArrayList<CurricularCourse>();
        for (Enrolment enrolment : studentApprovedEnrollments) {
            if (enrolment.isExtraCurricular() || enrolment.getExecutionPeriod().compareTo(executionSemester) > 0) continue;
            approvedCurricularCourses.add(enrolment.getCurricularCourse());
        }
        return this.isApproved(course, approvedCurricularCourses);
    }

    public final boolean isCurricularCourseApprovedWithoutEquivalencesInCurrentOrPreviousPeriod(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        for (Enrolment enrolment : this.getStudentEnrollmentsWithApprovedState()) {
            if (!enrolment.getCurricularCourse().getExternalId().equals(curricularCourse.getExternalId()) || !enrolment.isApproved() || enrolment.getExecutionPeriod().compareTo(executionSemester) > 0) continue;
            return true;
        }
        return false;
    }

    public final boolean isEquivalentAproved(CurricularCourse curricularCourse) {
        List<Enrolment> studentApprovedEnrollments = this.getStudentEnrollmentsWithApprovedState();
        List result = (List)CollectionUtils.collect(studentApprovedEnrollments, (Transformer)new Transformer(){

            public final Object transform(Object obj) {
                Enrolment enrollment = (Enrolment)obj;
                return enrollment.getCurricularCourse();
            }
        });
        return this.isThisCurricularCoursesInTheList(curricularCourse, result) || this.hasEquivalenceInNotNeedToEnroll(curricularCourse);
    }

    private boolean hasEquivalenceInNotNeedToEnroll(CurricularCourse curricularCourse) {
        if (this.notNeedToEnroll(curricularCourse)) {
            return true;
        }
        for (CurricularCourseEquivalence equiv : curricularCourse.getCurricularCourseEquivalencesSet()) {
            if (!this.allNotNeedToEnroll(equiv.getOldCurricularCoursesSet())) continue;
            return true;
        }
        return false;
    }

    public final void initEctsCreditsToEnrol(List<CurricularCourse2Enroll> setOfCurricularCoursesToEnroll, ExecutionSemester executionSemester) {
        for (CurricularCourse2Enroll curricularCourse2Enroll : setOfCurricularCoursesToEnroll) {
            curricularCourse2Enroll.setEctsCredits(this.getAccumulatedEctsCredits(executionSemester, curricularCourse2Enroll.getCurricularCourse()));
        }
    }

    private boolean allNotNeedToEnroll(Collection<CurricularCourse> oldCurricularCourses) {
        for (CurricularCourse course : oldCurricularCourses) {
            if (this.notNeedToEnroll(course)) continue;
            return false;
        }
        return true;
    }

    protected final boolean hasEquivalenceIn(CurricularCourse curricularCourse, List<CurricularCourse> otherCourses) {
        if (otherCourses.isEmpty()) {
            return false;
        }
        if (this.isThisCurricularCoursesInTheList(curricularCourse, otherCourses)) {
            return true;
        }
        for (CurricularCourseEquivalence equiv : curricularCourse.getCurricularCourseEquivalencesSet()) {
            if (!this.allCurricularCoursesInTheList(equiv.getOldCurricularCoursesSet(), otherCourses)) continue;
            return true;
        }
        return false;
    }

    private boolean allCurricularCoursesInTheList(Collection<CurricularCourse> oldCurricularCourses, List<CurricularCourse> otherCourses) {
        for (CurricularCourse oldCurricularCourse : oldCurricularCourses) {
            if (this.isThisCurricularCoursesInTheList(oldCurricularCourse, otherCourses) || this.hasEquivalenceInNotNeedToEnroll(oldCurricularCourse)) continue;
            return false;
        }
        return true;
    }

    public final boolean isCurricularCourseEnrolled(CurricularCourse curricularCourse) {
        List result = (List)CollectionUtils.collect(this.getStudentEnrollmentsWithEnrolledState(), (Transformer)new Transformer(){

            public final Object transform(Object obj) {
                Enrolment enrollment = (Enrolment)obj;
                return enrollment.getCurricularCourse();
            }
        });
        return result.contains((Object)curricularCourse);
    }

    public final boolean isEnroledInExecutionPeriod(CurricularCourse curricularCourse) {
        return this.isEnroledInExecutionPeriod(curricularCourse, ExecutionSemester.readActualExecutionSemester());
    }

    public final boolean isEnroledInExecutionPeriod(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return this.getRoot().isEnroledInExecutionPeriod(curricularCourse, executionSemester);
    }

    public final Integer getCurricularCourseAcumulatedEnrollments(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        Integer curricularCourseAcumulatedEnrolments = this.calculateStudentAcumulatedEnrollments(curricularCourse, executionSemester);
        if (curricularCourseAcumulatedEnrolments == null) {
            curricularCourseAcumulatedEnrolments = 0;
        }
        if (curricularCourseAcumulatedEnrolments >= curricularCourse.getMinimumValueForAcumulatedEnrollments()) {
            curricularCourseAcumulatedEnrolments = curricularCourse.getMaximumValueForAcumulatedEnrollments();
        }
        if (curricularCourseAcumulatedEnrolments == 0) {
            curricularCourseAcumulatedEnrolments = curricularCourse.getMinimumValueForAcumulatedEnrollments();
        }
        return curricularCourseAcumulatedEnrolments;
    }

    public final Integer getCurricularCourseAcumulatedEnrollments(CurricularCourse curricularCourse) {
        return this.getCurricularCourseAcumulatedEnrollments(curricularCourse, ExecutionSemester.readActualExecutionSemester());
    }

    public final List<Enrolment> getAllStudentEnrolledEnrollmentsInExecutionPeriod(ExecutionSemester executionSemester) {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (!enrolment.getExecutionPeriod().equals(executionSemester) || !enrolment.isEnroled() || enrolment.isInvisible()) continue;
            result.add(enrolment);
        }
        return result;
    }

    public final boolean hasEnrolledStateInPreviousExecutionPerdiod(CurricularCourse curricularCourse, List<Enrolment> enrollmentsWithEnrolledStateInPreviousExecutionPeriod) {
        for (Enrolment enrolment : enrollmentsWithEnrolledStateInPreviousExecutionPeriod) {
            if (!enrolment.getCurricularCourse().equals((Object)curricularCourse)) continue;
            return true;
        }
        return false;
    }

    public boolean areNewAreasCompatible(Branch specializationArea, Branch secundaryArea) throws BothAreasAreTheSameServiceException, InvalidArgumentsServiceException {
        return true;
    }

    public boolean getCanChangeSpecializationArea() {
        return this.getBranch() == null;
    }

    public final double getAccumulatedEctsCredits(ExecutionSemester executionSemester) {
        double result = 0.0;
        for (Enrolment enrolment : this.getVisibleEnroledEnrolments(executionSemester)) {
            result += this.getAccumulatedEctsCredits(executionSemester, enrolment.getCurricularCourse());
        }
        return result;
    }

    public final double getAccumulatedEctsCredits(ExecutionSemester executionSemester, CurricularCourse curricularCourse) {
        if (curricularCourse.isBolonhaDegree()) {
            return this.isAccumulated(executionSemester, curricularCourse) ? MaximumNumberOfCreditsForEnrolmentPeriod.getAccumulatedEcts(curricularCourse, executionSemester) : curricularCourse.getEctsCredits(executionSemester.getSemester(), executionSemester);
        }
        return this.getAccumulatedEctsCreditsForOldCurricularCourses(curricularCourse, executionSemester);
    }

    private double getAccumulatedEctsCreditsForOldCurricularCourses(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        Integer curricularCourseAcumulatedEnrolments = this.calculateStudentAcumulatedEnrollments(curricularCourse, executionSemester);
        Double factor = curricularCourseAcumulatedEnrolments == null || curricularCourseAcumulatedEnrolments == 0 ? Double.valueOf(1.0) : Double.valueOf(0.75);
        return curricularCourse.getEctsCredits() * factor;
    }

    private boolean isAccumulated(ExecutionSemester executionSemester, CurricularCourse curricularCourse) {
        if (curricularCourse.isBolonhaDegree()) {
            return this.hasEnrolmentInCurricularCourseBefore(curricularCourse, executionSemester);
        }
        Integer curricularCourseAcumulatedEnrolments = this.calculateStudentAcumulatedEnrollments(curricularCourse, executionSemester);
        return curricularCourseAcumulatedEnrolments != null && curricularCourseAcumulatedEnrolments != 0;
    }

    private boolean hasEnrolmentInCurricularCourseBefore(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return this.getRoot().hasEnrolmentInCurricularCourseBefore(curricularCourse, executionSemester);
    }

    public double getEnrolmentsEctsCredits(ExecutionYear executionYear) {
        return executionYear.getExecutionPeriodsSet().stream().mapToDouble(semester -> this.getEnrolmentsEctsCredits((ExecutionSemester)semester)).sum();
    }

    public final double getEnrolmentsEctsCredits(ExecutionSemester executionSemester) {
        return this.getEnrolmentsSet().stream().filter(e -> e.isValid(executionSemester)).mapToDouble(Enrolment::getEctsCredits).sum();
    }

    public final double getDismissalsEctsCredits() {
        return this.getDismissals().stream().mapToDouble(Dismissal::getEctsCredits).sum();
    }

    private Integer calculateStudentAcumulatedEnrollments(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        if (!this.isBolonhaDegree()) {
            return this.getRoot().calculateStudentAcumulatedEnrollments(curricularCourse, executionSemester);
        }
        return null;
    }

    private Set getCurricularCoursesInCurricularCourseEquivalences(CurricularCourse curricularCourse) {
        ArrayList<CurricularCourse> sameCompetenceCurricularCourses;
        HashSet<CurricularCourse> curricularCoursesEquivalent = new HashSet<CurricularCourse>();
        if (curricularCourse.getCompetenceCourse() == null) {
            sameCompetenceCurricularCourses = new ArrayList<CurricularCourse>();
            sameCompetenceCurricularCourses.add(curricularCourse);
        } else {
            sameCompetenceCurricularCourses = new ArrayList();
            for (CurricularCourse course : curricularCourse.getCompetenceCourse().getAssociatedCurricularCoursesSet()) {
                if (course.isBolonhaDegree()) continue;
                sameCompetenceCurricularCourses.add(course);
            }
        }
        for (CurricularCourse course : sameCompetenceCurricularCourses) {
            for (CurricularCourseEquivalence curricularCourseEquivalence : course.getOldCurricularCourseEquivalencesSet()) {
                curricularCoursesEquivalent.add(curricularCourseEquivalence.getEquivalentCurricularCourse());
            }
        }
        return curricularCoursesEquivalent;
    }

    private boolean isThisCurricularCoursesInTheList(CurricularCourse curricularCourse, List<CurricularCourse> curricularCourses) {
        for (CurricularCourse otherCourse : curricularCourses) {
            if (curricularCourse != otherCourse && !this.haveSameCompetence(curricularCourse, otherCourse)) continue;
            return true;
        }
        return false;
    }

    public final NotNeedToEnrollInCurricularCourse findNotNeddToEnrol(CurricularCourse curricularCourse) {
        for (NotNeedToEnrollInCurricularCourse notNeedToEnrollInCurricularCourse : this.getNotNeedToEnrollCurricularCoursesSet()) {
            CurricularCourse otherCourse = notNeedToEnrollInCurricularCourse.getCurricularCourse();
            if (curricularCourse != otherCourse && !this.haveSameCompetence(curricularCourse, otherCourse)) continue;
            return notNeedToEnrollInCurricularCourse;
        }
        return null;
    }

    public final boolean notNeedToEnroll(CurricularCourse curricularCourse) {
        return this.findNotNeddToEnrol(curricularCourse) != null;
    }

    private boolean haveSameCompetence(CurricularCourse course1, CurricularCourse course2) {
        CompetenceCourse comp1 = course1.getCompetenceCourse();
        CompetenceCourse comp2 = course2.getCompetenceCourse();
        return comp1 != null && comp1 == comp2;
    }

    private List<CurricularCourse> getStudentNotNeedToEnrollCurricularCourses() {
        return (List)CollectionUtils.collect((Collection)this.getNotNeedToEnrollCurricularCoursesSet(), (Transformer)new Transformer(){

            public final Object transform(Object obj) {
                NotNeedToEnrollInCurricularCourse notNeedToEnrollInCurricularCourse = (NotNeedToEnrollInCurricularCourse)((Object)obj);
                return notNeedToEnrollInCurricularCourse.getCurricularCourse();
            }
        });
    }

    protected final boolean hasCurricularCourseEquivalenceIn(CurricularCourse curricularCourse, List curricularCoursesEnrollments) {
        int size = curricularCoursesEnrollments.size();
        for (int i = 0; i < size; ++i) {
            CurricularCourse tempCurricularCourse = ((Enrolment)curricularCoursesEnrollments.get(i)).getCurricularCourse();
            Set curricularCourseEquivalences = this.getCurricularCoursesInCurricularCourseEquivalences(tempCurricularCourse);
            if (!curricularCourseEquivalences.contains((Object)curricularCourse)) continue;
            return true;
        }
        List<CurricularCourse> studentNotNeedToEnrollCourses = this.getStudentNotNeedToEnrollCurricularCourses();
        if (this.isThisCurricularCoursesInTheList(curricularCourse, studentNotNeedToEnrollCourses)) {
            return true;
        }
        size = studentNotNeedToEnrollCourses.size();
        for (int i = 0; i < size; ++i) {
            CurricularCourse ccNotNeedToDo = studentNotNeedToEnrollCourses.get(i);
            Set curricularCourseEquivalences = this.getCurricularCoursesInCurricularCourseEquivalences(ccNotNeedToDo);
            if (!curricularCourseEquivalences.contains((Object)curricularCourse)) continue;
            return true;
        }
        return false;
    }

    protected final boolean isMathematicalCourse(CurricularCourse curricularCourse) {
        String code = curricularCourse.getCode();
        return code.equals("QN") || code.equals("PY") || code.equals("P5") || code.equals("UN") || code.equals("U8") || code.equals("AZ2") || code.equals("AZ3") || code.equals("AZ4") || code.equals("AZ5") || code.equals("AZ6");
    }

    public final void setStudentAreasWithoutRestrictions(Branch specializationArea, Branch secundaryArea) throws DomainException {
        if (specializationArea != null && secundaryArea != null && specializationArea.equals((Object)secundaryArea)) {
            throw new DomainException("error.student.curricular.plan.areas.conflict", new String[0]);
        }
        this.setBranch(specializationArea);
        this.setSecundaryBranch(secundaryArea);
    }

    public final void setStudentAreas(Branch specializationArea, Branch secundaryArea) throws NotAuthorizedBranchChangeException, BothAreasAreTheSameServiceException, InvalidArgumentsServiceException, DomainException {
        if (!this.getCanChangeSpecializationArea()) {
            throw new NotAuthorizedBranchChangeException();
        }
        if (!this.areNewAreasCompatible(specializationArea, secundaryArea)) {
            throw new DomainException("error.student.curricular.plan.areas.conflict", new String[0]);
        }
        this.setStudentAreasWithoutRestrictions(specializationArea, secundaryArea);
    }

    public final GratuitySituation getGratuitySituationByGratuityValues(GratuityValues gratuityValues) {
        for (GratuitySituation gratuitySituation : this.getGratuitySituationsSet()) {
            if (!gratuitySituation.getGratuityValues().equals((Object)gratuityValues)) continue;
            return gratuitySituation;
        }
        return null;
    }

    public final GratuitySituation getGratuitySituationByGratuityValuesAndGratuitySituationType(GratuitySituationType gratuitySituationType, GratuityValues gratuityValues) {
        GratuitySituation gratuitySituation = this.getGratuitySituationByGratuityValues(gratuityValues);
        if (gratuitySituation != null && (gratuitySituationType == null || gratuitySituationType.equals((Object)GratuitySituationType.CREDITOR) && gratuitySituation.getRemainingValue() < 0.0 || gratuitySituationType.equals((Object)GratuitySituationType.DEBTOR) && gratuitySituation.getRemainingValue() > 0.0 || gratuitySituationType.equals((Object)GratuitySituationType.REGULARIZED) && gratuitySituation.getRemainingValue() == 0.0)) {
            return gratuitySituation;
        }
        return null;
    }

    public final <T extends GratuityEvent> T getGratuityEvent(ExecutionYear executionYear, Class<? extends GratuityEvent> type) {
        for (GratuityEvent gratuityEvent : this.getGratuityEventsSet()) {
            if (gratuityEvent.isCancelled() || gratuityEvent.getExecutionYear() != executionYear || !((Object)((Object)gratuityEvent)).getClass().equals(type)) continue;
            return (T)((Object)gratuityEvent);
        }
        return null;
    }

    public final boolean hasGratuityEvent(ExecutionYear executionYear, Class<? extends GratuityEvent> type) {
        return this.getGratuityEvent(executionYear, type) != null;
    }

    public final Set<GratuityEvent> getNotPayedGratuityEvents() {
        HashSet<GratuityEvent> result = new HashSet<GratuityEvent>();
        for (GratuityEvent gratuityEvent : this.getGratuityEventsSet()) {
            if (!gratuityEvent.isInDebt()) continue;
            result.add(gratuityEvent);
        }
        return result;
    }

    public final boolean hasAnyNotPayedGratuityEvents() {
        for (GratuityEvent gratuityEvent : this.getGratuityEventsSet()) {
            if (!gratuityEvent.isInDebt()) continue;
            return true;
        }
        return false;
    }

    public final boolean hasAnyNotPayedGratuityEventsUntil(ExecutionYear executionYear) {
        for (GratuityEvent gratuityEvent : this.getGratuityEventsSet()) {
            if (!gratuityEvent.getExecutionYear().isBeforeOrEquals(executionYear) || !gratuityEvent.isInDebt()) continue;
            return true;
        }
        return false;
    }

    public final boolean hasAnyNotPayedGratuityEventsForPreviousYears(ExecutionYear limitExecutionYear) {
        for (GratuityEvent gratuityEvent : this.getGratuityEventsSet()) {
            if (!gratuityEvent.getExecutionYear().isBefore(limitExecutionYear) || !gratuityEvent.isInDebt()) continue;
            return true;
        }
        return false;
    }

    public int numberCompletedCoursesForSpecifiedDegrees(Set<Degree> degrees) {
        int numberCompletedCourses = 0;
        for (StudentCurricularPlan studentCurricularPlan : this.getRegistration().getStudentCurricularPlansSet()) {
            for (Enrolment enrolment : studentCurricularPlan.getEnrolmentsSet()) {
                ExecutionSemester executionSemester;
                ExecutionYear executionYear;
                if (enrolment.isInvisible() || !enrolment.isApproved() || (executionYear = (executionSemester = enrolment.getExecutionPeriod()).getExecutionYear()).isCurrent()) continue;
                CurricularCourse curricularCourse = enrolment.getCurricularCourse();
                DegreeCurricularPlan degreeCurricularPlan = curricularCourse.getDegreeCurricularPlan();
                Degree degree = degreeCurricularPlan.getDegree();
                CompetenceCourse competenceCourse = curricularCourse.getCompetenceCourse();
                if (!degrees.contains(degree) && (competenceCourse == null || !competenceCourse.isAssociatedToAnyDegree(degrees))) continue;
                ++numberCompletedCourses;
            }
        }
        return numberCompletedCourses;
    }

    public boolean isEnroledInSpecialSeason(ExecutionSemester executionSemester) {
        return this.getRoot().isEnroledInSpecialSeason(executionSemester);
    }

    public boolean isEnroledInSpecialSeason(ExecutionYear executionYear) {
        return this.getRoot().isEnroledInSpecialSeason(executionYear);
    }

    public final Collection<EnrolmentEvaluation> getEnroledSpecialSeasons(ExecutionSemester input) {
        HashSet result = Sets.newHashSet();
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            for (EnrolmentEvaluation evaluation : enrolment.getEvaluationsSet()) {
                Optional<EnrolmentEvaluation> search;
                EvaluationSeason season = evaluation.getEvaluationSeason();
                if (!season.isSpecial() || !(search = enrolment.getEnrolmentEvaluation(season, input, null)).isPresent() || search.get() != evaluation) continue;
                result.add(evaluation);
            }
        }
        return result;
    }

    public boolean hasSpecialSeasonFor(ExecutionSemester executionSemester) {
        ExecutionSemester previous = executionSemester.getPreviousExecutionPeriod();
        return previous != null && this.isEnroledInSpecialSeason(previous.getExecutionYear());
    }

    public final void createEnrolmentEvaluationForSpecialSeason(Collection<Enrolment> toCreate, Person person, EvaluationSeason evaluationSeason) {
        HashSet<EnrolmentEvaluation> created = new HashSet<EnrolmentEvaluation>();
        for (Enrolment enrolment : toCreate) {
            created.add(enrolment.createTemporaryEvaluationForSpecialSeason(person, evaluationSeason));
        }
    }

    public final void createEnrolmentEvaluationForImprovement(Collection<Enrolment> toCreate, Person person, ExecutionSemester executionSemester, EvaluationSeason evaluationSeason) {
        HashSet<EnrolmentEvaluation> created = new HashSet<EnrolmentEvaluation>();
        for (Enrolment enrolment : toCreate) {
            created.add(enrolment.createTemporaryEvaluationForImprovement(person, evaluationSeason, executionSemester));
        }
    }

    private boolean isToPayImprovementOfApprovedEnrolments() {
        RegistrationProtocol protocol = this.getRegistration().getRegistrationProtocol();
        return !protocol.isMilitaryAgreement();
    }

    public final Set<EnrolmentEvaluation> getEnroledImprovements(ExecutionSemester input) {
        HashSet result = Sets.newHashSet();
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            for (EnrolmentEvaluation evaluation : enrolment.getEvaluationsSet()) {
                Optional<EnrolmentEvaluation> search;
                EvaluationSeason season = evaluation.getEvaluationSeason();
                if (!season.isImprovement() || !(search = enrolment.getEnrolmentEvaluation(season, input, null)).isPresent() || search.get() != evaluation) continue;
                result.add(evaluation);
            }
        }
        return result;
    }

    public final void createFirstTimeStudentEnrolmentsFor(ExecutionSemester executionSemester, String createdBy) {
        this.internalCreateFirstTimeStudentEnrolmentsFor((CurriculumGroup)((Object)this.getRoot()), this.getDegreeCurricularPlan().getCurricularPeriodFor(1, 1), executionSemester, createdBy);
    }

    private void internalCreateFirstTimeStudentEnrolmentsFor(CurriculumGroup curriculumGroup, CurricularPeriod curricularPeriod, ExecutionSemester executionSemester, String createdBy) {
        if (curriculumGroup.getDegreeModule() != null) {
            for (Context context : curriculumGroup.getDegreeModule().getContextsWithCurricularCourseByCurricularPeriod(curricularPeriod, executionSemester)) {
                new Enrolment(this, curriculumGroup, (CurricularCourse)((Object)context.getChildDegreeModule()), executionSemester, EnrollmentCondition.FINAL, createdBy);
            }
        }
        if (!curriculumGroup.getCurriculumModulesSet().isEmpty()) {
            for (CurriculumModule curriculumModule : curriculumGroup.getCurriculumModulesSet()) {
                if (curriculumModule.isLeaf()) continue;
                this.internalCreateFirstTimeStudentEnrolmentsFor((CurriculumGroup)((Object)curriculumModule), curricularPeriod, executionSemester, createdBy);
            }
        }
    }

    public final Set<IDegreeModuleToEvaluate> getDegreeModulesToEvaluate(ExecutionSemester executionSemester) {
        return this.isBolonhaDegree() ? this.getRoot().getDegreeModulesToEvaluate(executionSemester) : Collections.EMPTY_SET;
    }

    public final RuleResult enrol(ExecutionSemester executionSemester, Set<IDegreeModuleToEvaluate> degreeModulesToEnrol, List<CurriculumModule> curriculumModulesToRemove, CurricularRuleLevel curricularRuleLevel) {
        AccessControl.check(this, StudentCurricularPlanPredicates.ENROL);
        return this.enrol(executionSemester, degreeModulesToEnrol, curriculumModulesToRemove, curricularRuleLevel, null);
    }

    public final RuleResult enrol(ExecutionSemester executionSemester, Set<IDegreeModuleToEvaluate> set, List<CurriculumModule> list, CurricularRuleLevel curricularRuleLevel, EvaluationSeason evaluationSeason) {
        return (RuleResult)advice$enrol.perform((Callable)new StudentCurricularPlan$callable$enrol(this, executionSemester, set, list, curricularRuleLevel, evaluationSeason));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static final /* synthetic */ RuleResult advised$enrol(StudentCurricularPlan this_, ExecutionSemester executionSemester, Set degreeModulesToEnrol, List curriculumModulesToRemove, CurricularRuleLevel curricularRuleLevel, EvaluationSeason season) {
        AccessControl.check(this_, StudentCurricularPlanPredicates.ENROL);
        EnrolmentContext enrolmentContext = new EnrolmentContext(this_, executionSemester, degreeModulesToEnrol, curriculumModulesToRemove, curricularRuleLevel, season);
        return StudentCurricularPlanEnrolment.createManager(enrolmentContext).manage();
    }

    public final RuleResult enrol(ExecutionSemester executionSemester, CurricularRuleLevel curricularRuleLevel) {
        return this.enrol(executionSemester, Collections.EMPTY_SET, Collections.EMPTY_LIST, curricularRuleLevel);
    }

    public void enrolInAffinityCycle(CycleCourseGroup cycleCourseGroup, ExecutionSemester executionSemester) {
        AccessControl.check(this, StudentCurricularPlanPredicates.ENROL_IN_AFFINITY_CYCLE);
        CurriculumGroupFactory.createGroup((CurriculumGroup)((Object)this.getRoot()), (CourseGroup)((Object)cycleCourseGroup), executionSemester);
    }

    public final String getName() {
        return this.getDegreeCurricularPlan().getName();
    }

    public final String getPresentationName() {
        return this.getPresentationName(ExecutionYear.readCurrentExecutionYear());
    }

    public final String getPresentationName(ExecutionYear executionYear) {
        return this.getDegreeCurricularPlan().getPresentationName(executionYear);
    }

    public final Space getCurrentCampus() {
        Space currentCampus = this.getDegreeCurricularPlan().getCurrentCampus();
        return currentCampus == null ? this.getLastCampus() : currentCampus;
    }

    public final Space getCampus(ExecutionYear executionYear) {
        Space result = this.getDegreeCurricularPlan().getCampus(executionYear);
        return result == null ? this.getLastCampus() : result;
    }

    public final Space getLastCampus() {
        Space lastScpCampus = this.getDegreeCurricularPlan().getCampus(this.getLastExecutionYear());
        return lastScpCampus == null ? this.getDegreeCurricularPlan().getLastCampus() : lastScpCampus;
    }

    public final void createOptionalEnrolment(CurriculumGroup curriculumGroup, ExecutionSemester executionSemester, OptionalCurricularCourse optionalCurricularCourse, CurricularCourse curricularCourse, EnrollmentCondition enrollmentCondition) {
        if (this.getRoot().isApproved(curricularCourse, executionSemester)) {
            throw new DomainException("error.already.aproved", curricularCourse.getName());
        }
        if (this.getRoot().isEnroledInExecutionPeriod(curricularCourse, executionSemester)) {
            throw new DomainException("error.already.enroled.in.executionPeriod", curricularCourse.getName(), executionSemester.getQualifiedName());
        }
        new OptionalEnrolment(this, curriculumGroup, curricularCourse, executionSemester, enrollmentCondition, Authenticate.getUser().getUsername(), optionalCurricularCourse);
    }

    public final RuleResult createNoCourseGroupCurriculumGroupEnrolment(NoCourseGroupEnrolmentBean bean) {
        return StudentCurricularPlanEnrolment.createManager(EnrolmentContext.createForNoCourseGroupCurriculumGroupEnrolment(this, bean)).manage();
    }

    public RuleResult removeCurriculumModulesFromNoCourseGroupCurriculumGroup(List<CurriculumModule> list, ExecutionSemester executionSemester, NoCourseGroupCurriculumGroupType noCourseGroupCurriculumGroupType) {
        return (RuleResult)advice$removeCurriculumModulesFromNoCourseGroupCurriculumGroup.perform((Callable)new StudentCurricularPlan$callable$removeCurriculumModulesFromNoCourseGroupCurriculumGroup(this, list, executionSemester, noCourseGroupCurriculumGroupType));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ RuleResult advised$removeCurriculumModulesFromNoCourseGroupCurriculumGroup(StudentCurricularPlan this_, List curriculumModules, ExecutionSemester executionSemester, NoCourseGroupCurriculumGroupType groupType) {
        EnrolmentContext context = new EnrolmentContext(this_, executionSemester, Collections.EMPTY_SET, curriculumModules, groupType.getCurricularRuleLevel());
        return StudentCurricularPlanEnrolment.createManager(context).manage();
    }

    public final NoCourseGroupCurriculumGroup getNoCourseGroupCurriculumGroup(NoCourseGroupCurriculumGroupType groupType) {
        return this.getRoot().getNoCourseGroupCurriculumGroup(groupType);
    }

    public final NoCourseGroupCurriculumGroup createNoCourseGroupCurriculumGroup(NoCourseGroupCurriculumGroupType groupType) {
        NoCourseGroupCurriculumGroup noCourseGroupCurriculumGroup = this.getNoCourseGroupCurriculumGroup(groupType);
        if (noCourseGroupCurriculumGroup != null) {
            throw new DomainException("error.studentCurricularPlan.already.has.noCourseGroupCurriculumGroup.with.same.groupType", new String[0]);
        }
        return NoCourseGroupCurriculumGroup.create(groupType, this.getRoot());
    }

    public ExtraCurriculumGroup createExtraCurriculumGroup() {
        return (ExtraCurriculumGroup)((Object)this.createNoCourseGroupCurriculumGroup(NoCourseGroupCurriculumGroupType.EXTRA_CURRICULAR));
    }

    public ExtraCurriculumGroup getExtraCurriculumGroup() {
        return (ExtraCurriculumGroup)((Object)this.getNoCourseGroupCurriculumGroup(NoCourseGroupCurriculumGroupType.EXTRA_CURRICULAR));
    }

    public boolean hasExtraCurriculumGroup() {
        return this.getExtraCurriculumGroup() != null;
    }

    public StandaloneCurriculumGroup getStandaloneCurriculumGroup() {
        return (StandaloneCurriculumGroup)((Object)this.getNoCourseGroupCurriculumGroup(NoCourseGroupCurriculumGroupType.STANDALONE));
    }

    public boolean hasStandaloneCurriculumGroup() {
        return this.getStandaloneCurriculumGroup() != null;
    }

    public final Collection<CurriculumLine> getExtraCurricularCurriculumLines() {
        ArrayList<CurriculumLine> result = new ArrayList<CurriculumLine>();
        if (this.hasExtraCurriculumGroup()) {
            for (CurriculumLine curriculumLine : this.getExtraCurriculumGroup().getCurriculumLines()) {
                result.add(curriculumLine);
            }
        }
        return result;
    }

    public final Collection<CurriculumLine> getStandaloneCurriculumLines() {
        ArrayList<CurriculumLine> result = new ArrayList<CurriculumLine>();
        if (this.hasStandaloneCurriculumGroup()) {
            for (CurriculumLine curriculumLine : this.getStandaloneCurriculumGroup().getCurriculumLines()) {
                result.add(curriculumLine);
            }
        }
        return result;
    }

    public final Collection<Enrolment> getExtraCurricularEnrolments() {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (!enrolment.isExtraCurricular()) continue;
            result.add(enrolment);
        }
        return result;
    }

    public List<Enrolment> getExtraCurricularApprovedEnrolmentsNotInDismissal() {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        for (CurriculumLine curriculumLine : this.getExtraCurriculumGroup().getApprovedCurriculumLines()) {
            Dismissal dismissal;
            if (curriculumLine.isEnrolment()) {
                Enrolment enrolment = (Enrolment)((Object)curriculumLine);
                if (enrolment.isSourceOfAnyCreditsInCurriculum()) continue;
                result.add(enrolment);
                continue;
            }
            if (!curriculumLine.isDismissal() || !(dismissal = (Dismissal)((Object)curriculumLine)).getCredits().isSubstitution()) continue;
            for (IEnrolment enrolment : dismissal.getSourceIEnrolments()) {
                if (!enrolment.isEnrolment()) continue;
                result.add((Enrolment)enrolment);
            }
        }
        return result;
    }

    public List<Enrolment> getStandaloneApprovedEnrolmentsNotInDismissal() {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        StandaloneCurriculumGroup standaloneGroup = this.getStandaloneCurriculumGroup();
        if (standaloneGroup == null) {
            return result;
        }
        for (Enrolment enrolment : standaloneGroup.getEnrolments()) {
            if (!enrolment.isApproved() || enrolment.isSourceOfAnyCreditsInCurriculum()) continue;
            result.add(enrolment);
        }
        return result;
    }

    public PropaedeuticsCurriculumGroup getPropaedeuticCurriculumGroup() {
        return (PropaedeuticsCurriculumGroup)((Object)this.getNoCourseGroupCurriculumGroup(NoCourseGroupCurriculumGroupType.PROPAEDEUTICS));
    }

    public boolean hasPropaedeuticsCurriculumGroup() {
        return this.getPropaedeuticCurriculumGroup() != null;
    }

    public final Collection<CurriculumLine> getPropaedeuticCurriculumLines() {
        ArrayList<CurriculumLine> result = new ArrayList<CurriculumLine>();
        if (this.hasPropaedeuticsCurriculumGroup()) {
            for (CurriculumLine curriculumLine : this.getPropaedeuticCurriculumGroup().getCurriculumLines()) {
                result.add(curriculumLine);
            }
        }
        return result;
    }

    public final Collection<Enrolment> getPropaedeuticEnrolments() {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (!enrolment.isPropaedeutic()) continue;
            result.add(enrolment);
        }
        return result;
    }

    public Collection<CurricularCourse> getAllCurricularCoursesToDismissal(ExecutionSemester executionSemester) {
        HashSet<CurricularCourse> result = new HashSet<CurricularCourse>();
        if (this.isBolonhaDegree()) {
            for (CycleType cycleType : this.getDegreeType().getSupportedCyclesToEnrol()) {
                CourseGroup courseGroup = this.getCourseGroupWithCycleTypeToCollectCurricularCourses(cycleType);
                if (courseGroup == null) continue;
                for (CurricularCourse curricularCourse : courseGroup.getAllCurricularCourses(executionSemester)) {
                    if (this.isApproved(curricularCourse)) continue;
                    result.add(curricularCourse);
                }
            }
        } else {
            for (CurricularCourse curricularCourse : this.getDegreeCurricularPlan().getCurricularCoursesSet()) {
                if (!curricularCourse.isActive(executionSemester) || this.isApproved(curricularCourse)) continue;
                result.add(curricularCourse);
            }
        }
        return result;
    }

    public Collection<CurricularCourse> getAllCurricularCoursesToDismissal() {
        return this.getAllCurricularCoursesToDismissal(null);
    }

    private CourseGroup getCourseGroupWithCycleTypeToCollectCurricularCourses(CycleType cycleType) {
        CycleCurriculumGroup curriculumGroup = this.getCycle(cycleType);
        return curriculumGroup != null ? curriculumGroup.getDegreeModule() : this.getDegreeCurricularPlan().getCycleCourseGroup(cycleType);
    }

    public final Credits createNewCreditsDismissal(CourseGroup courseGroup, CurriculumGroup curriculumGroup, Collection<DismissalBean.SelectedCurricularCourse> dismissals, Collection<IEnrolment> enrolments, Double givenCredits, ExecutionSemester executionSemester) {
        this.checkPermission(courseGroup, curriculumGroup, dismissals);
        if (courseGroup != null) {
            ArrayList<CurricularCourse> noEnrolCurricularCourse = new ArrayList<CurricularCourse>();
            if (dismissals != null) {
                for (DismissalBean.SelectedCurricularCourse selectedCurricularCourse : dismissals) {
                    noEnrolCurricularCourse.add(selectedCurricularCourse.getCurricularCourse());
                }
            }
            return new Credits(this, courseGroup, enrolments, noEnrolCurricularCourse, givenCredits, executionSemester);
        }
        if (curriculumGroup != null) {
            return new Credits(this, curriculumGroup, enrolments, givenCredits, executionSemester);
        }
        return new Credits(this, dismissals, enrolments, executionSemester);
    }

    public List<Dismissal> getDismissals() {
        ArrayList<Dismissal> result = new ArrayList<Dismissal>();
        this.getRoot().collectDismissals(result);
        return result;
    }

    public Dismissal getDismissal(CurricularCourse curricularCourse) {
        return this.getRoot().getDismissal(curricularCourse);
    }

    public Substitution getSubstitution(IEnrolment iEnrolment) {
        for (Dismissal dismissal : this.getDismissals()) {
            if (!dismissal.getCredits().isSubstitution() || !dismissal.getSourceIEnrolments().contains(iEnrolment)) continue;
            return (Substitution)((Object)dismissal.getCredits());
        }
        return null;
    }

    public final Equivalence createNewEquivalenceDismissal(CourseGroup courseGroup, CurriculumGroup curriculumGroup, Collection<DismissalBean.SelectedCurricularCourse> dismissals, Collection<IEnrolment> enrolments, Double givenCredits, Grade givenGrade, ExecutionSemester executionSemester) {
        this.checkPermission(courseGroup, curriculumGroup, dismissals);
        return CreditsManager.createEquivalence(this, courseGroup, curriculumGroup, dismissals, enrolments, givenCredits, givenGrade, executionSemester);
    }

    public final Substitution createNewSubstitutionDismissal(CourseGroup courseGroup, CurriculumGroup curriculumGroup, Collection<DismissalBean.SelectedCurricularCourse> dismissals, Collection<IEnrolment> enrolments, Double givenCredits, ExecutionSemester executionSemester) {
        this.checkPermission(courseGroup, curriculumGroup, dismissals);
        return CreditsManager.createSubstitution(this, courseGroup, curriculumGroup, dismissals, enrolments, givenCredits, executionSemester);
    }

    public InternalSubstitution createNewInternalSubstitution(CourseGroup courseGroup, CurriculumGroup curriculumGroup, Collection<DismissalBean.SelectedCurricularCourse> dismissals, Collection<IEnrolment> enrolments, Double givenCredits, ExecutionSemester executionSemester) {
        this.checkPermission(courseGroup, curriculumGroup, dismissals);
        return CreditsManager.createInternalSubstitution(this, courseGroup, curriculumGroup, dismissals, enrolments, givenCredits, executionSemester);
    }

    private void checkPermission(CourseGroup courseGroup, CurriculumGroup curriculumGroup, Collection<DismissalBean.SelectedCurricularCourse> dismissals) {
        Person person = AccessControl.getPerson();
        boolean hasUpdateRegistrationAfterConclusionProcessPermission = AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.UPDATE_REGISTRATION_AFTER_CONCLUSION, (AcademicProgram)((Object)this.getDegree()), person.getUser());
        if (courseGroup != null) {
            CurriculumGroup group = this.findCurriculumGroupFor(courseGroup);
            if (group != null && group.getParentCycleCurriculumGroup() != null && group.getParentCycleCurriculumGroup().isConclusionProcessed() && !hasUpdateRegistrationAfterConclusionProcessPermission) {
                throw new DomainException("error.StudentCurricularPlan.cannot.create.dismissals", new String[0]);
            }
        } else if (curriculumGroup != null) {
            if (curriculumGroup.getParentCycleCurriculumGroup() != null && curriculumGroup.getParentCycleCurriculumGroup().isConclusionProcessed() && !hasUpdateRegistrationAfterConclusionProcessPermission) {
                throw new DomainException("error.StudentCurricularPlan.cannot.create.dismissals", new String[0]);
            }
        } else {
            for (DismissalBean.SelectedCurricularCourse selected : dismissals) {
                if (selected.getCurriculumGroup().getParentCycleCurriculumGroup() == null || !selected.getCurriculumGroup().getParentCycleCurriculumGroup().isConclusionProcessed() || hasUpdateRegistrationAfterConclusionProcessPermission) continue;
                throw new DomainException("error.StudentCurricularPlan.cannot.create.dismissals", new String[0]);
            }
        }
        if (this.getRegistration().isRegistrationConclusionProcessed() && !hasUpdateRegistrationAfterConclusionProcessPermission) {
            throw new DomainException("error.StudentCurricularPlan.cannot.create.dismissals", new String[0]);
        }
    }

    public final Set<DegreeModule> getAllDegreeModules() {
        TreeSet<DegreeModule> degreeModules = new TreeSet<DegreeModule>(DegreeModule.COMPARATOR_BY_NAME);
        this.getRoot().getAllDegreeModules(degreeModules);
        return degreeModules;
    }

    public boolean hasDegreeModule(DegreeModule degreeModule) {
        return this.getRoot().hasDegreeModule(degreeModule);
    }

    public boolean hasCurriculumModule(CurriculumModule curriculumModule) {
        return this.getRoot().hasCurriculumModule(curriculumModule);
    }

    public CurriculumGroup findCurriculumGroupFor(CourseGroup courseGroup) {
        return this.getRoot().findCurriculumGroupFor(courseGroup);
    }

    public boolean isConcluded(DegreeModule degreeModule, ExecutionYear executionYear) {
        return this.getRoot().hasConcluded(degreeModule, executionYear);
    }

    public final Double getCreditsConcludedForCourseGroup(CourseGroup courseGroup) {
        CurriculumGroup curriculumGroup = this.findCurriculumGroupFor(courseGroup);
        return curriculumGroup == null ? Double.valueOf(0.0) : curriculumGroup.getCreditsConcluded();
    }

    public final void setIsFirstTimeToNull() {
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            enrolment.setIsFirstTime(null);
        }
    }

    public final void resetIsFirstTimeEnrolmentForCurricularCourse(CurricularCourse curricularCourse) {
        TreeSet<Enrolment> enrolments = new TreeSet<Enrolment>(Enrolment.COMPARATOR_BY_EXECUTION_PERIOD_AND_ID);
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (curricularCourse != enrolment.getCurricularCourse()) continue;
            enrolments.add(enrolment);
        }
        Boolean b = Boolean.TRUE;
        for (Enrolment enrolment : enrolments) {
            if (!enrolment.isAnnulled()) {
                enrolment.setIsFirstTime(b);
                b = Boolean.FALSE;
                continue;
            }
            enrolment.setIsFirstTime(Boolean.FALSE);
        }
    }

    public final StudentCurricularPlanEquivalencePlan createStudentCurricularPlanEquivalencePlan() {
        return new StudentCurricularPlanEquivalencePlan(this);
    }

    public final boolean hasEnrolmentOrAprovalInCurriculumModule(DegreeModule degreeModule) {
        RootCurriculumGroup rootCurriculumGroup = this.getRoot();
        return rootCurriculumGroup != null && this.hasEnrolmentOrAprovalInCurriculumModule((CurriculumModule)((Object)rootCurriculumGroup), degreeModule);
    }

    private boolean hasEnrolmentOrAprovalInCurriculumModule(CurriculumModule curriculumModule, DegreeModule degreeModule) {
        if (curriculumModule.getDegreeModule() == degreeModule) {
            return true;
        }
        if (curriculumModule.isLeaf()) {
            return false;
        }
        CurriculumGroup curriculumGroup = (CurriculumGroup)((Object)curriculumModule);
        for (CurriculumModule child : curriculumGroup.getCurriculumModulesSet()) {
            if (!this.hasEnrolmentOrAprovalInCurriculumModule(child, degreeModule)) continue;
            return true;
        }
        return false;
    }

    public List<Enrolment> getEnrolmentsWithExecutionYearBeforeOrEqualTo(ExecutionYear executionYear) {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (!enrolment.getExecutionPeriod().getExecutionYear().isBeforeOrEquals(executionYear)) continue;
            result.add(enrolment);
        }
        return result;
    }

    public boolean getHasAnyEquivalences() {
        return !this.getNotNeedToEnrollCurricularCoursesSet().isEmpty();
    }

    public boolean isLastStudentCurricularPlanFromRegistration() {
        return this.hasRegistration() && this.getRegistration().getLastStudentCurricularPlan() == this;
    }

    public void moveCurriculumLines(MoveCurriculumLinesBean moveCurriculumLinesBean) {
        AccessControl.check(this, StudentCurricularPlanPredicates.MOVE_CURRICULUM_LINES);
        boolean runRules = false;
        Person responsible = AccessControl.getPerson();
        for (CurriculumLineLocationBean curriculumLineLocationBean : moveCurriculumLinesBean.getCurriculumLineLocations()) {
            CurriculumGroup destination = curriculumLineLocationBean.getCurriculumGroup();
            CurriculumLine curriculumLine = curriculumLineLocationBean.getCurriculumLine();
            if (curriculumLine.getCurriculumGroup() != destination) {
                this.checkPermission(responsible, curriculumLineLocationBean);
                if (!destination.canAdd(curriculumLine)) {
                    throw new DomainException("error.StudentCurricularPlan.cannot.move.curriculum.line.to.curriculum.group", curriculumLine.getFullPath(), destination.getFullPath());
                }
                if (curriculumLine.hasExecutionPeriod() && curriculumLine.getExecutionYear().isBefore(destination.getRegistration().getStartExecutionYear())) {
                    throw new DomainException("error.StudentCurricularPlan.cannot.move.curriculum.line.to.curriculum.group.invalid.period", curriculumLine.getFullPath(), destination.getFullPath(), curriculumLine.getExecutionPeriod().getQualifiedName(), destination.getRegistration().getStartExecutionYear().getQualifiedName());
                }
                if (!destination.isExtraCurriculum()) {
                    runRules = true;
                }
                curriculumLine.setCurriculumGroup(destination);
            }
            curriculumLine.setCreatedBy(responsible != null ? responsible.getUsername() : curriculumLine.getCreatedBy());
        }
        if (runRules &= this.isBolonhaDegree()) {
            this.checkEnrolmentRules(moveCurriculumLinesBean.getIDegreeModulesToEvaluate(ExecutionSemester.readActualExecutionSemester()), ExecutionSemester.readActualExecutionSemester());
        }
    }

    public void moveCurriculumLinesWithoutRules(Person responsiblePerson, MoveCurriculumLinesBean moveCurriculumLinesBean) {
        AccessControl.check(this, StudentCurricularPlanPredicates.MOVE_CURRICULUM_LINES_WITHOUT_RULES);
        for (CurriculumLineLocationBean curriculumLineLocationBean : moveCurriculumLinesBean.getCurriculumLineLocations()) {
            CurriculumGroup destination = curriculumLineLocationBean.getCurriculumGroup();
            CurriculumLine curriculumLine = curriculumLineLocationBean.getCurriculumLine();
            if (curriculumLine.getCurriculumGroup() != destination) {
                this.checkPermission(responsiblePerson, curriculumLineLocationBean);
                if (curriculumLine.hasExecutionPeriod() && curriculumLine.getExecutionYear().isBefore(destination.getRegistration().getStartExecutionYear())) {
                    throw new DomainException("error.StudentCurricularPlan.cannot.move.curriculum.line.to.curriculum.group.invalid.period", curriculumLine.getFullPath(), destination.getFullPath(), curriculumLine.getExecutionPeriod().getQualifiedName(), destination.getRegistration().getStartExecutionYear().getQualifiedName());
                }
                curriculumLine.setCurriculumGroup(destination);
            }
            curriculumLine.setCreatedBy(responsiblePerson != null ? responsiblePerson.getUsername() : curriculumLine.getCreatedBy());
        }
    }

    private void checkPermission(Person responsiblePerson, CurriculumLineLocationBean bean) {
        boolean hasUpdateRegistrationAfterConclusionPermission = AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.UPDATE_REGISTRATION_AFTER_CONCLUSION, (AcademicProgram)((Object)this.getDegree()), responsiblePerson.getUser());
        if (bean.getCurriculumGroup().getParentCycleCurriculumGroup() != null && bean.getCurriculumGroup().getParentCycleCurriculumGroup().isConclusionProcessed() && !hasUpdateRegistrationAfterConclusionPermission) {
            throw new DomainException("error.StudentCurricularPlan.cannot.move.is.not.authorized", new String[0]);
        }
        if (bean.getCurriculumLine().getParentCycleCurriculumGroup() != null && bean.getCurriculumLine().getParentCycleCurriculumGroup().isConclusionProcessed() && !hasUpdateRegistrationAfterConclusionPermission) {
            throw new DomainException("error.StudentCurricularPlan.cannot.move.is.not.authorized", new String[0]);
        }
    }

    private void checkEnrolmentRules(Set<IDegreeModuleToEvaluate> degreeModuleToEvaluate, ExecutionSemester executionSemester) {
        this.enrol(executionSemester, degreeModuleToEvaluate, Collections.EMPTY_LIST, CurricularRuleLevel.ENROLMENT_WITH_RULES);
    }

    public AdministrativeOffice getAdministrativeOffice() {
        return this.getDegree().getAdministrativeOffice();
    }

    public CycleCurriculumGroup getCycle(CycleType cycleType) {
        return this.getRoot().getCycleCurriculumGroup(cycleType);
    }

    public boolean hasCycleCurriculumGroup(CycleType cycleType) {
        return this.getCycle(cycleType) != null;
    }

    public CycleCourseGroup getCycleCourseGroup(CycleType cycleType) {
        return this.getDegreeCurricularPlan().getCycleCourseGroup(cycleType);
    }

    public Collection<CurriculumGroup> getCurricularCoursePossibleGroups(CurricularCourse curricularCourse) {
        return this.getRoot().getCurricularCoursePossibleGroups(curricularCourse);
    }

    public Collection<CurriculumGroup> getCurricularCoursePossibleGroupsWithoutNoCourseGroupCurriculumGroups(CurricularCourse curricularCourse) {
        return this.getRoot().getCurricularCoursePossibleGroupsWithoutNoCourseGroupCurriculumGroups(curricularCourse);
    }

    public CycleCurriculumGroup getFirstCycle() {
        return this.getRoot().getCycleCurriculumGroup(CycleType.FIRST_CYCLE);
    }

    public CycleCurriculumGroup getSecondCycle() {
        return this.getRoot().getCycleCurriculumGroup(CycleType.SECOND_CYCLE);
    }

    public CycleCurriculumGroup getThirdCycle() {
        return this.getRoot().getCycleCurriculumGroup(CycleType.THIRD_CYCLE);
    }

    public CycleCurriculumGroup getFirstOrderedCycleCurriculumGroup() {
        return this.getRoot().getFirstOrderedCycleCurriculumGroup();
    }

    public CycleCurriculumGroup getLastOrderedCycleCurriculumGroup() {
        return this.getRoot().getLastOrderedCycleCurriculumGroup();
    }

    public CycleCurriculumGroup getLastConcludedCycleCurriculumGroup() {
        return this.getRoot().getLastConcludedCycleCurriculumGroup();
    }

    public Collection<CycleCurriculumGroup> getCycleCurriculumGroups() {
        return this.getRoot().getCycleCurriculumGroups();
    }

    public List<CycleCurriculumGroup> getInternalCycleCurriculumGrops() {
        return this.getRoot().getInternalCycleCurriculumGroups();
    }

    public Collection<ExternalCurriculumGroup> getExternalCurriculumGroups() {
        return this.getRoot().getExternalCycleCurriculumGroups();
    }

    public boolean hasExternalCycleCurriculumGroups() {
        return this.getRoot().hasExternalCycles();
    }

    public Integer getInternalCycleCurriculumGroupsSize() {
        return this.getInternalCycleCurriculumGrops().size();
    }

    public List<CycleType> getSupportedCycleTypesToEnrol() {
        CycleType cycleType;
        ArrayList<CycleType> result = new ArrayList<CycleType>();
        ArrayList<CycleType> supportedCyclesToEnrol = new ArrayList<CycleType>(this.getDegreeType().getSupportedCyclesToEnrol());
        Collections.sort(supportedCyclesToEnrol, CycleType.COMPARATOR_BY_GREATER_WEIGHT);
        Iterator iterator = supportedCyclesToEnrol.iterator();
        while (iterator.hasNext() && !this.hasCycleCurriculumGroup(cycleType = (CycleType)((Object)iterator.next()))) {
            result.add(0, cycleType);
        }
        return result;
    }

    public boolean isEmpty() {
        if (this.hasAnyEnrolments()) {
            return false;
        }
        if (!this.getRoot().getAllCurriculumLines().isEmpty()) {
            return false;
        }
        if (this.getEquivalencePlan() != null) {
            return false;
        }
        if (!this.getGratuityEventsSet().isEmpty()) {
            return false;
        }
        if (!this.getNotNeedToEnrollCurricularCoursesSet().isEmpty()) {
            return false;
        }
        if (!this.getGratuitySituationsSet().isEmpty()) {
            return false;
        }
        return this.getCreditsSet().isEmpty();
    }

    public Collection<NoCourseGroupCurriculumGroup> getNoCourseGroupCurriculumGroups() {
        return this.getRoot().getNoCourseGroupCurriculumGroups();
    }

    public boolean hasAnyActiveRegistrationWithFirstCycleAffinity() {
        CycleCurriculumGroup firstCycle = this.getFirstCycle();
        if (firstCycle == null) {
            return false;
        }
        Student student = this.getRegistration().getStudent();
        for (CycleCourseGroup affinity : this.getCycleCourseGroup(firstCycle.getCycleType()).getDestinationAffinitiesSet()) {
            if (!student.hasActiveRegistrationFor(affinity.getParentDegreeCurricularPlan())) continue;
            return true;
        }
        return false;
    }

    public Collection<CycleType> getCycleTypes() {
        return this.getDegreeType().getCycleTypes();
    }

    public CurriculumLine getApprovedCurriculumLine(CurricularCourse curricularCourse) {
        return this.getRoot().getApprovedCurriculumLine(curricularCourse);
    }

    public Set<EnrolmentOutOfPeriodEvent> getEnrolmentOutOfPeriodEventsSet() {
        HashSet<EnrolmentOutOfPeriodEvent> result = new HashSet<EnrolmentOutOfPeriodEvent>();
        for (EnrolmentOutOfPeriodEvent each : super.getEnrolmentOutOfPeriodEventsSet()) {
            if (each.isCancelled()) continue;
            result.add(each);
        }
        return result;
    }

    public OptionalEnrolment convertEnrolmentToOptionalEnrolment(Enrolment enrolment, CurriculumGroup curriculumGroup, OptionalCurricularCourse curricularCourse) {
        Person person = AccessControl.getPerson();
        if (enrolment.getParentCycleCurriculumGroup() != null && enrolment.getParentCycleCurriculumGroup().isConclusionProcessed() && !AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.UPDATE_REGISTRATION_AFTER_CONCLUSION, (AcademicProgram)((Object)this.getDegree()), person.getUser())) {
            throw new DomainException("error.StudentCurricularPlan.cannot.move.is.not.authorized", new String[0]);
        }
        if (!this.hasEnrolments(enrolment)) {
            throw new DomainException("error.StudentCurricularPlan.doesnot.have.enrolment", enrolment.getName().getContent());
        }
        if (this.isApproved((CurricularCourse)((Object)curricularCourse))) {
            throw new DomainException("error.Enrolment.duplicate.enrolment", curricularCourse.getName());
        }
        OptionalEnrolment result = OptionalEnrolment.createBasedOn(enrolment, curriculumGroup, curricularCourse);
        enrolment.getProgramCertificateRequestsSet().clear();
        enrolment.getCourseLoadRequestsSet().clear();
        enrolment.getExamDateCertificateRequestsSet().clear();
        enrolment.delete();
        if (result.getStudentCurricularPlan() != this) {
            this.correctInvalidAttends(result.getStudentCurricularPlan());
        }
        return result;
    }

    private void correctInvalidAttends(StudentCurricularPlan to) {
        for (Attends attend : this.getRegistration().getAssociatedAttendsSet()) {
            if (attend.hasExecutionCourseTo(this) || !attend.canMove(this, to)) continue;
            this.getRegistration().changeShifts(attend, to.getRegistration());
            attend.setRegistration(to.getRegistration());
        }
    }

    public Enrolment convertOptionalEnrolmentToEnrolment(OptionalEnrolment enrolment, CurriculumGroup curriculumGroup) {
        Person person = AccessControl.getPerson();
        if (enrolment.getParentCycleCurriculumGroup() != null && enrolment.getParentCycleCurriculumGroup().isConclusionProcessed() && !AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.UPDATE_REGISTRATION_AFTER_CONCLUSION, (AcademicProgram)((Object)this.getDegree()), person.getUser())) {
            throw new DomainException("error.StudentCurricularPlan.cannot.move.is.not.authorized", new String[0]);
        }
        if (!this.hasEnrolments((Enrolment)((Object)enrolment))) {
            throw new DomainException("error.StudentCurricularPlan.doesnot.have.enrolment", enrolment.getName().getContent());
        }
        Enrolment result = Enrolment.createBasedOn(enrolment, curriculumGroup);
        enrolment.getProgramCertificateRequestsSet().clear();
        enrolment.getCourseLoadRequestsSet().clear();
        enrolment.getExamDateCertificateRequestsSet().clear();
        enrolment.delete();
        if (result.getStudentCurricularPlan() != this) {
            this.correctInvalidAttends(result.getStudentCurricularPlan());
        }
        return result;
    }

    public boolean isEmptyDegree() {
        return this.getDegreeCurricularPlan().isEmpty();
    }

    public boolean hasAnyGratuityEventFor(ExecutionYear executionYear) {
        for (GratuityEvent gratuityEvent : this.getGratuityEventsSet()) {
            if (!gratuityEvent.isFor(executionYear)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyGratuitySituationFor(ExecutionYear executionYear) {
        for (GratuitySituation gratuitySituation : this.getGratuitySituationsSet()) {
            if (gratuitySituation.getGratuityValues().getExecutionDegree().getExecutionYear() != executionYear) continue;
            return true;
        }
        return false;
    }

    public void setEvaluationsForCurriculumValidation(List<List<MarkSheetEnrolmentEvaluationBean>> list) {
        Object object = advice$setEvaluationsForCurriculumValidation.perform((Callable)new StudentCurricularPlan$callable$setEvaluationsForCurriculumValidation(this, list));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$setEvaluationsForCurriculumValidation(StudentCurricularPlan this_, List enrolmentEvaluationsBeanList) {
        for (List evaluationsList : enrolmentEvaluationsBeanList) {
            this_.setIndividualEvaluationsForCurriculumValidation(evaluationsList);
        }
    }

    private List<MarkSheetEnrolmentEvaluationBean> setIndividualEvaluationsForCurriculumValidation(List<MarkSheetEnrolmentEvaluationBean> enrolmentEvaluationsBeanList) {
        if (enrolmentEvaluationsBeanList.size() > 0) {
            Enrolment enrolmentForWeightSet = enrolmentEvaluationsBeanList.iterator().next().getEnrolment();
            enrolmentForWeightSet.setWeigth(enrolmentEvaluationsBeanList.iterator().next().getWeight());
        }
        for (MarkSheetEnrolmentEvaluationBean enrolmentEvaluationBean : enrolmentEvaluationsBeanList) {
            Enrolment enrolment = enrolmentEvaluationBean.getEnrolment();
            EnrolmentEvaluation enrolmentEvaluation = enrolmentEvaluationBean.getLatestEnrolmentEvaluation();
            if (StringUtils.isEmpty((String)enrolmentEvaluationBean.getGradeValue())) {
                enrolmentEvaluationBean.setEnrolmentEvaluationSet(Boolean.FALSE);
                continue;
            }
            enrolmentEvaluation = enrolment.addNewEnrolmentEvaluation(EnrolmentEvaluationState.TEMPORARY_OBJ, enrolmentEvaluationBean.getEvaluationSeason(), AccessControl.getPerson(), enrolmentEvaluationBean.getGradeValue(), new Date(), enrolmentEvaluationBean.getEvaluationDate(), enrolmentEvaluationBean.getExecutionSemester(), enrolmentEvaluationBean.getBookReference(), enrolmentEvaluationBean.getPage(), enrolmentEvaluationBean.getGradeScale());
            enrolmentEvaluation.confirmSubmission(AccessControl.getPerson(), BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"message.curriculum.validation.observation", (String[])new String[0]));
            enrolmentEvaluationBean.setEnrolmentEvaluationSet(Boolean.TRUE);
        }
        return enrolmentEvaluationsBeanList;
    }

    public void editEndStageDate(LocalDate localDate) {
        Object object = advice$editEndStageDate.perform((Callable)new StudentCurricularPlan$callable$editEndStageDate(this, localDate));
    }

    static /* synthetic */ void advised$editEndStageDate(StudentCurricularPlan this_, LocalDate date) {
        this_.setEndStageDate(date);
    }

    public Set<BranchCurriculumGroup> getBranchCurriculumGroups() {
        return this.getRoot().getBranchCurriculumGroups();
    }

    public Set<BranchCurriculumGroup> getMajorBranchCurriculumGroups() {
        return this.getRoot().getMajorBranchCurriculumGroups();
    }

    public Set<BranchCurriculumGroup> getMinorBranchCurriculumGroups() {
        return this.getRoot().getMinorBranchCurriculumGroups();
    }

    public Double getApprovedEctsCredits() {
        return this.getRoot().getAprovedEctsCredits();
    }

    public Double getApprovedEctsCredits(CycleType cycleType) {
        CycleCurriculumGroup cycle = this.getCycle(cycleType);
        return cycle != null ? cycle.getAprovedEctsCredits() : 0.0;
    }

    public Double getApprovedEctsCreditsForFirstCycle(CycleType cycleType) {
        return this.getApprovedEctsCredits(CycleType.FIRST_CYCLE);
    }

    public Double getApprovedEctsCreditsForSecondCycle(CycleType cycleType) {
        return this.getApprovedEctsCredits(CycleType.SECOND_CYCLE);
    }

    @Deprecated
    public Date getStartDate() {
        YearMonthDay ymd = this.getStartDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setStartDate(Date date) {
        if (date == null) {
            this.setStartDateYearMonthDay(null);
        } else {
            this.setStartDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getWhen() {
        DateTime dt = this.getWhenDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setWhen(Date date) {
        if (date == null) {
            this.setWhenDateTime(null);
        } else {
            this.setWhenDateTime(new DateTime(date.getTime()));
        }
    }

    public boolean isAllowedToDelete() {
        Set plans = this.getRegistration().getStudentCurricularPlansSet();
        return this.isAllowedToManageEnrolments() && plans.size() > 1;
    }

    public boolean isAllowedToManageEnrolments() {
        return AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.STUDENT_ENROLMENTS, (AcademicProgram)((Object)this.getDegree()), Authenticate.getUser());
    }

    public boolean isAllowedToManageAccountingEvents() {
        return AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.MANAGE_ACCOUNTING_EVENTS, (AcademicProgram)((Object)this.getDegree()), Authenticate.getUser());
    }

    public boolean isInCandidateEnrolmentProcess(ExecutionYear executionYear) {
        StudentCandidacy studentCandidacy = this.getRegistration().getStudentCandidacy();
        return studentCandidacy != null && studentCandidacy.getExecutionYear() == executionYear && studentCandidacy.getActiveCandidacySituationType() == CandidacySituationType.STAND_BY;
    }

    static {
        advice$enrol = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$removeCurriculumModulesFromNoCourseGroupCurriculumGroup = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$setEvaluationsForCurriculumValidation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$editEndStageDate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_STUDENT_NUMBER = new Comparator<StudentCurricularPlan>(){

            @Override
            public int compare(StudentCurricularPlan o1, StudentCurricularPlan o2) {
                return o1.getStudent().getNumber().compareTo(o2.getStudent().getNumber());
            }
        };
        STUDENT_CURRICULAR_PLAN_COMPARATOR_BY_DEGREE_TYPE_AND_DEGREE_NAME = new Comparator<StudentCurricularPlan>(){

            @Override
            public int compare(StudentCurricularPlan o1, StudentCurricularPlan o2) {
                Degree degree1 = o1.getDegree();
                Degree degree2 = o2.getDegree();
                int ct = degree1.getDegreeType().compareTo(degree2.getDegreeType());
                return ct == 0 ? degree1.getName().compareTo(degree2.getName()) : ct;
            }
        };
        STUDENT_CURRICULAR_PLAN_COMPARATOR_BY_DEGREE_DEGREE_NAME_AND_STUDENT_NUMBER_AND_NAME = new Comparator<StudentCurricularPlan>(){

            @Override
            public int compare(StudentCurricularPlan o1, StudentCurricularPlan o2) {
                int cd = o1.getDegree().getName().compareTo(o2.getDegree().getName());
                if (cd != 0) {
                    return cd;
                }
                int cn = o1.getStudent().getNumber().compareTo(o2.getStudent().getNumber());
                return cn == 0 ? o1.getPerson().getName().compareTo(o2.getPerson().getName()) : cn;
            }
        };
        COMPARATOR_BY_DEGREE_TYPE = new Comparator<StudentCurricularPlan>(){

            @Override
            public int compare(StudentCurricularPlan studentCurricularPlan1, StudentCurricularPlan studentCurricularPlan2) {
                DegreeType degreeType1 = studentCurricularPlan1.getDegreeType();
                DegreeType degreeType2 = studentCurricularPlan2.getDegreeType();
                return degreeType1.compareTo(degreeType2);
            }
        };
        STUDENT_CURRICULAR_PLAN_COMPARATOR_BY_START_DATE = new Comparator<StudentCurricularPlan>(){

            @Override
            public int compare(StudentCurricularPlan o1, StudentCurricularPlan o2) {
                return o1.getStartDateYearMonthDay().compareTo((ReadablePartial)o2.getStartDateYearMonthDay());
            }
        };
        DATE_COMPARATOR = new Comparator<StudentCurricularPlan>(){

            @Override
            public int compare(StudentCurricularPlan leftState, StudentCurricularPlan rightState) {
                int comparationResult = leftState.getStartDateYearMonthDay().compareTo((ReadablePartial)rightState.getStartDateYearMonthDay());
                return comparationResult == 0 ? leftState.getExternalId().compareTo(rightState.getExternalId()) : comparationResult;
            }
        };
        COMPARATOR_BY_STUDENT_IST_ID = new Comparator<StudentCurricularPlan>(){

            @Override
            public int compare(StudentCurricularPlan redSCP, StudentCurricularPlan blueSCP) {
                return redSCP.getPerson().getUsername() == null ? -1 : (blueSCP.getPerson().getUsername() == null ? 1 : redSCP.getPerson().getUsername().compareTo(blueSCP.getPerson().getUsername()));
            }
        };
    }
}

