/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.teacher;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisParticipationType;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.thesis.ConfirmThesisDocumentSubmission;
import org.fenixedu.academic.ui.struts.action.commons.AbstractManageThesisDA;
import org.fenixedu.academic.ui.struts.action.coordinator.thesis.ThesisPresentationState;
import org.fenixedu.academic.ui.struts.action.teacher.TeacherApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=TeacherApplication.TeacherFinalWorkApp.class, path="document-confirmation", titleKey="link.manage.thesis.document.confirmation")
@Mapping(module="teacher", path="/thesisDocumentConfirmation")
@Forwards(value={@Forward(name="viewThesis", path="/teacher/viewThesis.jsp"), @Forward(name="viewOperationsThesis", path="/student/thesis/viewOperationsThesis.jsp"), @Forward(name="showThesisList", path="/teacher/showThesisList.jsp")})
public class ThesisDocumentConfirmationDA
extends AbstractManageThesisDA {
    @EntryPoint
    public ActionForward showThesisList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Person person = AccessControl.getPerson();
        if (person != null) {
            ThesisPresentationWrapperSet orientedTheses = new ThesisPresentationWrapperSet(person, ThesisParticipationType.ORIENTATOR);
            request.setAttribute("orientedTheses", (Object)orientedTheses);
            ThesisPresentationWrapperSet coorientedTheses = new ThesisPresentationWrapperSet(person, ThesisParticipationType.COORIENTATOR);
            request.setAttribute("coorientedTheses", (Object)coorientedTheses);
        }
        return mapping.findForward("showThesisList");
    }

    public ActionForward viewThesis(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String thesisIdString = request.getParameter("thesisID");
        Thesis thesis = (Thesis)FenixFramework.getDomainObject((String)thesisIdString);
        request.setAttribute("thesis", (Object)thesis);
        ThesisPresentationState thesisPresentationState = ThesisPresentationState.getThesisPresentationState(thesis);
        request.setAttribute("thesisPresentationState", (Object)thesisPresentationState);
        return mapping.findForward("viewThesis");
    }

    public ActionForward showConfirmationPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("showConfirmationPage", (Object)Boolean.TRUE);
        return this.viewThesis(mapping, form, request, response);
    }

    public ActionForward confirmDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        String thesisIdString = request.getParameter("thesisID");
        Thesis thesis = (Thesis)FenixFramework.getDomainObject((String)thesisIdString);
        ConfirmThesisDocumentSubmission.run(thesis);
        request.setAttribute("documentsConfirmed", (Object)Boolean.TRUE);
        return this.viewThesis(mapping, form, request, response);
    }

    protected Teacher getLoggedTeacher() {
        Person person = AccessControl.getPerson();
        if (person != null) {
            Teacher teacher = person.getTeacher();
            return teacher;
        }
        return null;
    }

    @Override
    public ActionForward editProposal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        throw new Error("this.cannot.be.called.here");
    }

    public static class ThesisPresentationWrapperSet
    extends TreeSet<ThesisPresentationWrapper> {
        public ThesisPresentationWrapperSet(Collection<Thesis> theses) {
            super(ThesisPresentationWrapper.COMPARATOR_BY_STUDENT);
            for (Thesis thesis : theses) {
                this.add(new ThesisPresentationWrapper(thesis));
            }
        }

        public ThesisPresentationWrapperSet(Person person, ThesisParticipationType thesisParticipationType) {
            this((Collection<Thesis>)Thesis.getThesesByParticipationType(person, thesisParticipationType));
        }
    }

    public static class ThesisPresentationWrapper {
        public static final Comparator<ThesisPresentationWrapper> COMPARATOR_BY_STUDENT = new Comparator<ThesisPresentationWrapper>(){

            @Override
            public int compare(ThesisPresentationWrapper t1, ThesisPresentationWrapper t2) {
                return Thesis.COMPARATOR_BY_STUDENT.compare(t1.getThesis(), t2.getThesis());
            }
        };
        protected final Thesis thesis;
        protected final ThesisPresentationState thesisPresentationState;

        public ThesisPresentationWrapper(Thesis thesis) {
            this.thesis = thesis;
            this.thesisPresentationState = ThesisPresentationState.getThesisPresentationState(thesis);
        }

        public Thesis getThesis() {
            return this.thesis;
        }

        public ThesisPresentationState getThesisPresentationState() {
            return this.thesisPresentationState;
        }

        public boolean isUnexisting() {
            return this.thesisPresentationState.isUnexisting();
        }

        public boolean isDraft() {
            return this.thesisPresentationState.isDraft();
        }

        public boolean isSubmitted() {
            return this.thesisPresentationState.isSubmitted();
        }

        public boolean isRejected() {
            return this.thesisPresentationState.isRejected();
        }

        public boolean isApproved() {
            return this.thesisPresentationState.isApproved();
        }

        public boolean isDocumentsSubmitted() {
            return this.thesisPresentationState.isDocumentsSubmitted();
        }

        public boolean isDocumentsConfirmed() {
            return this.thesisPresentationState.isDocumentsConfirmed();
        }

        public boolean isConfirmed() {
            return this.thesisPresentationState.isConfirmed();
        }

        public boolean isEvaluated1st() {
            return this.thesisPresentationState.isEvaluated1st();
        }

        public boolean isEvaluated() {
            return this.thesisPresentationState.isEvaluated();
        }

        public boolean isUnknown() {
            return this.thesisPresentationState.isUnknown();
        }
    }
}

