/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student.enrollment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeCurricularPlanEquivalencePlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academic.dto.ShiftToEnrol;
import org.fenixedu.academic.service.filter.enrollment.ClassEnrollmentAuthorizationFilter;
import org.fenixedu.academic.service.services.enrollment.shift.ReadShiftsToEnroll;
import org.fenixedu.academic.service.services.enrollment.shift.UnEnrollStudentFromShift;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.student.StudentApplication;
import org.fenixedu.academic.ui.struts.config.FenixDomainExceptionHandler;
import org.fenixedu.academic.ui.struts.config.FenixErrorExceptionHandler;
import org.fenixedu.academic.util.ExecutionDegreesFormat;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.struts.annotations.ExceptionHandling;
import org.fenixedu.bennu.struts.annotations.Exceptions;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=StudentApplication.StudentEnrollApp.class, path="shift-enrollment", titleKey="link.shift.enrolment")
@Mapping(module="student", path="/studentShiftEnrollmentManager", input="/studentShiftEnrollmentManager.do?method=prepare", formBean="studentShiftEnrollmentForm", validate=false)
@Forwards(value={@Forward(name="showEnrollmentPage", path="/student/studentShiftEnrollmentManagerLookup.do?method=proceedToShiftEnrolment"), @Forward(name="chooseRegistration", path="/student/enrollment/shifts/chooseRegistration.jsp"), @Forward(name="showShiftsEnrollment", path="/student/enrollment/showShiftsEnrollment.jsp"), @Forward(name="prepareEnrollmentViewWarning", path="/student/enrollment/prepareEnrollmentViewWarning.jsp"), @Forward(name="selectCourses", path="/student/enrollment/showCoursesByDegree.jsp"), @Forward(name="shiftEnrollmentCannotProceed", path="/student/enrollment/bolonha/shiftEnrollmentCannotProceed.jsp")})
@Exceptions(value={@ExceptionHandling(type=ClassEnrollmentAuthorizationFilter.CurrentClassesEnrolmentPeriodUndefinedForDegreeCurricularPlan.class, key="error.message.CurrentClassesEnrolmentPeriodUndefinedForDegreeCurricularPlan", handler=FenixErrorExceptionHandler.class, scope="request"), @ExceptionHandling(type=DomainException.class, handler=FenixDomainExceptionHandler.class, scope="request"), @ExceptionHandling(type=ClassEnrollmentAuthorizationFilter.OutsideOfCurrentClassesEnrolmentPeriodForDegreeCurricularPlan.class, key="error.message.OutsideOfCurrentClassesEnrolmentPeriodForDegreeCurricularPlan", handler=FenixErrorExceptionHandler.class, scope="request")})
public class ShiftStudentEnrollmentManagerDispatchAction
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Student student = ShiftStudentEnrollmentManagerDispatchAction.getUserView(request).getPerson().getStudent();
        List<Registration> toEnrol = student.getRegistrationsToEnrolInShiftByStudent();
        if (toEnrol.size() == 1) {
            request.setAttribute("registrationOID", (Object)toEnrol.iterator().next().getExternalId());
            return this.prepareStartViewWarning(mapping, form, request, response);
        }
        request.setAttribute("toEnrol", toEnrol);
        return mapping.findForward("chooseRegistration");
    }

    private Registration getAndSetRegistration(HttpServletRequest request) {
        String registrationOID = (String)request.getAttribute("registrationOID");
        if (StringUtils.isEmpty((String)registrationOID)) {
            registrationOID = request.getParameter("registrationOID");
        }
        Registration registration = (Registration)FenixFramework.getDomainObject((String)registrationOID);
        if (!ShiftStudentEnrollmentManagerDispatchAction.getUserView(request).getPerson().getStudent().getRegistrationsToEnrolInShiftByStudent().contains((Object)registration)) {
            return null;
        }
        request.setAttribute("registration", (Object)registration);
        request.setAttribute("registrationOID", (Object)registration.getExternalId().toString());
        return registration;
    }

    public ActionForward prepareStartViewWarning(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String executionSemesterID = (String)this.getFromRequest(request, "executionSemesterID");
        if (!StringUtils.isEmpty((String)executionSemesterID)) {
            request.setAttribute("executionSemesterID", (Object)executionSemesterID);
        } else {
            request.setAttribute("executionSemesterID", (Object)ExecutionSemester.readActualExecutionSemester().getExternalId());
        }
        if (this.getAndSetRegistration(request) == null) {
            this.addActionMessage(request, "errors.impossible.operation");
            return mapping.getInputForward();
        }
        return mapping.findForward("prepareEnrollmentViewWarning");
    }

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.generateToken(request);
        this.saveToken(request);
        return this.prepareShiftEnrollment(mapping, form, request, response);
    }

    public ActionForward prepareShiftEnrollment(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Registration registration = this.getAndSetRegistration(request);
        if (registration == null) {
            this.addActionMessage(request, "errors.impossible.operation");
            return mapping.getInputForward();
        }
        String classID = request.getParameter("classId");
        if (classID != null) {
            request.setAttribute("classId", (Object)classID);
            return mapping.findForward("showEnrollmentPage");
        }
        ExecutionSemester executionSemester = (ExecutionSemester)this.getDomainObject(request, "executionSemesterID");
        request.setAttribute("executionSemesterID", (Object)executionSemester.getExternalId());
        if (this.readAndSetSelectCoursesParameter(request) == null) {
            return this.prepareShiftEnrolmentInformation(mapping, request, registration, executionSemester);
        }
        return this.prepareSelectCoursesInformation(mapping, actionForm, request, registration, executionSemester);
    }

    private ActionForward prepareSelectCoursesInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, Registration registration, ExecutionSemester executionSemester) {
        DynaActionForm form = (DynaActionForm)actionForm;
        List<ExecutionDegree> executionDegrees = executionSemester.getExecutionYear().getExecutionDegreesFor(DegreeType::isPreBolonhaDegree);
        executionDegrees.addAll(executionSemester.getExecutionYear().getExecutionDegreesFor(DegreeType::isBolonhaDegree));
        executionDegrees.addAll(executionSemester.getExecutionYear().getExecutionDegreesFor(DegreeType::isIntegratedMasterDegree));
        executionDegrees.addAll(executionSemester.getExecutionYear().getExecutionDegreesFor(DegreeType::isBolonhaMasterDegree));
        if (executionDegrees.isEmpty()) {
            this.addActionMessage(request, "errors.impossible.operation");
            return mapping.getInputForward();
        }
        ExecutionDegree selectedExecutionDegree = this.getSelectedExecutionDegree(form, registration, executionSemester, executionDegrees);
        if (selectedExecutionDegree == null) {
            this.addActionMessage(request, "errors.impossible.operation");
            return mapping.getInputForward();
        }
        request.setAttribute("selectedExecutionDegree", (Object)selectedExecutionDegree);
        form.set("degree", (Object)selectedExecutionDegree.getExternalId());
        this.sortExecutionDegreesByDegreeName(executionDegrees);
        request.setAttribute("executionDegrees", ExecutionDegreesFormat.buildLabelValueBeansForExecutionDegree(executionDegrees));
        request.setAttribute("attendingExecutionCourses", registration.getAttendingExecutionCoursesFor(executionSemester));
        request.setAttribute("executionCoursesFromExecutionDegree", selectedExecutionDegree.getDegreeCurricularPlan().getExecutionCoursesByExecutionPeriod(executionSemester));
        return mapping.findForward("selectCourses");
    }

    private void sortExecutionDegreesByDegreeName(List<ExecutionDegree> result) {
        Collections.sort(result, ExecutionDegree.COMPARATOR_BY_DEGREE_NAME);
    }

    private ActionForward prepareShiftEnrolmentInformation(ActionMapping mapping, HttpServletRequest request, Registration registration, ExecutionSemester executionSemester) throws FenixServiceException {
        List shiftsToEnrol;
        try {
            if (TreasuryBridgeAPIFactory.implementation().isAcademicalActsBlocked(registration.getPerson(), new LocalDate())) {
                this.addActionMessage(request, "error.StudentCurricularPlan.cannot.enrol.with.debts.for.previous.execution.years");
                return mapping.getInputForward();
            }
            shiftsToEnrol = ReadShiftsToEnroll.runReadShiftsToEnroll(registration, executionSemester);
        }
        catch (ClassEnrollmentAuthorizationFilter.OutsideOfCurrentClassesEnrolmentPeriodForDegreeCurricularPlan exception) {
            this.addActionMessage(request, "error.enrollment.period.closed", exception.getArgs());
            return mapping.getInputForward();
        }
        catch (FenixServiceException exception) {
            this.addActionMessage(request, exception.getMessage());
            return mapping.getInputForward();
        }
        catch (DomainException de) {
            this.addActionMessage(request, de.getLocalizedMessage(), false);
            return mapping.getInputForward();
        }
        request.setAttribute("numberOfExecutionCoursesHavingNotEnroledShifts", (Object)registration.getNumberOfExecutionCoursesHavingNotEnroledShiftsFor(executionSemester));
        request.setAttribute("shiftsToEnrolFromEnroledExecutionCourses", this.getShiftsToEnrolByEnroledState(shiftsToEnrol, true));
        request.setAttribute("shiftsToEnrolFromUnenroledExecutionCourses", this.getShiftsToEnrolByEnroledState(shiftsToEnrol, false));
        List<Shift> studentShifts = registration.getShiftsFor(executionSemester);
        request.setAttribute("studentShifts", studentShifts);
        this.sortStudentShifts(studentShifts);
        this.addSelectableSemesters(request, registration);
        return mapping.findForward("showShiftsEnrollment");
    }

    private void addSelectableSemesters(HttpServletRequest request, Registration registration) {
        List openedEnrolmentPeriodsSemesters = registration.getLastDegreeCurricularPlan().getEnrolmentPeriodsSet().stream().filter(ep -> ep.isValid() && ep.isForClasses()).map(ep -> ep.getExecutionPeriod()).sorted(ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR).collect(Collectors.toList());
        if (openedEnrolmentPeriodsSemesters.size() > 1) {
            request.setAttribute("openedEnrolmentPeriodsSemesters", openedEnrolmentPeriodsSemesters);
        }
    }

    private void sortStudentShifts(List<Shift> studentShifts) {
        Collections.sort(studentShifts, Shift.SHIFT_COMPARATOR_BY_TYPE_AND_ORDERED_LESSONS);
    }

    private List<ShiftToEnrol> getShiftsToEnrolByEnroledState(List<ShiftToEnrol> shiftsToEnrol, boolean enroled) {
        ArrayList<ShiftToEnrol> result = new ArrayList<ShiftToEnrol>();
        for (ShiftToEnrol shiftToEnrol : shiftsToEnrol) {
            if (shiftToEnrol.isEnrolled() != enroled) continue;
            result.add(shiftToEnrol);
        }
        return result;
    }

    private ExecutionDegree getSelectedExecutionDegree(DynaActionForm form, Registration registration, ExecutionSemester executionSemester, List<ExecutionDegree> executionDegrees) {
        ExecutionDegree executionDegreeChosen;
        String executionDegreeIdChosen = (String)form.get("degree");
        ExecutionDegree executionDegree = executionDegreeChosen = !StringUtils.isEmpty((String)executionDegreeIdChosen) ? (ExecutionDegree)FenixFramework.getDomainObject((String)executionDegreeIdChosen) : null;
        if (executionDegreeChosen != null && executionDegreeChosen.getExecutionYear() == executionSemester.getExecutionYear()) {
            return executionDegreeChosen;
        }
        return this.searchForExecutionDegreeInStudent(registration, executionSemester);
    }

    private ExecutionDegree searchForExecutionDegreeInStudent(Registration registration, ExecutionSemester executionSemester) {
        StudentCurricularPlan studentCurricularPlan = registration.getActiveStudentCurricularPlan();
        if (studentCurricularPlan == null) {
            return null;
        }
        for (ExecutionDegree executionDegree : studentCurricularPlan.getDegreeCurricularPlan().getExecutionDegreesSet()) {
            if (executionDegree.getExecutionYear() != executionSemester.getExecutionYear()) continue;
            return executionDegree;
        }
        for (DegreeCurricularPlan degreeCurricularPlan : studentCurricularPlan.getDegree().getDegreeCurricularPlansSet()) {
            for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
                if (executionDegree.getExecutionYear() != executionSemester.getExecutionYear()) continue;
                return executionDegree;
            }
        }
        for (DegreeCurricularPlanEquivalencePlan equivalencePlan : studentCurricularPlan.getDegreeCurricularPlan().getTargetEquivalencePlansSet()) {
            DegreeCurricularPlan otherDegreeCurricularPlan = equivalencePlan.getDegreeCurricularPlan();
            for (ExecutionDegree executionDegree : otherDegreeCurricularPlan.getExecutionDegreesSet()) {
                if (executionDegree.getExecutionYear() != executionSemester.getExecutionYear()) continue;
                return executionDegree;
            }
        }
        return null;
    }

    private String readAndSetSelectCoursesParameter(HttpServletRequest request) {
        String selectCourses = request.getParameter("selectCourses");
        if (selectCourses != null) {
            request.setAttribute("selectCourses", (Object)selectCourses);
        }
        return selectCourses;
    }

    public ActionForward unEnroleStudentFromShift(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Registration registration = this.getAndSetRegistration(request);
        if (registration == null) {
            this.addActionMessage(request, "errors.impossible.operation");
            return mapping.getInputForward();
        }
        String shiftId = request.getParameter("shiftId");
        String executionCourseID = request.getParameter("executionCourseID");
        if (!StringUtils.isEmpty((String)executionCourseID)) {
            request.setAttribute("executionCourseID", (Object)executionCourseID);
        }
        try {
            UnEnrollStudentFromShift.runUnEnrollStudentFromShift(registration, shiftId, (ExecutionSemester)this.getDomainObject(request, "executionSemesterID"));
        }
        catch (FenixServiceException e) {
            throw new FenixActionException(e);
        }
        return this.start(mapping, form, request, response);
    }
}

