/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student.administrativeOfficeServices;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentSigner;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;
import org.fenixedu.academic.service.factoryExecutors.DocumentRequestCreator;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.student.administrativeOfficeServices.DocumentRequestDispatchAction$callable$processConcludeAndDeliver;
import org.fenixedu.academic.ui.struts.action.student.administrativeOfficeServices.DocumentRequestDispatchAction$callable$resetDocumentSigner;
import org.fenixedu.academic.ui.struts.action.student.administrativeOfficeServices.StudentAcademicOfficeServices;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=StudentAcademicOfficeServices.class, path="create-document-request", titleKey="documents.requirement")
@Mapping(module="student", path="/documentRequest", formBean="documentRequestCreateForm")
@Forwards(value={@Forward(name="createDocumentRequests", path="/student/administrativeOfficeServices/documentRequest/createDocumentRequests.jsp"), @Forward(name="createSuccess", path="/student/administrativeOfficeServices/documentRequest/createSuccess.jsp"), @Forward(name="printDocument", path="/student/administrativeOfficeServices/documentRequest/printDocument.jsp"), @Forward(name="viewDocumentRequestsToCreate", path="/student/administrativeOfficeServices/documentRequest/viewDocumentRequestsToCreate.jsp"), @Forward(name="chooseRegistration", path="/student/administrativeOfficeServices/documentRequest/chooseRegistration.jsp")})
public class DocumentRequestDispatchAction
extends FenixDispatchAction {
    public static final Advice advice$processConcludeAndDeliver = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$resetDocumentSigner = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @EntryPoint
    public ActionForward chooseRegistration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("registrations", this.getLoggedPerson(request).getStudent().getRegistrationsSet());
        return mapping.findForward("chooseRegistration");
    }

    public ActionForward prepare(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("documentRequestCreateBean", (Object)new DocumentRequestCreator(this.getRegistration(request, actionForm)));
        return mapping.findForward("createDocumentRequests");
    }

    private Registration getRegistration(HttpServletRequest request, ActionForm actionForm) {
        String registrationId = this.getStringFromRequest(request, "registrationId");
        if (registrationId == null) {
            registrationId = ((DynaActionForm)actionForm).getString("registrationId");
        }
        return (Registration)FenixFramework.getDomainObject((String)registrationId);
    }

    public ActionForward prepareCreateDocumentRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("documentRequestCreateBean", (Object)new DocumentRequestCreator(this.getRegistration(request, actionForm)));
        return mapping.findForward("createDocumentRequests");
    }

    public ActionForward documentRequestTypeInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DocumentRequestCreateBean requestCreateBean = (DocumentRequestCreateBean)RenderUtils.getViewState().getMetaObject().getObject();
        this.setAdditionalInformationSchemaName(request, requestCreateBean);
        request.setAttribute("documentRequestCreateBean", (Object)requestCreateBean);
        return mapping.findForward("createDocumentRequests");
    }

    public ActionForward documentRequestTypeChosenPostBack(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DocumentRequestCreateBean requestCreateBean = (DocumentRequestCreateBean)RenderUtils.getViewState().getMetaObject().getObject();
        RenderUtils.invalidateViewState();
        this.setAdditionalInformationSchemaName(request, requestCreateBean);
        request.setAttribute("documentRequestCreateBean", (Object)requestCreateBean);
        return mapping.findForward("createDocumentRequests");
    }

    private void setAdditionalInformationSchemaName(HttpServletRequest request, DocumentRequestCreateBean requestCreateBean) {
        if (requestCreateBean.getHasAdditionalInformation()) {
            ServiceRequestType serviceRequestType = requestCreateBean.getChosenServiceRequestType();
            request.setAttribute("additionalInformationSchemaName", (Object)("DocumentRequestCreateBean." + serviceRequestType.getCode() + ".AdditionalInformation"));
        }
    }

    public ActionForward viewDocumentRequestToCreate(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DocumentRequestCreateBean requestCreateBean = (DocumentRequestCreateBean)RenderUtils.getViewState().getMetaObject().getObject();
        this.setAdditionalInformationSchemaName(request, requestCreateBean);
        request.setAttribute("documentRequestCreateBean", (Object)requestCreateBean);
        return mapping.findForward("viewDocumentRequestsToCreate");
    }

    public ActionForward create(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        AcademicServiceRequest documentRequest = null;
        try {
            documentRequest = (AcademicServiceRequest)this.executeFactoryMethod();
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
            return this.viewDocumentRequestToCreate(mapping, actionForm, request, response);
        }
        if (documentRequest.getServiceRequestType().isPayable()) {
            return mapping.findForward("createSuccess");
        }
        request.setAttribute("documentRequest", (Object)documentRequest);
        this.processConcludeAndDeliver(documentRequest);
        return mapping.findForward("printDocument");
    }

    public ActionForward printDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException, FenixServiceException {
        DocumentRequest documentRequest = (DocumentRequest)FenixFramework.getDomainObject((String)request.getParameter("documentRequestId"));
        this.resetDocumentSigner(documentRequest);
        byte[] data = documentRequest.generateDocument();
        response.setContentLength(data.length);
        response.setContentType("application/pdf");
        response.addHeader("Content-Disposition", "attachment; filename=" + documentRequest.getReportFileName() + ".pdf");
        ServletOutputStream writer = response.getOutputStream();
        writer.write(data);
        writer.flush();
        writer.close();
        response.flushBuffer();
        return null;
    }

    private void processConcludeAndDeliver(AcademicServiceRequest academicServiceRequest) {
        Object object = advice$processConcludeAndDeliver.perform((Callable)new DocumentRequestDispatchAction$callable$processConcludeAndDeliver(this, academicServiceRequest));
    }

    static /* synthetic */ void advised$processConcludeAndDeliver(DocumentRequestDispatchAction this_, AcademicServiceRequest documentRequest) {
        documentRequest.process();
        documentRequest.concludeServiceRequest();
        documentRequest.delivered();
    }

    private void resetDocumentSigner(DocumentRequest documentRequest) {
        Object object = advice$resetDocumentSigner.perform((Callable)new DocumentRequestDispatchAction$callable$resetDocumentSigner(this, documentRequest));
    }

    static /* synthetic */ void advised$resetDocumentSigner(DocumentRequestDispatchAction this_, DocumentRequest documentRequest) {
        documentRequest.setDocumentSigner(DocumentSigner.findDefaultDocumentSignature());
    }
}

