/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.person;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Photograph;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.dto.person.PhotographUploadBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.fileManager.UploadOwnPhoto;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.person.UpdateEmergencyContactDA;
import org.fenixedu.academic.ui.struts.action.person.VisualizePersonalInfo;
import org.fenixedu.academic.util.ContentType;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.joda.time.DateTime;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(module="person", path="/uploadPhoto", functionality=VisualizePersonalInfo.class)
@Forwards(value={@Forward(name="visualizePersonalInformation", path="/person/visualizePersonalInfo.jsp"), @Forward(name="confirm", path="/person/uploadPhoto.jsp"), @Forward(name="upload", path="/person/uploadPhoto.jsp")})
public class UploadPhotoDA
extends FenixDispatchAction {
    private static final int MAX_RAW_SIZE = 1000000;

    public ActionForward togglePhotoAvailability(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        boolean availability = Boolean.parseBoolean(request.getParameter("available"));
        this.atomic(() -> Authenticate.getUser().getPerson().setPhotoAvailable(availability));
        request.setAttribute("personBean", (Object)new PersonBean(AccessControl.getPerson()));
        request.setAttribute("emergencyContactBean", (Object)new UpdateEmergencyContactDA.EmergencyContactBean(AccessControl.getPerson()));
        return mapping.findForward("visualizePersonalInformation");
    }

    public ActionForward prepare(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("photo", (Object)new PhotographUploadBean());
        request.setAttribute("phroperCaption", (Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)"phroper.caption", (String[])new String[0]));
        request.setAttribute("phroperSubCaption", (Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)"phroper.subCaption", (String[])new String[0]));
        request.setAttribute("phroperButtonCaption", (Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)"phroper.buttonCaption", (String[])new String[0]));
        request.setAttribute("phroperLoadingCaption", (Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)"phroper.loadingCaption", (String[])new String[0]));
        request.setAttribute("buttonClean", (Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)"button.clean", (String[])new String[0]));
        request.setAttribute("buttonRevert", (Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)"button.phroper.revert", (String[])new String[0]));
        return mapping.findForward("upload");
    }

    public ActionForward upload(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PhotographUploadBean photo = (PhotographUploadBean)this.getRenderedObject();
        RenderUtils.invalidateViewState();
        String base64Thumbnail = request.getParameter("encodedThumbnail");
        String base64Image = request.getParameter("encodedPicture");
        if (base64Image != null && base64Thumbnail != null) {
            DateTime now = new DateTime();
            photo.setFilename("mylovelypic_" + now.getYear() + now.getMonthOfYear() + now.getDayOfMonth() + now.getHourOfDay() + now.getMinuteOfDay() + now.getSecondOfMinute() + ".png");
            photo.setBase64RawContent(base64Image.split(",")[1]);
            photo.setBase64RawThumbnail(base64Thumbnail.split(",")[1]);
            photo.setContentType(base64Image.split(",")[0].split(":")[1].split(";")[0]);
        }
        ActionMessages actionMessages = new ActionMessages();
        try (InputStream stream = photo.getFileInputStream();){
            if (stream == null) {
                actionMessages.add("fileRequired", new ActionMessage("errors.fileRequired"));
                this.saveMessages(request, actionMessages);
                ActionForward actionForward = this.prepare(mapping, actionForm, request, response);
                return actionForward;
            }
        }
        if (ContentType.getContentType(photo.getContentType()) == null) {
            actionMessages.add("fileUnsupported", new ActionMessage("errors.unsupportedFile"));
            this.saveMessages(request, actionMessages);
            return this.prepare(mapping, actionForm, request, response);
        }
        if (photo.getRawSize() > 1000000) {
            actionMessages.add("fileTooLarge", new ActionMessage("errors.fileTooLarge"));
            this.saveMessages(request, actionMessages);
            photo.deleteTemporaryFiles();
            return this.prepare(mapping, actionForm, request, response);
        }
        try {
            photo.processImage();
        }
        catch (PhotographUploadBean.UnableToProcessTheImage e) {
            actionMessages.add("unableToProcessImage", new ActionMessage("errors.unableToProcessImage"));
            this.saveMessages(request, actionMessages);
            photo.deleteTemporaryFiles();
            return this.prepare(mapping, actionForm, request, response);
        }
        photo.createTemporaryFiles();
        request.setAttribute("preview", (Object)true);
        request.setAttribute("photo", (Object)photo);
        return mapping.findForward("confirm");
    }

    public ActionForward save(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PhotographUploadBean photo = (PhotographUploadBean)this.getRenderedObject();
        RenderUtils.invalidateViewState();
        try (InputStream stream = photo.getFileInputStream();){
            UploadOwnPhoto.run(ByteStreams.toByteArray((InputStream)stream), ContentType.getContentType(photo.getContentType()));
        }
        Person person = Authenticate.getUser().getPerson();
        request.setAttribute("personBean", (Object)new PersonBean(person));
        UpdateEmergencyContactDA.EmergencyContactBean emergencyContactBean = new UpdateEmergencyContactDA.EmergencyContactBean(person);
        request.setAttribute("emergencyContactBean", (Object)emergencyContactBean);
        return mapping.findForward("visualizePersonalInformation");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("personBean", (Object)new PersonBean(AccessControl.getPerson()));
        request.setAttribute("emergencyContactBean", (Object)new UpdateEmergencyContactDA.EmergencyContactBean(AccessControl.getPerson()));
        return mapping.findForward("visualizePersonalInformation");
    }

    public ActionForward cancelSubmission(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Photograph photo = AccessControl.getPerson().getPersonalPhotoEvenIfRejected();
        if (photo != null) {
            photo.cancelSubmission();
        }
        request.setAttribute("personBean", (Object)new PersonBean(AccessControl.getPerson()));
        request.setAttribute("emergencyContactBean", (Object)new UpdateEmergencyContactDA.EmergencyContactBean(AccessControl.getPerson()));
        return mapping.findForward("visualizePersonalInformation");
    }

    public ActionForward backToShowInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("personBean", (Object)new PersonBean(AccessControl.getPerson()));
        request.setAttribute("emergencyContactBean", (Object)new UpdateEmergencyContactDA.EmergencyContactBean(AccessControl.getPerson()));
        return mapping.findForward("visualizePersonalInformation");
    }
}

