/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.candidacy.degreeChange;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.degreeChange.DegreeChangeCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.degreeChange.DegreeChangeIndividualCandidacyProcess;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.DegreeChangeCandidacyPeriod;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.candidacy.CandidacyProcessDA;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.fenixedu.commons.spreadsheet.StyledExcelSpreadsheet;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminCandidaciesApp.class, path="degree-change", titleKey="label.candidacy.degreeChange", accessGroup="(academic(MANAGE_CANDIDACY_PROCESSES) | academic(MANAGE_INDIVIDUAL_CANDIDACIES))", bundle="ApplicationResources")
@Mapping(path="/caseHandlingDegreeChangeCandidacyProcess", module="academicAdministration", formBeanClass=CandidacyProcessDA.CandidacyProcessForm.class)
@Forwards(value={@Forward(name="intro", path="/candidacy/mainCandidacyProcess.jsp"), @Forward(name="prepare-create-new-process", path="/candidacy/createCandidacyPeriod.jsp"), @Forward(name="prepare-edit-candidacy-period", path="/candidacy/editCandidacyPeriod.jsp"), @Forward(name="send-to-coordinator", path="/candidacy/sendToCoordinator.jsp"), @Forward(name="send-to-scientificCouncil", path="/candidacy/sendToScientificCouncil.jsp"), @Forward(name="view-candidacy-results", path="/candidacy/degreeChange/viewCandidacyResults.jsp"), @Forward(name="introduce-candidacy-results", path="/candidacy/degreeChange/introduceCandidacyResults.jsp"), @Forward(name="create-registrations", path="/candidacy/createRegistrations.jsp"), @Forward(name="prepare-select-available-degrees", path="/candidacy/selectAvailableDegrees.jsp")})
public class DegreeChangeCandidacyProcessDA
extends CandidacyProcessDA {
    private static final int MAX_GRADE_VALUE = 20;

    @Override
    protected Class getProcessType() {
        return DegreeChangeCandidacyProcess.class;
    }

    @Override
    protected Class getCandidacyPeriodType() {
        return DegreeChangeCandidacyPeriod.class;
    }

    @Override
    protected Class getChildProcessType() {
        return DegreeChangeIndividualCandidacyProcess.class;
    }

    @Override
    protected CandidacyProcess getCandidacyProcess(HttpServletRequest request, ExecutionInterval executionInterval) {
        return executionInterval.hasDegreeChangeCandidacyPeriod() ? executionInterval.getDegreeChangeCandidacyPeriod().getDegreeChangeCandidacyProcess() : null;
    }

    protected DegreeChangeCandidacyProcess getProcess(HttpServletRequest request) {
        return (DegreeChangeCandidacyProcess)((Object)super.getProcess(request));
    }

    @Override
    protected ActionForward introForward(ActionMapping mapping) {
        return mapping.findForward("intro");
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setChooseDegreeBean(request);
        return super.execute(mapping, actionForm, request, response);
    }

    private void setChooseDegreeBean(HttpServletRequest request) {
        CandidacyProcessDA.ChooseDegreeBean chooseDegreeBean = (CandidacyProcessDA.ChooseDegreeBean)this.getObjectFromViewState("choose.degree.bean");
        if (chooseDegreeBean == null) {
            chooseDegreeBean = new CandidacyProcessDA.ChooseDegreeBean();
        }
        request.setAttribute("chooseDegreeBean", (Object)chooseDegreeBean);
    }

    private CandidacyProcessDA.ChooseDegreeBean getChooseDegreeBean(HttpServletRequest request) {
        return (CandidacyProcessDA.ChooseDegreeBean)request.getAttribute("chooseDegreeBean");
    }

    @Override
    public ActionForward listProcessAllowedActivities(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)this.getProcess(request)));
        this.setCandidacyProcessInformation(form, (CandidacyProcess)((Object)this.getProcess(request)));
        return this.introForward(mapping);
    }

    protected void setCandidacyProcessInformation(ActionForm actionForm, CandidacyProcess process2) {
        CandidacyProcessDA.CandidacyProcessForm form = (CandidacyProcessDA.CandidacyProcessForm)actionForm;
        form.setExecutionIntervalId(process2.getCandidacyExecutionInterval().getExternalId());
    }

    @Override
    protected void setStartInformation(ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        if (!this.hasExecutionInterval(request)) {
            List<ExecutionInterval> executionIntervals = ExecutionInterval.readExecutionIntervalsWithCandidacyPeriod(this.getCandidacyPeriodType());
            if (executionIntervals.size() == 1) {
                this.setCandidacyProcessInformation(request, this.getCandidacyProcess(request, executionIntervals.iterator().next()));
            } else {
                request.setAttribute("canCreateProcess", this.canCreateProcess(this.getProcessType().getName()));
                request.setAttribute("executionIntervals", executionIntervals);
            }
        } else {
            this.setCandidacyProcessInformation(request, this.getCandidacyProcess(request, this.getExecutionInterval(request)));
        }
    }

    public ActionForward prepareExecuteSendToCoordinator(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("send-to-coordinator");
    }

    public ActionForward executeSendToCoordinator(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "SendToCoordinator");
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            return this.prepareExecuteSendToCoordinator(mapping, actionForm, request, response);
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    public ActionForward prepareExecuteSendToScientificCouncil(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("send-to-scientificCouncil");
    }

    public ActionForward executeSendToScientificCouncil(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "SendToScientificCouncil");
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            return this.prepareExecuteSendToScientificCouncil(mapping, actionForm, request, response);
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    public ActionForward prepareExecutePrintCandidaciesFromInstitutionDegrees(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.degreeChange.institution.report.filename", (String[])new String[0]) + ".xls");
        this.writeReportForInstitutionDegrees(this.getProcess(request), response.getOutputStream());
        response.getOutputStream().flush();
        response.flushBuffer();
        return null;
    }

    private void writeReportForInstitutionDegrees(DegreeChangeCandidacyProcess process2, ServletOutputStream outputStream) throws IOException {
        StyledExcelSpreadsheet excelSpreadsheet = new StyledExcelSpreadsheet();
        for (Map.Entry<Degree, SortedSet<DegreeChangeIndividualCandidacyProcess>> entry : process2.getValidInstitutionIndividualCandidacyProcessesByDegree().entrySet()) {
            this.createSpreadsheet(excelSpreadsheet, entry.getKey(), entry.getValue());
        }
        excelSpreadsheet.getWorkbook().write((OutputStream)outputStream);
    }

    public ActionForward prepareExecutePrintCandidaciesFromExternalDegrees(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.degreeChange.external.report.filename", (String[])new String[0]) + ".xls");
        this.writeReportForExternalDegrees(this.getProcess(request), response.getOutputStream());
        response.getOutputStream().flush();
        response.flushBuffer();
        return null;
    }

    private void writeReportForExternalDegrees(DegreeChangeCandidacyProcess process2, ServletOutputStream outputStream) throws IOException {
        StyledExcelSpreadsheet excelSpreadsheet = new StyledExcelSpreadsheet();
        for (Map.Entry<Degree, SortedSet<DegreeChangeIndividualCandidacyProcess>> entry : process2.getValidExternalIndividualCandidacyProcessesByDegree().entrySet()) {
            this.createSpreadsheet(excelSpreadsheet, entry.getKey(), entry.getValue());
        }
        excelSpreadsheet.getWorkbook().write((OutputStream)outputStream);
    }

    private void createSpreadsheet(StyledExcelSpreadsheet excelSpreadsheet, Degree degree, SortedSet<DegreeChangeIndividualCandidacyProcess> candidacies) {
        excelSpreadsheet.getSheet(degree.getSigla());
        this.createHeader(excelSpreadsheet, degree);
        this.createBody(excelSpreadsheet, candidacies);
    }

    private void createBody(StyledExcelSpreadsheet excelSpreadsheet, SortedSet<DegreeChangeIndividualCandidacyProcess> candidacies) {
        for (DegreeChangeIndividualCandidacyProcess process2 : candidacies) {
            if (!process2.canExecuteActivity(Authenticate.getUser())) continue;
            excelSpreadsheet.newRow();
            if (process2.hasCandidacyStudent()) {
                excelSpreadsheet.addCell((Object)process2.getCandidacyStudent().getNumber());
            } else {
                excelSpreadsheet.addCell((Object)"-");
            }
            excelSpreadsheet.addCell((Object)process2.getPersonalDetails().getName());
            PrecedentDegreeInformation information = process2.getPrecedentDegreeInformation();
            excelSpreadsheet.addCell((Object)information.getDegreeAndInstitutionName());
            excelSpreadsheet.addCell((Object)this.getValue(process2.getCandidacyAffinity()));
            excelSpreadsheet.addCell((Object)this.getValue(process2.getCandidacyDegreeNature()));
            excelSpreadsheet.addCell((Object)this.getValue(information.getNumberOfApprovedCurricularCourses()));
            excelSpreadsheet.addCell((Object)this.getValue(information.getGradeSum()));
            excelSpreadsheet.addCell((Object)this.getValue(information.getApprovedEcts()));
            excelSpreadsheet.addCell((Object)this.getValue(information.getEnroledEcts()));
            excelSpreadsheet.addCell((Object)this.getValue(this.calculateA(process2, true)));
            excelSpreadsheet.addCell((Object)this.getValue(this.calculateB(process2, true)));
            excelSpreadsheet.addCell((Object)this.getValue(this.calculateC(process2)));
            if (process2.isCandidacyAccepted() || process2.isCandidacyRejected()) {
                excelSpreadsheet.addCell((Object)BundleUtil.getString((String)"resources.EnumerationResources", (String)process2.getCandidacyState().getQualifiedName(), (String[])new String[0]).toUpperCase());
                continue;
            }
            excelSpreadsheet.addCell((Object)"");
        }
    }

    private String getValue(Object value) {
        return value != null ? value.toString() : "";
    }

    private String getValue(BigDecimal value) {
        return value != null ? value.toPlainString() : "";
    }

    private BigDecimal calculateA(DegreeChangeIndividualCandidacyProcess process2, boolean setScale) {
        if (process2.getCandidacyApprovedEctsRate() != null) {
            return process2.getCandidacyApprovedEctsRate();
        }
        BigDecimal approvedEcts = process2.getPrecedentDegreeInformation().getApprovedEcts();
        BigDecimal enroledEcts = process2.getPrecedentDegreeInformation().getEnroledEcts();
        if (approvedEcts != null && enroledEcts != null && enroledEcts.signum() > 0) {
            BigDecimal result = approvedEcts.divide(enroledEcts, MathContext.DECIMAL32);
            return setScale ? result.setScale(2, RoundingMode.HALF_EVEN) : result;
        }
        return null;
    }

    private BigDecimal calculateB(DegreeChangeIndividualCandidacyProcess process2, boolean setScale) {
        if (process2.getCandidacyGradeRate() != null) {
            return process2.getCandidacyGradeRate();
        }
        Integer total = process2.getPrecedentDegreeInformation().getNumberOfApprovedCurricularCourses();
        BigDecimal gradeSum = process2.getPrecedentDegreeInformation().getGradeSum();
        if (gradeSum != null && total != null && total != 0) {
            BigDecimal result = gradeSum.divide(new BigDecimal(total * 20), MathContext.DECIMAL32);
            return setScale ? result.setScale(2, RoundingMode.HALF_EVEN) : result;
        }
        return null;
    }

    private BigDecimal calculateC(DegreeChangeIndividualCandidacyProcess process2) {
        if (process2.getCandidacySeriesCandidacyGrade() != null) {
            return process2.getCandidacySeriesCandidacyGrade().setScale(2, RoundingMode.HALF_EVEN);
        }
        BigDecimal affinity = process2.getCandidacyAffinity();
        Integer nature = process2.getCandidacyDegreeNature();
        BigDecimal valueA = this.calculateA(process2, false);
        BigDecimal valueB = this.calculateB(process2, false);
        if (valueA != null && valueB != null && affinity != null && nature != null) {
            BigDecimal value03 = new BigDecimal("0.3");
            BigDecimal aff = new BigDecimal(affinity.toString()).multiply(new BigDecimal("0.4"), MathContext.DECIMAL32);
            BigDecimal nat = new BigDecimal(nature).multiply(value03).divide(new BigDecimal(5), MathContext.DECIMAL32);
            BigDecimal abp = valueA.add(valueB).multiply(value03).divide(new BigDecimal(2), MathContext.DECIMAL32);
            return aff.add(nat).add(abp).multiply(new BigDecimal(200)).setScale(2, RoundingMode.HALF_EVEN);
        }
        return null;
    }

    public String getString(String key) {
        return BundleUtil.getString((String)"resources.ApplicationResources", (String)key, (String[])new String[0]);
    }

    private void createHeader(StyledExcelSpreadsheet spreadsheet, Degree degree) {
        spreadsheet.newHeaderRow();
        spreadsheet.addCell((Object)degree.getName(), spreadsheet.getExcelStyle().getTitleStyle());
        spreadsheet.newHeaderRow();
        spreadsheet.newHeaderRow();
        spreadsheet.addHeader(this.getString("label.candidacy.identification"));
        spreadsheet.addHeader(2, this.getString("label.candidacy.degree.and.school"));
        spreadsheet.addHeader(this.getString("label.candidacy.affinity"));
        spreadsheet.addHeader(this.getString("label.candidacy.degreeNature"));
        spreadsheet.addHeader(this.getString("label.candidacy.concludedUCs"));
        spreadsheet.addHeader(8, "");
        spreadsheet.addHeader(this.getString("label.candidacy.approvedEctsRate"));
        spreadsheet.addHeader(this.getString("label.candidacy.gradeRate"));
        spreadsheet.addHeader(this.getString("label.candidacy.degreeChange.seriesCandidacyGrade"));
        spreadsheet.addHeader(this.getString("label.candidacy.result"));
        spreadsheet.newHeaderRow();
        spreadsheet.addHeader(this.getString("label.number"));
        spreadsheet.addHeader(this.getString("label.name"));
        spreadsheet.addHeader(5, this.getString("label.number"));
        spreadsheet.addHeader(this.getString("label.candidacy.gradeSum.abbr"));
        spreadsheet.addHeader(this.getString("label.candidacy.approvedEcts"));
        spreadsheet.addHeader(this.getString("label.candidacy.enroledEcts"));
        spreadsheet.getSheet().addMergedRegion((org.apache.poi.ss.util.Region)new Region(2, 0, 2, 1));
        spreadsheet.getSheet().addMergedRegion((org.apache.poi.ss.util.Region)new Region(2, 2, 3, 2));
        spreadsheet.getSheet().addMergedRegion((org.apache.poi.ss.util.Region)new Region(2, 3, 3, 3));
        spreadsheet.getSheet().addMergedRegion((org.apache.poi.ss.util.Region)new Region(2, 4, 3, 4));
        spreadsheet.getSheet().addMergedRegion((org.apache.poi.ss.util.Region)new Region(2, 5, 2, 7));
        spreadsheet.getSheet().addMergedRegion((org.apache.poi.ss.util.Region)new Region(2, 9, 3, 9));
        spreadsheet.getSheet().addMergedRegion((org.apache.poi.ss.util.Region)new Region(2, 10, 3, 10));
        spreadsheet.getSheet().addMergedRegion((org.apache.poi.ss.util.Region)new Region(2, 11, 3, 11));
        spreadsheet.getSheet().addMergedRegion((org.apache.poi.ss.util.Region)new Region(2, 12, 3, 12));
    }

    @Override
    protected List<CandidacyProcessDA.CandidacyDegreeBean> createCandidacyDegreeBeans(HttpServletRequest request) {
        ArrayList<CandidacyProcessDA.CandidacyDegreeBean> result = new ArrayList<CandidacyProcessDA.CandidacyDegreeBean>();
        for (DegreeChangeIndividualCandidacyProcess child : this.getProcess(request).getAcceptedDegreeChangeIndividualCandidacyProcesses()) {
            result.add(new DegreeChangeCandidacyDegreeBean(child));
        }
        return result;
    }

    @Override
    protected List<Object> getCandidacyHeader() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.processCode", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.name", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.identificationType", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.identificationNumber", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.nationality", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.precedent.institution", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.actual.degree.designation", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.selected.degree", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.state", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.verified", (String[])new String[0]));
        return result;
    }

    @Override
    protected Spreadsheet buildIndividualCandidacyReport(Spreadsheet spreadsheet, IndividualCandidacyProcess individualCandidacyProcess) {
        DegreeChangeIndividualCandidacyProcess degreeChangeIndividualCandidacyProcess = (DegreeChangeIndividualCandidacyProcess)((Object)individualCandidacyProcess);
        Spreadsheet.Row row = spreadsheet.addRow();
        row.setCell(degreeChangeIndividualCandidacyProcess.getProcessCode());
        row.setCell(degreeChangeIndividualCandidacyProcess.getPersonalDetails().getName());
        row.setCell(degreeChangeIndividualCandidacyProcess.getPersonalDetails().getIdDocumentType().getLocalizedName());
        row.setCell(degreeChangeIndividualCandidacyProcess.getPersonalDetails().getDocumentIdNumber());
        row.setCell(degreeChangeIndividualCandidacyProcess.getPersonalDetails().getCountry().getCountryNationality().getContent());
        row.setCell(degreeChangeIndividualCandidacyProcess.getPrecedentDegreeInformation().getPrecedentInstitution().getName());
        row.setCell(degreeChangeIndividualCandidacyProcess.getPrecedentDegreeInformation().getPrecedentDegreeDesignation());
        row.setCell(degreeChangeIndividualCandidacyProcess.getCandidacy().getSelectedDegree().getName());
        row.setCell(BundleUtil.getString((String)"resources.EnumerationResources", (String)individualCandidacyProcess.getCandidacyState().getQualifiedName(), (String[])new String[0]));
        row.setCell(BundleUtil.getString((String)"resources.CandidateResources", (String)(degreeChangeIndividualCandidacyProcess.getProcessChecked() != null && degreeChangeIndividualCandidacyProcess.getProcessChecked() != false ? this.MESSAGE_YES : this.MESSAGE_NO), (String[])new String[0]));
        return spreadsheet;
    }

    @Override
    protected Predicate<IndividualCandidacyProcess> getChildProcessSelectionPredicate(CandidacyProcess process2, HttpServletRequest request) {
        final Degree selectedDegree = this.getChooseDegreeBean(request).getDegree();
        if (selectedDegree == null) {
            return Predicates.alwaysTrue();
        }
        return new Predicate<IndividualCandidacyProcess>(){

            public boolean apply(IndividualCandidacyProcess process2) {
                return ((DegreeChangeIndividualCandidacyProcess)((Object)process2)).getCandidacy().getSelectedDegree() == selectedDegree;
            }
        };
    }

    public static class DegreeChangeCandidacyDegreeBean
    extends CandidacyProcessDA.CandidacyDegreeBean {
        DegreeChangeCandidacyDegreeBean(DegreeChangeIndividualCandidacyProcess process2) {
            this.setPersonalDetails(process2.getPersonalDetails());
            this.setDegree(process2.getCandidacySelectedDegree());
            this.setState(process2.getCandidacyState());
            this.setRegistrationCreated(process2.hasRegistrationForCandidacy());
        }
    }
}

