/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.scholarship.utl.report;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.scholarship.utl.report.ReportStudentsUTLCandidates;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.scholarship.utl.report.ReportStudentsUTLCandidatesBean;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.scholarship.utl.report.ReportStudentsUTLCandidatesForFirstYear;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.scholarship.utl.report.ReportStudentsUTLCandidatesForOneStudent;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.scholarship.utl.report.ReportStudentsUTLCandidatesForOneStudentFirstYear;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.scholarship.utl.report.StudentLine;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminScholarshipsApp.class, path="report-students-utl", titleKey="label.academicAdminOffice.scholarship.utl.report", accessGroup="academic(REPORT_STUDENTS_UTL_CANDIDATES)")
@Mapping(path="/reportStudentsUTLCandidates", module="academicAdministration")
@Forwards(value={@Forward(name="prepare", path="/academicAdminOffice/scholarship/utl/report/prepare.jsp"), @Forward(name="showReport", path="/academicAdminOffice/scholarship/utl/report/showReport.jsp"), @Forward(name="viewDetails", path="/academicAdminOffice/scholarship/utl/report/viewDetails.jsp"), @Forward(name="prepareForOneStudent", path="/academicAdminOffice/scholarship/utl/report/prepareForOneStudent.jsp")})
public class ReportStudentsUTLCandidatesDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ReportStudentsUTLCandidatesBean bean = new ReportStudentsUTLCandidatesBean();
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("prepare");
    }

    public ActionForward showReport(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ReportStudentsUTLCandidatesBean bean = (ReportStudentsUTLCandidatesBean)this.getRenderedObject("bean");
        if (bean == null || bean.getXlsFile() == null) {
            return this.prepare(mapping, actionForm, request, response);
        }
        POIFSFileSystem fs = new POIFSFileSystem(bean.getXlsFile());
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        if (sheet == null) {
            this.addErrorMessage(request, "error", "error.academicAdminOffice.scholarship.utl.report.invalid.spreadsheet", new String[0]);
            return this.prepare(mapping, actionForm, request, response);
        }
        ReportStudentsUTLCandidates report = null;
        report = bean.getForFirstYear() != false ? new ReportStudentsUTLCandidatesForFirstYear(bean.getExecutionYear(), sheet) : new ReportStudentsUTLCandidates(bean.getExecutionYear(), sheet);
        request.setAttribute("report", (Object)report);
        ArrayList<StudentLine> correctStudentLines = new ArrayList<StudentLine>();
        ArrayList<StudentLine> erroneousStudentLines = new ArrayList<StudentLine>();
        erroneousStudentLines.addAll(report.getErroneousStudentLines());
        for (StudentLine studentLine : report.getCorrectStudentLines()) {
            if (studentLine.isAbleToReadAllValues()) {
                correctStudentLines.add(studentLine);
                continue;
            }
            erroneousStudentLines.add(studentLine);
        }
        request.setAttribute("correctStudentLines", correctStudentLines);
        request.setAttribute("erroneousStudentLines", erroneousStudentLines);
        return mapping.findForward("showReport");
    }

    public ActionForward viewDetails(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("viewDetails");
    }

    public ActionForward exportReport(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ReportStudentsUTLCandidates report = (ReportStudentsUTLCandidates)this.getRenderedObject("report");
        HSSFWorkbook generateReport = report.generateReport();
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment; filename=bolsa_accao_social_utl.xls");
        generateReport.write((OutputStream)response.getOutputStream());
        response.getOutputStream().flush();
        response.flushBuffer();
        return null;
    }

    public ActionForward exportErrors(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ReportStudentsUTLCandidates report = (ReportStudentsUTLCandidates)this.getRenderedObject("report");
        HSSFWorkbook generateReport = report.generateErrors();
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment; filename=erros_bolsa_accao_social.xls");
        generateReport.write((OutputStream)response.getOutputStream());
        response.getOutputStream().flush();
        response.flushBuffer();
        return null;
    }

    public ActionForward prepareForOneStudent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ReportStudentsUTLCandidatesBean bean = new ReportStudentsUTLCandidatesBean();
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("prepareForOneStudent");
    }

    public ActionForward showReportForOneStudent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ReportStudentsUTLCandidatesBean bean = (ReportStudentsUTLCandidatesBean)this.getRenderedObject("bean");
        if (bean == null) {
            return this.prepareForOneStudent(mapping, form, request, response);
        }
        ReportStudentsUTLCandidatesForOneStudent report = null;
        report = bean.getForFirstYear() != false ? new ReportStudentsUTLCandidatesForOneStudentFirstYear(bean.getExecutionYear(), Student.readStudentByNumber(bean.getStudentNumber())) : new ReportStudentsUTLCandidatesForOneStudent(bean.getExecutionYear(), Student.readStudentByNumber(bean.getStudentNumber()));
        request.setAttribute("report", (Object)report);
        ArrayList<StudentLine> correctStudentLines = new ArrayList<StudentLine>();
        ArrayList<StudentLine> erroneousStudentLines = new ArrayList<StudentLine>();
        erroneousStudentLines.addAll(report.getErroneousStudentLines());
        for (StudentLine studentLine : report.getCorrectStudentLines()) {
            if (studentLine.isAbleToReadAllValues()) {
                correctStudentLines.add(studentLine);
                continue;
            }
            erroneousStudentLines.add(studentLine);
        }
        request.setAttribute("correctStudentLines", correctStudentLines);
        request.setAttribute("erroneousStudentLines", erroneousStudentLines);
        return mapping.findForward("showReport");
    }
}

