/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.manageservicerequesttypes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestCategory;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestTypeOption;
import org.fenixedu.academic.ui.spring.controller.AcademicAdministrationSpringApplication;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.i18n.LocalizedString;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=AcademicAdministrationSpringApplication.class, title="label.title.manageServiceRequestTypes", accessGroup="#managers")
@RequestMapping(value={"/academic/manageservicerequesttypes/servicerequesttype"})
public class ServiceRequestTypeController {
    private static final String BUNDLE = "resources.ApplicationResources";
    private static final String ERROR_MESSAGES = "errorMessages";
    private static final String WARNING_MESSAGES = "warningMessages";
    private static final String INFO_MESSAGES = "infoMessages";
    @Autowired
    protected HttpServletRequest request;

    @RequestMapping(method={RequestMethod.GET})
    public String home(Model model) {
        model.addAttribute("searchservicerequesttypeResultsDataSet", ServiceRequestType.findAll().collect(Collectors.toList()));
        return "redirect:/academic/manageservicerequesttypes/servicerequesttype/search";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(Model model) {
        model.addAttribute("searchservicerequesttypeResultsDataSet", ServiceRequestType.findAll().collect(Collectors.toList()));
        model.addAttribute("serviceRequestCategoryValues", (Object)ServiceRequestCategory.values());
        return "academic/manageservicerequesttypes/servicerequesttype/search";
    }

    @RequestMapping(value={"/search/view/{serviceRequestTypeId}"})
    public String processSearchToViewAction(@PathVariable(value="serviceRequestTypeId") ServiceRequestType serviceRequestType, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect("/academic/manageservicerequesttypes/servicerequesttype/read/" + serviceRequestType.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/search/delete/{serviceRequestTypeId}"}, method={RequestMethod.POST})
    public String processSearchToDeleteAction(@PathVariable(value="serviceRequestTypeId") ServiceRequestType serviceRequestType, Model model, RedirectAttributes redirectAttributes) {
        try {
            serviceRequestType.delete();
            this.addInfoMessage(BundleUtil.getString((String)BUNDLE, (String)"message.ServiceRequestType.removed.with.success", (String[])new String[0]), model);
        }
        catch (DomainException ex) {
            this.addErrorMessage(BundleUtil.getString((String)BUNDLE, (String)ex.getKey(), (String[])new String[0]), model);
        }
        return this.redirect("/academic/manageservicerequesttypes/servicerequesttype/", model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("serviceRequestCategoryValues", (Object)ServiceRequestCategory.values());
        return "academic/manageservicerequesttypes/servicerequesttype/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="code", required=true) String code, @RequestParam(value="name", required=true) LocalizedString name, @RequestParam(value="active", required=true) boolean active, @RequestParam(value="payable", required=true) boolean payable, @RequestParam(value="serviceRequestCategory", required=true) ServiceRequestCategory category, Model model, RedirectAttributes redirectAttributes) {
        try {
            ServiceRequestType serviceRequestType = ServiceRequestType.create(code, name, active, payable, category);
            return this.redirect("/academic/manageservicerequesttypes/servicerequesttype/read/" + serviceRequestType.getExternalId(), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(BundleUtil.getString((String)BUNDLE, (String)de.getKey(), (String[])new String[0]), model);
            return this.create(model);
        }
    }

    @RequestMapping(value={"/read/{serviceRequestTypeId}"})
    public String read(@PathVariable(value="serviceRequestTypeId") ServiceRequestType serviceRequestType, Model model) {
        model.addAttribute("serviceRequestType", (Object)serviceRequestType);
        model.addAttribute("serviceRequestTypeOptionList", (Object)Lists.newArrayList((Iterable)ServiceRequestTypeOption.findAll().collect(Collectors.toList())));
        return "academic/manageservicerequesttypes/servicerequesttype/read";
    }

    @RequestMapping(value={"/update/{serviceRequestTypeId}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="serviceRequestTypeId") ServiceRequestType serviceRequestType, Model model) {
        model.addAttribute("serviceRequestType", (Object)serviceRequestType);
        model.addAttribute("serviceRequestCategoryValues", (Object)ServiceRequestCategory.values());
        return "academic/manageservicerequesttypes/servicerequesttype/update";
    }

    @RequestMapping(value={"/update/{serviceRequestTypeId}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="serviceRequestTypeId") ServiceRequestType serviceRequestType, @RequestParam(value="code", required=true) String code, @RequestParam(value="name", required=true) LocalizedString name, @RequestParam(value="active", required=true) boolean active, @RequestParam(value="payable", required=true) boolean payable, @RequestParam(value="serviceRequestCategory", required=true) ServiceRequestCategory category, @RequestParam(value="numberOfUnitsLabel", required=false) LocalizedString numberOfUnitsLabel, Model model, RedirectAttributes redirectAttributes) {
        model.addAttribute("serviceRequestType", (Object)serviceRequestType);
        try {
            serviceRequestType.edit(code, name, active, payable, category, numberOfUnitsLabel);
            return this.redirect("/academic/manageservicerequesttypes/servicerequesttype/read/" + serviceRequestType.getExternalId(), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(BundleUtil.getString((String)BUNDLE, (String)de.getKey(), (String[])new String[0]), model);
            return this.update(serviceRequestType, model);
        }
    }

    private String redirectToReadRequestType(ServiceRequestType serviceRequestType, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect("/academic/manageservicerequesttypes/servicerequesttype/search/view/" + serviceRequestType.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/dissociateoption/{serviceRequestTypeId}/{serviceRequestTypeOptionId}"})
    public String dissociateOption(@PathVariable(value="serviceRequestTypeId") ServiceRequestType serviceRequestType, @PathVariable(value="serviceRequestTypeOptionId") ServiceRequestTypeOption serviceRequestTypeOption, Model model, RedirectAttributes redirectAttributes) {
        try {
            serviceRequestType.removeOption(serviceRequestTypeOption);
            this.addInfoMessage(BundleUtil.getString((String)BUNDLE, (String)"message.ServiceRequestTypeOption.dissociation.success", (String[])new String[0]), model);
        }
        catch (DomainException ex) {
            this.addErrorMessage(BundleUtil.getString((String)BUNDLE, (String)ex.getKey(), (String[])new String[0]), model);
        }
        return this.redirectToReadRequestType(serviceRequestType, model, redirectAttributes);
    }

    @RequestMapping(value={"/associateoption/{serviceRequestTypeId}/{serviceRequestTypeOptionId}"})
    public String associateOption(@PathVariable(value="serviceRequestTypeId") ServiceRequestType serviceRequestType, @PathVariable(value="serviceRequestTypeOptionId") ServiceRequestTypeOption serviceRequestTypeOption, Model model, RedirectAttributes redirectAttributes) {
        try {
            serviceRequestType.associateOption(serviceRequestTypeOption);
            this.addInfoMessage(BundleUtil.getString((String)BUNDLE, (String)"message.ServiceRequestTypeOption.association.success", (String[])new String[0]), model);
        }
        catch (DomainException de) {
            this.addErrorMessage(BundleUtil.getString((String)BUNDLE, (String)de.getKey(), (String[])new String[0]), model);
        }
        return this.redirectToReadRequestType(serviceRequestType, model, redirectAttributes);
    }

    protected void addInfoMessage(String message, Model model) {
        ((List)model.asMap().get(INFO_MESSAGES)).add(message);
    }

    protected void addWarningMessage(String message, Model model) {
        ((List)model.asMap().get(WARNING_MESSAGES)).add(message);
    }

    protected void addErrorMessage(String message, Model model) {
        ((List)model.asMap().get(ERROR_MESSAGES)).add(message);
    }

    protected void clearMessages(Model model) {
        model.addAttribute(INFO_MESSAGES, new ArrayList());
        model.addAttribute(WARNING_MESSAGES, new ArrayList());
        model.addAttribute(ERROR_MESSAGES, new ArrayList());
    }

    protected String redirect(String destinationAction, Model model, RedirectAttributes redirectAttributes) {
        if (model.containsAttribute(INFO_MESSAGES)) {
            redirectAttributes.addFlashAttribute(INFO_MESSAGES, model.asMap().get(INFO_MESSAGES));
        }
        if (model.containsAttribute(WARNING_MESSAGES)) {
            redirectAttributes.addFlashAttribute(WARNING_MESSAGES, model.asMap().get(WARNING_MESSAGES));
        }
        if (model.containsAttribute(ERROR_MESSAGES)) {
            redirectAttributes.addFlashAttribute(ERROR_MESSAGES, model.asMap().get(ERROR_MESSAGES));
        }
        return "redirect:" + destinationAction;
    }

    @ModelAttribute
    protected void addModelProperties(Model model) {
        if (!model.containsAttribute(INFO_MESSAGES)) {
            model.addAttribute(INFO_MESSAGES, new ArrayList());
        }
        if (!model.containsAttribute(WARNING_MESSAGES)) {
            model.addAttribute(WARNING_MESSAGES, new ArrayList());
        }
        if (!model.containsAttribute(ERROR_MESSAGES)) {
            model.addAttribute(ERROR_MESSAGES, new ArrayList());
        }
    }
}

