/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import java.util.List;
import org.fenixedu.academic.dto.PageContainerBean;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.CollectionRenderer;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.Renderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlHiddenField;
import pt.ist.fenixWebFramework.renderers.components.HtmlSimpleValueComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlSubmitButton;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlController;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlSubmitButtonController;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.components.state.ViewDestination;
import pt.ist.fenixWebFramework.renderers.contexts.PresentationContext;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderMode;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.DomainObject;

public class PagesRenderer
extends InputRenderer {
    private String subSchema;
    private String objectsPerPage;
    private String paged;
    private boolean pagedValue = true;
    private int defaultObjectsPerPage = 100;
    private String buttonLabel;
    private boolean key = true;
    private String bundle;
    private CollectionRenderer renderer = new CollectionRenderer();
    private PageContainerBean pageContainerBean;

    public HtmlComponent render(Object object, Class type) {
        PageContainerBean bean = (PageContainerBean)object;
        this.setPageContainerBean(bean);
        List<? extends DomainObject> objects = this.getPageObjects(bean.getObjects());
        Schema schema = RenderKit.getInstance().findSchema(this.getSubSchema());
        MetaObject listMetaObject = MetaObjectFactory.createObject(objects, (Schema)schema);
        PresentationContext context = this.getContext().createSubContext(listMetaObject);
        context.setRenderMode(RenderMode.OUTPUT);
        HtmlTable table = (HtmlTable)RenderKit.getInstance().renderUsing((Renderer)this.getRenderer(), context, objects, objects.getClass());
        return this.decorateTable(table, objects);
    }

    private List<? extends DomainObject> getPageObjects(List<? extends DomainObject> objects) {
        if (!this.pagedValue) {
            return this.getPageContainerBean().getAllObjects();
        }
        return this.getPageContainerBean().getPageByPageSize(this.getDefaultObjectsPerPage());
    }

    private HtmlComponent decorateTable(HtmlTable table, List<? extends DomainObject> objects) {
        MetaObject bean = this.getContext().getMetaObject();
        HtmlHiddenField page = new HtmlHiddenField();
        HtmlHiddenField selected = new HtmlHiddenField();
        page.setValue(this.getCurrentPage());
        page.bind(bean, "page");
        selected.bind(bean, "selected");
        selected.setConverter((Converter)new DomainObjectKeyConverter());
        HtmlBlockContainer container = new HtmlBlockContainer();
        container.addChild((HtmlComponent)page);
        container.addChild((HtmlComponent)selected);
        this.addPreviousNextButtons((HtmlContainer)container, page, "previous", "next");
        container.addChild((HtmlComponent)table);
        if (table.getHeader() != null) {
            for (HtmlTableRow row : table.getHeader().getRows()) {
                row.createCell("");
            }
        }
        String buttonText = this.getButtonText();
        int i = 0;
        for (HtmlTableRow row : table.getRows()) {
            HtmlTableCell cell = row.createCell();
            HtmlSubmitButton htmlSubmitButton = new HtmlSubmitButton();
            htmlSubmitButton.setName(this.getLocalName("select" + i));
            htmlSubmitButton.setText(buttonText);
            htmlSubmitButton.setController((HtmlController)new ButtonsController(MetaObjectFactory.createObject((Object)objects.get(i), null), (HtmlSimpleValueComponent)selected));
            cell.setBody((HtmlComponent)htmlSubmitButton);
            ++i;
        }
        this.addPreviousNextButtons((HtmlContainer)container, page, "previousAfter", "nextAfter");
        return container;
    }

    private void addPreviousNextButtons(HtmlContainer container, HtmlHiddenField page, String previousName, String nextName) {
        if (this.pagedValue && this.getPageContainerBean().getNumberOfPages(this.getDefaultObjectsPerPage()) > 0) {
            if (this.getPageContainerBean().hasPreviousPage(this.getDefaultObjectsPerPage())) {
                HtmlSubmitButton previousButton = new HtmlSubmitButton();
                previousButton.setText(RenderUtils.getResourceString((String)this.getBundle(), (String)"pages.button.previous"));
                previousButton.setName(this.getLocalName(previousName));
                previousButton.setController((HtmlController)new PreviousController((HtmlSimpleValueComponent)page));
                container.addChild((HtmlComponent)previousButton);
            }
            container.addChild((HtmlComponent)new HtmlText(this.getPageContainerBean().getPage() + " / " + this.getPageContainerBean().getNumberOfPages(this.getDefaultObjectsPerPage())));
            if (this.getPageContainerBean().hasNextPage(this.getDefaultObjectsPerPage())) {
                HtmlSubmitButton nextButton = new HtmlSubmitButton();
                nextButton.setText(RenderUtils.getResourceString((String)this.getBundle(), (String)"pages.button.next"));
                nextButton.setName(this.getLocalName(nextName));
                nextButton.setController((HtmlController)new NextController((HtmlSimpleValueComponent)page));
                container.addChild((HtmlComponent)nextButton);
            }
        }
    }

    private String getButtonText() {
        if (this.isKey()) {
            return RenderUtils.getResourceString((String)this.getBundle(), (String)this.getButtonLabel());
        }
        return this.getButtonLabel();
    }

    private String getLocalName(String string) {
        return this.getContext().getViewState().getId() + "renderers.page." + string;
    }

    private String getCurrentPage() {
        MetaObject metaObject = this.getContext().getMetaObject();
        PageContainerBean bean = (PageContainerBean)metaObject.getObject();
        return bean.getPage() == null ? null : bean.getPage().toString();
    }

    public String getSubSchema() {
        return this.subSchema;
    }

    public void setSubSchema(String subSchema) {
        this.subSchema = subSchema;
    }

    private Schema translateSchema(String name) {
        return RenderKit.getInstance().findSchema(name);
    }

    public String getClasses() {
        return this.renderer.getClasses();
    }

    public void setClasses(String classes) {
        this.renderer.setClasses(classes);
    }

    public String getColumnClasses() {
        return this.renderer.getColumnClasses();
    }

    public void setColumnClasses(String columnClasses) {
        this.renderer.setColumnClasses(columnClasses);
    }

    public String getHeaderClasses() {
        return this.renderer.getHeaderClasses();
    }

    public void setHeaderClasses(String headerClasses) {
        this.renderer.setHeaderClasses(headerClasses);
    }

    public String getRowClasses() {
        return this.renderer.getRowClasses();
    }

    public void setRowClasses(String rowClasses) {
        this.renderer.setRowClasses(rowClasses);
    }

    public String getStyle() {
        return this.renderer.getStyle();
    }

    public void setStyle(String style) {
        this.renderer.setStyle(style);
    }

    public String getObjectsPerPage() {
        return this.objectsPerPage;
    }

    public void setObjectsPerPage(String objectsPerPage) {
        this.objectsPerPage = objectsPerPage;
        if (objectsPerPage != null && objectsPerPage.length() != 0) {
            this.defaultObjectsPerPage = Integer.valueOf(objectsPerPage);
        }
    }

    private int getDefaultObjectsPerPage() {
        return this.defaultObjectsPerPage;
    }

    protected Layout getLayout(Object object, Class type) {
        return null;
    }

    public String getPaged() {
        return this.paged;
    }

    public void setPaged(String paged) {
        this.paged = paged;
        this.pagedValue = Boolean.valueOf(this.getPaged());
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getButtonLabel() {
        return this.buttonLabel;
    }

    public void setButtonLabel(String buttonLabel) {
        this.buttonLabel = buttonLabel;
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public PageContainerBean getPageContainerBean() {
        return this.pageContainerBean;
    }

    public void setPageContainerBean(PageContainerBean pageContainerBean) {
        this.pageContainerBean = pageContainerBean;
    }

    public CollectionRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(CollectionRenderer renderer) {
        this.renderer = renderer;
    }

    public static class ButtonsController
    extends HtmlSubmitButtonController {
        private final HtmlSimpleValueComponent component;
        private final MetaObject metaObject;

        public ButtonsController(MetaObject metaObject, HtmlSimpleValueComponent component) {
            this.component = component;
            this.metaObject = metaObject;
        }

        protected void buttonPressed(IViewState viewState, HtmlSubmitButton button) {
            viewState.setSkipUpdate(false);
            this.component.setValue(this.metaObject.getKey().toString());
        }
    }

    public static class NextController
    extends HtmlSubmitButtonController {
        private final HtmlSimpleValueComponent component;

        public NextController(HtmlSimpleValueComponent component) {
            this.component = component;
        }

        protected void buttonPressed(IViewState viewState, HtmlSubmitButton button) {
            viewState.setSkipUpdate(false);
            ViewDestination destination = viewState.getDestination("input");
            if (destination == null) {
                destination = viewState.getInputDestination();
            }
            viewState.setCurrentDestination(destination);
            Integer next = this.getCurrentValue() + 1;
            this.component.setValue(next.toString());
        }

        public int getCurrentValue() {
            String value = this.component.getValue();
            if (value == null) {
                return 0;
            }
            return Integer.parseInt(value);
        }
    }

    public static class PreviousController
    extends HtmlSubmitButtonController {
        private final HtmlSimpleValueComponent component;

        public PreviousController(HtmlSimpleValueComponent component) {
            this.component = component;
        }

        protected void buttonPressed(IViewState viewState, HtmlSubmitButton button) {
            viewState.setSkipUpdate(false);
            ViewDestination destination = viewState.getDestination("input");
            if (destination == null) {
                destination = viewState.getInputDestination();
            }
            viewState.setCurrentDestination(destination);
            Integer previous = this.getCurrentValue() - 1;
            this.component.setValue(previous.toString());
        }

        public int getCurrentValue() {
            String value = this.component.getValue();
            if (value == null) {
                return 0;
            }
            return Integer.parseInt(value);
        }
    }
}

