/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.GradeScale;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlMenu;
import pt.ist.fenixWebFramework.renderers.components.HtmlSimpleValueComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlTextInput;
import pt.ist.fenixWebFramework.renderers.components.Validatable;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlController;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;
import pt.ist.fenixWebFramework.renderers.validators.RequiredValidator;

public class GradeInputRenderer
extends InputRenderer {
    private boolean required = false;
    private Integer maxLength;
    private String size;

    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            public HtmlComponent createComponent(Object object, Class type) {
                Grade grade = (Grade)object;
                HtmlInlineContainer container = new HtmlInlineContainer();
                MetaSlot slot = (MetaSlot)GradeInputRenderer.this.getInputContext().getMetaObject();
                final HtmlGradeTextInput value = new HtmlGradeTextInput(GradeInputRenderer.this.isRequired());
                value.bind(slot);
                value.setMaxLength(GradeInputRenderer.this.getMaxLength());
                value.setSize(GradeInputRenderer.this.getSize());
                HtmlMenu menu = new HtmlMenu();
                menu.setName(slot.getKey().toString() + "_scale");
                menu.createDefaultOption(RenderUtils.getResourceString((String)"renderers.menu.default.title"));
                for (GradeScale scale : GradeScale.values()) {
                    menu.createOption(RenderUtils.getEnumString((Enum)scale)).setValue(scale.getName());
                }
                if (grade != null && !grade.isEmpty()) {
                    value.setValue(grade.getValue());
                    menu.setValue(grade.getGradeScale().getName());
                }
                menu.setController(new HtmlController(){

                    public void execute(IViewState viewState) {
                        HtmlSimpleValueComponent component = (HtmlSimpleValueComponent)this.getControlledComponent();
                        value.setConverter(new GradeConverter(component.getValue()));
                    }
                });
                container.addChild((HtmlComponent)value);
                container.addChild((HtmlComponent)menu);
                return container;
            }
        };
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    private static class HtmlGradeTextInput
    extends HtmlTextInput {
        public HtmlGradeTextInput(boolean required) {
            HtmlChainValidator htmlChainValidator = new HtmlChainValidator((Validatable)this);
            super.setChainValidator(htmlChainValidator);
            new HtmlGradeTextInputValidator(htmlChainValidator);
            if (required) {
                htmlChainValidator.addValidator((HtmlValidator)new RequiredValidator(htmlChainValidator));
            }
        }

        public void setChainValidator(HtmlChainValidator chainValidator) {
        }

        public void addValidator(HtmlValidator htmlValidator) {
        }

        private static class HtmlGradeTextInputValidator
        extends HtmlValidator {
            private Object[] arguments;

            public HtmlGradeTextInputValidator(HtmlChainValidator htmlChainValidator) {
                super(htmlChainValidator);
            }

            public Object[] getArguments() {
                return this.arguments;
            }

            public void setArguments(Object ... arguments) {
                this.arguments = arguments;
            }

            protected String getResourceMessage(String message) {
                return RenderUtils.getFormatedResourceString((String)message, (Object[])this.getArguments());
            }

            public void performValidation() {
                HtmlGradeTextInput htmlGradeTextInput = (HtmlGradeTextInput)this.getComponent();
                GradeConverter gradeConverter = (GradeConverter)htmlGradeTextInput.getConverter();
                GradeScale gradeScale = gradeConverter.getGradeScale();
                String value = this.getComponent().getValue().trim();
                if (value != null && value.length() > 0) {
                    if (gradeScale == null) {
                        this.setValid(false);
                        this.setMessage("renderers.validator.grade.no.grade.scale");
                    } else if (!gradeScale.belongsTo(value)) {
                        this.setValid(false);
                        this.setMessage("renderers.validator.grade.invalid.grade.value");
                        this.setArguments(value, RenderUtils.getEnumString((Enum)gradeScale));
                    }
                }
            }
        }
    }

    private static class GradeConverter
    extends Converter {
        private GradeScale gradeScale;

        public GradeConverter(String gradeScaleName) {
            if (gradeScaleName != null && gradeScaleName.length() > 0) {
                this.gradeScale = GradeScale.valueOf(gradeScaleName);
            }
        }

        public Object convert(Class type, Object value) {
            String gradeValue = (String)value;
            if (gradeValue == null || gradeValue.length() == 0) {
                return Grade.createEmptyGrade();
            }
            return Grade.createGrade(gradeValue, this.getGradeScale());
        }

        public GradeScale getGradeScale() {
            return this.gradeScale;
        }

        public void setGradeScale(GradeScale gradeScale) {
            this.gradeScale = gradeScale;
        }
    }
}

