/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.scientificCouncil.curricularPlans;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degree.degreeCurricularPlan.DegreeCurricularPlanState;
import org.fenixedu.academic.domain.degreeStructure.CurricularStage;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicYears;
import org.fenixedu.academic.dto.InfoExecutionYear;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.commons.ReadCurrentExecutionYear;
import org.fenixedu.academic.service.services.commons.ReadNotClosedExecutionYears;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.scientificCouncil.curricularPlans.CreateDegreeCurricularPlan;
import org.fenixedu.academic.service.services.scientificCouncil.curricularPlans.DeleteDegreeCurricularPlan;
import org.fenixedu.academic.service.services.scientificCouncil.curricularPlans.EditDegreeCurricularPlan;
import org.fenixedu.academic.ui.faces.bean.base.FenixBackingBean;
import org.fenixedu.academic.ui.faces.bean.scientificCouncil.curricularPlans.DegreeCurricularPlanManagementBackingBean$callable$addUserToGroup;
import org.fenixedu.academic.ui.faces.bean.scientificCouncil.curricularPlans.DegreeCurricularPlanManagementBackingBean$callable$removeUsersFromGroup;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DegreeCurricularPlanManagementBackingBean
extends FenixBackingBean {
    private static final String NO_SELECTION = "noSelection";
    private String degreeId;
    private String dcpId;
    private DegreeCurricularPlan dcp;
    private String name;
    private Boolean applyPreviousYearsEnrolmentRule;
    private String gradeScale;
    private String[] selectedGroupMembersToDelete;
    private String newGroupMember;
    private String durationTypeName;
    private List<SelectItem> durationTypes = null;
    public static final Advice advice$addUserToGroup = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$removeUsersFromGroup = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public String getAction() {
        return this.getAndHoldStringParameter("action");
    }

    public String getNewGroupMember() {
        return this.newGroupMember == null ? (this.newGroupMember = this.getAndHoldStringParameter("newGroupMember")) : this.newGroupMember;
    }

    public void setNewGroupMember(String newGroupMember) {
        this.newGroupMember = newGroupMember;
    }

    public String getDegreeId() {
        return this.degreeId == null ? (this.degreeId = this.getAndHoldStringParameter("degreeId")) : this.degreeId;
    }

    public String getDcpId() {
        if (this.dcp == null) {
            this.dcpId = this.getAndHoldStringParameter("dcpId") != null ? this.getAndHoldStringParameter("dcpId") : this.getAndHoldStringParameter("degreeCurricularPlanID");
        }
        return this.dcpId;
    }

    public void setDcpId(String dcpId) {
        this.dcpId = dcpId;
    }

    public DegreeCurricularPlan getDcp() {
        return this.dcp == null ? (this.dcp = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)this.getDcpId())) : this.dcp;
    }

    public void setDcp(DegreeCurricularPlan dcp) {
        this.dcp = dcp;
    }

    public List<String> getGroupMembersLabels() {
        return this.getGroupMembers().stream().map(SelectItem::getLabel).collect(Collectors.toList());
    }

    public List<SelectItem> getGroupMembers() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        Group curricularPlanMembersGroup = this.getDcp().getCurricularPlanMembersGroup();
        if (curricularPlanMembersGroup != null) {
            for (User user : curricularPlanMembersGroup.getMembers()) {
                result.add(new SelectItem((Object)user.getExternalId(), user.getPerson().getName() + " (" + user.getUsername() + ")"));
            }
        }
        return result;
    }

    public void addUserToGroup() {
        Object object = advice$addUserToGroup.perform((Callable)new DegreeCurricularPlanManagementBackingBean$callable$addUserToGroup(this));
    }

    static /* synthetic */ void advised$addUserToGroup(DegreeCurricularPlanManagementBackingBean this_) {
        User user;
        if (this_.getNewGroupMember() != null && (user = User.findByUsername((String)this_.getNewGroupMember())) != null) {
            Group group = this_.getDcp().getCurricularPlanMembersGroup();
            this_.getDcp().setCurricularPlanMembersGroup(group.grant(user));
            RoleType.grant(RoleType.BOLONHA_MANAGER, user);
        }
    }

    public void removeUsersFromGroup(ActionEvent actionEvent) {
        Object object = advice$removeUsersFromGroup.perform((Callable)new DegreeCurricularPlanManagementBackingBean$callable$removeUsersFromGroup(this, actionEvent));
    }

    static /* synthetic */ void advised$removeUsersFromGroup(DegreeCurricularPlanManagementBackingBean this_, ActionEvent event) {
        if (this_.selectedGroupMembersToDelete != null && this_.selectedGroupMembersToDelete.length > 0) {
            Group group = this_.getDcp().getCurricularPlanMembersGroup();
            for (String userExternalId : this_.selectedGroupMembersToDelete) {
                User user = (User)FenixFramework.getDomainObject((String)userExternalId);
                if (user == null) continue;
                group = group.revoke(user);
                this_.removeRoleIfNecessary(user);
            }
            this_.getDcp().setCurricularPlanMembersGroup(group);
        }
    }

    private boolean isUserMemberOfAnyCurricularPlanGroup(User user) {
        return Degree.readBolonhaDegrees().stream().flatMap(d -> d.getDegreeCurricularPlansSet().stream()).filter(dcp -> !dcp.equals((Object)this.getDcp())).anyMatch(dcp -> dcp.getCurricularPlanMembersGroup().isMember(user));
    }

    private boolean isUserMemberOfAnyDepartmentCompetenceCourseGroup(User user) {
        return Bennu.getInstance().getDepartmentsSet().stream().anyMatch(d -> d.getCompetenceCourseMembersGroup().isMember(user));
    }

    private void removeRoleIfNecessary(User user) {
        if (!this.isUserMemberOfAnyCurricularPlanGroup(user) && !this.isUserMemberOfAnyDepartmentCompetenceCourseGroup(user)) {
            RoleType.revoke(RoleType.BOLONHA_MANAGER, user);
        }
    }

    public String getName() {
        return this.name == null && this.getDcp() != null ? (this.name = this.getDcp().getName()) : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getApplyPreviousYearsEnrolmentRule() {
        return this.applyPreviousYearsEnrolmentRule == null && this.getDcp() != null ? (this.applyPreviousYearsEnrolmentRule = this.getDcp().getApplyPreviousYearsEnrolmentRule()) : this.applyPreviousYearsEnrolmentRule;
    }

    public void setApplyPreviousYearsEnrolmentRule(Boolean input) {
        this.applyPreviousYearsEnrolmentRule = input;
    }

    public String getCurricularStage() {
        if (this.getViewState().getAttribute("curricularStage") == null && this.getDcp() != null) {
            this.setCurricularStage(this.getDcp().getCurricularStage().getName());
        }
        return (String)this.getViewState().getAttribute("curricularStage");
    }

    public void setCurricularStage(String curricularStage) {
        this.getViewState().setAttribute("curricularStage", curricularStage);
    }

    public String getState() {
        if (this.getViewState().getAttribute("state") == null && this.getDcp() != null) {
            this.setState(this.getDcp().getState().getName());
        }
        return (String)this.getViewState().getAttribute("state");
    }

    public void setState(String state) {
        this.getViewState().setAttribute("state", state);
    }

    public String getGradeScale() {
        return this.gradeScale == null && this.getDcp() != null ? (this.gradeScale = this.getDcp().getGradeScale().getName()) : this.gradeScale;
    }

    public void setGradeScale(String gradeScale) {
        this.gradeScale = gradeScale;
    }

    public List<SelectItem> getGradeScales() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        result.add(new SelectItem((Object)NO_SELECTION, BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"choose", (String[])new String[0])));
        result.add(new SelectItem((Object)GradeScale.TYPE20.name(), BundleUtil.getString((String)"resources.EnumerationResources", (String)GradeScale.TYPE20.name(), (String[])new String[0])));
        result.add(new SelectItem((Object)GradeScale.TYPE5.name(), BundleUtil.getString((String)"resources.EnumerationResources", (String)GradeScale.TYPE5.name(), (String[])new String[0])));
        return result;
    }

    public String createCurricularPlan() {
        try {
            CreateDegreeCurricularPlan.run(this.getDegreeId(), this.name, null, this.getDuration());
        }
        catch (IllegalDataAccessException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.notAuthorized", (String[])new String[0]));
            return "curricularPlansManagement";
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)e.getMessage(), (String[])new String[0]));
            return "";
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getKey(), (String[])e.getArgs()));
            return "";
        }
        catch (Exception e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.creatingDegreeCurricularPlan", (String[])new String[0]));
            return "curricularPlansManagement";
        }
        this.addInfoMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"degreeCurricularPlan.created", (String[])new String[0]));
        return "curricularPlansManagement";
    }

    public List<SelectItem> getCurricularStages() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        if (this.getDcp().getExecutionDegreesSet().isEmpty()) {
            result.add(new SelectItem((Object)CurricularStage.DRAFT.name(), BundleUtil.getString((String)"resources.EnumerationResources", (String)CurricularStage.DRAFT.getName(), (String[])new String[0])));
        }
        result.add(new SelectItem((Object)CurricularStage.PUBLISHED.name(), BundleUtil.getString((String)"resources.EnumerationResources", (String)CurricularStage.PUBLISHED.getName(), (String[])new String[0])));
        result.add(new SelectItem((Object)CurricularStage.APPROVED.name(), BundleUtil.getString((String)"resources.EnumerationResources", (String)CurricularStage.APPROVED.getName(), (String[])new String[0])));
        return result;
    }

    public List<SelectItem> getStates() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        result.add(new SelectItem((Object)DegreeCurricularPlanState.ACTIVE.name(), BundleUtil.getString((String)"resources.EnumerationResources", (String)DegreeCurricularPlanState.ACTIVE.getName(), (String[])new String[0])));
        result.add(new SelectItem((Object)DegreeCurricularPlanState.NOT_ACTIVE.name(), BundleUtil.getString((String)"resources.EnumerationResources", (String)DegreeCurricularPlanState.NOT_ACTIVE.getName(), (String[])new String[0])));
        result.add(new SelectItem((Object)DegreeCurricularPlanState.CONCLUDED.name(), BundleUtil.getString((String)"resources.EnumerationResources", (String)DegreeCurricularPlanState.CONCLUDED.getName(), (String[])new String[0])));
        result.add(new SelectItem((Object)DegreeCurricularPlanState.PAST.name(), BundleUtil.getString((String)"resources.EnumerationResources", (String)DegreeCurricularPlanState.PAST.getName(), (String[])new String[0])));
        return result;
    }

    public ExecutionYear getExecutionYear() {
        return (ExecutionYear)FenixFramework.getDomainObject((String)this.getExecutionYearID());
    }

    public String getExecutionYearID() {
        return (String)this.getViewState().getAttribute("executionYearID");
    }

    public void setExecutionYearID(String executionYearID) {
        this.getViewState().setAttribute("executionYearID", executionYearID);
    }

    public List<SelectItem> getExecutionYearItems() throws FenixServiceException {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        InfoExecutionYear currentInfoExecutionYear = ReadCurrentExecutionYear.run();
        List<InfoExecutionYear> notClosedInfoExecutionYears = ReadNotClosedExecutionYears.run();
        for (InfoExecutionYear notClosedInfoExecutionYear : notClosedInfoExecutionYears) {
            Person loggedPerson = AccessControl.getPerson();
            if (!RoleType.MANAGER.isMember(loggedPerson.getUser()) && !notClosedInfoExecutionYear.after(currentInfoExecutionYear)) continue;
            result.add(new SelectItem((Object)notClosedInfoExecutionYear.getExternalId(), notClosedInfoExecutionYear.getYear()));
        }
        result.add(0, new SelectItem((Object)currentInfoExecutionYear.getExternalId(), currentInfoExecutionYear.getYear()));
        this.setDefaultExecutionYearIDIfExisting();
        return result;
    }

    private void setDefaultExecutionYearIDIfExisting() {
        DegreeCurricularPlan dcp = this.getDcp();
        if (dcp != null) {
            ArrayList executionYears = new ArrayList(dcp.getRoot().getBeginContextExecutionYears());
            Collections.sort(executionYears, ExecutionYear.COMPARATOR_BY_YEAR);
            if (!executionYears.isEmpty()) {
                this.setExecutionYearID(((ExecutionYear)executionYears.iterator().next()).getExternalId());
            }
        }
    }

    public String editCurricularPlan() {
        try {
            EditDegreeCurricularPlan.run(this.getDcp(), this.getName(), CurricularStage.valueOf(this.getCurricularStage()), DegreeCurricularPlanState.valueOf(this.getState()), null, this.getExecutionYear(), this.getDuration(), this.getApplyPreviousYearsEnrolmentRule());
            this.addInfoMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"degreeCurricularPlan.edited", (String[])new String[0]));
        }
        catch (IllegalDataAccessException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.notAuthorized", (String[])new String[0]));
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getKey(), (String[])e.getArgs()));
            return "";
        }
        catch (Exception e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.editingDegreeCurricularPlan", (String[])new String[0]));
        }
        return "curricularPlansManagement";
    }

    public String deleteCurricularPlan() {
        try {
            DeleteDegreeCurricularPlan.run(this.getDcpId());
        }
        catch (IllegalDataAccessException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.notAuthorized", (String[])new String[0]));
            return "curricularPlansManagement";
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)e.getMessage(), (String[])new String[0]));
            return "";
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getKey(), (String[])e.getArgs()));
            return "";
        }
        catch (Exception e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.deletingDegreeCurricularPlan", (String[])new String[0]));
            return "curricularPlansManagement";
        }
        this.addInfoMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"degreeCurricularPlan.deleted", (String[])new String[0]));
        return "curricularPlansManagement";
    }

    public String[] getSelectedGroupMembersToDelete() {
        return this.selectedGroupMembersToDelete;
    }

    public void setSelectedGroupMembersToDelete(String[] selectedGroupMembersToDelete) {
        this.selectedGroupMembersToDelete = selectedGroupMembersToDelete;
    }

    public String getDurationTypeName() {
        if (this.durationTypeName == null && this.getDcp() != null) {
            AcademicPeriod duration = this.getDcp().getDegreeStructure().getAcademicPeriod();
            return duration != null ? (this.durationTypeName = duration.getRepresentationInStringFormat()) : null;
        }
        return this.durationTypeName;
    }

    public void setDurationTypeName(String durationTypeName) {
        this.durationTypeName = durationTypeName;
    }

    private AcademicPeriod getDuration() {
        return this.getDurationTypeName().equals(NO_SELECTION) ? null : AcademicPeriod.getAcademicPeriodFromString(this.getDurationTypeName());
    }

    public List<SelectItem> getDurationTypes() {
        return this.durationTypes == null ? (this.durationTypes = this.readDurationTypes()) : this.durationTypes;
    }

    private List<SelectItem> readDurationTypes() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        TreeSet sortedPeriods = new TreeSet(Collections.reverseOrder());
        sortedPeriods.addAll(AcademicPeriod.values());
        for (AcademicPeriod entry : sortedPeriods) {
            if (!(entry instanceof AcademicYears)) continue;
            result.add(new SelectItem((Object)entry.getRepresentationInStringFormat(), BundleUtil.getString((String)"resources.EnumerationResources", (String)entry.getName(), (String[])new String[0])));
        }
        result.add(0, new SelectItem((Object)NO_SELECTION, BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"choose", (String[])new String[0])));
        return result;
    }
}

