/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.manager;

import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EnrolmentPeriodInClasses;
import org.fenixedu.academic.domain.EnrolmentPeriodInClassesCandidate;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCourses;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCoursesCandidate;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCoursesFlunkedSeason;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCoursesSpecialSeason;
import org.fenixedu.academic.domain.EnrolmentPeriodInImprovementOfApprovedEnrolment;
import org.fenixedu.academic.domain.EnrolmentPeriodInSpecialSeasonEvaluations;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ReingressionPeriod;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.enrolmentPeriods.EnrolmentPeriodType;
import org.fenixedu.academic.service.services.manager.CreateEnrolmentPeriods$callable$run;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreateEnrolmentPeriods {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void run(ExecutionSemester executionSemester, DegreeType degreeType, EnrolmentPeriodType enrolmentPeriodType, DateTime dateTime, DateTime dateTime2, List<DegreeCurricularPlan> list) {
        Object object = advice$run.perform((Callable)new CreateEnrolmentPeriods$callable$run(executionSemester, degreeType, enrolmentPeriodType, dateTime, dateTime2, list));
    }

    static /* synthetic */ void advised$run(ExecutionSemester executionSemester, DegreeType degreeType, EnrolmentPeriodType enrolmentPeriodType, DateTime start, DateTime end, List<DegreeCurricularPlan> dcps) {
        Date startDate = start.toDate();
        Date endDate = end.toDate();
        if (!degreeType.isBolonhaType() && enrolmentPeriodType.isReingressionPeriod()) {
            CreateEnrolmentPeriods.createReingressionPeriodsForPreBolonhaDegrees(executionSemester, degreeType, startDate, endDate, dcps);
        } else if (degreeType.isEmpty()) {
            CreateEnrolmentPeriods.createEnrolmentPeriodsForEmptyDegree(executionSemester, enrolmentPeriodType, startDate, endDate);
        } else {
            CreateEnrolmentPeriods.createEnrolmentPeriodsForBolonhaDegrees(executionSemester, degreeType, enrolmentPeriodType, startDate, endDate, dcps);
        }
    }

    private static void createReingressionPeriodsForPreBolonhaDegrees(ExecutionSemester executionSemester, DegreeType degreeType, Date startDate, Date endDate, List<DegreeCurricularPlan> dcpList) {
        for (DegreeCurricularPlan degreeCurricularPlan : dcpList) {
            new ReingressionPeriod(degreeCurricularPlan, executionSemester, startDate, endDate);
        }
    }

    private static void createEnrolmentPeriodsForEmptyDegree(ExecutionSemester executionSemester, EnrolmentPeriodType enrolmentPeriodType, Date startDate, Date endDate) {
        CreateEnrolmentPeriods.createPeriod(enrolmentPeriodType, startDate, endDate, executionSemester, DegreeCurricularPlan.readEmptyDegreeCurricularPlan());
    }

    private static void createEnrolmentPeriodsForBolonhaDegrees(ExecutionSemester executionSemester, DegreeType degreeType, EnrolmentPeriodType enrolmentPeriodType, Date startDate, Date endDate, List<DegreeCurricularPlan> dcpList) {
        for (DegreeCurricularPlan degreeCurricularPlan : dcpList) {
            if (degreeType != null && degreeType != degreeCurricularPlan.getDegree().getDegreeType()) continue;
            CreateEnrolmentPeriods.createPeriod(enrolmentPeriodType, startDate, endDate, executionSemester, degreeCurricularPlan);
        }
    }

    private static void createPeriod(EnrolmentPeriodType enrolmentPeriodType, Date startDate, Date endDate, ExecutionSemester executionSemester, DegreeCurricularPlan degreeCurricularPlan) {
        if (EnrolmentPeriodType.ENROLMENT_PERIOD_IN_CLASSES.equals((Object)enrolmentPeriodType)) {
            new EnrolmentPeriodInClasses(degreeCurricularPlan, executionSemester, startDate, endDate);
        } else if (EnrolmentPeriodType.ENROLMENT_PERIOD_IN_CURRICULAR_COURSES.equals((Object)enrolmentPeriodType)) {
            new EnrolmentPeriodInCurricularCourses(degreeCurricularPlan, executionSemester, startDate, endDate);
        } else if (EnrolmentPeriodType.ENROLMENT_PERIOD_IN_SPECIAL_SEASON_EVALUATIONS.equals((Object)enrolmentPeriodType)) {
            new EnrolmentPeriodInSpecialSeasonEvaluations(degreeCurricularPlan, executionSemester, startDate, endDate);
        } else if (EnrolmentPeriodType.ENROLMENT_PERIOD_IN_CURRICULAR_COURSES_SPECIAL_SEASON.equals((Object)enrolmentPeriodType)) {
            new EnrolmentPeriodInCurricularCoursesSpecialSeason(degreeCurricularPlan, executionSemester, startDate, endDate);
        } else if (EnrolmentPeriodType.ENROLMENT_PERIOD_IN_CURRICULAR_COURSES_FLUNKED_SEASON.equals((Object)enrolmentPeriodType)) {
            new EnrolmentPeriodInCurricularCoursesFlunkedSeason(degreeCurricularPlan, executionSemester, startDate, endDate);
        } else if (EnrolmentPeriodType.ENROLMENT_PERIOD_IN_IMPROVEMENT_OF_APPROVED_ENROLMENT.equals((Object)enrolmentPeriodType)) {
            new EnrolmentPeriodInImprovementOfApprovedEnrolment(degreeCurricularPlan, executionSemester, startDate, endDate);
        } else if (enrolmentPeriodType.isReingressionPeriod()) {
            new ReingressionPeriod(degreeCurricularPlan, executionSemester, startDate, endDate);
        }
        if (EnrolmentPeriodType.ENROLMENT_PERIOD_IN_CLASSES_CANDIDATE.equals((Object)enrolmentPeriodType)) {
            new EnrolmentPeriodInClassesCandidate(degreeCurricularPlan, executionSemester, startDate, endDate);
        } else if (EnrolmentPeriodType.ENROLMENT_PERIOD_IN_CURRICULAR_COURSES_CANDIDATE.equals((Object)enrolmentPeriodType)) {
            new EnrolmentPeriodInCurricularCoursesCandidate(degreeCurricularPlan, executionSemester, startDate, endDate);
        } else {
            throw new Error("error.invalid.enrolment.period.class.name");
        }
    }
}

