/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.util.function.Predicate;
import org.fenixedu.academic.domain.EnrolmentPeriod;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCoursesCandidate;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.joda.time.LocalDate;

public class StudentCurricularPlanEnrolmentPreConditions {
    private static EnrolmentPreConditionResult outOfPeriodResult(String periodType, EnrolmentPeriod nextPeriod) {
        if (nextPeriod != null) {
            return EnrolmentPreConditionResult.createFalse("message.out.curricular.course.enrolment.period." + periodType, nextPeriod.getStartDateDateTime().toString("dd/MM/yyyy"), nextPeriod.getEndDateDateTime().toString("dd/MM/yyyy")).withPeriod(nextPeriod);
        }
        return EnrolmentPreConditionResult.createFalse("message.out.curricular.course.enrolment.period." + periodType + ".noDates", new String[0]);
    }

    public static EnrolmentPreConditionResult checkPreConditionsToEnrol(StudentCurricularPlan scp, ExecutionSemester semester) {
        EnrolmentPreConditionResult result = StudentCurricularPlanEnrolmentPreConditions.checkEnrolmentPeriods(scp, semester);
        if (!result.isValid()) {
            return result;
        }
        return StudentCurricularPlanEnrolmentPreConditions.checkDebts(scp);
    }

    static EnrolmentPreConditionResult checkDebts(StudentCurricularPlan scp) {
        if (TreasuryBridgeAPIFactory.implementation().isAcademicalActsBlocked(scp.getPerson(), new LocalDate())) {
            return EnrolmentPreConditionResult.createFalse("error.StudentCurricularPlan.cannot.enrol.with.debts.for.previous.execution.years", new String[0]);
        }
        return EnrolmentPreConditionResult.createTrue();
    }

    private static boolean hasSpecialSeason(StudentCurricularPlan scp, ExecutionSemester semester) {
        if (scp.hasSpecialSeasonFor(semester)) {
            return true;
        }
        Registration registration = scp.getRegistration();
        return registration.getSourceRegistration() != null && registration.getSourceRegistration().getLastStudentCurricularPlan().hasSpecialSeasonFor(semester);
    }

    static EnrolmentPreConditionResult checkEnrolmentPeriods(StudentCurricularPlan scp, ExecutionSemester semester) {
        if (semester.isFirstOfYear() && StudentCurricularPlanEnrolmentPreConditions.hasSpecialSeason(scp, semester)) {
            if (!scp.getDegreeCurricularPlan().getActiveEnrolmentPeriodInCurricularCoursesSpecialSeason(semester).isPresent()) {
                return StudentCurricularPlanEnrolmentPreConditions.outOfPeriodResult("specialSeason", (EnrolmentPeriod)((Object)scp.getDegreeCurricularPlan().getNextEnrolmentPeriodInCurricularCoursesSpecialSeason()));
            }
        } else if (semester.isFirstOfYear() && StudentCurricularPlanEnrolmentPreConditions.hasPrescribed(scp, semester)) {
            if (!scp.getDegreeCurricularPlan().getActiveEnrolmentPeriodInCurricularCoursesFlunkedSeason(semester).isPresent()) {
                return StudentCurricularPlanEnrolmentPreConditions.outOfPeriodResult("flunked", (EnrolmentPeriod)((Object)scp.getDegreeCurricularPlan().getNextEnrolmentPeriodInCurricularCoursesFlunkedSeason()));
            }
        } else if (scp.isInCandidateEnrolmentProcess(semester.getExecutionYear())) {
            Predicate<EnrolmentPeriod> predicate = ep -> ep instanceof EnrolmentPeriodInCurricularCoursesCandidate;
            if (!scp.getDegreeCurricularPlan().getValidEnrolmentPeriod(predicate, semester).isPresent()) {
                return StudentCurricularPlanEnrolmentPreConditions.outOfPeriodResult("normal", (EnrolmentPeriod)((Object)scp.getDegreeCurricularPlan().getNextEnrolmentPeriod()));
            }
        } else if (!scp.getDegreeCurricularPlan().getActiveCurricularCourseEnrolmentPeriod(semester).isPresent()) {
            return StudentCurricularPlanEnrolmentPreConditions.outOfPeriodResult("normal", (EnrolmentPeriod)((Object)scp.getDegreeCurricularPlan().getNextEnrolmentPeriod()));
        }
        return EnrolmentPreConditionResult.createTrue();
    }

    static EnrolmentPreConditionResult checkEnrolmentPeriodsForSpecialSeason(StudentCurricularPlan scp, ExecutionSemester semester) {
        if (!scp.getDegreeCurricularPlan().hasOpenSpecialSeasonEnrolmentPeriod(semester)) {
            return StudentCurricularPlanEnrolmentPreConditions.outOfPeriodResult("specialSeason", (EnrolmentPeriod)((Object)scp.getDegreeCurricularPlan().getNextEnrolmentPeriodInCurricularCoursesSpecialSeason()));
        }
        return EnrolmentPreConditionResult.createTrue();
    }

    private static boolean hasPrescribed(StudentCurricularPlan scp, ExecutionSemester semester) {
        for (RegistrationState state : scp.getRegistration().getRegistrationStates(semester.getExecutionYear())) {
            if (!state.getExecutionYear().equals(semester.getExecutionYear()) || !RegistrationStateType.FLUNKED.equals((Object)state.getStateType())) continue;
            return scp.getRegistration().hasRegisteredActiveState();
        }
        return false;
    }

    public static class EnrolmentPreConditionResult {
        private boolean valid = false;
        private String message;
        private String[] args;
        private EnrolmentPeriod period;

        private EnrolmentPreConditionResult valid(boolean value) {
            this.valid = value;
            return this;
        }

        public boolean isValid() {
            return this.valid;
        }

        private EnrolmentPreConditionResult message(String message, String ... args) {
            this.message = message;
            this.args = args;
            return this;
        }

        private EnrolmentPreConditionResult withPeriod(EnrolmentPeriod period) {
            this.period = period;
            return this;
        }

        public String message() {
            return this.message;
        }

        public String[] args() {
            return this.args;
        }

        public EnrolmentPeriod getEnrolmentPeriod() {
            return this.period;
        }

        public static EnrolmentPreConditionResult createTrue() {
            return new EnrolmentPreConditionResult().valid(true);
        }

        public static EnrolmentPreConditionResult createFalse(String message, String ... args) {
            return new EnrolmentPreConditionResult().valid(false).message(message, args);
        }
    }
}

