/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.EnrolmentWrapper;
import org.fenixedu.academic.domain.studentCurriculum.ExtraCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.InternalSubstitution_Base;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroupType;
import org.fenixedu.academic.dto.administrativeOffice.dismissal.DismissalBean;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class InternalSubstitution
extends InternalSubstitution_Base {
    protected InternalSubstitution() {
    }

    public InternalSubstitution(StudentCurricularPlan studentCurricularPlan, Collection<DismissalBean.SelectedCurricularCourse> dismissals, Collection<IEnrolment> enrolments, ExecutionSemester executionSemester) {
        this();
        this.checkEnrolments(studentCurricularPlan, enrolments);
        this.changeParentCurriculumGroup(studentCurricularPlan, enrolments);
        this.init(studentCurricularPlan, dismissals, enrolments, executionSemester);
    }

    public InternalSubstitution(StudentCurricularPlan studentCurricularPlan, CourseGroup courseGroup, Collection<IEnrolment> enrolments, Collection<CurricularCourse> noEnrolCurricularCourses, Double credits, ExecutionSemester executionSemester) {
        this();
        this.checkEnrolments(studentCurricularPlan, enrolments);
        this.changeParentCurriculumGroup(studentCurricularPlan, enrolments);
        this.init(studentCurricularPlan, courseGroup, enrolments, noEnrolCurricularCourses, credits, executionSemester);
    }

    public InternalSubstitution(StudentCurricularPlan studentCurricularPlan, CurriculumGroup curriculumGroup, Collection<IEnrolment> enrolments, Double credits, ExecutionSemester executionSemester) {
        this();
        this.checkEnrolments(studentCurricularPlan, enrolments);
        this.changeParentCurriculumGroup(studentCurricularPlan, enrolments);
        this.init(studentCurricularPlan, curriculumGroup, enrolments, new HashSet(0), credits, executionSemester);
    }

    private void checkEnrolments(StudentCurricularPlan studentCurricularPlan, Collection<IEnrolment> enrolments) {
        for (IEnrolment iEnrolment : enrolments) {
            Enrolment enrolment;
            if (iEnrolment.isExternalEnrolment() || (enrolment = (Enrolment)iEnrolment).getStudentCurricularPlan() == studentCurricularPlan) continue;
            throw new DomainException("error.InternalSubstitution.invalid.enrolment", new String[0]);
        }
    }

    private void changeParentCurriculumGroup(StudentCurricularPlan studentCurricularPlan, Collection<IEnrolment> enrolments) {
        this.ensureSourceNoCourseGroupCurriculumGroup(studentCurricularPlan);
        NoCourseGroupCurriculumGroup curriculumGroup = this.getInternalCreditsSourceGroup(studentCurricularPlan);
        for (IEnrolment iEnrolment : enrolments) {
            Enrolment enrolment = (Enrolment)iEnrolment;
            enrolment.setCurriculumGroup((CurriculumGroup)((Object)curriculumGroup));
        }
    }

    private NoCourseGroupCurriculumGroup getInternalCreditsSourceGroup(StudentCurricularPlan studentCurricularPlan) {
        return studentCurricularPlan.getNoCourseGroupCurriculumGroup(NoCourseGroupCurriculumGroupType.INTERNAL_CREDITS_SOURCE_GROUP);
    }

    private void ensureSourceNoCourseGroupCurriculumGroup(StudentCurricularPlan studentCurricularPlan) {
        if (this.getInternalCreditsSourceGroup(studentCurricularPlan) == null) {
            studentCurricularPlan.createNoCourseGroupCurriculumGroup(NoCourseGroupCurriculumGroupType.INTERNAL_CREDITS_SOURCE_GROUP);
        }
    }

    protected void disconnect() {
        this.moveExistingEnrolmentsToExtraCurriculumGroup();
        this.deleteSourceGroupIfEmpty();
        super.disconnect();
    }

    private void moveExistingEnrolmentsToExtraCurriculumGroup() {
        ExtraCurriculumGroup extraCurriculumGroup = this.ensureExtraCurriculumGroup();
        for (EnrolmentWrapper wrapper : this.getEnrolmentsSet()) {
            Enrolment enrolment = (Enrolment)wrapper.getIEnrolment();
            enrolment.setCurriculumGroup((CurriculumGroup)((Object)extraCurriculumGroup));
        }
    }

    private ExtraCurriculumGroup ensureExtraCurriculumGroup() {
        ExtraCurriculumGroup extraCurriculumGroup = this.getStudentCurricularPlan().getExtraCurriculumGroup();
        if (extraCurriculumGroup == null) {
            extraCurriculumGroup = this.getStudentCurricularPlan().createExtraCurriculumGroup();
        }
        return extraCurriculumGroup;
    }

    private void deleteSourceGroupIfEmpty() {
        NoCourseGroupCurriculumGroup group = this.getStudentCurricularPlan().getNoCourseGroupCurriculumGroup(NoCourseGroupCurriculumGroupType.INTERNAL_CREDITS_SOURCE_GROUP);
        if (group != null && group.isDeletable()) {
            group.delete();
        }
    }

    public boolean isInternalSubstitution() {
        return true;
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.StudentResources", (String)"label.dismissal.InternalSubstitution", (String[])new String[0]);
    }

    public Curriculum getCurriculum(Dismissal dismissal, DateTime when, ExecutionYear year) {
        Curriculum curriculum = Curriculum.createEmpty(year);
        for (EnrolmentWrapper wrapper : this.getEnrolmentsSet()) {
            Enrolment enrolment = (Enrolment)wrapper.getIEnrolment();
            if (!enrolment.wasCreated(when) || !this.isBefore(enrolment, year)) continue;
            curriculum.add(new Curriculum((CurriculumModule)((Object)dismissal), year, Collections.singleton(enrolment), Collections.emptySet(), Collections.singleton(enrolment)));
        }
        return curriculum;
    }

    private boolean isBefore(Enrolment enrolment, ExecutionYear year) {
        return year == null || enrolment.getExecutionYear().isBefore(year);
    }
}

