/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.notification;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.academic.domain.phd.notification.PhdNotification$callable$markAsSent;
import org.fenixedu.academic.domain.phd.notification.PhdNotificationBean;
import org.fenixedu.academic.domain.phd.notification.PhdNotificationState;
import org.fenixedu.academic.domain.phd.notification.PhdNotificationType;
import org.fenixedu.academic.domain.phd.notification.PhdNotification_Base;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhdNotification
extends PhdNotification_Base {
    public static final Comparator<PhdNotification> COMPARATOR_BY_NUMBER;
    public static final Advice advice$markAsSent;

    public PhdNotification() {
        this.setWhenCreated(new DateTime());
        if (AccessControl.getPerson() != null) {
            this.setCreatedBy(AccessControl.getPerson().getUsername());
        }
    }

    public PhdNotification(PhdNotificationType type, PhdProgramCandidacyProcess candidacyProcess) {
        this();
        this.init(type, candidacyProcess);
    }

    public PhdNotification(PhdNotificationBean bean) {
        this(bean.getType(), bean.getCandidacyProcess());
    }

    protected void init(PhdNotificationType type, PhdProgramCandidacyProcess candidacyProcess) {
        String[] args = new String[]{};
        if (type == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.notification.PhdNotification.type.cannot.be.null", args);
        }
        String[] args1 = new String[]{};
        if (candidacyProcess == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.notification.PhdNotification.candidacyProcess.cannot.be.null", args1);
        }
        super.setType(type);
        super.setYear(Integer.valueOf(new LocalDate().getYear()));
        super.setNumber(this.generateNumber(this.getYear()));
        super.setRootDomainObject(Bennu.getInstance());
        super.setCandidacyProcess(candidacyProcess);
        super.setState(PhdNotificationState.EMITTED);
    }

    public void setType(PhdNotificationType type) {
        throw new DomainException("error.org.fenixedu.academic.domain.phd.notification.PhdNotification.cannot.modify.type", new String[0]);
    }

    public void setCandidacyProcess(PhdProgramCandidacyProcess candidacyProcess) {
        throw new DomainException("error.org.fenixedu.academic.domain.phd.notification.PhdNotification.cannot.modify.candidacyProcess", new String[0]);
    }

    public void setState(PhdNotificationState state) {
        throw new DomainException("error.org.fenixedu.academic.domain.phd.notification.PhdNotification.cannot.modify.state", new String[0]);
    }

    private Integer generateNumber(int year) {
        List<PhdNotification> notifications = this.getNotificationsForYear(year);
        return notifications.isEmpty() ? 1 : Collections.max(notifications, COMPARATOR_BY_NUMBER).getNumber() + 1;
    }

    private List<PhdNotification> getNotificationsForYear(int year) {
        ArrayList<PhdNotification> result = new ArrayList<PhdNotification>();
        for (PhdNotification each : Bennu.getInstance().getPhdNotificationsSet()) {
            if (!each.isFor(year)) continue;
            result.add(each);
        }
        return result;
    }

    private boolean isFor(int year) {
        return this.getYear() == year;
    }

    public String getNotificationNumber() {
        return this.getNumber() + "/" + this.getYear();
    }

    public void markAsSent() {
        Object object = advice$markAsSent.perform((Callable)new PhdNotification$callable$markAsSent(this));
    }

    static /* synthetic */ void advised$markAsSent(PhdNotification this_) {
        super.setState(PhdNotificationState.SENT);
    }

    public boolean isSent() {
        return this.getState() == PhdNotificationState.SENT;
    }

    static {
        advice$markAsSent = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_NUMBER = new Comparator<PhdNotification>(){

            @Override
            public int compare(PhdNotification left, PhdNotification right) {
                int result = left.getNumber().compareTo(right.getNumber());
                return result == 0 ? left.getExternalId().compareTo(right.getExternalId()) : result;
            }
        };
    }
}

