/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.candidacy;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.phd.PhdProgramFocusArea;
import org.fenixedu.academic.domain.phd.candidacy.ApplicantOverallPromise;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyReferee;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter;

public class PhdCandidacyRefereeLetterBean
implements Serializable {
    private static final long serialVersionUID = 6105525451822275989L;
    private PhdCandidacyReferee candidacyReferee;
    private PhdCandidacyRefereeLetter letter;
    private String howLongKnownApplicant;
    private String capacity;
    private String comparisonGroup;
    private String rankInClass;
    private ApplicantOverallPromise academicPerformance;
    private ApplicantOverallPromise socialAndCommunicationSkills;
    private ApplicantOverallPromise potencialToExcelPhd;
    private String comments;
    private String refereeName;
    private String refereePosition;
    private String refereeInstitution;
    private String refereeAddress;
    private String refereeCity;
    private String refereeZipCode;
    private Country refereeCountry;
    private transient InputStream file;
    private byte[] fileContent;
    private String filename;

    public PhdCandidacyRefereeLetterBean() {
    }

    public PhdCandidacyRefereeLetterBean(PhdCandidacyRefereeLetter letter) {
        this.setCandidacyReferee(letter.getCandidacyReferee());
        this.setLetter(letter);
        this.setHowLongKnownApplicant(letter.getHowLongKnownApplicant());
        this.setCapacity(letter.getCapacity());
        this.setComparisonGroup(letter.getComparisonGroup());
        this.setRankInClass(letter.getRankInClass());
        this.setAcademicPerformance(letter.getAcademicPerformance());
        this.setSocialAndCommunicationSkills(letter.getSocialAndCommunicationSkills());
        this.setPotencialToExcelPhd(letter.getPotencialToExcelPhd());
        this.setComments(letter.getComments());
        this.setRefereeName(letter.getRefereeName());
        this.setRefereePosition(letter.getRefereePosition());
        this.setRefereeInstitution(letter.getRefereeInstitution());
        this.setRefereeAddress(letter.getRefereeAddress());
        this.setRefereeCity(letter.getRefereeCity());
        this.setRefereeZipCode(letter.getRefereeZipCode());
        this.setRefereeCountry(letter.getRefereeCountry());
    }

    public PhdCandidacyReferee getCandidacyReferee() {
        return this.candidacyReferee;
    }

    public PhdCandidacyRefereeLetter getLetter() {
        return this.letter;
    }

    public void setLetter(PhdCandidacyRefereeLetter letter) {
        this.letter = letter;
    }

    public String getComparisonGroup() {
        return this.comparisonGroup;
    }

    public void setComparisonGroup(String comparisonGroup) {
        this.comparisonGroup = comparisonGroup;
    }

    public String getRefereeName() {
        return this.refereeName;
    }

    public void setRefereeName(String refereeName) {
        this.refereeName = refereeName;
    }

    public String getRefereePosition() {
        return this.refereePosition;
    }

    public void setRefereePosition(String refereePosition) {
        this.refereePosition = refereePosition;
    }

    public String getRefereeInstitution() {
        return this.refereeInstitution;
    }

    public void setRefereeInstitution(String refereeInstitution) {
        this.refereeInstitution = refereeInstitution;
    }

    public String getRefereeAddress() {
        return this.refereeAddress;
    }

    public void setRefereeAddress(String refereeAddress) {
        this.refereeAddress = refereeAddress;
    }

    public String getRefereeCity() {
        return this.refereeCity;
    }

    public void setRefereeCity(String refereeCity) {
        this.refereeCity = refereeCity;
    }

    public String getRefereeZipCode() {
        return this.refereeZipCode;
    }

    public void setRefereeZipCode(String refereeZipCode) {
        this.refereeZipCode = refereeZipCode;
    }

    public Country getRefereeCountry() {
        return this.refereeCountry;
    }

    public void setRefereeCountry(Country refereeCountry) {
        this.refereeCountry = refereeCountry;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public InputStream getFile() {
        return this.file;
    }

    public void setFile(InputStream file) {
        this.file = file;
        if (file != null) {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            try {
                ByteStreams.copy((InputStream)this.file, (OutputStream)result);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.fileContent = result.toByteArray();
        } else {
            this.fileContent = null;
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public byte[] getFileContent() {
        return this.fileContent;
    }

    public boolean hasFileContent() {
        return this.fileContent != null;
    }

    public Person getPerson() {
        return this.getCandidacyReferee().getPhdProgramCandidacyProcess().getPerson();
    }

    public PhdProgramFocusArea getFocusArea() {
        return this.getCandidacyReferee().getPhdProgramCandidacyProcess().getIndividualProgramProcess().getPhdProgramFocusArea();
    }

    public String getEmail() {
        return this.getCandidacyReferee().getEmail();
    }

    public boolean hasLetter() {
        return this.getLetter() != null;
    }

    public void removeFile() {
        this.setFile(null);
    }

    public String getHowLongKnownApplicant() {
        return this.howLongKnownApplicant;
    }

    public void setHowLongKnownApplicant(String howLongKnownApplicant) {
        this.howLongKnownApplicant = howLongKnownApplicant;
    }

    public String getCapacity() {
        return this.capacity;
    }

    public void setCapacity(String capacity) {
        this.capacity = capacity;
    }

    public String getRankInClass() {
        return this.rankInClass;
    }

    public void setRankInClass(String rankInClass) {
        this.rankInClass = rankInClass;
    }

    public ApplicantOverallPromise getAcademicPerformance() {
        return this.academicPerformance;
    }

    public void setAcademicPerformance(ApplicantOverallPromise academicPerformance) {
        this.academicPerformance = academicPerformance;
    }

    public ApplicantOverallPromise getSocialAndCommunicationSkills() {
        return this.socialAndCommunicationSkills;
    }

    public void setSocialAndCommunicationSkills(ApplicantOverallPromise socialAndCommunicationSkills) {
        this.socialAndCommunicationSkills = socialAndCommunicationSkills;
    }

    public ApplicantOverallPromise getPotencialToExcelPhd() {
        return this.potencialToExcelPhd;
    }

    public void setPotencialToExcelPhd(ApplicantOverallPromise potencialToExcelPhd) {
        this.potencialToExcelPhd = potencialToExcelPhd;
    }

    public void setCandidacyReferee(PhdCandidacyReferee candidacyReferee) {
        this.candidacyReferee = candidacyReferee;
    }

    public void setFileContent(byte[] fileContent) {
        this.fileContent = fileContent;
    }
}

