/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.util.Comparator;
import jvstm.cps.ConsistencyPredicate;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.ThesisSubject;
import org.fenixedu.academic.domain.phd.ThesisSubjectOrder_Base;
import org.fenixedu.bennu.core.domain.Bennu;

public class ThesisSubjectOrder
extends ThesisSubjectOrder_Base {
    public static Comparator<ThesisSubjectOrder> COMPARATOR_BY_ORDER = new Comparator<ThesisSubjectOrder>(){

        @Override
        public int compare(ThesisSubjectOrder order1, ThesisSubjectOrder order2) {
            return order1.getSubjectOrder() - order2.getSubjectOrder();
        }
    };

    public ThesisSubjectOrder() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public ThesisSubjectOrder(ThesisSubject subject, PhdIndividualProgramProcess phdProcess, int order) {
        this();
        this.setThesisSubject(subject);
        this.setPhdIndividualProgramProcess(phdProcess);
        this.setSubjectOrder(order);
    }

    public void delete() {
        if (this.getPhdIndividualProgramProcess() != null) {
            for (ThesisSubjectOrder followingSubjectOrder : this.getPhdIndividualProgramProcess().getThesisSubjectOrdersSorted()) {
                if (followingSubjectOrder.getSubjectOrder() <= this.getSubjectOrder()) continue;
                followingSubjectOrder.decreaseSubjectOrder();
            }
            this.setPhdIndividualProgramProcess(null);
        }
        this.setThesisSubject(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public void decreaseSubjectOrder() {
        if (this.getSubjectOrder() > 1) {
            this.setSubjectOrder(this.getSubjectOrder() - 1);
        }
    }

    @ConsistencyPredicate
    public boolean checkHasThesisSubject() {
        return this.getThesisSubject() != null;
    }

    @ConsistencyPredicate
    public boolean checkHasPhdIndividualProgramProcess() {
        return this.getPhdIndividualProgramProcess() != null;
    }
}

