/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.EventTypes;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup_Base;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcess;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.LocalizedString;

public class ProgramConclusion
extends ProgramConclusion_Base {
    private static final String DEGREE_NAME_TEMPLATE = "${degreeName}";

    protected ProgramConclusion() {
        this.setRoot(Bennu.getInstance());
    }

    public ProgramConclusion(LocalizedString name, LocalizedString description, LocalizedString graduationTitle, LocalizedString graduationLevel, boolean isAverageEditable, boolean isAlumniProvider, boolean isSkipValidation, RegistrationStateType targetState, EventTypes eventTypes) {
        this();
        this.edit(name, description, graduationTitle, graduationLevel, isAverageEditable, isAlumniProvider, isSkipValidation, targetState, eventTypes);
    }

    public void edit(LocalizedString name, LocalizedString description, LocalizedString graduationTitle, LocalizedString graduationLevel, boolean isAverageEditable, boolean isAlumniProvider, boolean isSkipValidation, RegistrationStateType targetState, EventTypes eventTypes) {
        this.setName(name);
        this.setDescription(description);
        this.setGraduationTitle(graduationTitle);
        this.setGraduationLevel(graduationLevel);
        this.setAverageEditable(isAverageEditable);
        this.setAlumniProvider(isAlumniProvider);
        this.setSkipValidation(isSkipValidation);
        this.setTargetState(targetState);
        this.setEventTypes(eventTypes);
    }

    public boolean isAverageEditable() {
        return this.getAverageEditable();
    }

    public boolean isAlumniProvider() {
        return this.getAlumniProvider();
    }

    public boolean isSkipValidation() {
        return this.getSkipValidation();
    }

    public void setAverageEditable(boolean averageEditable) {
        super.setAverageEditable(averageEditable);
    }

    public void setAlumniProvider(boolean alumniProvider) {
        super.setAlumniProvider(alumniProvider);
    }

    public void setSkipValidation(boolean skipValidation) {
        super.setSkipValidation(skipValidation);
    }

    public static Stream<ProgramConclusion> conclusionsFor(StudentCurricularPlan studentCurricularPlan) {
        return ProgramConclusion.curriculumGroups(studentCurricularPlan).map(CurriculumGroup::getDegreeModule).filter(Objects::nonNull).map(CourseGroup_Base::getProgramConclusion).filter(Objects::nonNull);
    }

    public static Stream<ProgramConclusion> conclusionsFor(Registration registration) {
        return ProgramConclusion.conclusionsFor(registration.getLastStudentCurricularPlan());
    }

    public static Stream<ProgramConclusion> conclusionsFor(DegreeCurricularPlan degreeCurricularPlan) {
        return degreeCurricularPlan.getAllCoursesGroups().stream().map(CourseGroup_Base::getProgramConclusion).filter(Objects::nonNull);
    }

    private static Stream<CurriculumGroup> curriculumGroups(StudentCurricularPlan studentCurricularPlan) {
        return Stream.concat(Stream.of(studentCurricularPlan.getRoot()), studentCurricularPlan.getAllCurriculumGroups().stream());
    }

    public Optional<CurriculumGroup> groupFor(StudentCurricularPlan studentCurricularPlan) {
        if (studentCurricularPlan == null) {
            return Optional.empty();
        }
        return ProgramConclusion.curriculumGroups(studentCurricularPlan).filter(cg -> cg.getDegreeModule() != null && this.equals((Object)cg.getDegreeModule().getProgramConclusion())).findAny();
    }

    public Optional<CurriculumGroup> groupFor(Registration registration) {
        if (registration == null) {
            return Optional.empty();
        }
        return this.groupFor(registration.getLastStudentCurricularPlan());
    }

    public Optional<CourseGroup> groupFor(DegreeCurricularPlan degreeCurricularPlan) {
        if (degreeCurricularPlan == null) {
            return Optional.empty();
        }
        return degreeCurricularPlan.getAllCoursesGroups().stream().filter(cg -> this.equals((Object)cg.getProgramConclusion())).findAny();
    }

    public boolean isTerminal() {
        return RegistrationStateType.CONCLUDED.equals((Object)this.getTargetState());
    }

    public boolean isConclusionProcessed(Registration registration) {
        return this.groupFor(registration).map(CurriculumGroup::isConclusionProcessed).orElse(false);
    }

    public String getGraduationTitle(Locale locale) {
        return this.getGraduationTitle(locale, null);
    }

    public String getGraduationTitle(Locale locale, String degreeName) {
        String graduationTitle = this.getGraduationTitle().getContent(locale);
        if (Strings.isNullOrEmpty((String)graduationTitle)) {
            return null;
        }
        if (!Strings.isNullOrEmpty((String)degreeName)) {
            graduationTitle = graduationTitle.replace(DEGREE_NAME_TEMPLATE, degreeName);
        }
        return graduationTitle;
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getCourseGroupSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.program.conclusion.has.groups", (String[])new String[0]));
        }
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        this.setRoot(null);
        super.deleteDomainObject();
    }

    public static Optional<ConclusionProcess> getConclusionProcess(StudentCurricularPlan studentCurricularPlan) {
        return ProgramConclusion.conclusionsFor(studentCurricularPlan).filter(ProgramConclusion::isTerminal).map(pc -> pc.groupFor(studentCurricularPlan)).filter(cg -> cg.map(CurriculumGroup::isConclusionProcessed).orElse(false)).map(cg -> cg.map(CurriculumGroup::getConclusionProcess)).map(Optional::get).findAny();
    }

    public static boolean isConclusionProcessed(StudentCurricularPlan studentCurricularPlan) {
        return ProgramConclusion.conclusionsFor(studentCurricularPlan).filter(ProgramConclusion::isTerminal).anyMatch(pc -> pc.groupFor(studentCurricularPlan).map(CurriculumGroup::isConclusionProcessed).orElse(false));
    }

    public static boolean isConcluded(StudentCurricularPlan studentCurricularPlan) {
        return ProgramConclusion.conclusionsFor(studentCurricularPlan).filter(ProgramConclusion::isTerminal).anyMatch(pc -> pc.groupFor(studentCurricularPlan).map(CurriculumGroup::isConcluded).orElse(false));
    }
}

