/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.CreditsLimit;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.DegreeModulesSelectionLimit;
import org.fenixedu.academic.domain.curricularRules.Exclusiveness;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.PreviousYearsEnrolmentCurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleLevel;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;

public class PreviousYearsEnrolmentExecutor
extends CurricularRuleExecutor {
    @Override
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        if (this.isEnrollingInCourseGroupsOnly(enrolmentContext, sourceDegreeModuleToEvaluate)) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        PreviousYearsEnrolmentCurricularRule previousYearsEnrolmentCurricularRule = (PreviousYearsEnrolmentCurricularRule)curricularRule;
        Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYear = this.getCurricularCoursesToEnrolByYear(previousYearsEnrolmentCurricularRule, enrolmentContext, sourceDegreeModuleToEvaluate, false);
        return this.hasAnyCurricularCoursesToEnrolInPreviousYears(enrolmentContext, curricularCoursesToEnrolByYear, sourceDegreeModuleToEvaluate);
    }

    private void printCurricularCoursesToEnrol(Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYear) {
        for (Map.Entry<Integer, Set<CurricularCourse>> entry : curricularCoursesToEnrolByYear.entrySet()) {
            System.out.println("Year " + entry.getKey());
            for (CurricularCourse curricularCourse : entry.getValue()) {
                System.out.println(curricularCourse.getName());
            }
            System.out.println("-------------");
        }
    }

    private boolean hasCurricularCoursesToEnrolInPreviousYears(Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYear, Integer curricularYear) {
        for (int i = curricularYear.intValue(); i > 0; --i) {
            int previousYear = i - 1;
            if (!curricularCoursesToEnrolByYear.containsKey(previousYear) || curricularCoursesToEnrolByYear.get(previousYear).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private RuleResult hasAnyCurricularCoursesToEnrolInPreviousYears(EnrolmentContext enrolmentContext, Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYear, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        RuleResult result = RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getAllChildDegreeModulesToEvaluateFor(sourceDegreeModuleToEvaluate.getDegreeModule())) {
            if (!degreeModuleToEvaluate.isLeaf() || degreeModuleToEvaluate.isAnnualCurricularCourse(enrolmentContext.getExecutionPeriod().getExecutionYear()) && degreeModuleToEvaluate.getContext() == null) continue;
            if (degreeModuleToEvaluate.getContext() == null) {
                throw new DomainException("error.degreeModuleToEvaluate.has.invalid.context", degreeModuleToEvaluate.getName(), degreeModuleToEvaluate.getExecutionPeriod().getQualifiedName());
            }
            if (!this.hasCurricularCoursesToEnrolInPreviousYears(curricularCoursesToEnrolByYear, degreeModuleToEvaluate.getContext().getCurricularYear())) continue;
            if (degreeModuleToEvaluate.isEnroled()) {
                result = result.and(this.createImpossibleRuleResult(sourceDegreeModuleToEvaluate, degreeModuleToEvaluate));
                continue;
            }
            result = result.and(this.createFalseRuleResult(sourceDegreeModuleToEvaluate, degreeModuleToEvaluate));
        }
        return result;
    }

    private RuleResult createFalseRuleResult(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, IDegreeModuleToEvaluate degreeModuleToEvaluate) {
        return RuleResult.createFalse(degreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.PreviousYearsEnrolmentExecutor", sourceDegreeModuleToEvaluate.getName(), degreeModuleToEvaluate.getContext().getCurricularYear().toString());
    }

    private RuleResult createImpossibleRuleResult(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, IDegreeModuleToEvaluate degreeModuleToEvaluate) {
        return RuleResult.createImpossible(degreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.PreviousYearsEnrolmentExecutor", sourceDegreeModuleToEvaluate.getName(), degreeModuleToEvaluate.getContext().getCurricularYear().toString());
    }

    private boolean isEnrollingInCourseGroupsOnly(EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getAllChildDegreeModulesToEvaluateFor(sourceDegreeModuleToEvaluate.getDegreeModule())) {
            if (!degreeModuleToEvaluate.isLeaf()) continue;
            return false;
        }
        return true;
    }

    private Map<Integer, Set<CurricularCourse>> getCurricularCoursesToEnrolByYear(PreviousYearsEnrolmentCurricularRule previousYearsEnrolmentCurricularRule, EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, boolean withTemporaryEnrolments) {
        HashMap<Integer, Set<CurricularCourse>> result = new HashMap<Integer, Set<CurricularCourse>>();
        for (CourseGroup courseGroup : this.getCourseGroupsToEvaluate(previousYearsEnrolmentCurricularRule.getDegreeModuleToApplyRule(), enrolmentContext)) {
            this.collectCourseGroupCurricularCoursesToEnrol(result, courseGroup, new CollectContext(), enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
        }
        return result;
    }

    private Collection<CourseGroup> getCourseGroupsToEvaluate(CourseGroup courseGroup, EnrolmentContext enrolmentContext) {
        if (courseGroup.isRoot()) {
            HashSet<CourseGroup> res = new HashSet<CourseGroup>();
            for (CycleType cycleType : enrolmentContext.getStudentCurricularPlan().getDegreeType().getCycleTypes()) {
                CycleCurriculumGroup cycleCurriculumGroup = enrolmentContext.getStudentCurricularPlan().getRoot().getCycleCurriculumGroup(cycleType);
                if (cycleCurriculumGroup == null) continue;
                if (cycleCurriculumGroup.isExternal()) {
                    throw new DomainException("error.cycleCurriculumGroup.cannot.be.external", new String[0]);
                }
                res.add((CourseGroup)((Object)cycleCurriculumGroup.getDegreeModule()));
            }
            return res;
        }
        return Collections.singleton(courseGroup);
    }

    private void collectCourseGroupCurricularCoursesToEnrol(Map<Integer, Set<CurricularCourse>> result, CourseGroup courseGroup, CollectContext collectContext, EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, boolean withTemporaryEnrolments) {
        if (!this.isToCollectCurricularCourses(courseGroup, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments)) {
            return;
        }
        int childDegreeModulesCount = courseGroup.getActiveChildContextsWithMax(enrolmentContext.getExecutionPeriod()).size();
        this.collectCurricularCoursesToEnrol(result, courseGroup, collectContext, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
        int minModules = this.getMinModules(courseGroup, enrolmentContext.getExecutionPeriod());
        int maxModules = this.getMaxModules(courseGroup, enrolmentContext.getExecutionPeriod());
        if (minModules == maxModules) {
            if (maxModules == childDegreeModulesCount) {
                this.collectChildCourseGroupsCurricularCoursesToEnrol(result, courseGroup, collectContext, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
            } else if (this.getSelectedChildDegreeModules(courseGroup, enrolmentContext).size() < minModules) {
                this.collectChildCourseGroupsCurricularCoursesToEnrol(result, courseGroup, collectContext, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
            } else {
                this.collectSelectedChildCourseGroupsCurricularCoursesToEnrol(result, courseGroup, collectContext, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
            }
        } else if (this.getSelectedChildDegreeModules(courseGroup, enrolmentContext).size() < minModules) {
            this.collectChildCourseGroupsCurricularCoursesToEnrol(result, courseGroup, collectContext, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
        } else {
            this.collectSelectedChildCourseGroupsCurricularCoursesToEnrol(result, courseGroup, collectContext, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
        }
    }

    private boolean isToCollectCurricularCourses(CourseGroup courseGroup, EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, boolean withTemporaryEnrolments) {
        return !this.isConcluded(courseGroup, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments) && !this.isExclusiveWithExisting(courseGroup, enrolmentContext) && !PreviousYearsEnrolmentExecutor.hasRuleBypassingPreviousYearsEnrolmentCurricularRule(courseGroup, enrolmentContext);
    }

    private boolean isExclusiveWithExisting(CourseGroup courseGroup, EnrolmentContext enrolmentContext) {
        for (Exclusiveness exclusiveness : courseGroup.getExclusivenessRules(enrolmentContext.getExecutionPeriod())) {
            if (!this.isEnroled(enrolmentContext, exclusiveness.getExclusiveDegreeModule())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasRuleBypassingPreviousYearsEnrolmentCurricularRule(CourseGroup courseGroup, EnrolmentContext enrolmentContext) {
        List<CurricularRuleType> bypassing = Arrays.asList(CurricularRuleType.ENROLMENT_TO_BE_APPROVED_BY_COORDINATOR);
        for (CurricularRule curricularRule : courseGroup.getCurricularRules(enrolmentContext.getExecutionPeriod())) {
            if (!bypassing.contains((Object)curricularRule.getCurricularRuleType())) continue;
            return true;
        }
        return false;
    }

    private boolean isConcluded(CourseGroup courseGroup, EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, boolean withTemporaryEnrolments) {
        CurriculumGroup curriculumGroup = enrolmentContext.getStudentCurricularPlan().findCurriculumGroupFor(courseGroup);
        if (curriculumGroup == null) {
            return false;
        }
        double minEctsToApprove = curriculumGroup.getDegreeModule().getMinEctsCredits();
        double totalEcts = this.calculateTotalEctsInGroup(enrolmentContext, curriculumGroup, withTemporaryEnrolments);
        return totalEcts >= minEctsToApprove;
    }

    private void collectSelectedChildCourseGroupsCurricularCoursesToEnrol(Map<Integer, Set<CurricularCourse>> result, CourseGroup courseGroup, CollectContext collectContext, EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, boolean withTemporaryEnrolments) {
        for (DegreeModule degreeModule : this.getSelectedChildDegreeModules(courseGroup, enrolmentContext)) {
            if (!degreeModule.isCourseGroup()) continue;
            this.collectCourseGroupCurricularCoursesToEnrol(result, (CourseGroup)((Object)degreeModule), new CollectContext(collectContext), enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
        }
    }

    private Set<DegreeModule> getSelectedChildDegreeModules(CourseGroup courseGroup, EnrolmentContext enrolmentContext) {
        HashSet<DegreeModule> result = new HashSet<DegreeModule>();
        for (DegreeModule degreeModule : courseGroup.getChildDegreeModulesValidOn(enrolmentContext.getExecutionPeriod())) {
            if (!enrolmentContext.getStudentCurricularPlan().hasDegreeModule(degreeModule)) continue;
            result.add(degreeModule);
        }
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getDegreeModulesToEvaluate()) {
            if (degreeModuleToEvaluate.getCurriculumGroup() == null || degreeModuleToEvaluate.getCurriculumGroup().getDegreeModule() != courseGroup) continue;
            result.add(degreeModuleToEvaluate.getDegreeModule());
        }
        return result;
    }

    private int getMinModules(CourseGroup courseGroup, ExecutionSemester executionSemester) {
        DegreeModulesSelectionLimit degreeModulesSelectionLimit = courseGroup.getDegreeModulesSelectionLimitRule(executionSemester);
        if (degreeModulesSelectionLimit != null) {
            return degreeModulesSelectionLimit.getMinimumLimit();
        }
        CreditsLimit creditsLimit = courseGroup.getCreditsLimitRule(executionSemester);
        if (creditsLimit != null) {
            DegreeModule degreeModule;
            TreeSet<DegreeModule> sortedChilds = new TreeSet<DegreeModule>(new DegreeModule.ComparatorByMinEcts(executionSemester));
            sortedChilds.addAll(courseGroup.getChildDegreeModulesValidOn(executionSemester));
            int counter = 0;
            double total = 0.0;
            Iterator iterator = sortedChilds.iterator();
            while (iterator.hasNext() && !((total += (degreeModule = (DegreeModule)((Object)iterator.next())).getMinEctsCredits().doubleValue()) > creditsLimit.getMinimumCredits())) {
                ++counter;
            }
            return counter;
        }
        return courseGroup.getChildDegreeModulesValidOn(executionSemester).size();
    }

    private int getMaxModules(CourseGroup courseGroup, ExecutionSemester executionSemester) {
        DegreeModulesSelectionLimit degreeModulesSelectionLimit = courseGroup.getDegreeModulesSelectionLimitRule(executionSemester);
        if (degreeModulesSelectionLimit != null) {
            return degreeModulesSelectionLimit.getMaximumLimit();
        }
        CreditsLimit creditsLimit = courseGroup.getCreditsLimitRule(executionSemester);
        if (creditsLimit != null) {
            DegreeModule degreeModule;
            TreeSet<DegreeModule> sortedChilds = new TreeSet<DegreeModule>(new DegreeModule.ComparatorByMinEcts(executionSemester));
            sortedChilds.addAll(courseGroup.getChildDegreeModulesValidOn(executionSemester));
            int counter = 0;
            double total = 0.0;
            Iterator iterator = sortedChilds.iterator();
            while (iterator.hasNext() && !((total += (degreeModule = (DegreeModule)((Object)iterator.next())).getMaxEctsCredits().doubleValue()) > creditsLimit.getMaximumCredits())) {
                ++counter;
            }
            return counter;
        }
        return courseGroup.getChildDegreeModulesValidOn(executionSemester).size();
    }

    private void collectCurricularCoursesToEnrol(Map<Integer, Set<CurricularCourse>> result, CourseGroup courseGroup, CollectContext collectContext, EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, boolean withTemporaryEnrolments) {
        CurriculumGroup curriculumGroup = enrolmentContext.getStudentCurricularPlan().findCurriculumGroupFor(courseGroup);
        collectContext.ectsCredits = curriculumGroup != null ? curriculumGroup.getChildCreditsDismissalEcts() : 0.0;
        double missingEctsToConcludeGroup = curriculumGroup != null ? curriculumGroup.getDegreeModule().getMinEctsCredits() - this.calculateTotalEctsInGroup(enrolmentContext, curriculumGroup, withTemporaryEnrolments) - this.calculateEnrollingEctsCreditsInCurricularCoursesFor(enrolmentContext, courseGroup) : courseGroup.getMinEctsCredits();
        Map<CurricularPeriod, Set<Context>> childContextsWithMaxByCurricularPeriod = courseGroup.getActiveChildCurricularContextsWithMaxByCurricularPeriod(enrolmentContext.getExecutionPeriod());
        SortedSet<Context> sortedCurricularCoursesContexts = this.getChildCurricularCoursesContextsToEvaluate(courseGroup, enrolmentContext);
        this.removeApprovedOrEnrolledOrEnrollingOrNotSatifyingCurricularRules(sortedCurricularCoursesContexts, childContextsWithMaxByCurricularPeriod, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
        this.removeCurricularCoursesThatCanBeApprovedInOtherCurricularPeriod(missingEctsToConcludeGroup, childContextsWithMaxByCurricularPeriod, sortedCurricularCoursesContexts, enrolmentContext);
        this.addValidCurricularCourses(result, sortedCurricularCoursesContexts, courseGroup, enrolmentContext.getExecutionPeriod());
    }

    private void removeCurricularCoursesThatCanBeApprovedInOtherCurricularPeriodOLD(double missingEctsToConcludeGroup, Map<CurricularPeriod, Set<Context>> childContextsWithMaxByCurricularPeriod, SortedSet<Context> sortedCurricularCoursesContexts, EnrolmentContext enrolmentContext) {
        Iterator iterator = sortedCurricularCoursesContexts.iterator();
        while (iterator.hasNext()) {
            Context context = (Context)iterator.next();
            if (!this.canObtainApprovalInOtherCurricularPeriod(missingEctsToConcludeGroup, context, childContextsWithMaxByCurricularPeriod)) continue;
            iterator.remove();
        }
    }

    private void removeCurricularCoursesThatCanBeApprovedInOtherCurricularPeriod(double missingEctsToConcludeGroup, Map<CurricularPeriod, Set<Context>> childContextsByCurricularPeriod, SortedSet<Context> sortedCurricularCoursesContexts, EnrolmentContext enrolmentContext) {
        for (Map.Entry<CurricularPeriod, Set<Context>> each : childContextsByCurricularPeriod.entrySet()) {
            for (Context context : each.getValue()) {
                if (!this.canObtainApprovalInOtherCurricularPeriod(missingEctsToConcludeGroup, context, childContextsByCurricularPeriod)) continue;
                sortedCurricularCoursesContexts.remove(context);
            }
        }
    }

    private void removeApprovedOrEnrolledOrEnrollingOrNotSatifyingCurricularRules(SortedSet<Context> sortedCurricularCoursesContexts, Map<CurricularPeriod, Set<Context>> childContextsWithMaxByCurricularPeriod, EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, boolean withTemporaryEnrolments) {
        Iterator iterator = sortedCurricularCoursesContexts.iterator();
        while (iterator.hasNext()) {
            Context context = (Context)iterator.next();
            CurricularCourse curricularCourse = (CurricularCourse)((Object)context.getChildDegreeModule());
            if (this.isApproved(enrolmentContext, curricularCourse)) {
                iterator.remove();
                this.removeFromChildContextsByCurricularPeriod(childContextsWithMaxByCurricularPeriod, context);
                continue;
            }
            if (this.isEnroled(enrolmentContext, curricularCourse, withTemporaryEnrolments) || this.isEnrolling(enrolmentContext, (DegreeModule)((Object)curricularCourse))) {
                iterator.remove();
                this.removeFromChildContextsByCurricularPeriod(childContextsWithMaxByCurricularPeriod, context);
                continue;
            }
            if (this.isCurricularRulesSatisfied(enrolmentContext, curricularCourse, sourceDegreeModuleToEvaluate)) continue;
            iterator.remove();
            this.removeFromChildContextsByCurricularPeriod(childContextsWithMaxByCurricularPeriod, context);
        }
    }

    private void removeFromChildContextsByCurricularPeriod(Map<CurricularPeriod, Set<Context>> result, Context contextToRemove) {
        DegreeModule degreeModule = contextToRemove.getChildDegreeModule();
        for (Map.Entry<CurricularPeriod, Set<Context>> each : result.entrySet()) {
            Iterator<Context> iterator = each.getValue().iterator();
            while (iterator.hasNext()) {
                Context candidate = iterator.next();
                if (candidate.getChildDegreeModule() != degreeModule) continue;
                iterator.remove();
            }
        }
    }

    private double calculateEnrollingEctsCreditsInCurricularCoursesFor(EnrolmentContext enrolmentContext, CourseGroup courseGroup) {
        double result = 0.0;
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!degreeModuleToEvaluate.isLeaf() || !degreeModuleToEvaluate.isEnroling() || degreeModuleToEvaluate.getCurriculumGroup().getDegreeModule() != courseGroup) continue;
            result += degreeModuleToEvaluate.getDegreeModule().getMinEctsCredits().doubleValue();
        }
        return result;
    }

    private boolean canObtainApprovalInOtherCurricularPeriod(double missingEctsToConcludeGroup, Context curricularCourseContext, Map<CurricularPeriod, Set<Context>> contextsByCurricularPeriod) {
        int curricularCourseSemester = curricularCourseContext.getCurricularPeriod().getChildOrder();
        double ectsToPerformInOtherCurricularPeriods = 0.0;
        for (Map.Entry<CurricularPeriod, Set<Context>> each : contextsByCurricularPeriod.entrySet()) {
            if (each.getKey().getChildOrder() == curricularCourseSemester) continue;
            for (Context context : each.getValue()) {
                CurricularCourse curricularCourse = (CurricularCourse)((Object)context.getChildDegreeModule());
                ectsToPerformInOtherCurricularPeriods += curricularCourse.getMinEctsCredits().doubleValue();
            }
        }
        return ectsToPerformInOtherCurricularPeriods >= missingEctsToConcludeGroup;
    }

    private double calculateTotalEctsInGroup(EnrolmentContext enrolmentContext, CurriculumGroup curriculumGroup, boolean withTemporaryEnrolments) {
        double result = curriculumGroup.getCreditsConcluded(enrolmentContext.getExecutionPeriod().getExecutionYear());
        result += curriculumGroup.getEnroledEctsCredits(enrolmentContext.getExecutionPeriod()).doubleValue();
        if (withTemporaryEnrolments) {
            result += curriculumGroup.getEnroledEctsCredits(enrolmentContext.getExecutionPeriod().getPreviousExecutionPeriod()).doubleValue();
        }
        return result;
    }

    private boolean isEnroled(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse, boolean withTemporaryEnrolments) {
        if (withTemporaryEnrolments) {
            return this.isEnroled(enrolmentContext, curricularCourse, enrolmentContext.getExecutionPeriod()) || this.isEnroled(enrolmentContext, curricularCourse, enrolmentContext.getExecutionPeriod().getPreviousExecutionPeriod());
        }
        return this.isEnroled(enrolmentContext, curricularCourse, enrolmentContext.getExecutionPeriod());
    }

    private boolean isCurricularRulesSatisfied(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        RuleResult result = RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        for (ICurricularRule curricularRule : curricularCourse.getCurricularRules(enrolmentContext.getExecutionPeriod())) {
            result = result.and(curricularRule.verify(this.getVerifyRuleLevel(enrolmentContext), enrolmentContext, (DegreeModule)((Object)curricularCourse), (CourseGroup)((Object)sourceDegreeModuleToEvaluate.getDegreeModule())));
        }
        return result.isTrue();
    }

    private VerifyRuleLevel getVerifyRuleLevel(EnrolmentContext enrolmentContext) {
        return enrolmentContext.getCurricularRuleLevel() == CurricularRuleLevel.ENROLMENT_WITH_RULES_AND_TEMPORARY_ENROLMENT ? VerifyRuleLevel.ENROLMENT_WITH_RULES_AND_TEMPORARY : VerifyRuleLevel.ENROLMENT_WITH_RULES;
    }

    private SortedSet<Context> getChildCurricularCoursesContextsToEvaluate(CourseGroup courseGroup, EnrolmentContext enrolmentContext) {
        ExecutionSemester executionSemester = enrolmentContext.getExecutionPeriod();
        TreeSet<Context> result = new TreeSet<Context>(Context.COMPARATOR_BY_CURRICULAR_YEAR);
        int minModules = this.getMinModules(courseGroup, executionSemester);
        int maxModules = this.getMaxModules(courseGroup, executionSemester);
        int childDegreeModulesCount = courseGroup.getActiveChildContextsWithMax(enrolmentContext.getExecutionPeriod()).size();
        if (minModules == maxModules) {
            if (maxModules == childDegreeModulesCount) {
                result.addAll(courseGroup.getActiveChildContextsWithMaxCurricularPeriodForCurricularCourses(enrolmentContext.getExecutionPeriod()));
            } else if (this.getSelectedChildDegreeModules(courseGroup, enrolmentContext).size() < minModules) {
                result.addAll(courseGroup.getActiveChildContextsWithMaxCurricularPeriodForCurricularCourses(enrolmentContext.getExecutionPeriod()));
            } else {
                result.addAll(this.getSelectedChildCurricularCoursesContexts(courseGroup, enrolmentContext));
            }
        } else if (this.getSelectedChildDegreeModules(courseGroup, enrolmentContext).size() < minModules) {
            result.addAll(courseGroup.getActiveChildContextsWithMaxCurricularPeriodForCurricularCourses(enrolmentContext.getExecutionPeriod()));
        } else {
            result.addAll(this.getSelectedChildCurricularCoursesContexts(courseGroup, enrolmentContext));
        }
        return result;
    }

    private Set<Context> getSelectedChildCurricularCoursesContexts(CourseGroup courseGroup, EnrolmentContext enrolmentContext) {
        HashSet<Context> result = new HashSet<Context>();
        for (Context context : courseGroup.getActiveChildContexts()) {
            if (!context.getChildDegreeModule().isCurricularCourse() || !enrolmentContext.getStudentCurricularPlan().hasDegreeModule(context.getChildDegreeModule())) continue;
            result.add(context);
        }
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!degreeModuleToEvaluate.isLeaf() || degreeModuleToEvaluate.getCurriculumGroup() == null || degreeModuleToEvaluate.getCurriculumGroup().getDegreeModule() != courseGroup || degreeModuleToEvaluate.isAnnualCurricularCourse(enrolmentContext.getExecutionPeriod().getExecutionYear()) && degreeModuleToEvaluate.getContext() == null) continue;
            Context context = degreeModuleToEvaluate.getContext();
            if (context == null) {
                throw new DomainException("error.degreeModuleToEvaluate.has.invalid.context", degreeModuleToEvaluate.getName(), degreeModuleToEvaluate.getExecutionPeriod().getQualifiedName());
            }
            result.add(context);
        }
        return result;
    }

    private void addValidCurricularCourses(Map<Integer, Set<CurricularCourse>> result, Set<Context> curricularCoursesContexts, CourseGroup courseGroup, ExecutionSemester executionSemester) {
        for (Context context : curricularCoursesContexts) {
            if (!context.isValid(executionSemester)) continue;
            this.addCurricularCourse(result, context.getCurricularYear(), (CurricularCourse)((Object)context.getChildDegreeModule()));
        }
    }

    private void addCurricularCourse(Map<Integer, Set<CurricularCourse>> result, Integer curricularYear, CurricularCourse curricularCourse) {
        Set<CurricularCourse> curricularCourses = result.get(curricularYear);
        if (curricularCourses == null) {
            curricularCourses = new HashSet<CurricularCourse>();
            result.put(curricularYear, curricularCourses);
        }
        curricularCourses.add(curricularCourse);
    }

    private void collectChildCourseGroupsCurricularCoursesToEnrol(Map<Integer, Set<CurricularCourse>> result, CourseGroup courseGroup, CollectContext parentCollectContext, EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, boolean withTemporaryEnrolments) {
        for (DegreeModule childDegreeModule : courseGroup.getChildDegreeModulesValidOn(enrolmentContext.getExecutionPeriod())) {
            if (!childDegreeModule.isCourseGroup()) continue;
            this.collectCourseGroupCurricularCoursesToEnrol(result, (CourseGroup)((Object)childDegreeModule), new CollectContext(parentCollectContext), enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
        }
    }

    @Override
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        if (this.isEnrollingInCourseGroupsOnly(enrolmentContext, sourceDegreeModuleToEvaluate)) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        PreviousYearsEnrolmentCurricularRule previousYearsEnrolmentCurricularRule = (PreviousYearsEnrolmentCurricularRule)curricularRule;
        Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYear = this.getCurricularCoursesToEnrolByYear(previousYearsEnrolmentCurricularRule, enrolmentContext, sourceDegreeModuleToEvaluate, false);
        Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYearWithTemporaries = this.getCurricularCoursesToEnrolByYear(previousYearsEnrolmentCurricularRule, enrolmentContext, sourceDegreeModuleToEvaluate, true);
        return this.hasAnyCurricularCoursesToEnrolInPreviousYears(enrolmentContext, curricularCoursesToEnrolByYear, curricularCoursesToEnrolByYearWithTemporaries, sourceDegreeModuleToEvaluate);
    }

    private RuleResult hasAnyCurricularCoursesToEnrolInPreviousYears(EnrolmentContext enrolmentContext, Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYear, Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYearWithTemporaries, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        RuleResult result = RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getAllChildDegreeModulesToEvaluateFor(sourceDegreeModuleToEvaluate.getDegreeModule())) {
            if (!degreeModuleToEvaluate.isLeaf() || degreeModuleToEvaluate.isAnnualCurricularCourse(enrolmentContext.getExecutionPeriod().getExecutionYear()) && degreeModuleToEvaluate.getContext() == null) continue;
            if (degreeModuleToEvaluate.getContext() == null) {
                throw new DomainException("error.degreeModuleToEvaluate.has.invalid.context", degreeModuleToEvaluate.getName(), degreeModuleToEvaluate.getExecutionPeriod().getQualifiedName());
            }
            if (this.hasCurricularCoursesToEnrolInPreviousYears(curricularCoursesToEnrolByYearWithTemporaries, degreeModuleToEvaluate.getContext().getCurricularYear())) {
                if (degreeModuleToEvaluate.isEnroled()) {
                    result = result.and(this.createImpossibleRuleResult(sourceDegreeModuleToEvaluate, degreeModuleToEvaluate));
                    continue;
                }
                result = result.and(this.createFalseRuleResult(sourceDegreeModuleToEvaluate, degreeModuleToEvaluate));
                continue;
            }
            if (!this.isAnyPreviousYearCurricularCoursesTemporary(curricularCoursesToEnrolByYear, curricularCoursesToEnrolByYearWithTemporaries, degreeModuleToEvaluate.getContext().getCurricularYear())) continue;
            result = result.and(RuleResult.createTrue(EnrolmentResultType.TEMPORARY, degreeModuleToEvaluate.getDegreeModule()));
        }
        return result;
    }

    private boolean isAnyPreviousYearCurricularCoursesTemporary(Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYear, Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYearWithTemporaries, Integer curricularYear) {
        for (int i = curricularYear.intValue(); i > 0; --i) {
            int previousYear = i - 1;
            if (!curricularCoursesToEnrolByYear.containsKey(previousYear) && !curricularCoursesToEnrolByYearWithTemporaries.containsKey(previousYear)) continue;
            if (curricularCoursesToEnrolByYearWithTemporaries.containsKey(previousYear) && !curricularCoursesToEnrolByYear.containsKey(previousYear) || !curricularCoursesToEnrolByYearWithTemporaries.containsKey(previousYear) && curricularCoursesToEnrolByYear.containsKey(previousYear)) {
                return true;
            }
            if (curricularCoursesToEnrolByYear.get(previousYear).size() == curricularCoursesToEnrolByYearWithTemporaries.get(previousYear).size()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }

    private static class CollectContext {
        public double ectsCredits;
        public CollectContext parentContext;

        public CollectContext() {
            this(null);
        }

        public CollectContext(CollectContext parentContext) {
            this.parentContext = parentContext;
        }

        public boolean hasCreditsToSpent(double ectsCredits) {
            if (this.ectsCredits >= ectsCredits) {
                return true;
            }
            if (this.parentContext == null) {
                return false;
            }
            return this.parentContext.hasCreditsToSpent(ectsCredits - this.ectsCredits);
        }

        public void useCredits(double ectsCredits) {
            if (this.ectsCredits >= ectsCredits) {
                this.ectsCredits -= ectsCredits;
            } else {
                double creditsMissing = ectsCredits - this.ectsCredits;
                if (this.parentContext == null) {
                    throw new DomainException("error.org.fenixedu.academic.domain.curricularRules.ruleExecutors.CollectContext.parentContent.is.expected", new String[0]);
                }
                this.parentContext.useCredits(creditsMissing);
            }
        }
    }
}

