/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.ImprovementOfApprovedEnrolment;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;

public class ImprovementOfApprovedEnrolmentExecutor
extends CurricularRuleExecutor {
    @Override
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        ImprovementOfApprovedEnrolment improvementOfApprovedEnrolment = (ImprovementOfApprovedEnrolment)curricularRule;
        Enrolment enrolment = improvementOfApprovedEnrolment.getEnrolment();
        DegreeModule degreeModule = enrolment.getDegreeModule();
        if (enrolment.hasImprovement()) {
            return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.ImprovementOfApprovedEnrolmentExecutor.already.enroled.in.improvement", degreeModule.getName());
        }
        if (!enrolment.isApproved()) {
            return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.ImprovementOfApprovedEnrolmentExecutor.degree.module.hasnt.been.approved", degreeModule.getName());
        }
        if (!enrolment.isBolonhaDegree()) {
            return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        ExecutionSemester executionSemester = enrolmentContext.getExecutionPeriod();
        if (!executionSemester.isOneYearAfter(enrolment.getExecutionPeriod())) {
            if (!degreeModule.hasAnyParentContexts(executionSemester)) {
                return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.ImprovementOfApprovedEnrolmentExecutor.degree.module.has.no.context.in.present.execution.period", degreeModule.getName(), executionSemester.getQualifiedName());
            }
            if (!enrolment.isImprovingInExecutionPeriodFollowingApproval(executionSemester)) {
                return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.ImprovementOfApprovedEnrolmentExecutor.is.not.improving.in.execution.period.following.approval", degreeModule.getName());
            }
        }
        return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }
}

