/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import java.util.Collection;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.Exclusiveness;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;

public class ExclusivenessExecutor
extends CurricularRuleExecutor {
    @Override
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        Exclusiveness rule = (Exclusiveness)((Object)curricularRule);
        if (!this.canApplyRule(enrolmentContext, (ICurricularRule)((Object)rule))) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        DegreeModule degreeModule = rule.getExclusiveDegreeModule();
        if (degreeModule.isLeaf()) {
            CurricularCourse curricularCourse = (CurricularCourse)((Object)degreeModule);
            ExecutionSemester previousExecutionPeriod = enrolmentContext.getExecutionPeriod().getPreviousExecutionPeriod();
            if (this.isApproved(enrolmentContext, curricularCourse) || this.hasEnrolmentWithEnroledState(enrolmentContext, curricularCourse, previousExecutionPeriod)) {
                if (this.isEnroled(enrolmentContext, (CurricularCourse)((Object)rule.getDegreeModuleToApplyRule()), enrolmentContext.getExecutionPeriod())) {
                    return this.createImpossibleRuleResult(rule, sourceDegreeModuleToEvaluate);
                }
                return this.createFalseRuleResult(rule, sourceDegreeModuleToEvaluate);
            }
        }
        if (this.isEnroled(enrolmentContext, degreeModule) || this.isEnrolling(enrolmentContext, degreeModule)) {
            return this.createFalseRuleResult(rule, sourceDegreeModuleToEvaluate);
        }
        return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    private RuleResult createFalseRuleResult(Exclusiveness rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.ExclusivenessExecutor.exclusive.degreeModule", rule.getDegreeModuleToApplyRule().getName(), rule.getExclusiveDegreeModule().getName());
    }

    private RuleResult createImpossibleRuleResult(Exclusiveness rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        return RuleResult.createImpossible(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.ExclusivenessExecutor.exclusive.degreeModule", rule.getDegreeModuleToApplyRule().getName(), rule.getExclusiveDegreeModule().getName());
    }

    @Override
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        Exclusiveness rule = (Exclusiveness)((Object)curricularRule);
        if (!this.canApplyRule(enrolmentContext, (ICurricularRule)((Object)rule))) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        DegreeModule degreeModule = rule.getExclusiveDegreeModule();
        if (degreeModule.isLeaf()) {
            CurricularCourse curricularCourse = (CurricularCourse)((Object)degreeModule);
            if (this.isApproved(enrolmentContext, curricularCourse)) {
                if (this.isEnroled(enrolmentContext, (CurricularCourse)((Object)rule.getDegreeModuleToApplyRule()), enrolmentContext.getExecutionPeriod())) {
                    return this.createImpossibleRuleResult(rule, sourceDegreeModuleToEvaluate);
                }
                return this.createFalseRuleResult(rule, sourceDegreeModuleToEvaluate);
            }
            ExecutionSemester previousExecutionPeriod = enrolmentContext.getExecutionPeriod().getPreviousExecutionPeriod();
            if (this.hasEnrolmentWithEnroledState(enrolmentContext, curricularCourse, previousExecutionPeriod)) {
                return RuleResult.createTrue(EnrolmentResultType.TEMPORARY, sourceDegreeModuleToEvaluate.getDegreeModule());
            }
        }
        if (this.isEnroled(enrolmentContext, degreeModule) || this.isEnrolling(enrolmentContext, degreeModule)) {
            return this.createFalseRuleResult(rule, sourceDegreeModuleToEvaluate);
        }
        return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        Exclusiveness exclusivenessRule = (Exclusiveness)((Object)curricularRule);
        Collection<CycleCourseGroup> cycleCourseGroups = exclusivenessRule.getExclusiveDegreeModule().getParentCycleCourseGroups();
        for (CycleCourseGroup cycleCourseGroup : cycleCourseGroups) {
            CycleCurriculumGroup cycleCurriculumGroup = (CycleCurriculumGroup)((Object)enrolmentContext.getStudentCurricularPlan().findCurriculumGroupFor((CourseGroup)((Object)cycleCourseGroup)));
            if (cycleCurriculumGroup == null) continue;
            return true;
        }
        return false;
    }
}

