/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import java.util.HashMap;
import java.util.Map;
import org.fenixedu.academic.domain.curricularRules.AnyCurricularCourse;
import org.fenixedu.academic.domain.curricularRules.AssertUniqueApprovalInCurricularCourseContexts;
import org.fenixedu.academic.domain.curricularRules.CreditsLimit;
import org.fenixedu.academic.domain.curricularRules.CreditsLimitInExternalCycle;
import org.fenixedu.academic.domain.curricularRules.DegreeModulesSelectionLimit;
import org.fenixedu.academic.domain.curricularRules.EnrolmentInSpecialSeasonEvaluation;
import org.fenixedu.academic.domain.curricularRules.EnrolmentPeriodRestrictions;
import org.fenixedu.academic.domain.curricularRules.EnrolmentToBeApprovedByCoordinator;
import org.fenixedu.academic.domain.curricularRules.EvenOddRule;
import org.fenixedu.academic.domain.curricularRules.Exclusiveness;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.ImprovementOfApprovedEnrolment;
import org.fenixedu.academic.domain.curricularRules.MaximumNumberOfCreditsForEnrolmentPeriod;
import org.fenixedu.academic.domain.curricularRules.MaximumNumberOfECTSInSpecialSeasonEvaluation;
import org.fenixedu.academic.domain.curricularRules.MaximumNumberOfEctsInStandaloneCurriculumGroup;
import org.fenixedu.academic.domain.curricularRules.MinimumNumberOfCreditsToEnrol;
import org.fenixedu.academic.domain.curricularRules.PreviousYearsEnrolmentCurricularRule;
import org.fenixedu.academic.domain.curricularRules.RestrictionBetweenDegreeModules;
import org.fenixedu.academic.domain.curricularRules.RestrictionDoneDegreeModule;
import org.fenixedu.academic.domain.curricularRules.RestrictionEnroledDegreeModule;
import org.fenixedu.academic.domain.curricularRules.RestrictionNotEnroledDegreeModule;
import org.fenixedu.academic.domain.curricularRules.SeniorStatuteSpecialSeasonEnrolmentScope;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.AnyCurricularCourseExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.AssertUniqueApprovalInCurricularCourseContextsExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CreditsLimitExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CreditsLimitInExternalCycleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.DegreeModulesSelectionLimitExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentInSpecialSeasonEvaluationExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentPeriodRestrictionsExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentToBeApprovedByCoordinatorExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EvenOddExecuter;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.ExclusivenessExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.ImprovementOfApprovedEnrolmentExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.MaximumNumberOfCreditsForEnrolmentPeriodExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.MaximumNumberOfECTSInSpecialSeasonEvaluationExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.MaximumNumberOfEctsInStandaloneCurriculumGroupExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.MinimumNumberOfCreditsToEnrolExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.PreviousYearsEnrolmentExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.RestrictionBetweenDegreeModulesExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.RestrictionDoneDegreeModuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.RestrictionEnroledDegreeModuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.RestrictionNotEnroledDegreeModuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.SeniorStatuteSpecialSeasonEnrolmentScopeExecutor;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.enrolments.PhdValidCurricularCoursesExecutor;
import org.fenixedu.academic.domain.phd.enrolments.PhdValidCurricularCoursesRule;

public class CurricularRuleExecutorFactory {
    private static Map<Class<? extends ICurricularRule>, CurricularRuleExecutor> executors = new HashMap<Class<? extends ICurricularRule>, CurricularRuleExecutor>();

    public static CurricularRuleExecutor findExecutor(ICurricularRule curricularRule) {
        return CurricularRuleExecutorFactory.findExecutor(curricularRule.getClass());
    }

    public static CurricularRuleExecutor findExecutor(Class<? extends ICurricularRule> clazz) {
        if (!executors.containsKey(clazz)) {
            throw new DomainException("error.curricularRules.RuleFactory.cannot.find.RuleExecutor.for.class", clazz.getName());
        }
        return executors.get(clazz);
    }

    static {
        executors.put(RestrictionDoneDegreeModule.class, new RestrictionDoneDegreeModuleExecutor());
        executors.put(RestrictionEnroledDegreeModule.class, new RestrictionEnroledDegreeModuleExecutor());
        executors.put(RestrictionNotEnroledDegreeModule.class, new RestrictionNotEnroledDegreeModuleExecutor());
        executors.put(RestrictionBetweenDegreeModules.class, new RestrictionBetweenDegreeModulesExecutor());
        executors.put(EnrolmentToBeApprovedByCoordinator.class, new EnrolmentToBeApprovedByCoordinatorExecutor());
        executors.put(Exclusiveness.class, new ExclusivenessExecutor());
        executors.put(MinimumNumberOfCreditsToEnrol.class, new MinimumNumberOfCreditsToEnrolExecutor());
        executors.put(DegreeModulesSelectionLimit.class, new DegreeModulesSelectionLimitExecutor());
        executors.put(CreditsLimit.class, new CreditsLimitExecutor());
        executors.put(AnyCurricularCourse.class, new AnyCurricularCourseExecutor());
        executors.put(MaximumNumberOfCreditsForEnrolmentPeriod.class, new MaximumNumberOfCreditsForEnrolmentPeriodExecutor());
        executors.put(EnrolmentPeriodRestrictions.class, new EnrolmentPeriodRestrictionsExecutor());
        executors.put(PreviousYearsEnrolmentCurricularRule.class, new PreviousYearsEnrolmentExecutor());
        executors.put(AssertUniqueApprovalInCurricularCourseContexts.class, new AssertUniqueApprovalInCurricularCourseContextsExecutor());
        executors.put(ImprovementOfApprovedEnrolment.class, new ImprovementOfApprovedEnrolmentExecutor());
        executors.put(EnrolmentInSpecialSeasonEvaluation.class, new EnrolmentInSpecialSeasonEvaluationExecutor());
        executors.put(MaximumNumberOfECTSInSpecialSeasonEvaluation.class, new MaximumNumberOfECTSInSpecialSeasonEvaluationExecutor());
        executors.put(CreditsLimitInExternalCycle.class, new CreditsLimitInExternalCycleExecutor());
        executors.put(EvenOddRule.class, new EvenOddExecuter());
        executors.put(MaximumNumberOfEctsInStandaloneCurriculumGroup.class, new MaximumNumberOfEctsInStandaloneCurriculumGroupExecutor());
        executors.put(PhdValidCurricularCoursesRule.class, new PhdValidCurricularCoursesExecutor());
        executors.put(SeniorStatuteSpecialSeasonEnrolmentScope.class, new SeniorStatuteSpecialSeasonEnrolmentScopeExecutor());
    }
}

