/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.serviceRequests;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.CertificateRequestEvent;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.ExamDateCertificateRequestPR_Base;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class ExamDateCertificateRequestPR
extends ExamDateCertificateRequestPR_Base {
    protected ExamDateCertificateRequestPR() {
    }

    public ExamDateCertificateRequestPR(ServiceAgreementTemplate serviceAgreementTemplate, DateTime startDate, DateTime endDate, Money baseAmount, Money amountPerPage) {
        this();
        super.init(EntryType.EXAM_DATE_CERTIFICATE_REQUEST_FEE, EventType.EXAM_DATE_CERTIFICATE_REQUEST, startDate, endDate, serviceAgreementTemplate, baseAmount, amountPerPage);
    }

    public ExamDateCertificateRequestPR edit(Money baseAmount, Money amountPerUnit) {
        this.deactivate();
        return new ExamDateCertificateRequestPR(this.getServiceAgreementTemplate(), new DateTime().minus(1000L), null, baseAmount, amountPerUnit);
    }

    protected Money getAmountForPages(Event event) {
        CertificateRequestEvent requestEvent = (CertificateRequestEvent)((Object)event);
        int extraPages = requestEvent.getNumberOfPages() - 1;
        return this.getAmountPerPage().multiply(BigDecimal.valueOf(extraPages < 0 ? 0L : (long)extraPages));
    }

    protected boolean isUrgent(Event event) {
        return ((CertificateRequestEvent)((Object)event)).isUrgentRequest();
    }
}

