/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.serviceRequests;

import java.util.Collections;
import java.util.Set;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.IPastRequestEvent;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.PastDegreeDiplomaRequestEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.PastDiplomaRequest;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;

public class PastDegreeDiplomaRequestEvent
extends PastDegreeDiplomaRequestEvent_Base
implements IPastRequestEvent {
    protected PastDegreeDiplomaRequestEvent() {
    }

    public PastDegreeDiplomaRequestEvent(AdministrativeOffice administrativeOffice, Person person, PastDiplomaRequest pastDiplomaRequest, Money pastAmount) {
        this();
        super.init(administrativeOffice, EventType.PAST_DEGREE_DIPLOMA_REQUEST, person, (RegistrationAcademicServiceRequest)((Object)pastDiplomaRequest));
        super.setPastAmount(pastAmount);
    }

    public LabelFormatter getDescription() {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(this.getEventType().getQualifiedName(), "resources.EnumerationResources");
        labelFormatter.appendLabel(" (");
        labelFormatter.appendLabel(this.getDegree().getDegreeType().getName().getContent());
        labelFormatter.appendLabel(" ");
        labelFormatter.appendLabel("label.in", "resources.ApplicationResources");
        labelFormatter.appendLabel(" ");
        labelFormatter.appendLabel(this.getDegree().getNameFor(this.getExecutionYear()).getContent());
        labelFormatter.appendLabel(")");
        return labelFormatter;
    }

    public Set<EntryType> getPossibleEntryTypesForDeposit() {
        return Collections.singleton(EntryType.DIPLOMA_REQUEST_FEE);
    }

    @Override
    public void setPastAmount(Money pastDegreeDiplomaRequestAmount) {
        throw new DomainException("error.accounting.events.cannot.modify.pastAmount", new String[0]);
    }
}

