/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DegreeOfficialPublication;
import org.fenixedu.academic.domain.DegreeSpecializationArea$callable$setNameEn;
import org.fenixedu.academic.domain.DegreeSpecializationArea$callable$setNamePt;
import org.fenixedu.academic.domain.DegreeSpecializationArea_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.MultiLanguageString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DegreeSpecializationArea
extends DegreeSpecializationArea_Base {
    public static final Advice advice$setNameEn = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$setNamePt = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public DegreeSpecializationArea(DegreeOfficialPublication officialPublication, MultiLanguageString area) {
        this.init(officialPublication, area);
    }

    protected void init(DegreeOfficialPublication degreeOfficialPublication, MultiLanguageString area) {
        this.checkParameters(degreeOfficialPublication, area);
        this.setOfficialPublication(degreeOfficialPublication);
        this.setName(area);
    }

    private void checkParameters(DegreeOfficialPublication degreeOfficialPublication, MultiLanguageString area) {
        if (degreeOfficialPublication == null) {
            throw new DomainException(DegreeSpecializationArea.class.getName() + ".degreeOfficialPublication.required", new String[0]);
        }
        if (area == null) {
            throw new DomainException(MultiLanguageString.class.getName() + ".area.required", new String[0]);
        }
        if (area.getAllLocales().isEmpty()) {
            throw new DomainException(DegreeSpecializationArea.class.getName() + ".area.names.required", new String[0]);
        }
        if (!this.verifyIfSomeContentsAreNotEmpty(area)) {
            throw new DomainException(DegreeSpecializationArea.class.getName() + ".area.names.nameForLanguage.required", new String[0]);
        }
    }

    private boolean verifyIfSomeContentsAreNotEmpty(MultiLanguageString area) {
        for (String language : area.getAllContents()) {
            if (language.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void delete() {
        this.setOfficialPublication(null);
        this.deleteDomainObject();
    }

    public void setNameEn(String string) {
        Object object = advice$setNameEn.perform((Callable)new DegreeSpecializationArea$callable$setNameEn(this, string));
    }

    static /* synthetic */ void advised$setNameEn(DegreeSpecializationArea this_, String nameEn) {
        this_.setName(this_.getName().with(MultiLanguageString.en, nameEn));
    }

    public void setNamePt(String string) {
        Object object = advice$setNamePt.perform((Callable)new DegreeSpecializationArea$callable$setNamePt(this, string));
    }

    static /* synthetic */ void advised$setNamePt(DegreeSpecializationArea this_, String namePt) {
        this_.setName(this_.getName().with(MultiLanguageString.pt, namePt));
    }

    public String getNameEn() {
        return this.getName().getContent(MultiLanguageString.en);
    }

    public String getNamePt() {
        return this.getName().getContent(MultiLanguageString.pt);
    }
}

